/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.bo.ability.QueryParam;
import com.tydic.commodity.bo.ability.SearchBarEsRspBO;
import com.tydic.commodity.bo.ability.SearchBarEsRspInfo;
import com.tydic.commodity.bo.busi.UccSearchProportionReqBO;
import com.tydic.commodity.busi.api.UccSearchProportionEsBusiService;
import com.tydic.commodity.search.SearchEsQueryService;
import com.tydic.commodity.search.SearchProportionEsService;
import com.tydic.commodity.search.bo.CommodityRspBo;
import com.tydic.commodity.search.bo.SearchEsRspBo;
import com.tydic.commodity.search.bo.SearchEsSQLRspBO;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uccSearchProportionEsBusiService")
public class UccSearchProportionEsBusiServiceImpl
implements UccSearchProportionEsBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSearchProportionEsBusiServiceImpl.class);
    @Autowired
    private SearchProportionEsService searchProportionEsService;
    @Autowired
    private SearchEsQueryService searchEsQueryService;
    private static Integer esSeaarchSize = 10000;

    public SearchBarEsRspBO qryBySearchBar(UccSearchProportionReqBO reqBO) {
        SearchBarEsRspBO searchBarEsRspBO = new SearchBarEsRspBO();
        List params = null;
        ArrayList<QueryParam> queryParamBOs = new ArrayList<QueryParam>();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getQueryParams())) {
            params = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getQueryParams()), QueryParam.class);
            for (QueryParam queryParam : params) {
                QueryParam queryParamBO = new QueryParam();
                BeanUtils.copyProperties((Object)queryParam, (Object)queryParamBO);
                queryParamBOs.add(queryParamBO);
            }
        }
        reqBO.setQueryParams(queryParamBOs);
        try {
            SearchEsSQLRspBO searchEsSQLRspBO = this.searchProportionEsService.buildSQL(reqBO);
            searchEsSQLRspBO.setField(true);
            searchEsSQLRspBO.setNeedKeyWorld(reqBO.isNeedKeyWorld());
            SearchEsRspBo rspBo = this.searchEsQueryService.executeSQL(searchEsSQLRspBO);
            if (rspBo == null) {
                log.info("\u67e5\u8be2ES\u6570\u636e\u670d\u52a1\u5f02\u5e38!!");
                searchBarEsRspBO.setRespCode("0000");
                searchBarEsRspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e!");
                searchBarEsRspBO.setPageNo(1);
                searchBarEsRspBO.setTotal(0);
                searchBarEsRspBO.setRecordsTotal(0);
                return searchBarEsRspBO;
            }
            List propParams = rspBo.getPropParams();
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getQueryParams())) {
                HashSet<String> queryFilterIds = new HashSet<String>();
                for (QueryParam queryParam : params) {
                    queryFilterIds.add(queryParam.getFilterId());
                }
                HashSet<String> filterIdSet = new HashSet<String>();
                HashSet<QueryParam> h1 = new HashSet<QueryParam>();
                if (propParams != null && propParams.size() > 0) {
                    for (QueryParam queryParam : propParams) {
                        String filterId = queryParam.getFilterId();
                        if (!filterIdSet.contains(filterId) && !queryFilterIds.contains(filterId)) {
                            h1.add(queryParam);
                        }
                        filterIdSet.add(filterId);
                    }
                    propParams.clear();
                    propParams.addAll(h1);
                }
            }
            rspBo.setPropParams(propParams);
            BeanUtils.copyProperties((Object)reqBO, (Object)searchBarEsRspBO);
            List commodityRspBos = rspBo.getCommodityRspBos();
            List<SearchBarEsRspInfo> result = this.convertRspBo(commodityRspBos);
            searchBarEsRspBO.setResult(result);
            int size = reqBO.getPageSize();
            int no = reqBO.getPageNo();
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            if (esSeaarchSize.compareTo(rspBo.getTotal()) > 0) {
                totalPage = rspBo.getTotal() / size;
                add = rspBo.getTotal() % size == 0 ? 0 : 1;
                total = rspBo.getTotal();
            } else {
                totalPage = esSeaarchSize / size;
                total = size * (totalPage + (add = esSeaarchSize % size == 0 ? 0 : 1));
                if (total.compareTo(rspBo.getTotal()) > 0) {
                    total = rspBo.getTotal();
                }
            }
            searchBarEsRspBO.setTotal(totalPage + add);
            searchBarEsRspBO.setPageNo(no);
            if (rspBo.getQueryParams() != null && rspBo.getPropParams() != null) {
                rspBo.getQueryParams().addAll(rspBo.getPropParams());
            }
            searchBarEsRspBO.setQueryParams(rspBo.getQueryParams());
            searchBarEsRspBO.setRecordsTotal(total.intValue());
            searchBarEsRspBO.setRespCode("0000");
            searchBarEsRspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
            return searchBarEsRspBO;
        }
        catch (ZTBusinessException e) {
            searchBarEsRspBO.setRespCode("8888");
            searchBarEsRspBO.setRespDesc(e.getMessage());
            return searchBarEsRspBO;
        }
        catch (Exception e1) {
            log.error("\u641c\u7d22\u5f02\u5e38 \uff1a" + e1.getMessage());
            searchBarEsRspBO.setRespCode("8888");
            searchBarEsRspBO.setRespDesc(e1.getMessage());
            return searchBarEsRspBO;
        }
    }

    private List<SearchBarEsRspInfo> convertRspBo(List<CommodityRspBo> commodityRspBos) {
        ArrayList<SearchBarEsRspInfo> searchBarEsRspInfos = new ArrayList<SearchBarEsRspInfo>();
        if (commodityRspBos != null && commodityRspBos.size() > 0) {
            for (CommodityRspBo commodityRspBo : commodityRspBos) {
                SearchBarEsRspInfo searchBarEsRspInfo = new SearchBarEsRspInfo();
                searchBarEsRspInfo.setCommodityId(Long.valueOf(commodityRspBo.getCommodity_id()));
                searchBarEsRspInfo.setSkuId(Long.valueOf(commodityRspBo.getSku_id()));
                searchBarEsRspInfo.setExtSkuId(commodityRspBo.getExt_sku_id());
                searchBarEsRspInfo.setPriPicUrl(commodityRspBo.getPicture_url());
                searchBarEsRspInfo.setAgreementPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getAgreement_price())));
                searchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMarket_price())));
                searchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getSale_price())));
                searchBarEsRspInfo.setMemberPrice1(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price1())));
                searchBarEsRspInfo.setMemberPrice2(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price2())));
                searchBarEsRspInfo.setMemberPrice3(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price3())));
                searchBarEsRspInfo.setMemberPrice4(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price4())));
                searchBarEsRspInfo.setMemberPrice5(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price5())));
                searchBarEsRspInfo.setCommentNumber(commodityRspBo.getComment_number());
                searchBarEsRspInfo.setSkuName(commodityRspBo.getSku_name());
                searchBarEsRspInfo.setSupplierShopId(commodityRspBo.getSupplier_shop_id());
                searchBarEsRspInfo.setSupplierShopName(commodityRspBo.getShop_name());
                searchBarEsRspInfo.setSupplierId(String.valueOf(commodityRspBo.getSupplier_id()));
                searchBarEsRspInfo.setSupplierName(commodityRspBo.getSupplier_name());
                searchBarEsRspInfo.setSkuSource(Integer.valueOf(commodityRspBo.getSku_source()));
                searchBarEsRspInfo.setCommodityName(commodityRspBo.getCommodity_name());
                searchBarEsRspInfo.setCommdPicUrl(commodityRspBo.getCommd_pic_url());
                if (commodityRspBo.getEcommerce_sale() != null) {
                    searchBarEsRspInfo.setEcommerceSale(Long.valueOf(commodityRspBo.getEcommerce_sale().longValue()));
                }
                searchBarEsRspInfo.setExtendProperties(commodityRspBo.getExtendProperties());
                searchBarEsRspInfo.setVendorName(commodityRspBo.getVendor_name());
                searchBarEsRspInfo.setAgreementId(Long.valueOf(commodityRspBo.getAgreement_id()));
                searchBarEsRspInfo.setTexture(commodityRspBo.getTexture());
                searchBarEsRspInfo.setModel(commodityRspBo.getModel());
                searchBarEsRspInfo.setVendorId(commodityRspBo.getVendor_id());
                searchBarEsRspInfo.setSpec(commodityRspBo.getSpec());
                searchBarEsRspInfo.setManufacturer(commodityRspBo.getManufacturer());
                searchBarEsRspInfo.setFigure(commodityRspBo.getFigure());
                searchBarEsRspInfo.setBrandName(commodityRspBo.getBrand_name());
                searchBarEsRspInfo.setMeasureName(commodityRspBo.getMeasure_name());
                searchBarEsRspInfos.add(searchBarEsRspInfo);
            }
        }
        commodityRspBos = null;
        return searchBarEsRspInfos;
    }
}

