/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.commodity.bo.busi.UccUpdateMsgTableBusiReqBO;
import com.tydic.commodity.bo.busi.UccUpdateMsgTableBusiRspBO;
import com.tydic.commodity.busi.api.UccUpdateMsgTableBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.XextSkuChangeHistoryMapper;
import com.tydic.commodity.dao.XextSkuChangeMapper;
import com.tydic.commodity.dao.po.XextSkuChangeHistoryPo;
import com.tydic.commodity.dao.po.XextSkuChangePo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.CacheMap;
import com.tydic.commodity.util.SyncSequenceUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccUpdateMsgTableBusiServiceImpl
implements UccUpdateMsgTableBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUpdateMsgTableBusiServiceImpl.class);
    @Autowired
    private XextSkuChangeMapper xextSkuChangeMapper;
    @Autowired
    private XextSkuChangeHistoryMapper xextSkuChangeHistoryMapper;
    @Autowired
    private OrderSequence uccCommodityIdSequence;
    @Autowired
    private OrderSequence uccSkuIdSequence;

    public UccUpdateMsgTableBusiRspBO updateSuccess(UccUpdateMsgTableBusiReqBO reqBo) {
        UccUpdateMsgTableBusiRspBO rspBo = new UccUpdateMsgTableBusiRspBO();
        XextSkuChangePo po = new XextSkuChangePo();
        po.setMsgGetId(reqBo.getMsgId());
        po.setSupplierShopId(reqBo.getSupplierShopId());
        po.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_SUCCESS_PROCESS);
        po.setExtSkuHandleState(ModelRuleConstant.EXT_SKU_HANDLE_STATE_SUCCESS);
        po.setRemark(reqBo.getRemark());
        try {
            this.xextSkuChangeMapper.deleteRecords(po);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25\uff1a\u5165\u5e93\u4fe1\u606f" + JSONObject.toJSONString((Object)po) + "---- \u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new BusinessException("xextSkuChangeMapper_updateSucces", "\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25");
        }
        XextSkuChangePo xextSkuChangePo = new XextSkuChangePo();
        xextSkuChangePo.setMsgGetId(reqBo.getMsgId());
        xextSkuChangePo.setSupplierShopId(reqBo.getSupplierShopId());
        List<XextSkuChangePo> skuChangePos = this.xextSkuChangeMapper.querMsg(xextSkuChangePo);
        XextSkuChangeHistoryPo xextSkuChangeHistoryPo = new XextSkuChangeHistoryPo();
        BeanUtils.copyProperties((Object)skuChangePos.get(0), (Object)xextSkuChangeHistoryPo);
        int count = 0;
        try {
            count = this.xextSkuChangeHistoryMapper.insertMsg(xextSkuChangeHistoryPo);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u6210\u529f\u6d88\u606f\u5165\u5e93{\u5386\u53f2}\u5931\u8d25\uff1a" + e.getMessage() + "  msgID = " + reqBo.getMsgId() + "  and supplierShopId = " + reqBo.getSupplierShopId());
        }
        if (count > 0) {
            XextSkuChangePo skuChangePo = new XextSkuChangePo();
            skuChangePo.setId(xextSkuChangeHistoryPo.getId());
            try {
                this.xextSkuChangeMapper.deleteRealRecords(skuChangePo);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u6d88\u606f\u8868\u4e2d\u7684\u5904\u7406\u6210\u529f\u8bb0\u5f55\u5931\u8d25");
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public UccUpdateMsgTableBusiRspBO updateFailed(UccUpdateMsgTableBusiReqBO reqBo) {
        UccUpdateMsgTableBusiRspBO rspBo = new UccUpdateMsgTableBusiRspBO();
        XextSkuChangePo po = new XextSkuChangePo();
        po.setMsgGetId(reqBo.getMsgId());
        po.setSupplierShopId(reqBo.getSupplierShopId());
        po.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_SUCCESS_PROCESS);
        po.setExtSkuHandleState(ModelRuleConstant.EXT_SKU_HANDLE_STATE_FAIL);
        po.setRemark(reqBo.getRemark());
        try {
            this.xextSkuChangeMapper.deleteRecords(po);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25\uff1a\u5165\u5e93\u4fe1\u606f" + JSONObject.toJSONString((Object)po) + "---- \u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new BusinessException("xextSkuChangeMapper_updateFail", "\u66f4\u65b0\u6d88\u606f\u5165\u5e93\u5931\u8d25");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public UccUpdateMsgTableBusiRspBO deleteRecord(UccUpdateMsgTableBusiReqBO reqBo) {
        UccUpdateMsgTableBusiRspBO rspBo = new UccUpdateMsgTableBusiRspBO();
        log.error("msgId = " + reqBo.getMsgId() + "and supplierShopId = " + reqBo.getSupplierShopId() + reqBo.getRemark());
        XextSkuChangePo po = new XextSkuChangePo();
        po.setMsgGetId(reqBo.getMsgId());
        po.setSupplierShopId(reqBo.getSupplierShopId());
        po.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_SUCCESS_PROCESS);
        po.setExtSkuHandleState(ModelRuleConstant.EXT_SKU_HANDLE_STATE_SUCCESS);
        po.setRemark(reqBo.getRemark());
        try {
            this.xextSkuChangeMapper.deleteRecords(po);
        }
        catch (Exception e) {
            log.error("msgId = " + reqBo.getMsgId() + "and supplierShopId = " + reqBo.getSupplierShopId() + "\u5220\u9664\u5931\u8d25");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public UccUpdateMsgTableBusiRspBO updateExecuting(UccUpdateMsgTableBusiReqBO reqBo) {
        UccUpdateMsgTableBusiRspBO rspBo = new UccUpdateMsgTableBusiRspBO();
        XextSkuChangePo xextSkuChangePo = new XextSkuChangePo();
        xextSkuChangePo.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_EXECUTING_PROCESS);
        try {
            this.xextSkuChangeMapper.batchUpdateById(xextSkuChangePo, reqBo.getMsgIdList());
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6d88\u606f\u4e3a\u6267\u884c\u4e2d\u72b6\u6001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new BusinessException("xextSkuChangeMapper_updateExecuting", "\u66f4\u65b0\u6d88\u606f\u4e3a\u6267\u884c\u4e2d\u72b6\u6001\u5931\u8d25");
        }
        CacheMap cacheMap = CacheMap.getInstance();
        long id = Thread.currentThread().getId();
        if (null != reqBo.getType() && ModelRuleConstant.E_COMMERCE_MESSAGE_CHANGE.equals(reqBo.getType())) {
            cacheMap.putValue(id + "_commodity_id", SyncSequenceUtil.getIds(this.uccCommodityIdSequence, reqBo.getMsgIdList().size()));
            cacheMap.putValue(id + "_sku_id", SyncSequenceUtil.getIds(this.uccSkuIdSequence, reqBo.getMsgIdList().size()));
        } else {
            cacheMap.putValue(id + "_commodity_id", new ArrayList());
            cacheMap.putValue(id + "_sku_id", new ArrayList());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

