/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.comb.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.tydic.commodity.bo.busi.UccCommodityPublishReqBO;
import com.tydic.commodity.bo.comb.UccCommodityPublishCombReqBO;
import com.tydic.commodity.bo.comb.UccCommodityPublishCombRspBO;
import com.tydic.commodity.busi.api.UccCommodityPublishBusiService;
import com.tydic.commodity.comb.api.UccCommodityPublishCombService;
import com.tydic.commodity.comb.api.UccESCreateSkuDataCombService;
import com.tydic.commodity.dao.UccCommdQueryDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccCommdQueryPO;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import com.tydic.uac.ability.UacTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.comb.api.UccCommodityPublishCombService"})
public class UccCommodityPublishCombServiceImpl
implements UccCommodityPublishCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityPublishCombServiceImpl.class);
    @Value(value="${busi_code}")
    private String busiCode;
    @Autowired
    private UacTaskAuditCreateAbilityService uocAuditOrderCreateBusiService;
    @Autowired
    private UccCommdQueryDealMapper uccCommdQueryDealMapper;
    @Autowired
    private UccCommodityPublishBusiService commodityPublishBusiService;
    @Autowired
    private UacTaskAuditCreateAbilityService uacTaskAuditCreateAbilityService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccESCreateSkuDataCombService uccESCreateSkuDataCombService;

    @PostMapping(value={"publishCommodity"})
    public UccCommodityPublishCombRspBO publishCommodity(@RequestBody UccCommodityPublishCombReqBO reqBO) {
        UacTaskAuditCreateRspBO uacTaskAuditCreateRspBO;
        ValidatorUtil.validator((Object)reqBO);
        UccCommodityPublishCombRspBO commodityPublishCombRspBO = new UccCommodityPublishCombRspBO();
        if (reqBO.getCommodityId() == null || reqBO.getCommodityId() != null && reqBO.getCommodityId().length == 0) {
            commodityPublishCombRspBO.setRespCode("8888");
            commodityPublishCombRspBO.setRespDesc("\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
            return commodityPublishCombRspBO;
        }
        ArrayList approvalObjBOS = Lists.newArrayList();
        ApprovalObjBO approvalObjBO = null;
        for (int i = 0; i < reqBO.getCommodityId().length; ++i) {
            UccCommdQueryPO uccCommdQueryPO = this.uccCommdQueryDealMapper.selectCommodityByCommodityId(reqBO.getCommodityId()[i]);
            if (uccCommdQueryPO == null) {
                commodityPublishCombRspBO.setRespCode("8888");
                commodityPublishCombRspBO.setRespDesc("\u8f93\u5165\u5546\u54c1ID\u4e3a[" + uccCommdQueryPO.getCommodityId() + "]\u7684\u5546\u54c1\u4e0d\u5b58\u5728");
                return commodityPublishCombRspBO;
            }
            if (uccCommdQueryPO.getCommodityStatus() == null || uccCommdQueryPO.getCommodityStatus() != null && uccCommdQueryPO.getCommodityStatus() != 0) {
                commodityPublishCombRspBO.setRespCode("8888");
                commodityPublishCombRspBO.setRespDesc("\u5546\u54c1ID\u4e3a[" + uccCommdQueryPO.getCommodityId() + "]\u72b6\u6001\u9519\u8bef,\u5fc5\u987b\u4e3a\u8349\u7a3f\u72b6\u6001");
                return commodityPublishCombRspBO;
            }
            approvalObjBO = new ApprovalObjBO();
            approvalObjBO.setObjId(String.valueOf(uccCommdQueryPO.getCommodityId()));
            approvalObjBO.setObjName(uccCommdQueryPO.getCommodityName());
            approvalObjBOS.add(approvalObjBO);
        }
        UacTaskAuditCreateReqBO uacTaskAuditCreateReqBO = new UacTaskAuditCreateReqBO();
        uacTaskAuditCreateReqBO.setObjType("2");
        uacTaskAuditCreateReqBO.setCreateOperId(reqBO.getUpdateOperid());
        uacTaskAuditCreateReqBO.setBusiCode(this.busiCode);
        uacTaskAuditCreateReqBO.setExtField1(String.valueOf(reqBO.getShopId()));
        uacTaskAuditCreateReqBO.setObjNum(String.valueOf(reqBO.getCommodityId().length));
        uacTaskAuditCreateReqBO.setRemark("\u5546\u54c1\u53d1\u5e03\u6d41\u7a0b");
        uacTaskAuditCreateReqBO.setApprovalObjInfo((List)approvalObjBOS);
        try {
            System.out.println("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u63a5\u53e3\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)uacTaskAuditCreateReqBO));
            uacTaskAuditCreateRspBO = this.uacTaskAuditCreateAbilityService.auditOrderCreate(uacTaskAuditCreateReqBO);
        }
        catch (BusinessException e) {
            LOGGER.error("\u9519\u8bef\u7f16\u7801\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f,{},{}", new Object[]{e.getMsgCode(), e.getMsgInfo(), e});
            throw new BusinessException(e.getMsgCode(), e.getMsgInfo());
        }
        UccCommodityPublishReqBO commodityPublishReqBO = new UccCommodityPublishReqBO();
        commodityPublishReqBO.setCommodityId(reqBO.getCommodityId());
        commodityPublishReqBO.setShopId(reqBO.getShopId());
        commodityPublishReqBO.setUpdateOperid(reqBO.getUpdateOperid());
        commodityPublishReqBO.setOrderId(uacTaskAuditCreateRspBO.getOrderId());
        try {
            this.commodityPublishBusiService.dealCommodityPublish(commodityPublishReqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u5e03\u5546\u54c1\u5f02\u5e38\uff0c\u539f\u56e0:", (Throwable)e);
            throw new BusinessException("8888", e.getMessage());
        }
        commodityPublishCombRspBO.setRespDesc("\u6210\u529f");
        commodityPublishCombRspBO.setRespCode("0000");
        commodityPublishCombRspBO.setOrderId(uacTaskAuditCreateRspBO.getOrderId());
        return commodityPublishCombRspBO;
    }
}

