/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.comb.impl;

import com.tydic.commodity.bo.busi.CreataESSkuDataRspBO;
import com.tydic.commodity.bo.comb.UccSkuESDetailBO;
import com.tydic.commodity.busi.api.UccCreateESSkuDataBusiService;
import com.tydic.commodity.comb.api.UccESCreateSkuDataCombService;
import com.tydic.commodity.dao.DSkuEsMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccChannelPutMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuDetailMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccBatchSaleNumPo;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.dao.po.UccCatalogConnectCommdTypeDealPO;
import com.tydic.commodity.dao.po.UccCatalogDealPO;
import com.tydic.commodity.dao.po.UccChannelPutPo;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccSaleNumPo;
import com.tydic.commodity.dao.po.UccSkuDetailPO;
import com.tydic.commodity.dao.po.UccSkuESDetailPO;
import com.tydic.commodity.dao.po.UccSkuPicPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.enumType.CreateESSkuStrategyEnum;
import com.tydic.commodity.util.ListCloneUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.comb.api.UccESCreateSkuDataCombService"})
public class UccESCreateSkuDataCombServiceImpl
implements UccESCreateSkuDataCombService {
    private static final Logger logger = LoggerFactory.getLogger(UccESCreateSkuDataCombServiceImpl.class);
    @Autowired
    private DSkuEsMapper dSkuEsMapper;
    @Autowired
    private UccSkuMapper skuMapper;
    @Autowired
    private UccSkuDetailMapper uccSkuDetailMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccSkuPicMapper skuPicMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccChannelPutMapper uccChannelPutMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccCatRCommdTypeMapper catalogRelCommdTypeDealMapper;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccCreateESSkuDataBusiService createESSkuDataBusiService;
    @Autowired
    private UccCommodityMapper commodityMapper;

    @PostMapping(value={"createESSkuData"})
    public CreataESSkuDataRspBO createESSkuData(@RequestBody Long businessId, @RequestBody CreateESSkuStrategyEnum esSkuStrategyEnum) {
        CreataESSkuDataRspBO creataESSkuDataRspBO = new CreataESSkuDataRspBO();
        try {
            List<UccSkuDetailPO> listSkuDetailInfo;
            UccSkuDetailPO uccSkuDetailPO;
            UccSkuPo uccSkuPo;
            List<UccSkuPo> skuPos = null;
            if (CreateESSkuStrategyEnum.COMMODITY.getCODE().equals(esSkuStrategyEnum.getCODE())) {
                uccSkuPo = new UccSkuPo();
                uccSkuDetailPO = new UccSkuDetailPO();
                uccSkuPo.setCommodityId(businessId);
                uccSkuDetailPO.setCommodityId(businessId);
                skuPos = this.skuMapper.qerySku(uccSkuPo);
                listSkuDetailInfo = this.uccSkuDetailMapper.qerySku(uccSkuDetailPO);
                skuPos.forEach(skubo -> listSkuDetailInfo.forEach(skuDetailbo -> {
                    if (skubo.getSkuId() == skuDetailbo.getSkuId()) {
                        skubo.setSkuPcDetailChar(skuDetailbo.getSkuPcDetailChar());
                        skubo.setSkuPcDetailUrl(skuDetailbo.getSkuPcDetailUrl());
                        skubo.setSkuPhoneDetailChar(skuDetailbo.getSkuPhoneDetailChar());
                        skubo.setSkuPhoneDetailUrl(skuDetailbo.getSkuPhoneDetailUrl());
                    }
                }));
            } else if (CreateESSkuStrategyEnum.SKU.getCODE().equals(esSkuStrategyEnum.getCODE())) {
                uccSkuPo = new UccSkuPo();
                uccSkuDetailPO = new UccSkuDetailPO();
                uccSkuPo.setSkuId(businessId);
                uccSkuDetailPO.setSkuId(businessId);
                skuPos = this.skuMapper.qerySku(uccSkuPo);
                listSkuDetailInfo = this.uccSkuDetailMapper.qerySku(uccSkuDetailPO);
                skuPos.forEach(skubo -> listSkuDetailInfo.forEach(skuDetailbo -> {
                    if (skubo.getSkuId() == skuDetailbo.getSkuId()) {
                        skubo.setSkuPcDetailChar(skuDetailbo.getSkuPcDetailChar());
                        skubo.setSkuPcDetailUrl(skuDetailbo.getSkuPcDetailUrl());
                        skubo.setSkuPhoneDetailChar(skuDetailbo.getSkuPhoneDetailChar());
                        skubo.setSkuPhoneDetailUrl(skuDetailbo.getSkuPhoneDetailUrl());
                    }
                }));
            }
            if (!CreateESSkuStrategyEnum.TIMER_TASK.getCODE().equals(esSkuStrategyEnum.getCODE())) {
                if (CollectionUtils.isNotEmpty(skuPos)) {
                    ArrayList<UccSkuESDetailPO> commodityModels = new ArrayList<UccSkuESDetailPO>();
                    for (UccSkuPo skuPo : skuPos) {
                        UccSkuESDetailPO uccSkuESDetailPO = new UccSkuESDetailPO();
                        this.setSkuToCommodity(uccSkuESDetailPO, skuPo);
                        this.setSkuPriceToCommodity(uccSkuESDetailPO, skuPo.getSkuId());
                        this.setBrandToCommodity(uccSkuESDetailPO, skuPo.getCommodityId());
                        if (CreateESSkuStrategyEnum.COMMODITY.equals((Object)esSkuStrategyEnum)) {
                            this.setPicUrlToCommodityByCommoId(uccSkuESDetailPO, skuPo.getSkuId(), skuPo.getCommodityId());
                        } else if (CreateESSkuStrategyEnum.SKU.equals((Object)esSkuStrategyEnum)) {
                            this.setPicUrlToCommodityBySkuId(uccSkuESDetailPO, skuPo.getSkuId(), skuPo.getCommodityId());
                        }
                        this.setShopInfoToCommodity(uccSkuESDetailPO, skuPo.getCommodityId());
                        this.setPropertiesToCommodity(uccSkuESDetailPO, skuPo.getSkuId());
                        this.setChannelToCommodity(uccSkuESDetailPO, skuPo.getSkuId());
                        this.setSoldNumberToCommodity(uccSkuESDetailPO, skuPo.getSkuId());
                        this.setLinkMallCommodityName(uccSkuESDetailPO, skuPo.getCommodityId());
                        commodityModels.addAll(this.getCatalogToCommoditys(uccSkuESDetailPO, skuPo.getCommodityTypeId()));
                    }
                    List uccSkuESDetailBOS = ListCloneUtils.clonePOListToBOListNotDate(commodityModels, UccSkuESDetailBO.class);
                    logger.info("\u624b\u52a8==\u521b\u5efaes\u6570\u636e\u6761\u6570:" + uccSkuESDetailBOS.size());
                    this.createESSkuDataBusiService.createESSkuDataBusiService(uccSkuESDetailBOS);
                }
            } else if (CreateESSkuStrategyEnum.TIMER_TASK.getCODE().equals(esSkuStrategyEnum.getCODE())) {
                boolean flage = true;
                while (flage) {
                    ArrayList<UccSkuESDetailPO> commodityModels = new ArrayList<UccSkuESDetailPO>();
                    List<UccSkuPo> uccSkuPos = null;
                    UccSkuESDetailPO uccSkuESDetailPO = this.dSkuEsMapper.selectSkuCreateTimeDescLimitOne();
                    if (null != uccSkuESDetailPO && null != uccSkuESDetailPO.getSkuCreateTime()) {
                        uccSkuPos = this.skuMapper.getGTESCreateTimeDetail(uccSkuESDetailPO.getSkuCreateTime());
                        if (CollectionUtils.isEmpty(uccSkuPos)) {
                            flage = false;
                        }
                    } else if (null != uccSkuESDetailPO && null == uccSkuESDetailPO.getSkuCreateTime() || null == uccSkuESDetailPO) {
                        uccSkuPos = this.skuMapper.getGTESCreateTimeASCDetail();
                    }
                    if (CollectionUtils.isNotEmpty(uccSkuPos)) {
                        Map<Long, Long> skuMaps = uccSkuPos.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, UccSkuPo::getSupplierShopId));
                        List<UccSkuDetailPO> listSkuDetailInfo2 = this.uccSkuDetailMapper.batchQrySkuCopy(skuMaps);
                        uccSkuPos.forEach(skubo -> listSkuDetailInfo2.forEach(skuDetailbo -> {
                            if (skubo.getSkuId() == skuDetailbo.getSkuId()) {
                                skubo.setSkuPcDetailChar(skuDetailbo.getSkuPcDetailChar());
                                skubo.setSkuPcDetailUrl(skuDetailbo.getSkuPcDetailUrl());
                                skubo.setSkuPhoneDetailChar(skuDetailbo.getSkuPhoneDetailChar());
                                skubo.setSkuPhoneDetailUrl(skuDetailbo.getSkuPhoneDetailUrl());
                            }
                        }));
                        logger.info("\u67e5\u8be2\u6570\u636e\u6761\u6570\uff1a" + uccSkuPos.size());
                        for (UccSkuPo skuPo : uccSkuPos) {
                            UccSkuESDetailPO uccSkuESDetail = new UccSkuESDetailPO();
                            this.setSkuToCommodity(uccSkuESDetail, skuPo);
                            this.setSkuPriceToCommodity(uccSkuESDetail, skuPo.getSkuId());
                            this.setBrandToCommodity(uccSkuESDetail, skuPo.getCommodityId());
                            this.setPicUrlToCommodityBySkuId(uccSkuESDetail, skuPo.getSkuId(), skuPo.getCommodityId());
                            this.setShopInfoToCommodity(uccSkuESDetail, skuPo.getCommodityId());
                            this.setPropertiesToCommodity(uccSkuESDetail, skuPo.getSkuId());
                            this.setChannelToCommodity(uccSkuESDetail, skuPo.getSkuId());
                            this.setSoldNumberToCommodity(uccSkuESDetail, skuPo.getSkuId());
                            this.setLinkMallCommodityName(uccSkuESDetailPO, skuPo.getCommodityId());
                            commodityModels.addAll(this.getCatalogToCommoditys(uccSkuESDetail, skuPo.getCommodityTypeId()));
                        }
                        List uccSkuESDetailBOS = ListCloneUtils.clonePOListToBOListNotDate(commodityModels, UccSkuESDetailBO.class);
                        logger.info("\u521b\u5efaes\u6570\u636e\u6761\u6570:" + uccSkuESDetailBOS.size());
                        this.createESSkuDataBusiService.createESSkuDataBusiService(uccSkuESDetailBOS);
                    }
                    flage = false;
                }
            }
        }
        catch (Exception e) {
            creataESSkuDataRspBO.setRespDesc("\u5931\u8d25");
            creataESSkuDataRspBO.setRespCode("8888");
            logger.error("\u7ec4\u88c5\u521b\u5efaes\uff0csku\u7684\u6570\u636e\u5931\u8d25", (Throwable)e);
            return creataESSkuDataRspBO;
        }
        creataESSkuDataRspBO.setRespDesc("\u6210\u529f");
        creataESSkuDataRspBO.setRespCode("0000");
        return creataESSkuDataRspBO;
    }

    private void setLinkMallCommodityName(UccSkuESDetailPO uccSkuESDetailPO, Long commodityId) {
        UccCommodityPo commodityPo = this.commodityMapper.getCommodityById(commodityId);
        if (commodityPo != null) {
            uccSkuESDetailPO.setViewOrder(commodityPo.getViewOrder());
            uccSkuESDetailPO.setCommodityName(commodityPo.getCommodityName());
        }
    }

    private void setSkuToCommodity(UccSkuESDetailPO commodityModel, UccSkuPo skuModel) {
        if (!StringUtils.isEmpty((Object)skuModel.getAgreementId())) {
            commodityModel.setAgreementId(skuModel.getAgreementId());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getSkuPcDetailChar())) {
            commodityModel.setSkuPcDetailChar(skuModel.getSkuPcDetailChar());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getSkuPhoneDetailChar())) {
            commodityModel.setSkuPhoneDetailChar(skuModel.getSkuPhoneDetailChar());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getExtSkuId())) {
            commodityModel.setExtSkuId(skuModel.getExtSkuId());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getMfgsku())) {
            commodityModel.setMfgsku(skuModel.getMfgsku());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getOnShelveTime())) {
            commodityModel.setOnShelveTime(skuModel.getOnShelveTime().getTime());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getSkuId())) {
            commodityModel.setSkuId(skuModel.getSkuId());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getSkuSource())) {
            commodityModel.setSkuSource(skuModel.getSkuSource());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getSkuStatus())) {
            commodityModel.setSkuStatus(skuModel.getSkuStatus());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getSkuName())) {
            commodityModel.setSkuName(skuModel.getSkuName());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getUpcCode())) {
            commodityModel.setUpc(skuModel.getUpcCode());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getCommodityId())) {
            commodityModel.setCommodityId(skuModel.getCommodityId());
        }
        commodityModel.setSkuCreateTime(skuModel.getCreateTime());
    }

    private void setSkuPriceToCommodity(UccSkuESDetailPO commodityModel, Long skuId) {
        try {
            List<UccSkuPricePo> skuPriceModels = this.uccSkuPriceMapper.getPricesBySkuId(skuId);
            for (UccSkuPricePo skuPriceModel : skuPriceModels) {
                if (!StringUtils.isEmpty((Object)skuPriceModel.getAgreementPrice())) {
                    commodityModel.setAgreementPrice(skuPriceModel.getAgreementPrice());
                }
                if (!StringUtils.isEmpty((Object)skuPriceModel.getMarketPrice())) {
                    commodityModel.setMarketPrice(skuPriceModel.getMarketPrice());
                }
                if (!StringUtils.isEmpty((Object)skuPriceModel.getMemberPrice1())) {
                    commodityModel.setMemberPrice1(skuPriceModel.getMemberPrice1());
                }
                if (!StringUtils.isEmpty((Object)skuPriceModel.getMemberPrice2())) {
                    commodityModel.setMemberPrice2(skuPriceModel.getMemberPrice2());
                }
                if (!StringUtils.isEmpty((Object)skuPriceModel.getMemberPrice3())) {
                    commodityModel.setMemberPrice3(skuPriceModel.getMemberPrice3());
                }
                if (!StringUtils.isEmpty((Object)skuPriceModel.getMemberPrice4())) {
                    commodityModel.setMemberPrice4(skuPriceModel.getMemberPrice4());
                }
                if (!StringUtils.isEmpty((Object)skuPriceModel.getMemberPrice5())) {
                    commodityModel.setMemberPrice5(skuPriceModel.getMemberPrice5());
                }
                if (!StringUtils.isEmpty((Object)skuPriceModel.getSalePrice())) {
                    commodityModel.setSalePrice(skuPriceModel.getSalePrice());
                }
                BigDecimal discounts = new BigDecimal(0);
                try {
                    discounts = new BigDecimal(commodityModel.getSalePrice()).divide(new BigDecimal(commodityModel.getMarketPrice()), 2, 4);
                }
                catch (Exception e) {
                    logger.error("set price is error\uff0c\u4ef7\u683c\u53ef\u80fd\u4e3a0" + e + "");
                }
                commodityModel.setDiscounts(discounts);
            }
        }
        catch (Exception e) {
            logger.error("set price is error" + e);
            throw e;
        }
    }

    private void setBrandToCommodity(UccSkuESDetailPO commodityModel, Long commodityId) {
        try {
            List<UccBrandDealPO> brandModels = this.uccBrandDealMapper.getBrandsByCommodityId(commodityId);
            for (UccBrandDealPO brandModel : brandModels) {
                if (!StringUtils.isEmpty((Object)brandModel.getBrandId())) {
                    commodityModel.setBrandId(brandModel.getBrandId());
                }
                if (!StringUtils.isEmpty((Object)brandModel.getBrandEnName())) {
                    commodityModel.setBrandIdName(brandModel.getBrandEnName());
                }
                if (StringUtils.isEmpty((Object)brandModel.getBrandName())) continue;
                commodityModel.setBrandName(brandModel.getBrandName());
            }
        }
        catch (Exception e) {
            logger.error("set brand is error" + e);
            throw e;
        }
    }

    private void setPicUrlToCommodityBySkuId(UccSkuESDetailPO commodityModel, Long skuId, Long commodityId) {
        try {
            UccSkuPicPo skuPicPo = new UccSkuPicPo();
            skuPicPo.setSkuId(skuId);
            skuPicPo.setCommodityPicType(1);
            List<UccSkuPicPo> uccSkuPicPos = this.skuPicMapper.qeurySkuPic(skuPicPo);
            if (CollectionUtils.isNotEmpty(uccSkuPicPos)) {
                UccSkuPicPo uccSkuPicPo = uccSkuPicPos.get(0);
                commodityModel.setPictureUrl(uccSkuPicPo.getSkuPicUrl());
                commodityModel.setCommdPicUrl(uccSkuPicPo.getSkuPicUrl());
            }
        }
        catch (Exception e) {
            logger.error("set sku picture is error" + e);
            throw e;
        }
    }

    private void setPicUrlToCommodityByCommoId(UccSkuESDetailPO commodityModel, Long skuId, Long commodityId) {
        try {
            UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
            uccCommodityPicPo.setCommodityId(commodityId);
            uccCommodityPicPo.setCommodityPicType(1);
            List<UccCommodityPicPo> uccCommodityPicPos = this.uccCommodityPicMapper.queryCommdPic(uccCommodityPicPo);
            if (CollectionUtils.isNotEmpty(uccCommodityPicPos)) {
                UccCommodityPicPo uccSkuPicPo = uccCommodityPicPos.get(0);
                commodityModel.setPictureUrl(uccSkuPicPo.getCommodityPicUrl());
                commodityModel.setCommdPicUrl(uccSkuPicPo.getCommodityPicUrl());
            }
        }
        catch (Exception e) {
            logger.error("set commodity picture is error" + e);
            throw e;
        }
    }

    private void setShopInfoToCommodity(UccSkuESDetailPO commodityModel, Long commodityId) {
        try {
            List<SupplierShopPo> shopModels = this.supplierShopMapper.queryShopByCommodityId(commodityId);
            for (SupplierShopPo shopModel : shopModels) {
                if (!StringUtils.isEmpty((Object)shopModel.getSupplierId())) {
                    commodityModel.setSupplierId(shopModel.getSupplierId());
                }
                if (!StringUtils.isEmpty((Object)shopModel.getSupplierName())) {
                    commodityModel.setSupplierName(shopModel.getSupplierName());
                }
                if (!StringUtils.isEmpty((Object)shopModel.getSupplierShopId())) {
                    commodityModel.setSupplierShopId(shopModel.getSupplierShopId());
                }
                if (StringUtils.isEmpty((Object)shopModel.getShopName())) continue;
                commodityModel.setShopName(shopModel.getShopName());
            }
        }
        catch (Exception e) {
            logger.error("set shop is error ;" + e);
            throw e;
        }
    }

    private void setPropertiesToCommodity(UccSkuESDetailPO commodityModel, Long skuId) {
        try {
            String s = this.uccSpuSpecMapper.getSpuSpecProperties(skuId);
            if (!StringUtils.isEmpty((Object)s)) {
                commodityModel.setProperties(s);
            }
        }
        catch (Exception e) {
            logger.error("set properties is error:" + e);
            throw e;
        }
    }

    private void setChannelToCommodity(UccSkuESDetailPO commodityModel, Long skuId) {
        try {
            UccChannelPutPo uccChannelPutPo = new UccChannelPutPo();
            ArrayList<Long> channelIds = new ArrayList<Long>();
            uccChannelPutPo.setPutObjId(skuId);
            uccChannelPutPo.setPutObjType(2);
            List<UccChannelPutPo> uccChannelPutPos = this.uccChannelPutMapper.qryChannels(uccChannelPutPo);
            try {
                for (UccChannelPutPo channelPutPo : uccChannelPutPos) {
                    channelIds.add(channelPutPo.getChannelId());
                }
            }
            catch (Exception e) {
                logger.info("this sku has no channel");
            }
            if (channelIds != null && channelIds.size() > 0 && channelIds.size() < 2) {
                commodityModel.setChannelId((Long)channelIds.get(0));
            }
        }
        catch (Exception e) {
            logger.error("set channel is error" + e);
            throw e;
        }
    }

    private void setSoldNumberToCommodity(UccSkuESDetailPO commodityModel, Long skuId) {
        try {
            UccBatchSaleNumPo uccBatchSaleNumPo = new UccBatchSaleNumPo();
            ArrayList<Long> skuIds = new ArrayList<Long>();
            skuIds.add(skuId);
            uccBatchSaleNumPo.setSkuIds(skuIds);
            List<UccSaleNumPo> uccSaleNumPos = this.uccSaleNumMapper.queryBatchSaleNum(uccBatchSaleNumPo);
            for (UccSaleNumPo saleNumModel : uccSaleNumPos) {
                if (saleNumModel.getSoldNumber() == null) continue;
                commodityModel.setSoldNumber(saleNumModel.getSoldNumber().longValue());
                commodityModel.setEcommerceSale(saleNumModel.getEcommerceSale());
            }
        }
        catch (Exception e) {
            logger.error("set soldNum is error:" + e);
            throw e;
        }
    }

    private List<UccSkuESDetailPO> getCatalogToCommoditys(UccSkuESDetailPO commodityModel, Long commodityTypeId) {
        ArrayList<UccSkuESDetailPO> commodityModelList = new ArrayList<UccSkuESDetailPO>();
        try {
            UccCatalogConnectCommdTypeDealPO catalogConnectCommdTypeDealPO = new UccCatalogConnectCommdTypeDealPO();
            catalogConnectCommdTypeDealPO.setCommodityTypeId(commodityTypeId);
            List<UccCatalogConnectCommdTypeDealPO> connectCommdTypeDealPOS = this.catalogRelCommdTypeDealMapper.selectExistingRel(catalogConnectCommdTypeDealPO);
            if (CollectionUtils.isNotEmpty(connectCommdTypeDealPOS)) {
                for (UccCatalogConnectCommdTypeDealPO connectCommdTypeDealPO : connectCommdTypeDealPOS) {
                    UccSkuESDetailPO commodityModelGuid = new UccSkuESDetailPO();
                    BeanUtils.copyProperties((Object)commodityModel, (Object)commodityModelGuid);
                    if (!this.setCatalogToCommodity(commodityModelGuid, connectCommdTypeDealPO.getGuideCatalogId())) continue;
                    commodityModelList.add(commodityModelGuid);
                }
            } else {
                commodityModelList.add(commodityModel);
            }
        }
        catch (BeansException e) {
            logger.error("set catalog is error:" + (Object)((Object)e));
            throw e;
        }
        return commodityModelList;
    }

    private boolean setCatalogToCommodity(UccSkuESDetailPO commodityModel, Long guidCatalogId) {
        UccCatalogDealPO catalogDealPO = new UccCatalogDealPO();
        catalogDealPO.setGuideCatalogId(guidCatalogId);
        List<UccCatalogDealPO> categoryModels = this.uccCatalogDealMapper.queryCatalog(catalogDealPO);
        if (categoryModels.size() < 1 || categoryModels == null) {
            return false;
        }
        Integer level = 0;
        for (UccCatalogDealPO categoryModel : categoryModels) {
            if (categoryModel.getCatalogLevel() != null) {
                level = categoryModel.getCatalogLevel();
            }
            if (level.equals(1)) {
                if (!StringUtils.isEmpty((Object)categoryModel.getGuideCatalogId())) {
                    commodityModel.setL1CategoryId(categoryModel.getGuideCatalogId());
                }
                if (StringUtils.isEmpty((Object)categoryModel.getCatalogName())) continue;
                commodityModel.setL1CategoryName(categoryModel.getCatalogName());
                continue;
            }
            if (level.equals(2)) {
                if (!StringUtils.isEmpty((Object)categoryModel.getGuideCatalogId())) {
                    commodityModel.setL2CategoryId(categoryModel.getGuideCatalogId());
                }
                if (!StringUtils.isEmpty((Object)categoryModel.getCatalogName())) {
                    commodityModel.setL2CategoryName(categoryModel.getCatalogName());
                }
                if (categoryModel.getUpperCatalogId() == null) continue;
                this.setCatalogToCommodity(commodityModel, categoryModel.getUpperCatalogId());
                continue;
            }
            if (!level.equals(3)) continue;
            if (!StringUtils.isEmpty((Object)categoryModel.getGuideCatalogId())) {
                commodityModel.setL3CategoryId(categoryModel.getGuideCatalogId());
            }
            if (!StringUtils.isEmpty((Object)categoryModel.getCatalogName())) {
                commodityModel.setL3CategoryName(categoryModel.getCatalogName());
            }
            if (categoryModel.getUpperCatalogId() == null) continue;
            this.setCatalogToCommodity(commodityModel, categoryModel.getUpperCatalogId());
        }
        return true;
    }
}

