/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.comb.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.bo.busi.SkuNumBO_busi;
import com.tydic.commodity.bo.busi.UccCurrentStockQryReqBO;
import com.tydic.commodity.bo.busi.UccCurrentStockQryRspBO;
import com.tydic.commodity.bo.busi.UccStockUpdateReqBO;
import com.tydic.commodity.bo.comb.UccStockControlReqBO;
import com.tydic.commodity.bo.comb.UccStockControlRspBO;
import com.tydic.commodity.busi.api.UccCommdStockQryBusiService;
import com.tydic.commodity.busi.api.UccStockUpdateBusiService;
import com.tydic.commodity.busi.impl.UccStockUpdateBusiServiceImpl;
import com.tydic.commodity.comb.api.UccStockControlCombService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccSkuStockPo;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.comb.api.UccStockControlCombService"})
public class UccStockControlCombServiceImpl
implements UccStockControlCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccStockUpdateBusiServiceImpl.class);
    @Autowired
    private UccSkuStockMapper uccSkuStockMapper;
    @Autowired
    private UccCommdStockQryBusiService uccCommdStockQryBusiService;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccStockUpdateBusiService uccStockUpdateBusiService;

    @PostMapping(value={"updateStock"})
    public UccStockControlRspBO updateStock(@RequestBody UccStockControlReqBO reqBO) {
        UccStockControlRspBO rspBO = new UccStockControlRspBO();
        if (reqBO.getSupplierId() == null) {
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u5546\u6237ID");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        if (reqBO.getAreaId() == null) {
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u533a\u57df\u7801");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        List<SupplierShopPo> supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (CollectionUtils.isEmpty(supplierShopPos)) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u6b63\u786e\u5546\u6237");
        }
        List<Long> supplierShopIds = supplierShopPos.stream().map(SupplierShopPo::getSupplierShopId).collect(Collectors.toList());
        int pageNo = 1;
        while (true) {
            LOGGER.info("\u7b2c" + pageNo + "\u8f6e\u66f4\u65b0\u5f00\u59cb");
            Page page = new Page(pageNo, 20);
            List<Object> uccSkuStockPos = new ArrayList();
            try {
                uccSkuStockPos = this.uccSkuStockMapper.qryStockPage((Page<UccSkuStockPo>)page, supplierShopIds);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u6279\u91cf\u67e5\u8be2\u5355\u54c1\u5931\u8d25");
            }
            ++pageNo;
            if (CollectionUtils.isEmpty(uccSkuStockPos)) break;
            ArrayList<SkuNumBO_busi> skuNumBO_busis = new ArrayList<SkuNumBO_busi>();
            for (UccSkuStockPo uccSkuStockPo : uccSkuStockPos) {
                SkuNumBO_busi skuNumBO_busi = new SkuNumBO_busi();
                if (reqBO.getStockNum() != null) {
                    if (uccSkuStockPo.getStockNum().compareTo(reqBO.getStockNum()) != -1) continue;
                    skuNumBO_busi.setSkuId(uccSkuStockPo.getSkuId());
                    skuNumBO_busi.setNum(Long.valueOf(reqBO.getStockNum().longValue()));
                    skuNumBO_busis.add(skuNumBO_busi);
                    continue;
                }
                skuNumBO_busi.setSkuId(uccSkuStockPo.getSkuId());
                skuNumBO_busi.setNum(Long.valueOf(1L));
                skuNumBO_busis.add(skuNumBO_busi);
            }
            if (CollectionUtils.isEmpty(skuNumBO_busis)) continue;
            UccCurrentStockQryReqBO uccCurrentStockQryReqBO = new UccCurrentStockQryReqBO();
            uccCurrentStockQryReqBO.setCounty(reqBO.getAreaId());
            uccCurrentStockQryReqBO.setSkuNum(skuNumBO_busis);
            uccCurrentStockQryReqBO.setSupplierShopId(supplierShopIds.get(0));
            UccCurrentStockQryRspBO uccCurrentStockQryRspBO = this.uccCommdStockQryBusiService.qryStock(uccCurrentStockQryReqBO);
            if (CollectionUtils.isEmpty((Collection)uccCurrentStockQryRspBO.getCommdStockInfo())) continue;
            List commdStockBO_busis = uccCurrentStockQryRspBO.getCommdStockInfo();
            try {
                UccStockUpdateReqBO uccStockUpdateReqBO = new UccStockUpdateReqBO();
                uccStockUpdateReqBO.setCommdStockBO_busis(commdStockBO_busis);
                uccStockUpdateReqBO.setSupplierShopId(supplierShopIds.get(0));
                this.uccStockUpdateBusiService.updateStock(uccStockUpdateReqBO);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u4fee\u6539\u5e93\u5b58\u5931\u8d25");
            }
            int page1 = pageNo - 1;
            LOGGER.info("\u7b2c" + page1 + "\u8f6e\u66f4\u65b0\u7ed3\u675f");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u66f4\u65b0\u6210\u529f");
        return rspBO;
    }
}

