/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.ability.api.UccBatchShopingQryAbilityService;
import com.tydic.commodity.atom.UccAreaAvailableQryAtomService;
import com.tydic.commodity.atom.UccAvailableCommdQryAtomService;
import com.tydic.commodity.atom.UccCommdDetailsQryAtomService;
import com.tydic.commodity.atom.UccCurrentStockQryAtomService;
import com.tydic.commodity.atom.UccQryPriceFromLadderPriceAtomService;
import com.tydic.commodity.atom.bo.SkuNumBO_Atom;
import com.tydic.commodity.atom.bo.UccAreaAvailableQryReqBO;
import com.tydic.commodity.atom.bo.UccAreaAvailableQryRspBO;
import com.tydic.commodity.atom.bo.UccAvailableCommdQryReqBO;
import com.tydic.commodity.atom.bo.UccAvailableCommdQryRspBO;
import com.tydic.commodity.atom.bo.UccCommdDetailsQryReqBO;
import com.tydic.commodity.atom.bo.UccCommdDetailsQryRspBO;
import com.tydic.commodity.atom.bo.UccCurrentStockQryReqBO;
import com.tydic.commodity.atom.bo.UccCurrentStockQryRspBO;
import com.tydic.commodity.atom.bo.UccQryPriceFromLadderPriceBO;
import com.tydic.commodity.atom.bo.UccQryPriceFromLadderPriceReqBO;
import com.tydic.commodity.atom.bo.UccQryPriceFromLadderPriceRspBO;
import com.tydic.commodity.bo.ability.LadderPriceBo;
import com.tydic.commodity.bo.ability.SaleSkuPropEntityBo;
import com.tydic.commodity.bo.ability.UccBatchShopQryBo;
import com.tydic.commodity.bo.ability.UccBatchShopQryMsgBo;
import com.tydic.commodity.bo.ability.UccBatchShopQryReqBo;
import com.tydic.commodity.bo.ability.UccBatchShopQryRspBo;
import com.tydic.commodity.bo.busi.AreaAvailableCommdBO_busi;
import com.tydic.commodity.bo.busi.AvailableCommdBO_busi;
import com.tydic.commodity.bo.busi.CommdStockBO_busi;
import com.tydic.commodity.bo.busi.JdPriceBO_busi;
import com.tydic.commodity.bo.busi.NotJdPriceBO_busi;
import com.tydic.commodity.bo.busi.UccCurrentPriceQryReqBO;
import com.tydic.commodity.bo.busi.UccCurrentPriceQryRspBO;
import com.tydic.commodity.busi.api.UccCurrentPriceQryBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccEMdmMaterialPO;
import com.tydic.commodity.dao.po.UccLadderPricePO;
import com.tydic.commodity.dao.po.UccSkuPicPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuSpecPo;
import com.tydic.commodity.dao.po.UccSkuStockPo;
import com.tydic.commodity.dao.po.UccVendorPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.CommdStockBO;
import com.tydic.commodity.external.bo.SkuStateRspBo;
import com.tydic.commodity.external.bo.UccSkuStateReqBO;
import com.tydic.commodity.external.bo.UccSkuStateRsp;
import com.tydic.commodity.external.bo.UccTmCommdStockQryReqBO;
import com.tydic.commodity.external.bo.UccTmCommdStockQryRspBO;
import com.tydic.commodity.external.bo.UccTmStockBO;
import com.tydic.commodity.external.service.UccQrySkuStateService;
import com.tydic.commodity.external.service.UccTmCommdStockQryService;
import com.tydic.commodity.util.ListUtils;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.ability.api.UccBatchShopingQryAbilityService"})
public class UccBatchShopingQryAbilityServiceImpl
implements UccBatchShopingQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchShopingQryAbilityServiceImpl.class);
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(UccBatchShopingQryAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccCommdDetailsQryAtomService uccCommdDetailsQryAtomService;
    @Autowired
    private UccCurrentPriceQryBusiService uccCurrentPriceQryBusiService;
    @Autowired
    private UccAreaAvailableQryAtomService uccAreaAvailableQryAtomService;
    @Autowired
    private UccAvailableCommdQryAtomService uccAvailableCommdQryAtomService;
    @Autowired
    private UccQrySkuStateService UccQrySkuStateService;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccCurrentStockQryAtomService uccCurrentStockQryAtomService;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuStockMapper uccSkuStockMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccTmCommdStockQryService uccTmCommdStockQryService;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccQryPriceFromLadderPriceAtomService uccQryPriceFromLadderPriceAtomService;

    @PostMapping(value={"qryInfo"})
    public UccBatchShopQryRspBo qryInfo(@RequestBody UccBatchShopQryReqBo reqBo) {
        UccBatchShopQryRspBo rspBo = new UccBatchShopQryRspBo();
        if (reqBo.getShopQry() == null || reqBo.getShopQry().size() == 0) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5355\u54c1ID \u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBo;
        }
        if (((UccBatchShopQryBo)reqBo.getShopQry().get(0)).getSupplierShopId() == null) {
            List<Long> skus = reqBo.getShopQry().stream().map(UccBatchShopQryBo::getSkuId).collect(Collectors.toList());
            List<UccSkuPo> skuPoList = this.uccSkuMapper.batchQrySku(skus, null);
            if (CollectionUtils.isEmpty(skuPoList)) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5355\u54c1ID!");
                return rspBo;
            }
            Map<Long, Long> skuShopsMap = skuPoList.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, UccSkuPo::getSupplierShopId));
            for (UccBatchShopQryBo each : reqBo.getShopQry()) {
                if (skuShopsMap.containsKey(each.getSkuId())) {
                    each.setSupplierShopId(skuShopsMap.get(each.getSkuId()));
                    continue;
                }
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5355\u54c1ID:" + each.getSkuId());
                return rspBo;
            }
        }
        ArrayList<UccBatchShopQryMsgBo> shopQryMsgBos = new ArrayList<UccBatchShopQryMsgBo>();
        Map<Integer, Map<Long, ArrayList<UccBatchShopQryBo>>> sortmap = this.groupBySourceAndSupplierShopId(reqBo);
        Map<Object, Object> map = new HashMap();
        if (sortmap.containsKey(ModelRuleConstant.SKU_SOURCE_SELF_SUPPORT)) {
            map = sortmap.get(ModelRuleConstant.SKU_SOURCE_SELF_SUPPORT);
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                try {
                    shopQryMsgBos.addAll(this.queryLocalDetail((List)entry.getValue()));
                }
                catch (BusinessException e) {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc(e.getMsgInfo());
                    return rspBo;
                }
            }
        }
        if (sortmap.containsKey(ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT)) {
            map = sortmap.get(ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT);
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                try {
                    shopQryMsgBos.addAll(this.queryElcCommdDetail((List)entry.getValue(), reqBo.getOrgIdIn()));
                }
                catch (BusinessException e) {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc(e.getMsgInfo());
                    return rspBo;
                }
            }
        }
        if (sortmap.containsKey(ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION)) {
            map = sortmap.get(ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION);
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                List<UccBatchShopQryMsgBo> uccBatchShopQryMsgBos = null;
                try {
                    uccBatchShopQryMsgBos = this.queryLocalDetail((List)entry.getValue());
                    this.dealZoneSkuMiniOrderNum(uccBatchShopQryMsgBos);
                }
                catch (BusinessException e) {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc(e.getMsgInfo());
                    return rspBo;
                }
                shopQryMsgBos.addAll(uccBatchShopQryMsgBos);
            }
        }
        ArrayList<UccBatchShopQryMsgBo> invalid = new ArrayList<UccBatchShopQryMsgBo>();
        for (UccBatchShopQryBo old : reqBo.getShopQry()) {
            if (shopQryMsgBos.size() > 0) {
                for (int i = 0; i < shopQryMsgBos.size() && !old.getSkuId().equals(((UccBatchShopQryMsgBo)shopQryMsgBos.get(i)).getSkuId()); ++i) {
                    if (i != shopQryMsgBos.size() - 1 || old.getSkuId().equals(((UccBatchShopQryMsgBo)shopQryMsgBos.get(i)).getSkuId())) continue;
                    UccBatchShopQryMsgBo shopQryMsgBo = new UccBatchShopQryMsgBo();
                    BeanUtils.copyProperties((Object)old, (Object)shopQryMsgBo);
                    shopQryMsgBo.setStatus(Integer.valueOf(0));
                    shopQryMsgBo.setStock(Integer.valueOf(0));
                    shopQryMsgBo.setSaleNum(old.getSaleNum());
                    invalid.add(shopQryMsgBo);
                }
                continue;
            }
            UccBatchShopQryMsgBo shopQryMsgBo = new UccBatchShopQryMsgBo();
            BeanUtils.copyProperties((Object)old, (Object)shopQryMsgBo);
            shopQryMsgBo.setStatus(Integer.valueOf(0));
            shopQryMsgBo.setStock(Integer.valueOf(0));
            shopQryMsgBo.setSaleNum("1");
            invalid.add(shopQryMsgBo);
        }
        shopQryMsgBos.addAll(invalid);
        try {
            this.getMeasure(shopQryMsgBos);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u67e5\u8be2\u7269\u6599\u4fe1\u606f\u5931\u8d25");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setShopQryMsg(shopQryMsgBos);
        return rspBo;
    }

    /*
     * WARNING - void declaration
     */
    public List<UccBatchShopQryMsgBo> queryElcCommdDetail(List<UccBatchShopQryBo> bos, Long orgId) throws BusinessException {
        List<UccSkuPricePo> pricePos;
        ArrayList result = new ArrayList();
        SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(bos.get(0).getSupplierShopId());
        SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(supplierShopPo.getSupplierId());
        Long supplierShopId = supplierShopPo.getSupplierShopId();
        Long supplierId = supplierBusiPo.getSupplierId();
        String supplierCode = supplierBusiPo.getSupplierCode();
        Integer city = bos.get(0).getCity();
        Integer county = bos.get(0).getCounty();
        Integer provice = bos.get(0).getProvince();
        Integer town = bos.get(0).getTown();
        ArrayList<Long> skus = new ArrayList<Long>();
        for (UccBatchShopQryBo each : bos) {
            skus.add(each.getSkuId());
        }
        Object uccSkuPo = null;
        List<UccSkuPo> skuPoList = this.uccSkuMapper.queryBatchSkusLessCloumCcs(skus, supplierShopId, orgId);
        ArrayList<Long> invalid = new ArrayList<Long>();
        ArrayList<Long> invalidSku = new ArrayList<Long>();
        ArrayList<String> extSkus = new ArrayList<String>();
        ArrayList<UccBatchShopQryMsgBo> invalidBatchShopQryMsgBo = new ArrayList<UccBatchShopQryMsgBo>();
        ArrayList<UccBatchShopQryMsgBo> onShlefBatchShopQryMsgBo = new ArrayList<UccBatchShopQryMsgBo>();
        List<UccQryPriceFromLadderPriceBO> uccQryPriceFromLadderPriceBOS = this.getResultLadderPrice(bos);
        UccBatchShopQryMsgBo batchShopQryMsgBo = null;
        for (UccSkuPo po : skuPoList) {
            batchShopQryMsgBo = new UccBatchShopQryMsgBo();
            batchShopQryMsgBo.setSkuId(po.getSkuId());
            batchShopQryMsgBo.setSupplierShopId(supplierShopId);
            batchShopQryMsgBo.setSupplierId(supplierId);
            batchShopQryMsgBo.setSupplierName(supplierBusiPo.getSupplierName());
            batchShopQryMsgBo.setSupplierCode(supplierBusiPo.getSupplierCode());
            batchShopQryMsgBo.setSkuSource(po.getSkuSource());
            batchShopQryMsgBo.setExtralSkuId(po.getExtSkuId());
            batchShopQryMsgBo.setCommodityId(po.getCommodityId());
            batchShopQryMsgBo.setAgreementId(po.getAgreementId());
            batchShopQryMsgBo.setModel(po.getModel());
            batchShopQryMsgBo.setSpec(po.getSpec());
            batchShopQryMsgBo.setFigure(po.getFigure());
            batchShopQryMsgBo.setPreDeliverDay(po.getPreDeliverDay());
            batchShopQryMsgBo.setExtSkuId(po.getExtSkuId());
            batchShopQryMsgBo.setMaterialId(po.getMaterialId());
            batchShopQryMsgBo.setMaterialName(po.getMaterialName());
            batchShopQryMsgBo.setSkuName(po.getSkuName());
            batchShopQryMsgBo.setSaleUnit(po.getMeasureName());
            batchShopQryMsgBo.setIsFactoryShip(po.getIsFactoryShip());
            if (po.getMoq() != null) {
                batchShopQryMsgBo.setMoq(new BigDecimal(po.getMoq()));
            }
            List<LadderPriceBo> ladderPriceBos = this.getLadderPriceInfo(po.getSkuId(), po.getSupplierShopId());
            batchShopQryMsgBo.setLadderPrice((List)ladderPriceBos);
            for (UccBatchShopQryBo uccBatchShopQryBo : bos) {
                if (!po.getSkuId().equals(uccBatchShopQryBo.getSkuId())) continue;
                batchShopQryMsgBo.setSaleNum(uccBatchShopQryBo.getSaleNum());
                batchShopQryMsgBo.setIsChoice(uccBatchShopQryBo.getIsChoice());
                batchShopQryMsgBo.setJoinTime(uccBatchShopQryBo.getJoinTime());
            }
            if (CollectionUtils.isNotEmpty(uccQryPriceFromLadderPriceBOS)) {
                for (UccQryPriceFromLadderPriceBO uccQryPriceFromLadderPriceBO : uccQryPriceFromLadderPriceBOS) {
                    if (!po.getSkuId().equals(uccQryPriceFromLadderPriceBO.getSkuId())) continue;
                    batchShopQryMsgBo.setLadderResultPrice(uccQryPriceFromLadderPriceBO.getPurchasePrice());
                }
            }
            if (po.getSkuStatus() != ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                batchShopQryMsgBo.setStatus(Integer.valueOf(0));
                batchShopQryMsgBo.setStock(Integer.valueOf(0));
                batchShopQryMsgBo.setSkuName(po.getSkuName());
                invalid.add(po.getCommodityId());
                invalidBatchShopQryMsgBo.add(batchShopQryMsgBo);
                skus.remove(po.getSkuId());
                invalidSku.add(po.getSkuId());
                continue;
            }
            onShlefBatchShopQryMsgBo.add(batchShopQryMsgBo);
            extSkus.add(po.getExtSkuId());
        }
        if (invalidSku.size() > 0 && !CollectionUtils.isEmpty(pricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(invalidSku, supplierShopId))) {
            Map<Long, Long> invalidPricMap = pricePos.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, UccSkuPricePo::getSalePrice));
            for (UccBatchShopQryMsgBo uccBatchShopQryMsgBo : invalidBatchShopQryMsgBo) {
                if (!invalidPricMap.containsKey(uccBatchShopQryMsgBo.getSkuId())) continue;
                uccBatchShopQryMsgBo.setPrice(MoneyUtils.haoToYuan((Long)invalidPricMap.get(uccBatchShopQryMsgBo.getSkuId())));
            }
            invalidPricMap = null;
        }
        ArrayList<UccBatchShopQryMsgBo> allBos = new ArrayList<UccBatchShopQryMsgBo>();
        allBos.addAll(onShlefBatchShopQryMsgBo);
        if (!CollectionUtils.isEmpty(onShlefBatchShopQryMsgBo)) {
            UccSkuStateReqBO uccSkuStateReqBO = new UccSkuStateReqBO();
            uccSkuStateReqBO.setExtSkuIds(extSkus);
            uccSkuStateReqBO.setSupplierCode(supplierCode);
            uccSkuStateReqBO.setSupplierId(supplierId);
            UccSkuStateRsp uccSkuStateRsp = this.UccQrySkuStateService.qrySkuStatus(uccSkuStateReqBO);
            if (!"0000".equals(uccSkuStateRsp.getRespCode())) {
                LOGGER.error("\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)uccSkuStateRsp));
                for (UccBatchShopQryMsgBo uccBatchShopQryMsgBo : allBos) {
                    uccBatchShopQryMsgBo.setStatus(Integer.valueOf(0));
                }
            }
            if (uccSkuStateRsp.getSkuStates() != null) {
                Map<String, Integer> map = uccSkuStateRsp.getSkuStates().stream().collect(Collectors.toMap(SkuStateRspBo::getSku, SkuStateRspBo::getState));
                for (UccBatchShopQryMsgBo each : allBos) {
                    if (!map.containsKey(each.getExtralSkuId())) continue;
                    each.setStatus(map.get(each.getExtralSkuId()));
                }
            }
        }
        UccCurrentPriceQryReqBO uccCurrentPriceQryReqBO = new UccCurrentPriceQryReqBO();
        uccCurrentPriceQryReqBO.setSkuIds(skus);
        uccCurrentPriceQryReqBO.setSupplierShopId(supplierShopId);
        UccCurrentPriceQryRspBO uccCurrentPriceQryRspBO = this.uccCurrentPriceQryBusiService.changeCommdCurrentPrice(uccCurrentPriceQryReqBO);
        LOGGER.info("\u6253\u5370\u8c03\u7528\u4ef7\u683c\u51fa\u53c2\u65e5\u5fd7\uff1a" + JSON.toJSONString((Object)uccCurrentPriceQryRspBO));
        HashMap hashMap = new HashMap();
        if ("0000".equals(uccCurrentPriceQryRspBO.getRespCode())) {
            void var26_37;
            if (uccCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos() != null && uccCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos().size() > 0) {
                Map<String, BigDecimal> map = uccCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos().stream().collect(Collectors.toMap(JdPriceBO_busi::getSkuId, JdPriceBO_busi::getNewSalePrice));
            }
            if (uccCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo() != null && uccCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo().size() > 0) {
                for (NotJdPriceBO_busi notJdPriceBO_busi : uccCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo()) {
                    if (notJdPriceBO_busi.getNewSalePrice() != null) {
                        var26_37.put(notJdPriceBO_busi.getSkuId(), notJdPriceBO_busi.getNewSalePrice());
                        continue;
                    }
                    var26_37.put(notJdPriceBO_busi.getSkuId(), new BigDecimal(0));
                }
            }
            for (UccBatchShopQryMsgBo each : allBos) {
                if (!var26_37.containsKey(each.getSkuId().toString())) continue;
                each.setPrice((BigDecimal)var26_37.get(each.getSkuId().toString()));
            }
        } else {
            LOGGER.error("\u67e5\u8be2\u91d1\u989d\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)uccCurrentPriceQryRspBO));
        }
        UccAvailableCommdQryReqBO uccAvailableCommdQryReqBO = new UccAvailableCommdQryReqBO();
        uccAvailableCommdQryReqBO.setSkuIds(extSkus);
        uccAvailableCommdQryReqBO.setSupplierCode(supplierCode);
        UccAvailableCommdQryRspBO uccAvailableCommdQryRspBO = this.uccAvailableCommdQryAtomService.qryAvailableCommd(uccAvailableCommdQryReqBO);
        if ("0000".equals(uccAvailableCommdQryRspBO.getResultCode())) {
            Map<String, Integer> extSkuArea = uccAvailableCommdQryRspBO.getAvailableCommdInfos().stream().collect(Collectors.toMap(AvailableCommdBO_busi::getSkuId, AvailableCommdBO_busi::getSaleState));
            for (UccBatchShopQryMsgBo each : allBos) {
                each.setAvailableSale(extSkuArea.get(each.getExtralSkuId()));
                if (null != each.getAvailableSale()) continue;
                each.setAvailableSale(Integer.valueOf(0));
            }
        } else {
            LOGGER.error("\u67e5\u8be2\u53ef\u552e\u9a8c\u8bc1\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)((Object)uccAvailableCommdQryRspBO)));
        }
        if (city != null && provice != null && county != null) {
            UccAreaAvailableQryReqBO uccAreaAvailableQryReqBO = new UccAreaAvailableQryReqBO();
            uccAreaAvailableQryReqBO.setSkuIds(extSkus);
            if (city != null) {
                uccAreaAvailableQryReqBO.setCity(city.longValue());
            }
            if (county != null) {
                uccAreaAvailableQryReqBO.setCounty(county.longValue());
            }
            if (provice != null) {
                uccAreaAvailableQryReqBO.setProvince(provice.longValue());
            }
            if (town != null) {
                uccAreaAvailableQryReqBO.setTown(town.longValue());
            } else {
                uccAreaAvailableQryReqBO.setTown(0L);
            }
            uccAreaAvailableQryReqBO.setSupplierCode(supplierCode);
            uccAreaAvailableQryReqBO.setSupplierId(supplierId);
            UccAreaAvailableQryRspBO uccAreaAvailableQryRspBO = this.uccAreaAvailableQryAtomService.qryAreaAvailableCommd(uccAreaAvailableQryReqBO);
            if ("0000".equals(uccAreaAvailableQryRspBO.getRespCode())) {
                Iterator areaLimit = uccAreaAvailableQryRspBO.getAreaAvailableCommdInfos().stream().collect(Collectors.toMap(AreaAvailableCommdBO_busi::getSkuId, AreaAvailableCommdBO_busi::isAreaRestrict));
                for (UccBatchShopQryMsgBo each : allBos) {
                    if (areaLimit.containsKey(each.getExtralSkuId())) {
                        if (!((Boolean)areaLimit.get(each.getExtralSkuId())).booleanValue()) {
                            each.setAreaLimit(Integer.valueOf(1));
                            continue;
                        }
                        each.setAreaLimit(Integer.valueOf(2));
                        continue;
                    }
                    each.setAreaLimit(Integer.valueOf(2));
                }
            } else {
                LOGGER.error("\u67e5\u8be2\u533a\u57df\u9650\u5236\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)((Object)uccAreaAvailableQryRspBO)));
                for (UccBatchShopQryMsgBo each : allBos) {
                    each.setAreaLimit(Integer.valueOf(2));
                }
            }
        }
        if (city != null && provice != null && county != null) {
            UccCurrentStockQryReqBO uccCurrentStockQryReqBO = new UccCurrentStockQryReqBO();
            uccCurrentStockQryReqBO.setSupplierCode(supplierCode);
            uccCurrentStockQryReqBO.setSupplierId(supplierId);
            if (city != null) {
                uccCurrentStockQryReqBO.setCity(city.longValue());
            }
            if (county != null) {
                uccCurrentStockQryReqBO.setCounty(county.longValue());
            }
            if (provice != null) {
                uccCurrentStockQryReqBO.setProvince(provice.longValue());
            }
            if (town != null) {
                uccCurrentStockQryReqBO.setTown(town.longValue());
            } else {
                uccCurrentStockQryReqBO.setTown(0L);
            }
            ArrayList<SkuNumBO_Atom> stock = new ArrayList<SkuNumBO_Atom>();
            for (UccBatchShopQryMsgBo each : allBos) {
                SkuNumBO_Atom skuNumBO_atom = new SkuNumBO_Atom();
                skuNumBO_atom.setSkuId(each.getExtralSkuId());
                skuNumBO_atom.setNum(Long.valueOf(each.getSaleNum() == null ? "1" : each.getSaleNum()));
                stock.add(skuNumBO_atom);
            }
            uccCurrentStockQryReqBO.setSkuNum(stock);
            UccCurrentStockQryRspBO uccCurrentStockQryRspBO = this.uccCurrentStockQryAtomService.qryCommdCurrentStock(uccCurrentStockQryReqBO);
            if ("0000".equals(uccCurrentStockQryRspBO.getRespCode())) {
                Map<String, CommdStockBO_busi> stockBO_busiMap = uccCurrentStockQryRspBO.getCommdStockInfo().stream().collect(Collectors.toMap(CommdStockBO_busi::getSkuId, CommdStockBO_busi2 -> CommdStockBO_busi2));
                for (UccBatchShopQryMsgBo each : allBos) {
                    if (stockBO_busiMap.containsKey(each.getExtralSkuId())) {
                        each.setStock(stockBO_busiMap.get(each.getExtralSkuId()).getRemainNum());
                        each.setStockStateDesc(stockBO_busiMap.get(each.getExtralSkuId()).getStockStateDesc());
                        each.setStockStateId(stockBO_busiMap.get(each.getExtralSkuId()).getStockStateId());
                        continue;
                    }
                    each.setStock(Integer.valueOf(0));
                    each.setStockStateDesc("\u65e0\u8d27");
                    each.setStockStateId(Integer.valueOf(34));
                }
                stockBO_busiMap = null;
            } else {
                for (UccBatchShopQryMsgBo each : allBos) {
                    each.setStock(Integer.valueOf(0));
                    each.setStockStateDesc("\u65e0\u8d27");
                    each.setStockStateId(Integer.valueOf(34));
                }
            }
        }
        allBos.addAll(invalidBatchShopQryMsgBo);
        if (allBos.size() > 0) {
            List<Long> coommds = allBos.stream().map(UccBatchShopQryMsgBo::getCommodityId).collect(Collectors.toList());
            List<UccCommodityPicPo> picPos = this.uccCommodityPicMapper.queryBatchLesCloum(coommds, supplierShopId, ModelRuleConstant.COMMD_IMG_MAIN);
            Map<Long, String> img = picPos.stream().collect(Collectors.toMap(UccCommodityPicPo::getCommodityId, UccCommodityPicPo::getCommodityPicUrl));
            for (UccBatchShopQryMsgBo each : allBos) {
                if (!img.containsKey(each.getCommodityId())) continue;
                each.setImage(img.get(each.getCommodityId()));
            }
        }
        return allBos;
    }

    public List<UccBatchShopQryMsgBo> queryLocalDetail(List<UccBatchShopQryBo> bos) throws BusinessException {
        Map<Long, Object> commdImg;
        ArrayList result = new ArrayList();
        SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(bos.get(0).getSupplierShopId());
        SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(supplierShopPo.getSupplierId());
        Long supplierShopId = bos.get(0).getSupplierShopId();
        Long supplierId = supplierBusiPo.getSupplierId();
        String supplierCode = supplierBusiPo.getSupplierCode();
        Integer city = bos.get(0).getCity();
        Integer county = bos.get(0).getCounty();
        Integer provice = bos.get(0).getProvince();
        Integer town = bos.get(0).getTown();
        ArrayList<Long> skus = new ArrayList<Long>();
        for (UccBatchShopQryBo each : bos) {
            skus.add(each.getSkuId());
        }
        Object uccSkuPo = null;
        List<UccSkuPo> skuPoList = this.uccSkuMapper.queryBatchSkusLessCloum(skus, supplierShopId);
        ArrayList<Long> invalid = new ArrayList<Long>();
        ArrayList<String> extSkus = new ArrayList<String>();
        ArrayList<Long> commdIds = new ArrayList<Long>();
        ArrayList<UccBatchShopQryMsgBo> invalidBatchShopQryMsgBo = new ArrayList<UccBatchShopQryMsgBo>();
        ArrayList<UccBatchShopQryMsgBo> onShlefBatchShopQryMsgBo = new ArrayList<UccBatchShopQryMsgBo>();
        List<UccQryPriceFromLadderPriceBO> uccQryPriceFromLadderPriceBOS = this.getResultLadderPrice(bos);
        UccBatchShopQryMsgBo batchShopQryMsgBo = null;
        for (UccSkuPo po : skuPoList) {
            batchShopQryMsgBo = new UccBatchShopQryMsgBo();
            batchShopQryMsgBo.setSkuId(po.getSkuId());
            batchShopQryMsgBo.setSupplierShopId(supplierShopId);
            batchShopQryMsgBo.setSupplierId(supplierId);
            batchShopQryMsgBo.setSupplierName(supplierBusiPo.getSupplierName());
            batchShopQryMsgBo.setSupplierCode(supplierBusiPo.getSupplierCode());
            batchShopQryMsgBo.setSkuSource(po.getSkuSource());
            batchShopQryMsgBo.setExtralSkuId(po.getExtSkuId());
            batchShopQryMsgBo.setCommodityId(po.getCommodityId());
            batchShopQryMsgBo.setSkuName(po.getSkuName());
            batchShopQryMsgBo.setSaleUnit(po.getMeasureName());
            batchShopQryMsgBo.setAgreementId(po.getAgreementId());
            batchShopQryMsgBo.setModel(po.getModel());
            batchShopQryMsgBo.setSpec(po.getSpec());
            batchShopQryMsgBo.setFigure(po.getFigure());
            batchShopQryMsgBo.setPreDeliverDay(po.getPreDeliverDay());
            batchShopQryMsgBo.setExtSkuId(po.getExtSkuId());
            batchShopQryMsgBo.setMaterialId(po.getMaterialId());
            batchShopQryMsgBo.setMaterialName(po.getMaterialName());
            if (po.getMoq() != null) {
                batchShopQryMsgBo.setMoq(new BigDecimal(po.getMoq()));
            }
            List<LadderPriceBo> ladderPriceBos = this.getLadderPriceInfo(po.getSkuId(), po.getSupplierShopId());
            batchShopQryMsgBo.setLadderPrice(ladderPriceBos);
            batchShopQryMsgBo.setBrandName(po.getBrandName());
            commdIds.add(po.getCommodityId());
            for (UccBatchShopQryBo uccBatchShopQryBo : bos) {
                if (!po.getSkuId().equals(uccBatchShopQryBo.getSkuId())) continue;
                batchShopQryMsgBo.setSaleNum(uccBatchShopQryBo.getSaleNum());
                batchShopQryMsgBo.setIsChoice(uccBatchShopQryBo.getIsChoice());
                batchShopQryMsgBo.setJoinTime(uccBatchShopQryBo.getJoinTime());
            }
            if (CollectionUtils.isNotEmpty(uccQryPriceFromLadderPriceBOS)) {
                for (UccQryPriceFromLadderPriceBO uccQryPriceFromLadderPriceBO : uccQryPriceFromLadderPriceBOS) {
                    if (!po.getSkuId().equals(uccQryPriceFromLadderPriceBO.getSkuId())) continue;
                    batchShopQryMsgBo.setLadderResultPrice(uccQryPriceFromLadderPriceBO.getPurchasePrice());
                }
            }
            if (po.getSkuStatus() != ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                batchShopQryMsgBo.setStatus(Integer.valueOf(0));
                batchShopQryMsgBo.setSkuName(po.getSkuName());
                batchShopQryMsgBo.setStock(Integer.valueOf(0));
                invalid.add(po.getSkuId());
                invalidBatchShopQryMsgBo.add(batchShopQryMsgBo);
                continue;
            }
            batchShopQryMsgBo.setStatus(Integer.valueOf(1));
            onShlefBatchShopQryMsgBo.add(batchShopQryMsgBo);
            extSkus.add(po.getExtSkuId());
        }
        ArrayList<UccBatchShopQryMsgBo> allQryMsgBo = new ArrayList<UccBatchShopQryMsgBo>();
        allQryMsgBo.addAll(invalidBatchShopQryMsgBo);
        allQryMsgBo.addAll(onShlefBatchShopQryMsgBo);
        ArrayList<Long> noSkuPic = new ArrayList<Long>();
        List<UccSkuPicPo> picPos = this.uccSkuPicMapper.queryBatchLesCloum(skus, supplierShopId, ModelRuleConstant.COMMD_IMG_MAIN);
        Map<Long, String> SkuImg = picPos.stream().collect(Collectors.toMap(UccSkuPicPo::getSkuId, UccSkuPicPo::getSkuPicUrl));
        for (UccBatchShopQryMsgBo each : allQryMsgBo) {
            if (!SkuImg.containsKey(each.getSkuId()) || SkuImg.get(each.getSkuId()) == null) {
                noSkuPic.add(each.getCommodityId());
                continue;
            }
            each.setImage(SkuImg.get(each.getSkuId()));
        }
        if (noSkuPic.size() > 0) {
            List<UccCommodityPicPo> list = this.uccCommodityPicMapper.queryBatchLesCloum(noSkuPic, supplierShopId, ModelRuleConstant.COMMD_IMG_MAIN);
            commdImg = list.stream().collect(Collectors.toMap(UccCommodityPicPo::getCommodityId, UccCommodityPicPo::getCommodityPicUrl));
            for (UccBatchShopQryMsgBo each : allQryMsgBo) {
                if (!commdImg.containsKey(each.getCommodityId())) continue;
                each.setImage((String)commdImg.get(each.getCommodityId()));
            }
        }
        List<UccSkuPricePo> list = this.uccSkuPriceMapper.batchQryPriBySkuIds(skus, supplierShopId);
        commdImg = list.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, UccSkuPricePo::getSalePrice));
        for (UccBatchShopQryMsgBo each : allQryMsgBo) {
            each.setPrice(MoneyUtils.haoToYuan((Long)((Long)commdImg.get(each.getSkuId()))));
        }
        List<UccCommodityPo> commodityPoList = this.uccCommodityMapper.qeryBatchCommdity(commdIds);
        Map<Long, String> commdNameMap = commodityPoList.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, UccCommodityPo::getCommodityName));
        for (UccBatchShopQryMsgBo each : allQryMsgBo) {
            each.setCommodityName(commdNameMap.get(each.getCommodityId()));
        }
        List<UccSkuStockPo> skuStockPos = this.uccSkuStockMapper.batchQryById(skus, supplierShopId);
        Map<Long, BigDecimal> stockMap = skuStockPos.stream().collect(Collectors.toMap(UccSkuStockPo::getSkuId, UccSkuStockPo::getStockNum));
        for (UccBatchShopQryMsgBo uccBatchShopQryMsgBo : allQryMsgBo) {
            if (stockMap.containsKey(uccBatchShopQryMsgBo.getSkuId())) {
                uccBatchShopQryMsgBo.setStock(Integer.valueOf(stockMap.get(uccBatchShopQryMsgBo.getSkuId()).intValue()));
                if (uccBatchShopQryMsgBo.getStock() != null && uccBatchShopQryMsgBo.getStock() > 0) {
                    uccBatchShopQryMsgBo.setStockStateId(Integer.valueOf(33));
                    uccBatchShopQryMsgBo.setStockStateDesc("\u6709\u8d27 \u73b0\u8d27-\u4e0b\u5355\u7acb\u5373\u53d1\u8d27");
                } else if (uccBatchShopQryMsgBo.getStock() != null && uccBatchShopQryMsgBo.getStock() == -1) {
                    uccBatchShopQryMsgBo.setStockStateId(Integer.valueOf(33));
                    uccBatchShopQryMsgBo.setStockStateDesc("\u6709\u8d27 \u73b0\u8d27-\u4e0b\u5355\u7acb\u5373\u53d1\u8d27");
                } else {
                    uccBatchShopQryMsgBo.setStockStateId(Integer.valueOf(34));
                    uccBatchShopQryMsgBo.setStockStateDesc("\u65e0\u8d27");
                }
            } else {
                uccBatchShopQryMsgBo.setStockStateId(Integer.valueOf(34));
                uccBatchShopQryMsgBo.setStockStateDesc("\u65e0\u8d27");
                uccBatchShopQryMsgBo.setStock(Integer.valueOf(0));
            }
            uccBatchShopQryMsgBo.setAreaLimit(Integer.valueOf(1));
            uccBatchShopQryMsgBo.setAvailableSale(Integer.valueOf(1));
        }
        HashMap<Long, Long> commdMap = new HashMap<Long, Long>();
        if (CollectionUtils.isNotEmpty(commodityPoList)) {
            for (UccCommodityPo uccCommodityPo : commodityPoList) {
                if (uccCommodityPo.getCommodityId() == null || uccCommodityPo.getVendorId() == null) continue;
                commdMap.put(uccCommodityPo.getCommodityId(), uccCommodityPo.getVendorId());
            }
        }
        UccVendorPo uccVendorPo = new UccVendorPo();
        uccVendorPo.setVendorCode("tianmao");
        List<UccVendorPo> vendorPoList = this.uccVendorMapper.queryVerdor(uccVendorPo);
        Long tianmao = 0L;
        if (vendorPoList.size() > 0) {
            tianmao = vendorPoList.get(0).getVendorId();
        }
        ArrayList<UccBatchShopQryMsgBo> qryTanmaoStockList = new ArrayList<UccBatchShopQryMsgBo>();
        for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
            if (tianmao == 0L || !tianmao.equals(commdMap.get(each.getCommodityId()))) continue;
            qryTanmaoStockList.add(each);
        }
        if (qryTanmaoStockList.size() > 0) {
            this.queryTaomaoStock(qryTanmaoStockList, String.valueOf(bos.get(0).getCounty()));
        }
        for (UccBatchShopQryMsgBo each : allQryMsgBo) {
            this.querySkuProperties(each);
        }
        return allQryMsgBo;
    }

    private Map<Integer, Map<Long, ArrayList<UccBatchShopQryBo>>> groupBySourceAndSupplierShopId(UccBatchShopQryReqBo reqBo) {
        HashMap<Integer, Map<Long, ArrayList<UccBatchShopQryBo>>> sort = new HashMap<Integer, Map<Long, ArrayList<UccBatchShopQryBo>>>();
        ArrayList<Long> skus = new ArrayList<Long>();
        for (UccBatchShopQryBo each : reqBo.getShopQry()) {
            skus.add(each.getSkuId());
        }
        List<UccSkuPo> skuPoList = this.uccSkuMapper.qeryBatchSkus(skus);
        Map<Long, Integer> source = skuPoList.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, UccSkuPo::getSkuSource));
        ArrayList<UccBatchShopQryBo> eccomer = new ArrayList<UccBatchShopQryBo>();
        ArrayList<UccBatchShopQryBo> self = new ArrayList<UccBatchShopQryBo>();
        ArrayList<UccBatchShopQryBo> zone = new ArrayList<UccBatchShopQryBo>();
        for (UccBatchShopQryBo each : reqBo.getShopQry()) {
            if (ModelRuleConstant.SKU_SOURCE_SELF_SUPPORT == source.get(each.getSkuId())) {
                self.add(each);
            }
            if (ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT == source.get(each.getSkuId())) {
                eccomer.add(each);
            }
            if (ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION != source.get(each.getSkuId())) continue;
            zone.add(each);
        }
        if (self.size() > 0) {
            sort.put(ModelRuleConstant.SKU_SOURCE_SELF_SUPPORT, this.groupBySupplierShopId(self));
        }
        if (eccomer.size() > 0) {
            sort.put(ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT, this.groupBySupplierShopId(eccomer));
        }
        if (zone.size() > 0) {
            sort.put(ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION, this.groupBySupplierShopId(zone));
        }
        return sort;
    }

    public Map<Long, ArrayList<UccBatchShopQryBo>> groupBySupplierShopId(List<UccBatchShopQryBo> bos) {
        HashMap<Long, ArrayList<UccBatchShopQryBo>> result = new HashMap<Long, ArrayList<UccBatchShopQryBo>>();
        for (UccBatchShopQryBo each : bos) {
            if (result.containsKey(each.getSupplierShopId())) {
                ((ArrayList)result.get(each.getSupplierShopId())).add(each);
                continue;
            }
            ArrayList<UccBatchShopQryBo> data = new ArrayList<UccBatchShopQryBo>();
            data.add(each);
            result.put(each.getSupplierShopId(), data);
        }
        return result;
    }

    private void querySkuProperties(UccBatchShopQryMsgBo sku) {
        UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
        uccSkuSpecPo.setSkuId(sku.getSkuId());
        uccSkuSpecPo.setSupplierShopId(sku.getSupplierShopId());
        List<UccSkuSpecPo> skuSpecPoList = this.uccSkuSpecMapper.querySpec(uccSkuSpecPo);
        if (skuSpecPoList == null || skuSpecPoList.size() == 0) {
            return;
        }
        sku.setSkuProperteis(new ArrayList());
        SaleSkuPropEntityBo bo = null;
        JSONArray properties = new JSONArray();
        JSONObject object = null;
        SaleSkuPropEntityBo entityBo = null;
        for (UccSkuSpecPo each : skuSpecPoList) {
            bo = new SaleSkuPropEntityBo();
            entityBo = new SaleSkuPropEntityBo();
            BeanUtils.copyProperties((Object)each, (Object)bo);
            bo.setShowName(each.getPropShowName());
            sku.getSkuProperteis().add(bo);
            object = new JSONObject();
            object.put(each.getPropShowName(), (Object)each.getPropValue());
            properties.add((Object)object);
        }
        sku.setShowProperties(JSONObject.toJSONString((Object)properties));
    }

    private void queryTaomaoStock(List<UccBatchShopQryMsgBo> list, String area) {
        HashSet<Long> set = new HashSet<Long>();
        Long[] commds = new Long[list.size()];
        for (UccBatchShopQryMsgBo each : list) {
            set.add(each.getCommodityId());
        }
        set.toArray(commds);
        List<UccCommodityPo> poList = this.uccCommodityMapper.qeryBatchCommdity(Arrays.stream(commds).collect(Collectors.toList()));
        Map<Long, String> commditys = poList.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, UccCommodityPo::getExtSkuId));
        UccTmCommdStockQryReqBO reqBO = new UccTmCommdStockQryReqBO();
        ArrayList<UccTmStockBO> itemList = new ArrayList<UccTmStockBO>();
        reqBO.setDivisionCode(area);
        reqBO.setItemList(itemList);
        HashedMap pointer = new HashedMap();
        UccTmStockBO bo = null;
        for (UccBatchShopQryMsgBo each : list) {
            if (pointer.containsKey(each.getCommodityId())) {
                ((UccTmStockBO)itemList.get((Integer)pointer.get(each.getCommodityId()) - 1)).getSkuIdLists().add(Long.parseLong(each.getExtralSkuId()));
                each.setExtSkuId(commditys.get(each.getCommodityId()));
                continue;
            }
            bo = new UccTmStockBO();
            ArrayList<Long> skuList = new ArrayList<Long>();
            bo.setItemId(Long.valueOf(Long.parseLong(commditys.get(each.getCommodityId()))));
            bo.setSkuIdLists(skuList);
            itemList.add(bo);
            if (each.getExtralSkuId().equals(commditys.get(each.getCommodityId()))) {
                skuList.add(-1L);
                each.setExtSkuId(commditys.get(each.getCommodityId()));
                each.setExtralSkuId("-1");
            } else {
                skuList.add(Long.parseLong(each.getExtralSkuId()));
                each.setExtSkuId(commditys.get(each.getCommodityId()));
            }
            pointer.put(each.getCommodityId(), itemList.size());
        }
        UccTmCommdStockQryRspBO uccTmCommdStockQryRspBO = this.uccTmCommdStockQryService.qryStock(reqBO);
        if (uccTmCommdStockQryRspBO.getItemList() == null || uccTmCommdStockQryRspBO.getItemList().size() == 0) {
            LOGGER.error("\u5546\u54c1\u5e93\u5b58\u67e5\u8be2\u8fd4\u56de\u7a7a:" + JSONObject.toJSONString((Object)reqBO));
            for (UccBatchShopQryMsgBo each : list) {
                each.setStock(Integer.valueOf(0));
                each.setStockStateDesc("\u6b64\u5546\u54c1\u533a\u57df\u65e0\u8d27");
                each.setStockStateId(Integer.valueOf(34));
            }
            return;
        }
        if ("0000".equals(uccTmCommdStockQryRspBO.getRespCode())) {
            block5: for (UccBatchShopQryMsgBo each : list) {
                for (CommdStockBO stock : uccTmCommdStockQryRspBO.getItemList()) {
                    try {
                        if (!each.getExtSkuId().equals(stock.getCommdExtSkuId()) || !each.getExtralSkuId().equals(stock.getSkuId())) continue;
                        each.setStock(stock.getRemainNum());
                        continue block5;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                    }
                }
            }
        } else {
            LOGGER.error("\u67e5\u8be2\u5e93\u5b58\u5f02\u5e38\uff1a" + uccTmCommdStockQryRspBO.getRespDesc());
        }
    }

    private List<LadderPriceBo> getLadderPriceInfo(Long skuId, Long supplierShopId) {
        List<UccLadderPricePO> uccLadderPricePOS = this.uccLadderPriceMapper.selectBySkuId(skuId, supplierShopId);
        ArrayList<LadderPriceBo> ladderPriceBos = new ArrayList<LadderPriceBo>();
        if (CollectionUtils.isNotEmpty(uccLadderPricePOS)) {
            for (UccLadderPricePO uccLadderPricePO : uccLadderPricePOS) {
                LadderPriceBo ladderPriceBo = new LadderPriceBo();
                if (uccLadderPricePO.getStart() != null) {
                    ladderPriceBo.setStartPrice(MoneyUtils.haoToYuan((Long)uccLadderPricePO.getStart()));
                }
                if (uccLadderPricePO.getStop() != null) {
                    ladderPriceBo.setStopPrice(MoneyUtils.haoToYuan((Long)uccLadderPricePO.getStop()));
                }
                if (uccLadderPricePO.getPrice() != null) {
                    ladderPriceBo.setPrice(MoneyUtils.haoToYuan((Long)uccLadderPricePO.getPrice()));
                }
                ladderPriceBos.add(ladderPriceBo);
            }
        }
        return ladderPriceBos;
    }

    private void dealZoneSkuMiniOrderNum(List<UccBatchShopQryMsgBo> uccBatchShopQryMsgBos) {
        if (CollectionUtils.isNotEmpty(uccBatchShopQryMsgBos)) {
            for (UccBatchShopQryMsgBo uccBatchShopQryMsgBo : uccBatchShopQryMsgBos) {
                if (StringUtils.isEmpty((Object)uccBatchShopQryMsgBo.getSaleNum()) || uccBatchShopQryMsgBo.getMoq() == null || new BigDecimal(uccBatchShopQryMsgBo.getSaleNum()).compareTo(uccBatchShopQryMsgBo.getMoq()) >= 0) continue;
                uccBatchShopQryMsgBo.setStatus(Integer.valueOf(3));
            }
        }
    }

    private List<UccBatchShopQryMsgBo> getElcCommdInfo(List<UccBatchShopQryMsgBo> onShlefBatchShopQryMsgBo, List<UccBatchShopQryBo> bos) {
        List<String> extSkus = onShlefBatchShopQryMsgBo.stream().map(UccBatchShopQryMsgBo::getExtSkuId).collect(Collectors.toList());
        String supplierCode = onShlefBatchShopQryMsgBo.get(0).getSupplierCode();
        Long supplierId = onShlefBatchShopQryMsgBo.get(0).getSupplierId();
        Long supplierShopId = onShlefBatchShopQryMsgBo.get(0).getSupplierShopId();
        Integer city = bos.get(0).getCity();
        Integer county = bos.get(0).getCounty();
        Integer provice = bos.get(0).getProvince();
        Integer town = bos.get(0).getTown();
        ArrayList<Long> skus = new ArrayList<Long>();
        for (UccBatchShopQryBo each : bos) {
            skus.add(each.getSkuId());
        }
        UccSkuStateReqBO uccSkuStateReqBO = new UccSkuStateReqBO();
        uccSkuStateReqBO.setExtSkuIds(extSkus);
        uccSkuStateReqBO.setSupplierCode(supplierCode);
        uccSkuStateReqBO.setSupplierId(supplierId);
        UccSkuStateRsp uccSkuStateRsp = this.UccQrySkuStateService.qrySkuStatus(uccSkuStateReqBO);
        if (!"0000".equals(uccSkuStateRsp.getRespCode())) {
            LOGGER.error("\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)uccSkuStateRsp));
            for (UccBatchShopQryMsgBo uccBatchShopQryMsgBo : onShlefBatchShopQryMsgBo) {
                uccBatchShopQryMsgBo.setStatus(Integer.valueOf(0));
            }
        }
        if (uccSkuStateRsp.getSkuStates() != null) {
            Map<String, Integer> extSkustatus = uccSkuStateRsp.getSkuStates().stream().collect(Collectors.toMap(SkuStateRspBo::getSku, SkuStateRspBo::getState));
            for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
                each.setStatus((Integer)extSkustatus.get(each.getExtralSkuId()));
            }
        }
        for (UccBatchShopQryMsgBo uccBatchShopQryMsgBo : onShlefBatchShopQryMsgBo) {
            UccCommdDetailsQryReqBO uccCommdDetailsQryReqBO = new UccCommdDetailsQryReqBO();
            uccCommdDetailsQryReqBO.setSkuId(uccBatchShopQryMsgBo.getExtralSkuId());
            uccCommdDetailsQryReqBO.setSupplierCode(supplierCode);
            UccCommdDetailsQryRspBO rspBO = this.uccCommdDetailsQryAtomService.qryCommdDetails(uccCommdDetailsQryReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                LOGGER.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + rspBO);
                continue;
            }
            if (rspBO.getCommdInfo().getJdBookInfo() != null) {
                uccBatchShopQryMsgBo.setImage(rspBO.getCommdInfo().getJdBookInfo().getImage());
                uccBatchShopQryMsgBo.setSaleUnit("\u672c");
                uccBatchShopQryMsgBo.setSkuName(rspBO.getCommdInfo().getJdBookInfo().getName());
            }
            if (rspBO.getCommdInfo().getJdCommdInfo() != null) {
                uccBatchShopQryMsgBo.setImage(rspBO.getCommdInfo().getJdCommdInfo().getImagePath());
                uccBatchShopQryMsgBo.setSaleUnit(rspBO.getCommdInfo().getNotJdCommdDetails().getSaleUnit());
                uccBatchShopQryMsgBo.setSkuName(rspBO.getCommdInfo().getNotJdCommdDetails().getName());
            }
            if (rspBO.getCommdInfo().getJdVedioInfo() != null) {
                uccBatchShopQryMsgBo.setImage(rspBO.getCommdInfo().getJdVedioInfo().getImage());
                uccBatchShopQryMsgBo.setSaleUnit(rspBO.getCommdInfo().getJdVedioInfo().getSaleUnit());
                uccBatchShopQryMsgBo.setSkuName(rspBO.getCommdInfo().getJdVedioInfo().getName());
            }
            if (rspBO.getCommdInfo().getNotJdCommdDetails() == null) continue;
            uccBatchShopQryMsgBo.setImage(rspBO.getCommdInfo().getNotJdCommdDetails().getImagePath());
            uccBatchShopQryMsgBo.setSaleUnit(rspBO.getCommdInfo().getNotJdCommdDetails().getSaleUnit());
            uccBatchShopQryMsgBo.setSkuName(rspBO.getCommdInfo().getNotJdCommdDetails().getName());
        }
        UccCurrentPriceQryReqBO uccCurrentPriceQryReqBO = new UccCurrentPriceQryReqBO();
        uccCurrentPriceQryReqBO.setSkuIds(skus);
        uccCurrentPriceQryReqBO.setSupplierShopId(supplierShopId);
        UccCurrentPriceQryRspBO uccCurrentPriceQryRspBO = this.uccCurrentPriceQryBusiService.changeCommdCurrentPrice(uccCurrentPriceQryReqBO);
        Map<String, BigDecimal> extSkuPrice = null;
        if ("0000".equals(uccCurrentPriceQryRspBO.getRespCode())) {
            if (uccCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos() != null && uccCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos().size() > 0) {
                extSkuPrice = uccCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos().stream().collect(Collectors.toMap(JdPriceBO_busi::getSkuId, JdPriceBO_busi::getNewSalePrice));
            }
            if (uccCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo() != null && uccCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo().size() > 0) {
                extSkuPrice = uccCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo().stream().collect(Collectors.toMap(NotJdPriceBO_busi::getSkuId, NotJdPriceBO_busi::getNewSalePrice));
            }
            for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
                each.setPrice(extSkuPrice.get(each.getSkuId().toString()));
            }
        } else {
            LOGGER.error("\u67e5\u8be2\u91d1\u989d\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)uccCurrentPriceQryRspBO));
        }
        UccAvailableCommdQryReqBO uccAvailableCommdQryReqBO = new UccAvailableCommdQryReqBO();
        uccAvailableCommdQryReqBO.setSkuIds(extSkus);
        uccAvailableCommdQryReqBO.setSupplierCode(supplierCode);
        UccAvailableCommdQryRspBO uccAvailableCommdQryRspBO = this.uccAvailableCommdQryAtomService.qryAvailableCommd(uccAvailableCommdQryReqBO);
        if ("0000".equals(uccAvailableCommdQryRspBO.getResultCode())) {
            Map<String, Integer> extSkuArea = uccAvailableCommdQryRspBO.getAvailableCommdInfos().stream().collect(Collectors.toMap(AvailableCommdBO_busi::getSkuId, AvailableCommdBO_busi::getSaleState));
            for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
                each.setAvailableSale(extSkuArea.get(each.getExtralSkuId()));
                if (null != each.getAvailableSale()) continue;
                each.setAvailableSale(Integer.valueOf(0));
            }
        } else {
            LOGGER.error("\u67e5\u8be2\u53ef\u552e\u9a8c\u8bc1\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)((Object)uccAvailableCommdQryRspBO)));
        }
        if (city != null && provice != null && county != null) {
            UccAreaAvailableQryReqBO uccAreaAvailableQryReqBO = new UccAreaAvailableQryReqBO();
            uccAreaAvailableQryReqBO.setSkuIds(extSkus);
            if (city != null) {
                uccAreaAvailableQryReqBO.setCity(city.longValue());
            }
            if (county != null) {
                uccAreaAvailableQryReqBO.setCounty(county.longValue());
            }
            if (provice != null) {
                uccAreaAvailableQryReqBO.setProvince(provice.longValue());
            }
            if (town != null) {
                uccAreaAvailableQryReqBO.setTown(town.longValue());
            } else {
                uccAreaAvailableQryReqBO.setTown(0L);
            }
            uccAreaAvailableQryReqBO.setSupplierCode(supplierCode);
            uccAreaAvailableQryReqBO.setSupplierId(supplierId);
            UccAreaAvailableQryRspBO uccAreaAvailableQryRspBO = this.uccAreaAvailableQryAtomService.qryAreaAvailableCommd(uccAreaAvailableQryReqBO);
            if ("0000".equals(uccAreaAvailableQryRspBO.getRespCode())) {
                Map<String, Boolean> areaLimit = uccAreaAvailableQryRspBO.getAreaAvailableCommdInfos().stream().collect(Collectors.toMap(AreaAvailableCommdBO_busi::getSkuId, AreaAvailableCommdBO_busi::isAreaRestrict));
                for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
                    if (areaLimit.containsKey(each.getExtralSkuId())) {
                        if (!((Boolean)areaLimit.get(each.getExtralSkuId())).booleanValue()) {
                            each.setAreaLimit(Integer.valueOf(1));
                            continue;
                        }
                        each.setAreaLimit(Integer.valueOf(2));
                        continue;
                    }
                    each.setAreaLimit(Integer.valueOf(2));
                }
            } else {
                LOGGER.error("\u67e5\u8be2\u533a\u57df\u9650\u5236\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)((Object)uccAreaAvailableQryRspBO)));
                throw new BusinessException("BATCHSHOPINGQRY_ESB_AREAVAILABLE", uccAreaAvailableQryRspBO.getResultMessage());
            }
        }
        if (city != null && provice != null && county != null) {
            UccCurrentStockQryReqBO uccCurrentStockQryReqBO = new UccCurrentStockQryReqBO();
            uccCurrentStockQryReqBO.setSupplierCode(supplierCode);
            uccCurrentStockQryReqBO.setSupplierId(supplierId);
            if (city != null) {
                uccCurrentStockQryReqBO.setCity(city.longValue());
            }
            if (county != null) {
                uccCurrentStockQryReqBO.setCounty(county.longValue());
            }
            if (provice != null) {
                uccCurrentStockQryReqBO.setProvince(provice.longValue());
            }
            if (town != null) {
                uccCurrentStockQryReqBO.setTown(town.longValue());
            } else {
                uccCurrentStockQryReqBO.setTown(0L);
            }
            ArrayList<SkuNumBO_Atom> stock = new ArrayList<SkuNumBO_Atom>();
            for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
                SkuNumBO_Atom skuNumBO_atom = new SkuNumBO_Atom();
                skuNumBO_atom.setSkuId(each.getExtralSkuId());
                skuNumBO_atom.setNum(Long.valueOf(each.getSaleNum() == null ? "1" : each.getSaleNum()));
                stock.add(skuNumBO_atom);
            }
            uccCurrentStockQryReqBO.setSkuNum(stock);
            UccCurrentStockQryRspBO uccCurrentStockQryRspBO = this.uccCurrentStockQryAtomService.qryCommdCurrentStock(uccCurrentStockQryReqBO);
            if ("0000".equals(uccCurrentStockQryRspBO.getRespCode())) {
                for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
                    for (CommdStockBO_busi stockBO_busi : uccCurrentStockQryRspBO.getCommdStockInfo()) {
                        if (!stockBO_busi.getSkuId().equals(each.getExtralSkuId())) continue;
                        each.setStock(stockBO_busi.getRemainNum());
                        each.setStockStateDesc(stockBO_busi.getStockStateDesc());
                        each.setStockStateId(stockBO_busi.getStockStateId());
                    }
                }
            }
        }
        return onShlefBatchShopQryMsgBo;
    }

    private List<UccQryPriceFromLadderPriceBO> getResultLadderPrice(List<UccBatchShopQryBo> bos) {
        ArrayList<UccQryPriceFromLadderPriceBO> uccQryPriceFromLadderPriceBOS = new ArrayList<UccQryPriceFromLadderPriceBO>();
        for (UccBatchShopQryBo each : bos) {
            if (StringUtils.isEmpty((Object)each.getSaleNum())) continue;
            UccQryPriceFromLadderPriceBO uccQryPriceFromLadderPriceBO = new UccQryPriceFromLadderPriceBO();
            uccQryPriceFromLadderPriceBO.setSkuId(each.getSkuId());
            uccQryPriceFromLadderPriceBO.setPurchaseQuantity(new BigDecimal(each.getSaleNum()));
            uccQryPriceFromLadderPriceBOS.add(uccQryPriceFromLadderPriceBO);
        }
        if (CollectionUtils.isEmpty(uccQryPriceFromLadderPriceBOS)) {
            return new ArrayList<UccQryPriceFromLadderPriceBO>();
        }
        UccQryPriceFromLadderPriceReqBO uccQryPriceFromLadderPriceReqBO = new UccQryPriceFromLadderPriceReqBO();
        uccQryPriceFromLadderPriceReqBO.setQryPriceFromLadderPriceBOS(uccQryPriceFromLadderPriceBOS);
        UccQryPriceFromLadderPriceRspBO uccQryPriceFromLadderPriceRspBO = this.uccQryPriceFromLadderPriceAtomService.qryPriceFromLadderPrice(uccQryPriceFromLadderPriceReqBO);
        List<UccQryPriceFromLadderPriceBO> uccQryPriceFromLadderPriceBOList = new ArrayList<UccQryPriceFromLadderPriceBO>();
        if ("0000".equals(uccQryPriceFromLadderPriceRspBO.getRespCode())) {
            uccQryPriceFromLadderPriceBOList = uccQryPriceFromLadderPriceRspBO.getQryPriceFromLadderPriceBOS();
        }
        return uccQryPriceFromLadderPriceBOList;
    }

    private void getMeasure(List<UccBatchShopQryMsgBo> bos) {
        if (CollectionUtils.isNotEmpty(bos)) {
            List materialIds = bos.stream().map(UccBatchShopQryMsgBo::getMaterialId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)(materialIds = ListUtils.removeNull(materialIds)))) {
                return;
            }
            ArrayList<Long> materialIds2 = new ArrayList<Long>();
            for (String each : materialIds) {
                if (each == null) continue;
                materialIds2.add(Long.parseLong(each));
            }
            try {
                List<UccEMdmMaterialPO> uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.batchQryById(materialIds2);
                if (CollectionUtils.isNotEmpty(uccEMdmMaterialPOS)) {
                    for (UccBatchShopQryMsgBo uccBatchShopQryMsgBo : bos) {
                        for (UccEMdmMaterialPO uccEMdmMaterialPO : uccEMdmMaterialPOS) {
                            if (uccBatchShopQryMsgBo.getMaterialId() == null || uccEMdmMaterialPO.getMaterialId() == null || !uccBatchShopQryMsgBo.getMaterialId().equals(String.valueOf(uccEMdmMaterialPO.getMaterialId()))) continue;
                            uccBatchShopQryMsgBo.setMeasure(uccEMdmMaterialPO.getMeasure());
                            uccBatchShopQryMsgBo.setLongDesc(uccEMdmMaterialPO.getLongDesc());
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u67e5\u8be2\u7269\u6599\u4fe1\u606f\u5931\u8d25");
            }
        }
    }
}

