/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.ability.api.UccCommodityOverviewAbilityService;
import com.tydic.commodity.bo.ability.CommodityOverviewBO;
import com.tydic.commodity.bo.ability.UccCommodityOverviewReqBO;
import com.tydic.commodity.bo.ability.UccCommodityOverviewRspBO;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.dao.po.CommodityOverviewPO;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccVendorPo;
import com.tydic.commodity.util.ListCloneUtils;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.ability.api.UccCommodityOverviewAbilityService"})
public class UccCommodityOverviewAbilityServiceImpl
implements UccCommodityOverviewAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCommodityOverviewAbilityServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityOverviewAbilityServiceImpl.class);
    @Autowired
    private UccCommodityMapper commodityMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    private static final int STATUS_LOSE_EFFICACY = 4;

    @PostMapping(value={"qryCommodityList"})
    public UccCommodityOverviewRspBO qryCommodityList(@RequestBody UccCommodityOverviewReqBO reqBO) {
        List<CommodityOverviewPO> commodityOverviewPOList;
        List<SupplierShopPo> supplierShopPos;
        Integer[] commodityStatus;
        UccCommodityOverviewRspBO rspBO = new UccCommodityOverviewRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        if (reqBO.getStatus() == 1) {
            commodityStatus = new Integer[]{3};
            reqBO.setCommodityStatus(commodityStatus);
        } else {
            commodityStatus = new Integer[]{0, 2, 4, 5, 7, 8, 10};
            reqBO.setCommodityStatus(commodityStatus);
        }
        if (reqBO.getMaxCurrentPrice() != null) {
            reqBO.setMaxCurrentPrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getMaxCurrentPrice()));
        }
        if (reqBO.getMinCurrentPrice() != null) {
            reqBO.setMinCurrentPrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getMinCurrentPrice()));
        }
        if (StringUtils.isNumeric((String)reqBO.getBaseConditions())) {
            reqBO.setBaseType(Integer.valueOf(3));
        }
        if (reqBO.getOrgIdIn() != null && CollectionUtils.isNotEmpty(supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getOrgIdIn()))) {
            reqBO.setQuerySupplierShopId(supplierShopPos.stream().map(supplierShopPo -> String.valueOf(supplierShopPo.getSupplierShopId())).collect(Collectors.joining(",")));
        }
        if (CollectionUtils.isNotEmpty(commodityOverviewPOList = this.commodityMapper.queryCommodityListPage((Page<CommodityOverviewPO>)page, reqBO))) {
            for (CommodityOverviewPO commodityOverviewPO : commodityOverviewPOList) {
                UccVendorPo uccVendorPo = new UccVendorPo();
                uccVendorPo.setId(commodityOverviewPO.getShopId());
                List<UccVendorPo> uccVendorPos = this.uccVendorMapper.queryVerdor(uccVendorPo);
                if (!CollectionUtils.isNotEmpty(uccVendorPos)) continue;
                UccVendorPo vendorPo = uccVendorPos.get(0);
                commodityOverviewPO.setSupplyName(vendorPo.getShopName());
                Integer status = commodityOverviewPO.getStatus();
                if (status != 4) continue;
                commodityOverviewPO.setRemark("\u4f9b\u8d27\u65b9\u4e0d\u53ef\u552e\uff0ccansell\u5b57\u6bb5\u4e3a\u5426");
            }
        }
        try {
            List commodityOverviewBOS = ListCloneUtils.clonePOListToBOListNotDate(commodityOverviewPOList, CommodityOverviewBO.class);
            rspBO.setRows(commodityOverviewBOS);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setPageNo(page.getPageNo());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5546\u54c1\u603b\u89c8\u5931\u8d25\uff0c\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        return rspBO;
    }
}

