/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.aop;

import com.tydic.commodity.annotation.OrgIdAnno;
import com.tydic.commodity.annotation.RegisterMerchantUpdateAnnotation;
import com.tydic.commodity.annotation.SupplierIdAnno;
import com.tydic.commodity.bo.busi.UccRegisteredMerchantReqBO;
import com.tydic.commodity.busi.api.UccRegisteredMerchantService;
import com.tydic.commodity.dao.UccRegisteredMerchantMapper;
import com.tydic.commodity.enumType.RegisterMerchantStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class RegisterMerchantAspect {
    @Autowired
    private UccRegisteredMerchantService registeredMerchantService;
    @Autowired
    private UccRegisteredMerchantMapper registeredMerchantMapper;

    @AfterThrowing(value="(execution(* com.tydic..*(..))) && @annotation(registerMerchant)", argNames="joinPoint, registerMerchant")
    public void doAfterThrowing(JoinPoint joinPoint, RegisterMerchantUpdateAnnotation registerMerchant) throws Throwable {
        UccRegisteredMerchantReqBO reqBO = new UccRegisteredMerchantReqBO();
        try {
            reqBO.setOrgId(Long.valueOf(this.containValue(joinPoint).toString()));
        }
        catch (NumberFormatException e) {
            throw new BusinessException("8888", "\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
        }
        reqBO.setStatus(RegisterMerchantStatusEnum.FAIL.getStatus());
        reqBO.setStep(registerMerchant.step().getStep());
        this.registeredMerchantService.updateRegisterMerchantStatusAndStep(reqBO);
    }

    @Before(value="(execution(* com.tydic..*(..))) && @annotation(registerMerchant)", argNames="joinPoint, registerMerchant")
    public void methodBefore(JoinPoint joinPoint, RegisterMerchantUpdateAnnotation registerMerchant) throws Throwable {
        UccRegisteredMerchantReqBO reqBO = new UccRegisteredMerchantReqBO();
        try {
            reqBO.setOrgId(Long.valueOf(this.containValue(joinPoint).toString()));
            reqBO.setSupplierId(Long.valueOf(this.supplierId(joinPoint).toString()));
        }
        catch (NumberFormatException e) {
            throw new BusinessException("8888", "\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
        }
        reqBO.setStep(registerMerchant.step().getStep());
        this.registeredMerchantService.insertSupplierRegisterInfo(reqBO);
        reqBO.setStatus(RegisterMerchantStatusEnum.PROCESSING.getStatus());
        this.registeredMerchantService.updateRegisterMerchantStatusAndStep(reqBO);
    }

    @AfterReturning(value="(execution(* com.tydic..*(..))) && @annotation(registerMerchant)", argNames="joinPoint, registerMerchant")
    public void methodAfter(JoinPoint joinPoint, RegisterMerchantUpdateAnnotation registerMerchant) throws Throwable {
        UccRegisteredMerchantReqBO reqBO = new UccRegisteredMerchantReqBO();
        try {
            reqBO.setOrgId(Long.valueOf(this.containValue(joinPoint).toString()));
        }
        catch (NumberFormatException e) {
            throw new BusinessException("8888", "\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
        }
        reqBO.setStatus(RegisterMerchantStatusEnum.COMPLETE.getStatus());
        reqBO.setStep(registerMerchant.step().getStep());
        this.registeredMerchantService.updateRegisterMerchantStatusAndStep(reqBO);
    }

    private Object containValue(JoinPoint joinPoint) {
        Object[] target = joinPoint.getArgs();
        boolean flage = false;
        for (Object object : target) {
            List<Field> list = Arrays.asList(object.getClass().getDeclaredFields());
            for (int i = 0; i < list.size(); ++i) {
                Field field = list.get(i);
                if (!field.isAnnotationPresent(OrgIdAnno.class)) continue;
                for (Annotation anno : field.getDeclaredAnnotations()) {
                    if (!anno.annotationType().equals(OrgIdAnno.class)) continue;
                    if (!Objects.isNull(anno)) {
                        flage = true;
                        field.setAccessible(true);
                        return this.getFieldValueByName(field.getName(), object);
                    }
                    throw new BusinessException("8888", "\u5546\u6237\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
        if (!flage) {
            throw new BusinessException("8888", "\u672a\u6307\u5b9a\u8bf7\u6c42\u5546\u6237ID");
        }
        return null;
    }

    private Object supplierId(JoinPoint joinPoint) {
        Object[] target = joinPoint.getArgs();
        boolean flage = false;
        for (Object object : target) {
            List<Field> list = Arrays.asList(object.getClass().getDeclaredFields());
            for (int i = 0; i < list.size(); ++i) {
                Field field = list.get(i);
                if (!field.isAnnotationPresent(SupplierIdAnno.class)) continue;
                for (Annotation anno : field.getDeclaredAnnotations()) {
                    if (!anno.annotationType().equals(SupplierIdAnno.class)) continue;
                    if (!Objects.isNull(anno)) {
                        flage = true;
                        field.setAccessible(true);
                        return this.getFieldValueByName(field.getName(), object);
                    }
                    throw new BusinessException("8888", "\u5546\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
        if (!flage) {
            throw new BusinessException("8888", "\u672a\u6307\u5b9a\u8bf7\u6c42\u5546\u6237ID");
        }
        return null;
    }

    private Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }
}

