/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.atom.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.bo.busi.CommodityCategoryForEsBO;
import com.tydic.commodity.bo.busi.CommodityForEsBO;
import com.tydic.commodity.bo.busi.CommoditySpecForEsBO;
import com.tydic.commodity.bo.busi.DeleteSpuInfoFromEsBO;
import com.tydic.commodity.bo.busi.EsStorageSpuAttrInfoBO;
import com.tydic.commodity.bo.busi.EsStorageSpuInfoBO;
import com.tydic.commodity.bo.busi.SkuForEsBO;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsRspBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.dao.po.UccCatalogDealPO;
import com.tydic.commodity.dao.po.UccCatalogLevelPo;
import com.tydic.commodity.dao.po.UccSaleNumPo;
import com.tydic.commodity.dao.po.UccSkuPicPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuStockPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.search.SearchCommodityService;
import com.tydic.commodity.search.bo.CommodityRspBo;
import com.tydic.commodity.search.bo.SearchEsReqBO;
import com.tydic.commodity.search.bo.SearchEsRspBo;
import com.tydic.commodity.search.config.ElasticsearchUtil;
import com.tydic.commodity.search.config.EsConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="syncSceneCommodityToEsAtomService")
public class SyncSceneCommodityToEsAtomServiceImpl
implements SyncSceneCommodityToEsAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncSceneCommodityToEsAtomServiceImpl.class);
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStockMapper uccSkuStockMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private SearchCommodityService searchCommodityService;

    @Override
    public SyncSceneCommodityToEsRspBO syncSceneCommodityToEs(SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO) {
        SyncSceneCommodityToEsRspBO rspBO = new SyncSceneCommodityToEsRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u573a\u666fES\u540c\u6b65\u6210\u529f!");
        if (syncSceneCommodityToEsReqBO.getSupplierId() == null && syncSceneCommodityToEsReqBO.getRootOrgIdIn() != null) {
            syncSceneCommodityToEsReqBO.setSupplierId(syncSceneCommodityToEsReqBO.getRootOrgIdIn());
        }
        this.validateReqParams(syncSceneCommodityToEsReqBO);
        if (ModelRuleConstant.OPER_ES_ADD_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.syncCommodityToEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.OPER_ES_DELETE_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.deleteCommodityInfoFromEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.OPER_ES_UPDATE_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.updateCommodityToEs(syncSceneCommodityToEsReqBO);
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u573a\u666fES\u540c\u6b65\u5931\u8d25\uff1aES\u64cd\u4f5c\u7c7b\u578b[" + syncSceneCommodityToEsReqBO.getOperType() + "]\u6682\u4e0d\u652f\u6301!");
        }
        return rspBO;
    }

    private void syncCommodityToEs(SyncSceneCommodityToEsReqBO reqBO) {
        List<CommodityForEsBO> commodityForEsBOS = this.qryCommodityList(reqBO);
        if (commodityForEsBOS == null || commodityForEsBOS.isEmpty()) {
            LOGGER.error("ES \u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a \u4e3a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f->{}" + JSONObject.toJSONString((Object)reqBO));
            return;
        }
        List<Long> commodityIds = commodityForEsBOS.stream().map(CommodityForEsBO::getCommodityId).collect(Collectors.toList());
        ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
        this.assemblyEsSkuInfo(reqBO, commodityIds, esStorageSpuInfoBOS);
        this.assemblyEsCommodityAndCategoryInfo(reqBO, commodityIds, esStorageSpuInfoBOS, commodityForEsBOS);
        this.syncCommodityInfoToEs(esStorageSpuInfoBOS);
        List<EsStorageSpuAttrInfoBO> attrInfoBOS = this.assemblyCommodityAttrInfo(commodityIds);
        this.syncCommodityAttrToEs(attrInfoBOS);
    }

    private void deleteCommodityInfoFromEs(SyncSceneCommodityToEsReqBO reqBO) {
        List<CommodityForEsBO> commodityForEsBOS = this.qryCommodityList(reqBO);
        if (commodityForEsBOS == null || commodityForEsBOS.isEmpty()) {
            LOGGER.error("\u4eceES\u5220\u9664\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u573a\u666f[" + reqBO.getSceneId() + "]\u4e0b\u5173\u8054\u7684\u5546\u54c1\u6570\u636e!");
            return;
        }
        List commodityIds = commodityForEsBOS.stream().map(CommodityForEsBO::getCommodityId).collect(Collectors.toList());
        ArrayList<DeleteSpuInfoFromEsBO> deleteSpuInfoFromEsBOS = new ArrayList<DeleteSpuInfoFromEsBO>();
        Long sceneId = reqBO.getSceneId();
        for (Long commodityId : commodityIds) {
            DeleteSpuInfoFromEsBO deleteSpuInfoFromEsBO = new DeleteSpuInfoFromEsBO();
            deleteSpuInfoFromEsBO.setSceneId(sceneId);
            deleteSpuInfoFromEsBO.setCommodityId(commodityId);
            deleteSpuInfoFromEsBOS.add(deleteSpuInfoFromEsBO);
        }
        this.deleteSpuInfoFromEs(deleteSpuInfoFromEsBOS);
    }

    private void updateCommodityToEs(SyncSceneCommodityToEsReqBO reqBO) {
        if (reqBO.getSingleType() == 0) {
            List<CommodityForEsBO> commodityForEsBOS = this.qryCommodityList(reqBO);
            if (commodityForEsBOS == null || commodityForEsBOS.isEmpty()) {
                LOGGER.error("\u66f4\u65b0ES\u4e0b\u7684\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u573a\u666f[" + reqBO.getSceneId() + "]\u4e0b\u5173\u8054\u7684\u5546\u54c1\u6570\u636e!");
                return;
            }
            List commodityIds = commodityForEsBOS.stream().map(CommodityForEsBO::getCommodityId).collect(Collectors.toList());
            SearchEsReqBO searchEsReqBO = new SearchEsReqBO();
            searchEsReqBO.setCommdIds(commodityIds);
            searchEsReqBO.setSceneId(reqBO.getSceneId());
            SearchEsRspBo searchEsRspBo = this.searchCommodityService.queryByMatch(searchEsReqBO);
            List<Long> esExistCommodityIds = null;
            if (searchEsRspBo != null && searchEsRspBo.getCommodityRspBos() != null && !searchEsRspBo.getCommodityRspBos().isEmpty()) {
                List commodityRspBos = searchEsRspBo.getCommodityRspBos();
                esExistCommodityIds = commodityRspBos.stream().map(CommodityRspBo::getCommodity_id).collect(Collectors.toList());
            }
            if (esExistCommodityIds == null || esExistCommodityIds.isEmpty()) {
                return;
            }
            ArrayList<CommodityForEsBO> newCommodityForEsBOS = new ArrayList<CommodityForEsBO>();
            for (CommodityForEsBO commodityForEsBO : commodityForEsBOS) {
                if (!esExistCommodityIds.contains(commodityForEsBO.getCommodityId())) continue;
                newCommodityForEsBOS.add(commodityForEsBO);
            }
            ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
            this.assemblyEsSkuInfo(reqBO, esExistCommodityIds, esStorageSpuInfoBOS);
            this.assemblyEsCommodityAndCategoryInfo(reqBO, esExistCommodityIds, esStorageSpuInfoBOS, newCommodityForEsBOS);
            this.syncCommodityInfoToEs(esStorageSpuInfoBOS);
        } else {
            this.searchSku(reqBO);
            if (reqBO.getSingleType() != 1) {
                if (reqBO.getSingleType() == 2) {
                    List<UccSkuPo> poList = this.uccSkuMapper.queryBatchSkusLessCloum(reqBO.getSkuIds(), reqBO.getSupplierId());
                    if (!CollectionUtils.isEmpty(poList)) {
                        for (UccSkuPo each : poList) {
                            JSONObject object = new JSONObject();
                            object.put("sku_status", (Object)each.getSkuStatus());
                            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), reqBO.getSceneId() == null ? each.getSkuId().toString() : reqBO.getSceneId() + "" + each.getSkuId(), object);
                        }
                    }
                } else if (reqBO.getSingleType() == 3) {
                    List<UccSkuPricePo> pricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(reqBO.getSkuIds(), reqBO.getSupplierId());
                    if (!CollectionUtils.isEmpty(pricePos)) {
                        for (UccSkuPricePo each : pricePos) {
                            JSONObject object = new JSONObject();
                            object.put("sale_price", (Object)each.getSalePrice());
                            object.put("agreement_price", (Object)each.getAgreementPrice());
                            object.put("market_price", (Object)each.getMarketPrice());
                            object.put("member_price1", (Object)each.getMemberPrice1());
                            object.put("member_price2", (Object)each.getMemberPrice2());
                            object.put("member_price3", (Object)each.getMemberPrice3());
                            object.put("member_price4", (Object)each.getMemberPrice4());
                            object.put("member_price5", (Object)each.getMemberPrice5());
                            object.put("discounts", (Object)(each.getSalePrice() / each.getAgreementPrice()));
                            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), reqBO.getSceneId() == null ? each.getSkuId().toString() : reqBO.getSceneId() + "" + each.getSkuId(), object);
                        }
                    }
                } else {
                    LOGGER.error("\u672a\u77e5\u540c\u6b65\u7c7b\u578b");
                }
            }
        }
    }

    private List<CommodityForEsBO> qryCommodityList(SyncSceneCommodityToEsReqBO reqBO) {
        List<Long> commodityTypeIds;
        List<CommodityForEsBO> commodityForEsBOS = null;
        if (ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID.equals(reqBO.getSyncType())) {
            commodityTypeIds = this.uccCommodityTypeMapper.qryCommodityTypeIdsByCategorys(reqBO.getCategoryIds());
            if (commodityTypeIds == null || commodityTypeIds.isEmpty()) {
                throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u7c7b\u76ee\u5173\u8054\u7684\u5546\u54c1\u7c7b\u578b\u6570\u636e!");
            }
            commodityForEsBOS = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(commodityTypeIds, null, reqBO.getRootOrgIdIn(), reqBO.getSceneId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_GUI_CATEGORY_ID.equals(reqBO.getSyncType())) {
            commodityTypeIds = this.uccCatRCommdTypeMapper.queryTypeByGuideCatalogIds(reqBO.getGuiCategoryIds());
            if (commodityTypeIds == null || commodityTypeIds.isEmpty()) {
                throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u7c7b\u76ee\u5173\u8054\u7684\u5546\u54c1\u7c7b\u578b\u6570\u636e!");
            }
            commodityForEsBOS = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(commodityTypeIds, null, reqBO.getSupplierId(), reqBO.getSceneId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType())) {
            commodityForEsBOS = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(null, reqBO.getCommodityIds(), reqBO.getSupplierId(), reqBO.getSceneId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_SKU_ID.equals(reqBO.getSyncType())) {
            List<UccSkuPo> skuPoList = this.uccSkuMapper.queryBatchSkusLessCloum(reqBO.getSkuIds(), reqBO.getSupplierId());
            if (CollectionUtils.isEmpty(skuPoList)) {
                return commodityForEsBOS;
            }
            ArrayList<Long> commodityIds = new ArrayList<Long>();
            for (UccSkuPo uccSkuPo : skuPoList) {
                if (commodityIds.contains(uccSkuPo.getCommodityId())) continue;
                commodityIds.add(uccSkuPo.getCommodityId());
            }
            commodityForEsBOS = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(null, commodityIds, reqBO.getSupplierId(), reqBO.getSceneId());
        }
        if (!CollectionUtils.isEmpty(commodityForEsBOS)) {
            ArrayList mergeSameB0s = new ArrayList();
            HashedMap mergeSameMap = new HashedMap();
            for (CommodityForEsBO commodityForEsBO : commodityForEsBOS) {
                CommodityForEsBO bo;
                if (commodityForEsBO.getGuideCataLogId() == null) {
                    bo = new CommodityForEsBO();
                    BeanUtils.copyProperties((Object)commodityForEsBO, (Object)bo);
                    mergeSameMap.put(commodityForEsBO.getCommodityId(), bo);
                    continue;
                }
                if (mergeSameMap.containsKey(commodityForEsBO.getCommodityId())) {
                    ((CommodityForEsBO)mergeSameMap.get(commodityForEsBO.getCommodityId())).getGuideCataLogIds().add(commodityForEsBO.getGuideCataLogId());
                    continue;
                }
                bo = new CommodityForEsBO();
                BeanUtils.copyProperties((Object)commodityForEsBO, (Object)bo);
                bo.setGuideCataLogIds(new ArrayList<Long>(Arrays.asList(commodityForEsBO.getGuideCataLogId())));
                mergeSameMap.put(commodityForEsBO.getCommodityId(), bo);
            }
            commodityForEsBOS = new ArrayList<CommodityForEsBO>();
            for (Map.Entry entry : mergeSameMap.entrySet()) {
                commodityForEsBOS.add((CommodityForEsBO)entry.getValue());
            }
            commodityForEsBOS.addAll(mergeSameB0s);
        }
        return commodityForEsBOS;
    }

    private void assemblyEsSkuInfo(SyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        List<SkuForEsBO> skuForEsBOS = this.uccSkuMapper.qrySkuAndLowPriceList(reqBO.getSupplierId(), commodityIds);
        if (skuForEsBOS == null || skuForEsBOS.isEmpty()) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4e0b\u5173\u8054\u7684\u5355\u54c1\u6570\u636e!");
        }
        List<Long> skuIds = skuForEsBOS.stream().map(SkuForEsBO::getSkuId).collect(Collectors.toList());
        List<UccSkuStockPo> skuStockPos = this.uccSkuStockMapper.batchQryById(skuIds, reqBO.getSupplierId());
        Map<Long, UccSkuStockPo> skuStockPoMap = skuStockPos.stream().collect(Collectors.toMap(UccSkuStockPo::getSkuId, uccSkuStockPo -> uccSkuStockPo));
        List<UccSaleNumPo> saleNumPos = this.uccSaleNumMapper.qryBySkuIds(skuIds);
        Map<Long, UccSaleNumPo> saleNumPoMap = saleNumPos.stream().collect(Collectors.toMap(UccSaleNumPo::getSkuId, uccSaleNumPo -> uccSaleNumPo));
        List<UccSkuPicPo> skuPicPos = this.uccSkuPicMapper.qeurySkuPicBySkuId(skuIds);
        Map<Long, UccSkuPicPo> skuPicPoMap = skuPicPos.stream().collect(Collectors.toMap(UccSkuPicPo::getSkuId, uccSkuPicPo -> uccSkuPicPo));
        this.buildEsSku(esStorageSpuInfoBOS, skuForEsBOS, skuStockPoMap, saleNumPoMap, skuPicPoMap);
    }

    private void buildEsSku(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS, List<SkuForEsBO> skuForEsBOS, Map<Long, UccSkuStockPo> skuStockPoMap, Map<Long, UccSaleNumPo> saleNumPoMap, Map<Long, UccSkuPicPo> skuPicPoMap) {
        for (SkuForEsBO skuForEsBO : skuForEsBOS) {
            UccSkuPicPo uccSkuPicPo;
            UccSaleNumPo uccSaleNumPo;
            UccSkuStockPo uccSkuStockPo;
            EsStorageSpuInfoBO esStorageSpuInfoBO = new EsStorageSpuInfoBO();
            esStorageSpuInfoBO.setCommodity_id(skuForEsBO.getCommodityId());
            esStorageSpuInfoBO.setSku_id(skuForEsBO.getSkuId());
            esStorageSpuInfoBO.setSku_name(skuForEsBO.getSkuName());
            esStorageSpuInfoBO.setSearch_name(skuForEsBO.getSkuName());
            esStorageSpuInfoBO.setExt_sku_id(skuForEsBO.getExtSkuId());
            esStorageSpuInfoBO.setBrand_id(skuForEsBO.getBrandId());
            esStorageSpuInfoBO.setBrand_name(skuForEsBO.getBrandName());
            esStorageSpuInfoBO.setSku_status(skuForEsBO.getSkuStatus());
            esStorageSpuInfoBO.setSku_source(skuForEsBO.getSkuSource());
            esStorageSpuInfoBO.setMfgsku(skuForEsBO.getMfgsku());
            esStorageSpuInfoBO.setUpc(skuForEsBO.getUpcCode());
            esStorageSpuInfoBO.setType_id(skuForEsBO.getCommodityTypeId());
            esStorageSpuInfoBO.setType_name(skuForEsBO.getCommodityTypeName());
            if (skuForEsBO.getOnShelveTime() != null) {
                esStorageSpuInfoBO.setOn_shelve_time(Long.valueOf(DateUtils.strToDateLong((String)skuForEsBO.getOnShelveTime()).getTime()));
            }
            esStorageSpuInfoBO.setAgreement_id(skuForEsBO.getAgreementId());
            esStorageSpuInfoBO.setSale_price(Double.valueOf(skuForEsBO.getSalePrice() == null ? 0.0 : (double)skuForEsBO.getSalePrice().longValue()));
            esStorageSpuInfoBO.setAgreement_price(Double.valueOf(skuForEsBO.getAgreementPrice() == null ? 0.0 : (double)skuForEsBO.getAgreementPrice().longValue()));
            esStorageSpuInfoBO.setMarket_price(Double.valueOf(skuForEsBO.getMarketPrice() == null ? 0.0 : (double)skuForEsBO.getMarketPrice().longValue()));
            esStorageSpuInfoBO.setMember_price1(Double.valueOf(skuForEsBO.getMemberPrice1() == null ? 0.0 : (double)skuForEsBO.getMemberPrice1().longValue()));
            esStorageSpuInfoBO.setMember_price2(Double.valueOf(skuForEsBO.getMemberPrice2() == null ? 0.0 : (double)skuForEsBO.getMemberPrice2().longValue()));
            esStorageSpuInfoBO.setMember_price3(Double.valueOf(skuForEsBO.getMemberPrice3() == null ? 0.0 : (double)skuForEsBO.getMemberPrice3().longValue()));
            esStorageSpuInfoBO.setMember_price4(Double.valueOf(skuForEsBO.getMemberPrice4() == null ? 0.0 : (double)skuForEsBO.getMemberPrice4().longValue()));
            esStorageSpuInfoBO.setMember_price5(Double.valueOf(skuForEsBO.getMemberPrice5() == null ? 0.0 : (double)skuForEsBO.getMemberPrice5().longValue()));
            esStorageSpuInfoBO.setSupplier_id(skuForEsBO.getSupplierId());
            esStorageSpuInfoBO.setSupplier_shop_id(skuForEsBO.getSupplierShopId());
            esStorageSpuInfoBO.setShop_name(skuForEsBO.getShopName());
            esStorageSpuInfoBO.setSupplier_name(skuForEsBO.getSupplierName());
            String discount = "0";
            if (skuForEsBO.getSalePrice() != null && skuForEsBO.getMarketPrice() != null && skuForEsBO.getMarketPrice() != 0L) {
                discount = String.format("%.2f", (double)skuForEsBO.getSalePrice().longValue() / (double)skuForEsBO.getMarketPrice().longValue());
            }
            esStorageSpuInfoBO.setDiscounts(Double.valueOf(discount));
            esStorageSpuInfoBO.setComment_number(null);
            if (skuStockPoMap.size() > 0 && (uccSkuStockPo = skuStockPoMap.get(skuForEsBO.getSkuId())) != null) {
                esStorageSpuInfoBO.setComment_number(Long.valueOf(uccSkuStockPo.getStockNum().longValue()));
            }
            esStorageSpuInfoBO.setSold_number(null);
            esStorageSpuInfoBO.setEcommerce_sale(null);
            if (saleNumPoMap.size() > 0 && (uccSaleNumPo = saleNumPoMap.get(skuForEsBO.getSkuId())) != null) {
                if (uccSaleNumPo.getSoldNumber() != null) {
                    esStorageSpuInfoBO.setSold_number(Long.valueOf(uccSaleNumPo.getSoldNumber().longValue()));
                }
                if (uccSaleNumPo.getEcommerceSale() != null) {
                    esStorageSpuInfoBO.setEcommerce_sale(Long.valueOf(uccSaleNumPo.getEcommerceSale().longValue()));
                }
            }
            if (skuPicPoMap.size() > 0 && (uccSkuPicPo = skuPicPoMap.get(skuForEsBO.getSkuId())) != null) {
                esStorageSpuInfoBO.setPicture_url(uccSkuPicPo.getSkuPicUrl());
            }
            esStorageSpuInfoBO.setChannel_id(null);
            esStorageSpuInfoBO.setBrand_id_name(null);
            esStorageSpuInfoBO.setDescription(null);
            esStorageSpuInfoBO.setSupplier_id_name(null);
            esStorageSpuInfoBO.setProperties(null);
            esStorageSpuInfoBO.setL4mg_category_id(skuForEsBO.getMgCatalogId());
            esStorageSpuInfoBO.setL4mg_category_name(skuForEsBO.getMgCatalogName());
            esStorageSpuInfoBO.setMaterial_id(skuForEsBO.getMaterialId());
            esStorageSpuInfoBO.setMaterial_name(skuForEsBO.getMaterialName());
            esStorageSpuInfoBO.setManufacturer(skuForEsBO.getManufacturer());
            esStorageSpuInfoBO.setFigure(skuForEsBO.getFigure());
            esStorageSpuInfoBO.setModel(skuForEsBO.getModel());
            esStorageSpuInfoBO.setMeasure_name(skuForEsBO.getMeasureName());
            esStorageSpuInfoBOS.add(esStorageSpuInfoBO);
        }
    }

    private void assemblyEsCommodityAndCategoryInfo(SyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS, List<CommodityForEsBO> commodityForEsBOS) {
        Map<Long, CommodityForEsBO> commodityEsBOMap = commodityForEsBOS.stream().collect(Collectors.toMap(CommodityForEsBO::getCommodityId, commodityForEsBO -> commodityForEsBO));
        ArrayList<Long> guiCataLog = new ArrayList<Long>();
        for (CommodityForEsBO each : commodityForEsBOS) {
            if (CollectionUtils.isEmpty((Collection)each.getGuideCataLogIds())) continue;
            guiCataLog.addAll(each.getGuideCataLogIds());
        }
        if (!CollectionUtils.isEmpty(guiCataLog)) {
            LinkedHashSet hashSet = new LinkedHashSet(guiCataLog);
            guiCataLog = new ArrayList(hashSet);
        }
        List<UccCatalogLevelPo> catalogLevelPos = this.uccCatalogDealMapper.quryCatalogLevel(reqBO.getSceneId(), null, guiCataLog);
        Object catalogDealPOMap = new HashedMap();
        if (!CollectionUtils.isEmpty(catalogLevelPos)) {
            catalogDealPOMap = catalogLevelPos.stream().collect(Collectors.toMap(UccCatalogLevelPo::getL3GuideCatalogId, UccCatalogLevelPo2 -> UccCatalogLevelPo2));
        }
        List<CommoditySpecForEsBO> commoditySpecForEsBOS = this.uccSpuSpecMapper.qrySpuSpecList(commodityIds, reqBO.getSupplierId());
        Map<Long, CommoditySpecForEsBO> commoditySpecForEsBOMap = commoditySpecForEsBOS.stream().collect(Collectors.toMap(CommoditySpecForEsBO::getCommodityId, commoditySpecForEsBO -> commoditySpecForEsBO));
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            CommoditySpecForEsBO commoditySpecForEsBO2;
            CommodityForEsBO commodityForEsBO2 = commodityEsBOMap.get(esStorageSpuInfoBO.getCommodity_id());
            esStorageSpuInfoBO.setScene_id(reqBO.getSceneId());
            esStorageSpuInfoBO.setCommodity_name(commodityForEsBO2.getCommodityName());
            esStorageSpuInfoBO.setCommd_pic_url(commodityForEsBO2.getCommodityPicUrl());
            if (!CollectionUtils.isEmpty((Collection)commodityForEsBO2.getGuideCataLogIds())) {
                esStorageSpuInfoBO.setL3_category_id(commodityForEsBO2.getGuideCataLogIds().stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
            }
            esStorageSpuInfoBO.setVendor_id(commodityForEsBO2.getVendorId());
            esStorageSpuInfoBO.setVendor_name(commodityForEsBO2.getVendorName());
            if (StringUtils.isEmpty((CharSequence)esStorageSpuInfoBO.getPicture_url())) {
                esStorageSpuInfoBO.setPicture_url(commodityForEsBO2.getCommodityPicUrl());
            }
            esStorageSpuInfoBO.setView_order(commodityForEsBO2.getViewOrder());
            esStorageSpuInfoBO.setShow_prop_json(null);
            if (catalogDealPOMap.size() > 0 && !CollectionUtils.isEmpty((Collection)esStorageSpuInfoBO.getL3_category_id())) {
                for (String l3_category_id : esStorageSpuInfoBO.getL3_category_id()) {
                    if (!catalogDealPOMap.containsKey(Long.valueOf(l3_category_id))) continue;
                    if (((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL1GuideCatalogId() != null) {
                        if (CollectionUtils.isEmpty((Collection)esStorageSpuInfoBO.getL1_category_id())) {
                            esStorageSpuInfoBO.setL1_category_id(new ArrayList<String>(Arrays.asList(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL1GuideCatalogId()))));
                        } else {
                            esStorageSpuInfoBO.getL1_category_id().add(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL1GuideCatalogId()));
                        }
                    }
                    if (((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL2GuideCatalogId() != null) {
                        if (CollectionUtils.isEmpty((Collection)esStorageSpuInfoBO.getL2_category_id())) {
                            esStorageSpuInfoBO.setL2_category_id(new ArrayList<String>(Arrays.asList(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL2GuideCatalogId()))));
                        } else {
                            esStorageSpuInfoBO.getL2_category_id().add(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL2GuideCatalogId()));
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL1CatalogName())) {
                        if (CollectionUtils.isEmpty((Collection)esStorageSpuInfoBO.getL1_category_name())) {
                            esStorageSpuInfoBO.setL1_category_name(new ArrayList<String>(Arrays.asList(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL1CatalogName()))));
                        } else {
                            esStorageSpuInfoBO.getL1_category_name().add(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL1CatalogName()));
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL2CatalogName())) {
                        if (CollectionUtils.isEmpty((Collection)esStorageSpuInfoBO.getL2_category_name())) {
                            esStorageSpuInfoBO.setL2_category_name(new ArrayList<String>(Arrays.asList(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL2CatalogName()))));
                        } else {
                            esStorageSpuInfoBO.getL2_category_name().add(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL2CatalogName()));
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL3CatalogName())) {
                        if (CollectionUtils.isEmpty((Collection)esStorageSpuInfoBO.getL3_category_name())) {
                            esStorageSpuInfoBO.setL3_category_name(new ArrayList<String>(Arrays.asList(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL3CatalogName()))));
                        } else {
                            esStorageSpuInfoBO.getL3_category_name().add(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL3CatalogName()));
                        }
                    }
                    if (((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getChannelId() == null) continue;
                    if (CollectionUtils.isEmpty((Collection)esStorageSpuInfoBO.getChannel_id())) {
                        esStorageSpuInfoBO.setChannel_id(new ArrayList<Long>(Arrays.asList(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getChannelId())));
                        continue;
                    }
                    esStorageSpuInfoBO.getChannel_id().add(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getChannelId());
                }
            }
            if (commoditySpecForEsBOMap.size() > 0 && (commoditySpecForEsBO2 = commoditySpecForEsBOMap.get(esStorageSpuInfoBO.getCommodity_id())) != null) {
                esStorageSpuInfoBO.setShow_prop_json(commoditySpecForEsBO2.getPropJson());
            }
            String properties = this.uccSpuSpecMapper.getSpuSpecProperties(esStorageSpuInfoBO.getSku_id());
            esStorageSpuInfoBO.setProperties(properties);
            esStorageSpuInfoBO.setUnuse_suppliershop_list(null);
        }
    }

    private CommodityCategoryForEsBO assemblyCategoryInfo(CommodityCategoryForEsBO categoryForEsBO, Map<Long, UccCatalogDealPO> upperCatalogDealPOMap) {
        CommodityCategoryForEsBO finalSpuCategoryForEsBO = new CommodityCategoryForEsBO();
        for (int i = 0; i < upperCatalogDealPOMap.size(); ++i) {
            UccCatalogDealPO uccCatalogDealPO;
            if (i == 0 && categoryForEsBO.getUpperGatalogId() == 0L) {
                return categoryForEsBO;
            }
            if (i == 0 && categoryForEsBO.getUpperGatalogId() != 0L) {
                uccCatalogDealPO = upperCatalogDealPOMap.get(categoryForEsBO.getUpperGatalogId());
                finalSpuCategoryForEsBO = this.mergeChildAndParentCategory(categoryForEsBO, uccCatalogDealPO);
                continue;
            }
            if (finalSpuCategoryForEsBO.getUpperGatalogId() == 0L) {
                return finalSpuCategoryForEsBO;
            }
            uccCatalogDealPO = upperCatalogDealPOMap.get(finalSpuCategoryForEsBO.getUpperGatalogId());
            finalSpuCategoryForEsBO = this.mergeChildAndParentCategory(finalSpuCategoryForEsBO, uccCatalogDealPO);
        }
        return finalSpuCategoryForEsBO;
    }

    private CommodityCategoryForEsBO mergeChildAndParentCategory(CommodityCategoryForEsBO childCategory, UccCatalogDealPO parentCategory) {
        CommodityCategoryForEsBO finalCategory = new CommodityCategoryForEsBO();
        finalCategory.setGuideCatalogId(parentCategory.getGuideCatalogId());
        finalCategory.setUpperGatalogId(parentCategory.getUpperCatalogId());
        finalCategory.setCatalogName(parentCategory.getCatalogName());
        finalCategory.setChildCatalog((Object)childCategory);
        return finalCategory;
    }

    private void syncCommodityInfoToEs(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            String jsonStr = JSONObject.toJSONString((Object)esStorageSpuInfoBO);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String esId = "";
            esId = esStorageSpuInfoBO.getScene_id() == null ? String.valueOf(esStorageSpuInfoBO.getSku_id()) : esStorageSpuInfoBO.getScene_id() + String.valueOf(esStorageSpuInfoBO.getSku_id());
            String id = this.elasticsearchUtil.addData(this.esConfig.getIndexName(), this.esConfig.getEsType(), esId, jsonObject);
            if (!StringUtils.isBlank((CharSequence)id)) continue;
            LOGGER.error("\u5546\u54c1\u4fe1\u606f[" + esStorageSpuInfoBO.getScene_id() == null ? "" : esStorageSpuInfoBO.getScene_id() + "|" + esStorageSpuInfoBO.getCommodity_id() + "]\u540c\u6b65\u5931\u8d25!");
        }
    }

    private void syncCommodityAttrToEs(List<EsStorageSpuAttrInfoBO> attrInfoBOS) {
        if (CollectionUtils.isEmpty(attrInfoBOS)) {
            return;
        }
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (EsStorageSpuAttrInfoBO each : attrInfoBOS) {
            JSONObject map = JSONObject.parseObject((String)JSON.toJSONString((Object)each));
            list.add(map);
        }
        this.elasticsearchUtil.bulkPutIndex(this.esConfig.getPropIndexName(), this.esConfig.getPropIndexType(), list, "spec_id");
    }

    private void deleteSpuInfoFromEs(List<DeleteSpuInfoFromEsBO> deleteSpuInfoFromEsBOS) {
        for (DeleteSpuInfoFromEsBO deleteSpuInfoFromEsBO : deleteSpuInfoFromEsBOS) {
            JSONObject delConditionOrderJson = new JSONObject();
            delConditionOrderJson.put("commodity_id", (Object)String.valueOf(deleteSpuInfoFromEsBO.getCommodityId()));
            JSONObject termOrderJson = new JSONObject();
            termOrderJson.put("term", (Object)delConditionOrderJson);
            JSONObject delConditionAfsJson = new JSONObject();
            delConditionAfsJson.put("scene_id", (Object)String.valueOf(deleteSpuInfoFromEsBO.getSceneId()));
            JSONObject termAfsJson = new JSONObject();
            termAfsJson.put("term", (Object)delConditionAfsJson);
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)termOrderJson);
            jsonArray.add((Object)termAfsJson);
            JSONObject mustJson = new JSONObject();
            mustJson.put("must", (Object)jsonArray);
            JSONObject boolJson = new JSONObject();
            boolJson.put("bool", (Object)mustJson);
            JSONObject qryJson = new JSONObject();
            qryJson.put("query", (Object)boolJson);
            String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_delete_by_query";
            Boolean deleteResult = this.elasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
            if (deleteResult.booleanValue()) continue;
            LOGGER.error("\u573a\u666f\u4e0b\u7684\u5546\u54c1\u4fe1\u606f[" + deleteSpuInfoFromEsBO.getSceneId() + "|" + deleteSpuInfoFromEsBO.getCommodityId() + "]\u5220\u9664\u5931\u8d25!");
        }
    }

    public void searchSku(SyncSceneCommodityToEsReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            return;
        }
        List<Object> skuPoList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getGuiCategoryIds())) {
            skuPoList = this.uccSkuMapper.qrySkuByGuiCataLogs(reqBO.getGuiCategoryIds(), reqBO.getSupplierId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCategoryIds())) {
            skuPoList = this.uccSkuMapper.qrySkuByCataLogs(reqBO.getCategoryIds(), reqBO.getSupplierId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
            skuPoList = this.uccSkuMapper.qrySkuByCommoditys(reqBO.getCommodityIds(), reqBO.getSupplierId());
        }
        if (!CollectionUtils.isEmpty(skuPoList)) {
            reqBO.setSkuIds(skuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
        }
    }

    private List<EsStorageSpuAttrInfoBO> assemblyCommodityAttrInfo(List<Long> commodityIds) {
        if (CollectionUtils.isEmpty(commodityIds)) {
            return new ArrayList<EsStorageSpuAttrInfoBO>();
        }
        return this.uccSpuSpecMapper.qryEsAttrList(commodityIds);
    }

    private void validateReqParams(SyncSceneCommodityToEsReqBO reqBO) {
        if (reqBO.getOperType() == null) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1aES\u64cd\u4f5c\u7c7b\u578b\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getSyncType() == null) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u540c\u6b65\u7c7b\u578b\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID.equals(reqBO.getSyncType()) && (reqBO.getCategoryIds() == null || reqBO.getCategoryIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5173\u8054\u7c7b\u76ee\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_GUI_CATEGORY_ID.equals(reqBO.getSyncType()) && (reqBO.getGuiCategoryIds() == null || reqBO.getGuiCategoryIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5173\u8054\u7c7b\u76ee\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType()) && (reqBO.getCommodityIds() == null || reqBO.getCommodityIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5546\u54c1ID\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_ACTIVITY_CONTENT.equals(reqBO.getSyncType()) && (reqBO.getSpuEsForActivityBOS() == null || reqBO.getSpuEsForActivityBOS().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u6d3b\u52a8\u4fe1\u606f\u5230ES\u5931\u8d25\uff1a\u6d3b\u52a8\u76f8\u5173\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

