/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccCommodityAtomService;
import com.tydic.commodity.atom.bo.BatchUpdateCommodityBO;
import com.tydic.commodity.atom.bo.BatchUpdateCommodityStatusReqBo;
import com.tydic.commodity.atom.bo.BatchUpdateSkuBO;
import com.tydic.commodity.atom.bo.BatchUpdateSkuStatusReqBO;
import com.tydic.commodity.bo.RspUccBo;
import com.tydic.commodity.bo.busi.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.bo.busi.CommodityBo;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.busi.impl.DealCommoApprovalLevelServiceImpl;
import com.tydic.commodity.businessenums.BusinessRsponseEnums;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccCommodityLogMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccCommodityLogPO;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccJoinQuerySkusPo;
import com.tydic.commodity.dao.po.UccSkuLogPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.AuditResultStatusEnum;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.validate.ValidatorUtil;
import com.tydic.plugin.starter.mq.manager.MqManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService"})
public class BatchUpdateCommoStatusForMarketServiceImpl
implements BatchUpdateCommoStatusForMarketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DealCommoApprovalLevelServiceImpl.class);
    @Autowired
    private UccCommodityAtomService uccCommodityAtomService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityLogMapper uccCommodityLogMapper;
    @Autowired
    private UccSkuMapper skuMapper;
    @Autowired
    private UccSkuLogMapper uccSkuLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private MqManager mqManager;

    @PostMapping(value={"batchUpdateCommoStatusForMarket"})
    public RspUccBo batchUpdateCommoStatusForMarket(@RequestBody BatchUpdateCommoStatusForMarketBO statusForMarketBO, @RequestBody CommodityStatusEnum commodityStatusEnum, @RequestBody SkuStatusEnum skuStatusEnum) {
        ValidatorUtil.validator((Object)statusForMarketBO);
        if (statusForMarketBO.getBusinessId() == null || statusForMarketBO.getBusinessId().length == 0) {
            throw new BusinessException(BusinessRsponseEnums.PARAMETER_ERROR.code(), "\u4e1a\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object batchId = null;
        ArrayList uccCommodityLogPOS = Lists.newArrayList();
        ArrayList batchUpdateSkuBOS = Lists.newArrayList();
        ArrayList batchUpdateCommodityBOs = Lists.newArrayList();
        BatchUpdateSkuStatusReqBO batchUpdateSkuStatusReqBO = new BatchUpdateSkuStatusReqBO();
        BatchUpdateCommodityStatusReqBo commodityStatusReqBo = new BatchUpdateCommodityStatusReqBo();
        long[] sequence = new long[statusForMarketBO.getBusinessId().length];
        sequence = this.uccBatchSequence.nextIds(statusForMarketBO.getBusinessId().length);
        for (int i = 0; i < statusForMarketBO.getBusinessId().length; ++i) {
            UccCommodityPo uccCommodityPo = this.uccCommodityMapper.getCommodityById(statusForMarketBO.getBusinessId()[i]);
            if (uccCommodityPo == null) continue;
            if (commodityStatusEnum != null) {
                UccCommodityLogPO uccCommodityLogPO = new UccCommodityLogPO();
                BeanUtils.copyProperties((Object)uccCommodityPo, (Object)uccCommodityLogPO);
                uccCommodityLogPO.setBatchId(sequence[i]);
                uccCommodityLogPO.setAduitResult(statusForMarketBO.getReason());
                uccCommodityLogPOS.add(uccCommodityLogPO);
                BatchUpdateCommodityBO batchUpdateCommodityBO = new BatchUpdateCommodityBO();
                batchUpdateCommodityBO.setCommodityId(uccCommodityPo.getCommodityId());
                batchUpdateCommodityBO.setStatus(commodityStatusEnum.getStatus());
                commodityStatusReqBo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
                batchUpdateCommodityBOs.add(batchUpdateCommodityBO);
            }
            if (skuStatusEnum == null) continue;
            BatchUpdateSkuBO batchUpdateSkuBO = new BatchUpdateSkuBO();
            batchUpdateSkuBO.setCommodityId(statusForMarketBO.getBusinessId()[i]);
            batchUpdateSkuBO.setSupplierShopId(uccCommodityPo.getSupplierShopId());
            batchUpdateSkuBO.setStatus(skuStatusEnum.getStatus());
            batchUpdateSkuBOS.add(batchUpdateSkuBO);
        }
        if (skuStatusEnum != null) {
            UccJoinQuerySkusPo uccJoinQuerySkusPo = new UccJoinQuerySkusPo();
            uccJoinQuerySkusPo.setCommodityIdArrays(statusForMarketBO.getBusinessId());
            List<UccSkuPo> skuPos = this.skuMapper.queryJoinSkuByCommodityId(uccJoinQuerySkusPo);
            List<UccSkuLogPo> UccSkuLogPo2 = this.cloneUccSkuPo(skuPos);
            batchUpdateSkuStatusReqBO.setStatus(skuStatusEnum.getStatus());
            batchUpdateSkuStatusReqBO.setBoList(batchUpdateSkuBOS);
            this.processUpdateSkuAndLog(batchUpdateSkuStatusReqBO, UccSkuLogPo2);
        }
        if (commodityStatusEnum != null) {
            commodityStatusReqBo.setBoList(batchUpdateCommodityBOs);
            this.processUpdateCommodityAndLog(commodityStatusReqBo, uccCommodityLogPOS);
        }
        if (!CollectionUtils.isEmpty((Collection)batchUpdateSkuBOS)) {
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds(batchUpdateSkuBOS.stream().map(BatchUpdateSkuBO::getCommodityId).collect(Collectors.toList()));
            syncSceneCommodityToEsReqBO.setSupplierId(((BatchUpdateSkuBO)batchUpdateSkuBOS.get(0)).getSupplierShopId());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
            this.mqManager.getSender(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_PID")).sendMessage(JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
        }
        LOGGER.info("\u5904\u7406\u5546\u54c1\u5355\u54c1\u72b6\u6001\u5b8c\u6210");
        RspUccBo rspUccBo = new RspUccBo();
        rspUccBo.setRespCode("0000");
        rspUccBo.setRespDesc("\u6210\u529f");
        return rspUccBo;
    }

    @PostMapping(value={"updateCommoApprovalStatus"})
    public void updateCommoApprovalStatus(@RequestBody CommodityBo commodityBo, @RequestBody AuditResultStatusEnum auditResultStatusEnum) {
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        uccCommodityPo.setCommodityId(commodityBo.getCommodityId());
        uccCommodityPo.setApprovalStatus(commodityBo.getApprovalStatus());
        uccCommodityPo.setSupplierShopId(commodityBo.getSupplierShopId());
        this.uccCommodityMapper.updateCommodity(uccCommodityPo);
    }

    private void processUpdateCommodityAndLog(BatchUpdateCommodityStatusReqBo reqBO, List<UccCommodityLogPO> commodityLogPOS) {
        try {
            if (CollectionUtils.isNotEmpty(commodityLogPOS)) {
                this.uccCommodityLogMapper.batchInsert(commodityLogPOS);
            }
            this.uccCommodityAtomService.batchUpdateCommodityByCommodityId(reqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("8888", "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    private void processUpdateSkuAndLog(BatchUpdateSkuStatusReqBO reqBO, List<UccSkuLogPo> uccSkuLogPos) {
        try {
            if (CollectionUtils.isNotEmpty(uccSkuLogPos)) {
                this.uccSkuLogMapper.addSkuLog(uccSkuLogPos);
            }
            this.uccCommodityAtomService.batchSkuInStatus(reqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("8888", "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    private List<UccSkuLogPo> cloneUccSkuPo(List<UccSkuPo> skuPos) {
        ArrayList uccSkuLogPos = Lists.newArrayList();
        for (UccSkuPo skuPo : skuPos) {
            Long batchId = this.uccBatchSequence.nextId();
            UccSkuLogPo uccSkuLogPo = new UccSkuLogPo();
            uccSkuLogPo.setBatchId(batchId);
            BeanUtils.copyProperties((Object)skuPo, (Object)uccSkuLogPo);
            uccSkuLogPos.add(uccSkuLogPo);
        }
        return uccSkuLogPos;
    }
}

