/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.bo.busi.AuditlevelBO;
import com.tydic.commodity.bo.busi.UccAuditlevelQueryReqBO;
import com.tydic.commodity.bo.busi.UccAuditlevelQueryRspBO;
import com.tydic.commodity.busi.api.UccAuditlevelQueryBusiService;
import com.tydic.commodity.dao.ApprovalLevelMapper;
import com.tydic.commodity.dao.po.ApprovalLevelPO;
import com.tydic.commodity.enumType.ApprovalLevelEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccAuditlevelQueryBusiService"})
public class UccAuditlevelQueryBusiServiceImpl
implements UccAuditlevelQueryBusiService {
    @Autowired
    private ApprovalLevelMapper approvalLevelMapper;

    @PostMapping(value={"qryAuditlevel"})
    public UccAuditlevelQueryRspBO qryAuditlevel(@RequestBody UccAuditlevelQueryReqBO reqBO) {
        UccAuditlevelQueryRspBO uccAuditlevelQueryRspBO = new UccAuditlevelQueryRspBO();
        ApprovalLevelPO approvalLevelPO = this.cloneApprovalLevel(reqBO);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<ApprovalLevelPO> approvalLevelPOList = this.approvalLevelMapper.queryAuditLevelListPage(approvalLevelPO, (Page<ApprovalLevelPO>)page);
        uccAuditlevelQueryRspBO.setRespCode("0000");
        uccAuditlevelQueryRspBO.setRespDesc("\u6210\u529f");
        uccAuditlevelQueryRspBO.setPageNo(page.getPageNo());
        uccAuditlevelQueryRspBO.setTotal(page.getTotalPages());
        uccAuditlevelQueryRspBO.setRecordsTotal(page.getTotalCount());
        uccAuditlevelQueryRspBO.setRows(this.processApprovalLevel(approvalLevelPOList, reqBO));
        return uccAuditlevelQueryRspBO;
    }

    private List<AuditlevelBO> processApprovalLevel(List<ApprovalLevelPO> approvalLevelPOList, UccAuditlevelQueryReqBO reqBO) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList auditlevelBOS = Lists.newArrayList();
        for (ApprovalLevelPO approvalLevelPO : approvalLevelPOList) {
            AuditlevelBO auditlevelBO = new AuditlevelBO();
            String classification = stringBuilder.append(approvalLevelPO.getCatalogName1()).append(StringUtils.isBlank((String)approvalLevelPO.getCatalogName2()) ? "" : "/" + approvalLevelPO.getCatalogName2() + "").append(StringUtils.isBlank((String)approvalLevelPO.getCatalogName3()) ? "" : "/" + approvalLevelPO.getCatalogName3() + "").append("/" + approvalLevelPO.getCommodityTypeName()).toString();
            auditlevelBO.setClassificationStr(classification);
            stringBuilder.setLength(0);
            auditlevelBO.setCommodityTypeId(approvalLevelPO.getCommodityTypeId());
            auditlevelBO.setLevel(approvalLevelPO.getApprovalLevel());
            auditlevelBO.setLevelDesc(ApprovalLevelEnum.getLevelDesc((int)approvalLevelPO.getApprovalLevel()).getLevelDesc());
            auditlevelBOS.add(auditlevelBO);
        }
        return auditlevelBOS;
    }

    private ApprovalLevelPO cloneApprovalLevel(UccAuditlevelQueryReqBO reqBO) {
        ApprovalLevelPO approvalLevelPO = new ApprovalLevelPO();
        approvalLevelPO.setApprovalLevel(reqBO.getAuditLevel());
        approvalLevelPO.setCommodityTypeId(reqBO.getCommodityTypeId());
        approvalLevelPO.setCommodityTypeName(reqBO.getCommodityTypeName());
        approvalLevelPO.setGuideCatalogId(reqBO.getGuideCatalogId());
        approvalLevelPO.setGuideCatalogLevel(reqBO.getGuideCatalogLevel());
        return approvalLevelPO;
    }
}

