/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.UccCatalogRelCommdTypeBusiUpdateReqBO;
import com.tydic.commodity.bo.busi.UccCatalogRelCommdTypeBusiUpdateRspBO;
import com.tydic.commodity.busi.api.UccCatalogConnectCommdTypeUpdateBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.po.UccCatalogConnectCommdTypeDealPO;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.plugin.starter.mq.manager.MqManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.SqlSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccCatalogConnectCommdTypeUpdateBusiService"})
public class UccCatalogRelCommdTypeUpdateBusiServiceImpl
implements UccCatalogConnectCommdTypeUpdateBusiService {
    @Autowired
    private UccCatRCommdTypeMapper mapper;
    @Autowired
    private MqManager mqManager;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCatalogRelCommdTypeUpdateBusiServiceImpl.class);
    UccCatalogRelCommdTypeBusiUpdateRspBO rspBO = new UccCatalogRelCommdTypeBusiUpdateRspBO();
    UccCatalogConnectCommdTypeDealPO PO = new UccCatalogConnectCommdTypeDealPO();

    @PostMapping(value={"updateCatalogConnectCommdType"})
    public UccCatalogRelCommdTypeBusiUpdateRspBO updateCatalogConnectCommdType(@RequestBody UccCatalogRelCommdTypeBusiUpdateReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        UccCatalogConnectCommdTypeDealPO uccCatalogConnectCommdTypeDealPO = new UccCatalogConnectCommdTypeDealPO();
        uccCatalogConnectCommdTypeDealPO.setRelId(reqBO.getRelId());
        List<UccCatalogConnectCommdTypeDealPO> uccCatalogConnectCommdTypeDealPOS = this.mapper.selectDataByRelId(uccCatalogConnectCommdTypeDealPO);
        if (CollectionUtils.isEmpty(uccCatalogConnectCommdTypeDealPOS)) {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRespDesc("\u5173\u7cfbID\u8f93\u5165\u9519\u8bef");
            return this.rspBO;
        }
        Long commodityTypeId = uccCatalogConnectCommdTypeDealPOS.get(0).getCommodityTypeId();
        BeanUtils.copyProperties((Object)reqBO, (Object)this.PO);
        int result = 0;
        try {
            result = this.mapper.updateData(this.PO);
        }
        catch (Exception e) {
            throw new SqlSessionException("\u6570\u636e\u66f4\u65b0\u5f02\u5e38");
        }
        if (result != 1) {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRespDesc("\u66f4\u65b0\u5173\u8054\u5931\u8d25");
            return this.rspBO;
        }
        this.rspBO.setRespCode("0000");
        this.rspBO.setRespDesc("\u66f4\u65b0\u5173\u8054\u6210\u529f");
        try {
            ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
            commodityTypeIds.add(commodityTypeId);
            commodityTypeIds.add(reqBO.getCommodityTypeId());
            List<UccCommodityTypePo> uccCommodityTypePos = this.uccCommodityTypeMapper.batchQryInType(commodityTypeIds);
            if (CollectionUtils.isEmpty(uccCommodityTypePos)) {
                this.rspBO.setRespCode("8888");
                this.rspBO.setRespDesc("\u5546\u54c1\u7c7b\u578b\u4e0d\u5b58\u5728");
                return this.rspBO;
            }
            List catalogList = uccCommodityTypePos.stream().map(UccCommodityTypePo::getCatalogId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID);
            syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            syncSceneCommodityToEsReqBo.setCategoryIds(catalogList);
            this.mqManager.getSender(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_PID")).sendMessage(JSON.toJSONString((Object)syncSceneCommodityToEsReqBo));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u7c7b\u76ee\u540c\u6b65ES\u5931\u8d25");
        }
        return this.rspBO;
    }

    public boolean judge(UccCatalogRelCommdTypeBusiUpdateReqBO reqBO) {
        if (reqBO.getRelId() == null) {
            this.rspBO.setRespDesc("\u5173\u8054ID\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)this.PO);
        if (this.mapper.selectDataByRelId(this.PO) == null || this.mapper.selectDataByRelId(this.PO).size() == 0) {
            this.rspBO.setRespDesc("\u5173\u8054ID\u4e0d\u5b58\u5728");
            return false;
        }
        if (reqBO.getCommodityTypeId() == null) {
            this.rspBO.setRespDesc("\u5546\u54c1\u7c7b\u578bID\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        return true;
    }
}

