/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.bo.busi.CommCompletenessCheckInfoBO;
import com.tydic.commodity.bo.busi.CommInfoCompletenessCheckReqBO;
import com.tydic.commodity.bo.busi.CommInfoCompletenessCheckRspBO;
import com.tydic.commodity.bo.busi.CommodityCheckPassBO;
import com.tydic.commodity.bo.busi.CommodityInfoCheckReqBO;
import com.tydic.commodity.bo.busi.CommodityInfoCheckRspBO;
import com.tydic.commodity.bo.busi.DealCommoApprovalLevelBO;
import com.tydic.commodity.bo.busi.SendNextCommoDealDetail;
import com.tydic.commodity.bo.busi.SensitiveWordCheckInfoBO;
import com.tydic.commodity.bo.busi.SensitiveWordCheckReqBO;
import com.tydic.commodity.bo.busi.SensitiveWordCheckRspBO;
import com.tydic.commodity.bo.busi.UccExaminationApprovalRspBO;
import com.tydic.commodity.bo.busi.UccRestoreShelfRspBO;
import com.tydic.commodity.busi.api.DealCommoApprovalLevelService;
import com.tydic.commodity.busi.api.UccCommodityInfoCheckBusiService;
import com.tydic.commodity.busi.api.UccCompletenessBusiService;
import com.tydic.commodity.busi.api.UccSensitiveWordCheckBusiService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.po.CommodityInfoForCheckPO;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.ListCloneUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccCommodityInfoCheckBusiService"})
public class UccCommodityInfoCheckBusiServiceImpl
implements UccCommodityInfoCheckBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityInfoCheckBusiServiceImpl.class);
    @Autowired
    private UccCommodityMapper commodityMapper;
    @Autowired
    private UccCompletenessBusiService uccCompletenessBusiService;
    @Autowired
    private UccSensitiveWordCheckBusiService uccSensitiveWordCheckBusiService;
    @Autowired
    private DealCommoApprovalLevelService dealCommoApprovalLevelService;
    @Autowired
    private UccSkuMapper skuMapper;
    @Autowired
    private UccCommodityPicMapper commodityPicMapper;
    @Autowired
    private UccSkuPriceMapper priceMapper;

    @PostMapping(value={"dealCommodityInfoCheck"})
    public CommodityInfoCheckRspBO dealCommodityInfoCheck(@RequestBody CommodityInfoCheckReqBO reqBO) {
        UccExaminationApprovalRspBO uccExaminationApprovalRspBO;
        CommodityInfoCheckRspBO commodityInfoCheckRspBO = new CommodityInfoCheckRspBO();
        CommInfoCompletenessCheckReqBO commInfoCompletenessCheckReqBO = new CommInfoCompletenessCheckReqBO();
        DealCommoApprovalLevelBO dealCommoApprovalLevelBO = new DealCommoApprovalLevelBO();
        ArrayList notPassCommodity = Lists.newArrayList();
        ArrayList sendNextCommoDealDetail = Lists.newArrayList();
        SensitiveWordCheckReqBO sensitiveWordCheckReqBO = new SensitiveWordCheckReqBO();
        List<CommodityInfoForCheckPO> poList = null;
        try {
            poList = this.getCommodityInfoForCheck(reqBO.getCommodityId(), reqBO.getSupplierId());
        }
        catch (BusinessException e) {
            LOGGER.error("\u5546\u54c1\u68c0\u67e5\u6570\u636e\u67e5\u8be2\u5f02\u5e38:" + (Object)((Object)e));
            throw new BusinessException("8888", "\u5546\u54c1\u68c0\u67e5\u6570\u636e\u67e5\u8be2\u5f02\u5e38");
        }
        try {
            List checkInfoBOS = ListCloneUtils.clonePOListToBOListNotDate(poList, CommCompletenessCheckInfoBO.class);
            commInfoCompletenessCheckReqBO.setCommCompletenessCheckInfoBOS(checkInfoBOS);
        }
        catch (Exception e) {
            LOGGER.error("\u8fdb\u884c\u5546\u54c1\u4fe1\u606f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38," + e);
            commodityInfoCheckRspBO.setRespDesc("\u68c0\u67e5\u5546\u54c1\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
            commodityInfoCheckRspBO.setRespCode("8888");
        }
        CommInfoCompletenessCheckRspBO completenessCheckRspBO = this.uccCompletenessBusiService.completenessCheck(commInfoCompletenessCheckReqBO);
        notPassCommodity.addAll(completenessCheckRspBO.getCheckPassAndNotPassBO().getNotPassCommodity());
        if (CollectionUtils.isNotEmpty((Collection)completenessCheckRspBO.getCheckPassAndNotPassBO().getPassCommodity())) {
            List sensitiveWordCheckInfoBOS;
            try {
                sensitiveWordCheckInfoBOS = ListCloneUtils.clonePOListToBOList((List)completenessCheckRspBO.getCheckPassAndNotPassBO().getPassCommodity(), SensitiveWordCheckInfoBO.class);
            }
            catch (Exception e) {
                LOGGER.error("\u5546\u54c1\u4fe1\u606f\u5b8c\u6574\u6027\u6821\u9a8c\u901a\u8fc7\u6570\u636e\u8f6c\u6362\u5f02\u5e38," + e);
                commodityInfoCheckRspBO.setRespDesc("\u5546\u54c1\u4fe1\u606f\u5b8c\u6574\u6027\u6821\u9a8c\u901a\u8fc7\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
                commodityInfoCheckRspBO.setRespCode("8888");
                throw new BusinessException("8888", "\u5546\u54c1\u4fe1\u606f\u5b8c\u6574\u6027\u6821\u9a8c\u901a\u8fc7\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
            }
            sensitiveWordCheckReqBO.setSensitiveWordCheckInfoBOList(sensitiveWordCheckInfoBOS);
            SensitiveWordCheckRspBO sensitiveWordCheckRspBO = this.uccSensitiveWordCheckBusiService.executeSensitiveWordCheck(sensitiveWordCheckReqBO);
            notPassCommodity.addAll(sensitiveWordCheckRspBO.getCheckPassAndNotPassBO().getNotPassCommodity());
            List commodityCheckPassBOS = sensitiveWordCheckRspBO.getCheckPassAndNotPassBO().getPassCommodity();
            try {
                if (CollectionUtils.isNotEmpty((Collection)commodityCheckPassBOS)) {
                    for (CommodityCheckPassBO commodityCheckPassBO : commodityCheckPassBOS) {
                        SendNextCommoDealDetail commoDealDetail = new SendNextCommoDealDetail();
                        commoDealDetail.setCommodityId(commodityCheckPassBO.getCommodityId());
                        commoDealDetail.setCommodityName(commodityCheckPassBO.getCommodityName());
                        commoDealDetail.setCommodityTypeId(commodityCheckPassBO.getCommodityTypeId());
                        sendNextCommoDealDetail.add(commoDealDetail);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5546\u54c1\u4fe1\u606f\u654f\u611f\u8bcd\u6821\u9a8c\u901a\u8fc7\u6570\u636e\u8f6c\u6362\u5f02\u5e38," + e);
                throw new BusinessException("8888", "\u5546\u54c1\u4fe1\u606f\u654f\u611f\u8bcd\u6821\u9a8c\u901a\u8fc7\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
            }
        }
        dealCommoApprovalLevelBO.setSupplierId(reqBO.getSupplierId());
        dealCommoApprovalLevelBO.setNotPassCommodity((List)notPassCommodity);
        dealCommoApprovalLevelBO.setSendNextCommoDealDetail((List)sendNextCommoDealDetail);
        dealCommoApprovalLevelBO.setOperId(reqBO.getOperId());
        this.dealCommoApprovalLevelService.dealRejectDetail(dealCommoApprovalLevelBO);
        if (!reqBO.getViewIsTrue().booleanValue() && null != (uccExaminationApprovalRspBO = this.dealCommoApprovalLevelService.dealSendNextCommoDealDetail(dealCommoApprovalLevelBO)) && CollectionUtils.isNotEmpty((Collection)uccExaminationApprovalRspBO.getCommodityCheckNotPassBOList())) {
            notPassCommodity.addAll(uccExaminationApprovalRspBO.getCommodityCheckNotPassBOList());
        }
        commodityInfoCheckRspBO.setCommodityCheckNotPassBOS((List)notPassCommodity);
        commodityInfoCheckRspBO.setSendNextCommoDealDetails((List)sendNextCommoDealDetail);
        commodityInfoCheckRspBO.setRespCode("0000");
        commodityInfoCheckRspBO.setRespDesc("\u6210\u529f");
        return commodityInfoCheckRspBO;
    }

    @PostMapping(value={"repeatedProcessingCheck"})
    public UccRestoreShelfRspBO repeatedProcessingCheck(@RequestBody Long[] commodityIds) {
        UccRestoreShelfRspBO uccRestoreShelfRspBO = new UccRestoreShelfRspBO();
        List<Long> arrayCommo = Arrays.asList(commodityIds);
        List<Long> arraysCommodityId = this.skuMapper.checkSkuByCommdIds(arrayCommo, null, SkuStatusEnum.DOWN_FRAME_STATUS.getStatus());
        int count = this.skuMapper.queryGroupCommoCountByCommodityid(arrayCommo, null, SkuStatusEnum.DOWN_FRAME_STATUS.getStatus());
        if (CollectionUtils.isEmpty(arraysCommodityId) || arrayCommo.size() != count) {
            uccRestoreShelfRspBO.setRespCode("8888");
            uccRestoreShelfRspBO.setRespDesc("\u5546\u54c1\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c");
            return uccRestoreShelfRspBO;
        }
        uccRestoreShelfRspBO.setRespCode("0000");
        uccRestoreShelfRspBO.setRespDesc("\u6210\u529f");
        return uccRestoreShelfRspBO;
    }

    private List<CommodityInfoForCheckPO> getCommodityInfoForCheck(Long[] customerIds, String supplierId) {
        try {
            CommodityInfoForCheckPO commodityInfoForCheckPO = new CommodityInfoForCheckPO();
            commodityInfoForCheckPO.setCommodityIds(customerIds);
            commodityInfoForCheckPO.setSupplierId(supplierId);
            List<CommodityInfoForCheckPO> commodityInfoForCheckPOs = this.commodityMapper.getCommodityInfoForCheck(commodityInfoForCheckPO);
            if (CollectionUtils.isEmpty(commodityInfoForCheckPOs)) {
                throw new BusinessException("8888", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
            }
            return commodityInfoForCheckPOs;
        }
        catch (BusinessException e) {
            LOGGER.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u9519\u8bef," + (Object)((Object)e));
            throw new BusinessException("8888", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
        }
    }
}

