/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccCommodityAtomService;
import com.tydic.commodity.atom.bo.BatchUpdateCommodityBO;
import com.tydic.commodity.atom.bo.BatchUpdateCommodityStatusReqBo;
import com.tydic.commodity.atom.bo.BatchUpdateSkuBO;
import com.tydic.commodity.atom.bo.BatchUpdateSkuStatusReqBO;
import com.tydic.commodity.bo.busi.UccCommodityPublishReqBO;
import com.tydic.commodity.bo.busi.UccCommodityPublishRspBO;
import com.tydic.commodity.busi.api.UccCommodityPublishBusiService;
import com.tydic.commodity.dao.UccCommdQueryDealMapper;
import com.tydic.commodity.dao.UccCommodityLogMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.UccCommdQueryPO;
import com.tydic.commodity.dao.po.UccCommodityLogPO;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccCommodityPublishBusiService"})
public class UccCommodityPublishBusiServiceImpl
implements UccCommodityPublishBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityPublishBusiServiceImpl.class);
    @Autowired
    private UccCommdQueryDealMapper uccCommdQueryDealMapper;
    @Autowired
    private UccCommodityAtomService uccCommodityAtomService;
    @Value(value="${busi_code}")
    private String busiCode;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityLogMapper commodityLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();

    @PostMapping(value={"dealCommodityPublish"})
    public UccCommodityPublishRspBO dealCommodityPublish(@RequestBody UccCommodityPublishReqBO reqBO) {
        Long batchId = this.uccBatchSequence.nextId();
        UccCommodityPublishRspBO uccCommodityPublishRspBO = new UccCommodityPublishRspBO();
        BatchUpdateSkuBO batchUpdateSkuBO = null;
        BatchUpdateCommodityBO batchUpdateCommodityBO = null;
        ArrayList batchUpdateCommodityBOS = Lists.newArrayList();
        ArrayList batchUpdateSkuBOS = Lists.newArrayList();
        for (int i = 0; i < reqBO.getCommodityId().length; ++i) {
            UccCommdQueryPO uccCommdQueryPO = this.uccCommdQueryDealMapper.selectCommodityByCommodityId(reqBO.getCommodityId()[i]);
            if (uccCommdQueryPO.getCommodityStatus() == null || uccCommdQueryPO.getCommodityStatus() != null && uccCommdQueryPO.getCommodityStatus() != 0) {
                uccCommodityPublishRspBO.setRespCode("8888");
                uccCommodityPublishRspBO.setRespDesc("\u5546\u54c1ID\u4e3a[" + uccCommdQueryPO.getCommodityId() + "]\u72b6\u6001\u9519\u8bef,\u5fc5\u987b\u4e3a\u8349\u7a3f\u72b6\u6001");
                return uccCommodityPublishRspBO;
            }
            batchUpdateCommodityBO = new BatchUpdateCommodityBO();
            batchUpdateCommodityBO.setCommodityId(uccCommdQueryPO.getCommodityId());
            batchUpdateCommodityBO.setStatus(1);
            batchUpdateCommodityBO.setSupplierShopId(uccCommdQueryPO.getSupplierShopId());
            batchUpdateCommodityBOS.add(batchUpdateCommodityBO);
            batchUpdateSkuBO = new BatchUpdateSkuBO();
            batchUpdateSkuBO.setCommodityId(uccCommdQueryPO.getCommodityId());
            batchUpdateSkuBO.setStatus(2);
            batchUpdateSkuBO.setSupplierShopId(uccCommdQueryPO.getSupplierShopId());
            batchUpdateSkuBOS.add(batchUpdateSkuBO);
        }
        try {
            UccCommodityLogPO commodityLogPO = new UccCommodityLogPO();
            for (BatchUpdateCommodityBO updateCommodityBO : batchUpdateCommodityBOS) {
                UccCommodityPo commodityPo = this.uccCommodityMapper.getCommodityById(updateCommodityBO.getCommodityId());
                BeanUtils.copyProperties((Object)commodityPo, (Object)commodityLogPO);
            }
            commodityLogPO.setBatchId(batchId);
            this.commodityLogMapper.insert(commodityLogPO);
            BatchUpdateCommodityStatusReqBo batchUpdateCommodityStatusReqBo = new BatchUpdateCommodityStatusReqBo();
            BatchUpdateSkuStatusReqBO batchUpdateSkuStatusReqBO = new BatchUpdateSkuStatusReqBO();
            if (reqBO.getOrderId() != null) {
                LOGGER.info("\u9700\u5ba1\u6279-->\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838");
                batchUpdateCommodityStatusReqBo.setBoList(batchUpdateCommodityBOS);
                batchUpdateCommodityStatusReqBo.setSupplierShopId(reqBO.getShopId());
                this.uccCommodityAtomService.batchUpdateCommodityByCommodityId(batchUpdateCommodityStatusReqBo);
                LOGGER.info("\u9700\u5ba1\u6279-->\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838");
                batchUpdateSkuStatusReqBO.setBoList(batchUpdateSkuBOS);
                batchUpdateSkuStatusReqBO.setBatchId(batchId);
                batchUpdateSkuStatusReqBO.setStatus(1);
                this.uccCommodityAtomService.batchUpdateSkuInStatusByCommodityId(batchUpdateSkuStatusReqBO);
            } else {
                LOGGER.info("\u65e0\u9700\u5ba1\u6279-->\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u4e3a\u5df2\u751f\u6548\uff0c\u5355\u54c1\u4fee\u6539\u4e3a\u5f85\u4e0a\u67b6");
                for (BatchUpdateCommodityBO updateCommodityBO : batchUpdateCommodityBOS) {
                    updateCommodityBO.setStatus(2);
                }
                batchUpdateCommodityStatusReqBo.setBoList(batchUpdateCommodityBOS);
                batchUpdateCommodityStatusReqBo.setSupplierShopId(reqBO.getShopId());
                this.uccCommodityAtomService.batchUpdateCommodityByCommodityId(batchUpdateCommodityStatusReqBo);
                batchUpdateSkuStatusReqBO.setBoList(batchUpdateSkuBOS);
                batchUpdateSkuStatusReqBO.setBatchId(batchId);
                batchUpdateSkuStatusReqBO.setStatus(2);
                this.uccCommodityAtomService.batchUpdateSkuInStatusByCommodityId(batchUpdateSkuStatusReqBO);
            }
        }
        catch (BusinessException e) {
            LOGGER.error("\u5546\u54c1\u53d1\u5e03\u5f02\u5e38,\u539f\u56e0\uff1a{}", (Throwable)e);
            throw new BusinessException("8888", "\u53d1\u5e03\u5546\u54c1\u4e1a\u52a1\u5f02\u5e38");
        }
        uccCommodityPublishRspBO.setRespCode("0000");
        uccCommodityPublishRspBO.setRespDesc("\u6210\u529f");
        return uccCommodityPublishRspBO;
    }
}

