/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.bo.busi.UccCopyAttributesReqBO;
import com.tydic.commodity.bo.busi.UccCopyAttributesRspBO;
import com.tydic.commodity.busi.api.UccCopyAttributesBusiService;
import com.tydic.commodity.busi.impl.UccModifyPropGroupBusiServiceImpl;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccPropValueListMapper;
import com.tydic.commodity.dao.UccRelPropGrpPropMapper;
import com.tydic.commodity.dao.po.UccCommdPropDefPo;
import com.tydic.commodity.dao.po.UccCommodityPropGrpPo;
import com.tydic.commodity.dao.po.UccPropValueListPo;
import com.tydic.commodity.dao.po.UccRelPropGrpPropPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccCopyAttributesBusiService"})
public class UccCopyAttributesBusiServiceImpl
implements UccCopyAttributesBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccModifyPropGroupBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccPropValueListMapper uccPropValueListMapper;
    @Autowired
    private UccRelPropGrpPropMapper uccRelPropGrpPropMapper;

    @PostMapping(value={"addAttributes"})
    public UccCopyAttributesRspBO addAttributes(@RequestBody UccCopyAttributesReqBO reqBO) {
        UccCopyAttributesRspBO rspBO = new UccCopyAttributesRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        UccCommodityPropGrpPo uccCommodityPropGrpPo = this.uccCommodityPropGrpMapper.queryGroupByGrpId(reqBO.getCommodityPropGrpId());
        if (uccCommodityPropGrpPo == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4ID" + reqBO.getCommodityPropGrpId() + " \u4e0d\u5b58\u5728");
            return rspBO;
        }
        UccCommdPropDefPo uccCommdPropDefPo = new UccCommdPropDefPo();
        for (Object commodityPropDefId : reqBO.getCommodityPropDefIds()) {
            uccCommdPropDefPo.setCommodityPropDefId((Long)commodityPropDefId);
            if ((uccCommdPropDefPo = this.uccCommodityPropDefMapper.queryBycommodityPropDefId(uccCommdPropDefPo)) != null) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027ID" + commodityPropDefId + " \u4e0d\u5b58\u5728");
            return rspBO;
        }
        UccRelPropGrpPropPo uccRelPropGrpPropPo = null;
        for (Object defId : reqBO.getCommodityPropDefIds()) {
            uccRelPropGrpPropPo = this.uccRelPropGrpPropMapper.queryByDefIdAndGrpId((Long)defId, reqBO.getOldPropGrpId());
            if (uccRelPropGrpPropPo != null) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4ID\uff1a" + reqBO.getOldPropGrpId() + " \u5c5e\u6027ID\uff1a" + defId + "\u672a\u5173\u8054");
            return rspBO;
        }
        LOGGER.info("--------------- \u5c5e\u6027\u6821\u9a8c\u901a\u8fc7\uff0c\u5f00\u59cb\u590d\u5236\u5c5e\u6027 ----------------------------");
        HashMap<Long, Long> propDefIds = new HashMap<Long, Long>();
        for (Long commodityPropDefId : reqBO.getCommodityPropDefIds()) {
            uccCommdPropDefPo = new UccCommdPropDefPo();
            uccCommdPropDefPo.setCommodityPropDefId(commodityPropDefId);
            try {
                this.uccCommodityPropDefMapper.copyRecordsBycommodityPropDefId(uccCommdPropDefPo);
                propDefIds.put(commodityPropDefId, uccCommdPropDefPo.getCommodityPropDefId());
            }
            catch (Exception e) {
                LOGGER.error("\u5c5e\u6027\u590d\u5236\u5931\u8d25\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u5c5e\u6027\u590d\u5236\u5931\u8d25" + e.getMessage());
            }
        }
        LOGGER.info("--------------- \u5c5e\u6027\u5236\u5b8c\u6210\uff0c\u5f00\u59cb\u590d\u5236\u5c5e\u6027\u503c ----------------------------");
        ArrayList<Long> hasValue = new ArrayList<Long>();
        List<UccPropValueListPo> valueListPo = null;
        for (Long commodityPropDefId : reqBO.getCommodityPropDefIds()) {
            valueListPo = this.uccPropValueListMapper.queryAttrValueBycommodityPropDefId(commodityPropDefId);
            if (valueListPo != null && valueListPo.size() != 0) {
                hasValue.add(commodityPropDefId);
            }
            LOGGER.info("\u5c5e\u6027\u503cID \uff1a" + commodityPropDefId + "\u65e0\u5c5e\u6027\u503c");
        }
        if (hasValue.size() != 0) {
            for (Long commodityPropDefId : hasValue) {
                try {
                    this.uccPropValueListMapper.copyAttrValueBycommodityPropDefId(commodityPropDefId, (Long)propDefIds.get(commodityPropDefId));
                }
                catch (Exception e) {
                    LOGGER.error("\u5c5e\u6027\u503c\u53c2\u7167\u5931\u8d25\uff1a" + e.getMessage());
                    throw new ZTBusinessException("\u5c5e\u6027\u503c\u53c2\u7167\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            LOGGER.info("--------------- \u5c5e\u6027\u590d\u5236\u5b8c\u6210\uff0c\u5f00\u59cb\u590d\u5236\u5c5e\u6027\u5173\u7cfb ----------------------------");
        } else {
            LOGGER.info("\u5c5e\u6027\u53c2\u7167\uff1a \u5c5e\u6027\u672a\u5b9e\u6dfb\u52a0\u5c5e\u6027\u503c");
        }
        HashMap map = new HashMap();
        for (Map.Entry entry : propDefIds.entrySet()) {
            try {
                this.uccRelPropGrpPropMapper.copyRelByPropDefIdAndGrpId((Long)entry.getKey(), reqBO.getOldPropGrpId(), reqBO.getCommodityPropGrpId(), (Long)entry.getValue());
            }
            catch (Exception e) {
                LOGGER.error("\u5c5e\u6027\u7ec4\u5173\u8054\u5931\u8d25\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u5c5e\u6027\u7ec4\u5173\u8054\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        LOGGER.info("--------------- \u5c5e\u6027\u53c2\u7167\u5b8c\u6210 ----------------------------");
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5c5e\u6027\u53c2\u7167\u6210\u529f");
        return rspBO;
    }

    private String verify(UccCopyAttributesReqBO reqBO) {
        String errMsg = "";
        if (reqBO.getCommodityPropGrpId() == null) {
            errMsg = "\u5c5e\u6027\u7ec4ID \u5fc5\u4f20";
        }
        if (reqBO.getCommodityPropDefIds() == null || reqBO.getCommodityPropDefIds().size() == 0) {
            errMsg = "\u8bf7\u9009\u62e9\u53c2\u7167\u5c5e\u6027ID";
        }
        if (reqBO.getOldPropGrpId() == null || reqBO.getOldPropGrpId() == 0L) {
            errMsg = "\u8bf7\u4f20\u5165\u53c2\u7167\u5c5e\u6027\u7ec4ID";
        }
        return errMsg;
    }
}

