/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.CommodityAttrButesBo;
import com.tydic.commodity.bo.busi.CommodityImageBo;
import com.tydic.commodity.bo.busi.SalesAttributesBo;
import com.tydic.commodity.bo.busi.UccCreateCommdReqBO;
import com.tydic.commodity.bo.busi.UccCreateCommdRspBO;
import com.tydic.commodity.busi.api.UccCreateCommdityBusiService;
import com.tydic.commodity.config.vo.CommdProPertiesVo;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccChannelPutMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPackageMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.dao.po.UccChannelPutPo;
import com.tydic.commodity.dao.po.UccCommodityPackagePo;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccSaleNumPo;
import com.tydic.commodity.dao.po.UccSkuPicPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuPutCirPo;
import com.tydic.commodity.dao.po.UccSkuSpecPo;
import com.tydic.commodity.dao.po.UccSkuStockPo;
import com.tydic.commodity.dao.po.UccSpuSpecPo;
import com.tydic.commodity.enumType.CommodityEnum;
import com.tydic.commodity.enumType.SkuEnum;
import com.tydic.commodity.util.DateUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccCreateCommdityBusiService"})
public class UccCreateCommdityBusiServiceImpl
implements UccCreateCommdityBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCreateCommdityBusiServiceImpl.class);
    @Autowired
    private CommdProPertiesVo commdProPertiesVo;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityPackageMapper uccCommodityPackageMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccSkuStockMapper uccSkuStockMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccChannelPutMapper uccChannelPutMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private OrderSequence uccCommdSequence;
    @Autowired
    private OrderSequence uccSkuSequence;
    private Sequence sequenceUtil = Sequence.getInstance();

    @PostMapping(value={"addCommd"})
    public UccCreateCommdRspBO addCommd(@RequestBody UccCreateCommdReqBO reqBO) {
        UccCreateCommdRspBO rspBO = new UccCreateCommdRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        Long star = this.commdProPertiesVo.getCommdStartOrder();
        Long order = 0L;
        Long commdityId = null;
        try {
            commdityId = this.uccCommdSequence.nextId();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccCommodityPo);
        uccCommodityPo.setStoreGetType(1);
        uccCommodityPo.setCommodityId(commdityId);
        try {
            this.uccCommodityMapper.addcommodity(uccCommodityPo);
            commdityId = uccCommodityPo.getCommodityId();
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u5546\u54c1\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
            throw new ZTBusinessException("\u65b0\u589e\u5546\u54c1\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
        }
        UccSpuSpecPo uccSpuSpecPo = null;
        for (Object each : reqBO.getCommdAttrGroups()) {
            uccSpuSpecPo = new UccSpuSpecPo();
            BeanUtils.copyProperties((Object)each, (Object)uccSpuSpecPo);
            uccSpuSpecPo.setCommodityId(commdityId);
            uccSpuSpecPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSpuSpecPo.setCreateOperId(reqBO.getCreateOperId());
            try {
                uccSpuSpecPo.setCommoditySpecId(this.sequenceUtil.nextId());
                this.uccSpuSpecMapper.addCommoditySpec(uccSpuSpecPo);
            }
            catch (Exception e) {
                LOGGER.error("\u5546\u54c1\u5c5e\u6027\u65b0\u589e\u5931\u8d25" + e.getMessage());
                throw new ZTBusinessException("\u5546\u54c1\u5c5e\u6027\u65b0\u589e\u5931\u8d25" + e.getMessage());
            }
        }
        UccCommodityPicPo uccCommodityPicPo = null;
        for (CommodityImageBo each : reqBO.getCommdImages()) {
            uccCommodityPicPo = new UccCommodityPicPo();
            BeanUtils.copyProperties((Object)each, (Object)uccCommodityPicPo);
            uccCommodityPicPo.setCommodityId(commdityId);
            uccCommodityPicPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccCommodityPicPo.setCreateOperId(reqBO.getCreateOperId());
            uccCommodityPicPo.setCommodityPicId(this.sequenceUtil.nextId());
            try {
                this.uccCommodityPicMapper.addcommodityPic(uccCommodityPicPo);
            }
            catch (Exception e) {
                LOGGER.error("\u5546\u54c1\u56fe\u7247\u65b0\u589e\u5931\u8d25\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u5546\u54c1\u56fe\u7247\u65b0\u589e\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        if (!(StringUtils.isEmpty((CharSequence)reqBO.getAfterService()) && StringUtils.isEmpty((CharSequence)reqBO.getPackParam()) && StringUtils.isEmpty((CharSequence)reqBO.getPlaceDelivery()) && StringUtils.isEmpty((CharSequence)reqBO.getFreightTemplateId()))) {
            UccCommodityPackagePo packagePo = new UccCommodityPackagePo();
            packagePo.setCommodityId(commdityId);
            packagePo.setAfterService(reqBO.getAfterService());
            packagePo.setPlaceDelivery(reqBO.getPlaceDelivery());
            packagePo.setPackParam(reqBO.getPackParam());
            if (!StringUtils.isEmpty((CharSequence)reqBO.getFreightTemplateId())) {
                packagePo.setFreightTemplateId(Long.parseLong(reqBO.getFreightTemplateId()));
            }
            packagePo.setSupplierShopId(reqBO.getSupplierShopId());
            packagePo.setCreateOperId(reqBO.getCreateOperId());
            try {
                packagePo.setPackageId(this.sequenceUtil.nextId());
                this.uccCommodityPackageMapper.addcommodityPackage(packagePo);
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u589e\u5546\u54c1\u89c4\u683c\u53c2\u6570\u5931\u8d25\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u65b0\u589e\u5546\u54c1\u89c4\u683c\u53c2\u6570\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        Long count = 1L;
        Long skuId = null;
        UccSkuPo uccSkuPo = null;
        UccSkuSpecPo uccSkuSpecPo = null;
        UccSkuPicPo uccSkuPicPo = null;
        UccSkuPricePo uccSkuPricePo = null;
        UccSkuStockPo uccSkuStockPo = null;
        UccSkuPutCirPo uccSkuPutCirPo = null;
        UccChannelPutPo uccChannelPutPo = null;
        if (reqBO.getSalesAttrs() == null || reqBO.getSalesAttrs().size() == 0) {
            LOGGER.error("\u672a\u63d2\u5165\u5355\u54c1\u4fe1\u606f");
            rspBO.setCommodityId(commdityId);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u521b\u5efa\u5546\u54c1\u6210\u529f");
            return rspBO;
        }
        for (SalesAttributesBo sku : reqBO.getSalesAttrs()) {
            Long l = count;
            Long l2 = count = Long.valueOf(count + 1L);
            skuId = Long.parseLong(commdityId.toString() + l);
            uccSkuPo = new UccSkuPo();
            BeanUtils.copyProperties((Object)sku, (Object)uccSkuPo);
            uccSkuPo.setBrandId(reqBO.getBrandId());
            uccSkuPo.setBrandName(reqBO.getBrandName());
            uccSkuPo.setCommodityId(commdityId);
            uccSkuPo.setCommodityTypeId(reqBO.getCommodityTypeId());
            uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPo.setShopName(reqBO.getShopName());
            uccSkuPo.setCreateOperId(reqBO.getCreateOperId());
            Long primaryKey = null;
            try {
                primaryKey = this.uccSkuSequence.nextId();
            }
            catch (SQLException e) {
                LOGGER.error("\u83b7\u53d6\u5355\u54c1id \u5e8f\u5217\u5931\u8d25\uff1a" + e.getMessage());
            }
            uccSkuPo.setSkuId(primaryKey);
            try {
                this.uccSkuMapper.addsku(uccSkuPo);
                skuId = uccSkuPo.getSkuId();
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u589e\u5355\u54c1\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (sku.getSkuAttrGroups() != null && sku.getSkuAttrGroups().size() > 0) {
                for (CommodityAttrButesBo each : sku.getSkuAttrGroups()) {
                    uccSkuSpecPo = new UccSkuSpecPo();
                    BeanUtils.copyProperties((Object)each, (Object)uccSkuSpecPo);
                    Long primarySpecKey = null;
                    primarySpecKey = this.sequenceUtil.nextId();
                    uccSkuSpecPo.setSkuSpecId(primarySpecKey);
                    uccSkuSpecPo.setCommodityId(commdityId);
                    uccSkuSpecPo.setSkuId(skuId);
                    uccSkuSpecPo.setSupplierShopId(reqBO.getSupplierShopId());
                    uccSkuSpecPo.setCreateOperId(reqBO.getCreateOperId());
                    try {
                        this.uccSkuSpecMapper.addskuSpec(uccSkuSpecPo);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u63d2\u5165\u5355\u54c1\u5c5e\u6027\u5931\u8d25\uff1a" + e.getMessage());
                        throw new ZTBusinessException("\u63d2\u5165\u5355\u54c1\u5c5e\u6027\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
            }
            if (sku.getSkuImage() != null && sku.getSkuImage().size() > 0) {
                for (CommodityAttrButesBo each : sku.getSkuImage()) {
                    uccSkuPicPo = new UccSkuPicPo();
                    BeanUtils.copyProperties((Object)each, (Object)uccSkuPicPo);
                    uccSkuPicPo.setSkuId(skuId);
                    uccSkuPicPo.setCreateOperId(reqBO.getCreateOperId());
                    uccSkuPicPo.setSupplierShopId(reqBO.getSupplierShopId());
                    try {
                        uccSkuPicPo.setSkuPicId(this.sequenceUtil.nextId());
                        this.uccSkuPicMapper.addskuPic(uccSkuPicPo);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5355\u54c1\u56fe\u7247\u63d2\u5165\u5931\u8d25\uff1a" + e.getMessage());
                        throw new ZTBusinessException("\u5355\u54c1\u56fe\u7247\u63d2\u5165\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
            }
            uccSkuPricePo = new UccSkuPricePo();
            BeanUtils.copyProperties((Object)sku, (Object)uccSkuPricePo);
            uccSkuPricePo.setSkuId(skuId);
            uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPricePo.setCreateOperId(reqBO.getCreateOperId());
            uccSkuPricePo.setSkuPriceId(this.sequenceUtil.nextId());
            try {
                this.uccSkuPriceMapper.addskuPrice(uccSkuPricePo);
            }
            catch (Exception e) {
                LOGGER.error("\u63d2\u5165\u5355\u54c1\u4ef7\u683c\u5931\u8d25\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u63d2\u5165\u5355\u54c1\u4ef7\u683c\u5931\u8d25\uff1a" + e.getMessage());
            }
            uccSkuStockPo = new UccSkuStockPo();
            uccSkuStockPo.setStockNum(new BigDecimal(sku.getStockNum()));
            uccSkuStockPo.setStockStatus(sku.getStockStatus());
            uccSkuStockPo.setSkuId(skuId);
            uccSkuStockPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuStockPo.setCreateOperId(reqBO.getCreateOperId());
            try {
                uccSkuStockPo.setStockId(this.sequenceUtil.nextId());
                this.uccSkuStockMapper.addskuStock(uccSkuStockPo);
            }
            catch (Exception e) {
                LOGGER.error("\u5355\u54c1\u5e93\u5b58\u63d2\u5165\u5931\u8d25\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u5355\u54c1\u5e93\u5b58\u63d2\u5165\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (sku.getOnShelveWay() != null) {
                uccSkuPutCirPo = new UccSkuPutCirPo();
                uccSkuPutCirPo.setSkuId(skuId);
                uccSkuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPutCirPo.setId(this.sequenceUtil.nextId());
                uccSkuPutCirPo.setState(0);
                if (0 == sku.getOnShelveWay()) {
                    uccSkuPutCirPo.setUpType(1);
                    uccSkuPutCirPo.setDownType(1);
                } else {
                    uccSkuPutCirPo.setUpType(2);
                    uccSkuPutCirPo.setDownType(2);
                }
                try {
                    if (!StringUtils.isEmpty((CharSequence)sku.getPreUpTime())) {
                        uccSkuPutCirPo.setPreUpTime(DateUtils.strToDate((String)sku.getPreUpTime()));
                    }
                    if (!StringUtils.isEmpty((CharSequence)sku.getPreDownTime())) {
                        uccSkuPutCirPo.setPreDownTime(DateUtils.strToDate((String)sku.getPreDownTime()));
                    }
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff01");
                    throw new ZTBusinessException(e.getMessage());
                }
                try {
                    this.uccSkuPutCirMapper.addSkuPutCir(uccSkuPutCirPo);
                }
                catch (Exception e) {
                    LOGGER.error("\u5355\u54c1\u4e0a\u67b6\u5468\u671f\u63d2\u5165\u5931\u8d25\uff1a" + e.getMessage());
                    throw new ZTBusinessException("\u5355\u54c1\u4e0a\u67b6\u5468\u671f\u63d2\u5165\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            if (sku.getChannelIds() != null && sku.getChannelIds().size() > 0) {
                for (Long channel : sku.getChannelIds()) {
                    uccChannelPutPo = new UccChannelPutPo();
                    uccChannelPutPo.setChannelId(channel);
                    uccChannelPutPo.setSupplierShopId(reqBO.getSupplierShopId());
                    uccChannelPutPo.setId(this.sequenceUtil.nextId());
                    uccChannelPutPo.setPutObjId(skuId);
                    uccChannelPutPo.setPutObjType(2);
                    uccChannelPutPo.setCreateOperId(reqBO.getCreateOperId());
                    try {
                        this.uccChannelPutMapper.sendChannel(uccChannelPutPo);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u65b0\u589e\u6295\u653e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
                        throw new ZTBusinessException("\u65b0\u589e\u6295\u653e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
            }
            UccSaleNumPo uccSaleNumPo = new UccSaleNumPo();
            uccSaleNumPo.setSkuId(skuId);
            uccSaleNumPo.setCreateOperId(reqBO.getCreateOperId());
            uccSaleNumPo.setSoldNumber(new BigDecimal(0));
            uccSaleNumPo.setSupplierShopId(reqBO.getSupplierShopId());
            try {
                uccSaleNumPo.setSaleId(this.sequenceUtil.nextId());
                this.uccSaleNumMapper.insertSaleNum(uccSaleNumPo);
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u589e\u5355\u54c1\u9500\u91cf\u5931\u8d25\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u65b0\u589e\u5355\u54c1\u9500\u91cf\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        rspBO.setCommodityId(commdityId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u521b\u5efa\u5546\u54c1\u6210\u529f");
        return rspBO;
    }

    private String verify(UccCreateCommdReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getCommodityCode())) {
            return "\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCommodityName())) {
            return "\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getCommodityTypeId() == null || reqBO.getCommodityTypeId() == 0L) {
            return "\u5546\u54c1\u7c7b\u578bID\u4e0d\u80fd\u7a7a";
        }
        if (reqBO.getCommoditySource() == null) {
            return "\u8bf7\u8f93\u5165\u5546\u54c1\u6765\u6e90";
        }
        if (reqBO.getCommodityStatus() == null) {
            return "\u8bf7\u8f93\u5165\u5546\u54c1\u72b6\u6001";
        }
        if (reqBO.getSupplierShopId() == null) {
            return "\u8bf7\u4f20\u5165\u5e97\u94faID";
        }
        if (reqBO.getBrandId() == null || reqBO.getBrandId() == 0L) {
            return "\u8bf7\u4f20\u5165\u54c1\u724cID";
        }
        if (reqBO.getCommdImages() == null || reqBO.getCommdImages().size() == 0) {
            return "\u8bf7\u4f20\u5165\u5546\u54c1\u56fe\u7247";
        }
        if (reqBO.getCommdAttrGroups() == null || reqBO.getCommdAttrGroups().size() == 0) {
            return "\u8bf7\u4f20\u5165\u5546\u54c1\u5c5e\u6027\u4fe1\u606f";
        }
        if (reqBO.getSalesAttrs() == null || reqBO.getSalesAttrs().size() == 0) {
            return "\u8bf7\u4f20\u5165\u5355\u54c1\u4fe1\u606f";
        }
        for (SalesAttributesBo each : reqBO.getSalesAttrs()) {
            if (!StringUtils.isEmpty((CharSequence)each.getSkuName())) continue;
            return "\u8bf7\u4f20\u5165\u5355\u54c1\u540d\u79f0";
        }
        return this.verifyData(reqBO);
    }

    private String verifyData(UccCreateCommdReqBO reqBO) {
        Integer count = this.supplierShopMapper.selectSupplierShopById(reqBO.getSupplierShopId());
        if (count == null || count == 0) {
            return "\u5e97\u94faID\uff1a " + reqBO.getSupplierShopId() + "\u4e0d\u5b58\u5728";
        }
        UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
        uccBrandDealPO.setBrandId(reqBO.getBrandId());
        uccBrandDealPO = this.uccBrandDealMapper.selectById(uccBrandDealPO);
        if (uccBrandDealPO == null) {
            return "\u54c1\u724cID\uff1a " + reqBO.getBrandId() + "\u4e0d\u5b58\u5728";
        }
        UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCommodityTypeId());
        if (uccCommodityTypePo == null) {
            return "\u5546\u54c1\u7c7b\u578bID\uff1a " + reqBO.getCommodityTypeId() + "\u4e0d\u5b58\u5728";
        }
        return this.enumVerify(reqBO);
    }

    private String enumVerify(UccCreateCommdReqBO reqBO) {
        Map<String, String> map = null;
        if (reqBO.getCommoditySource() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_SOURCE.toString())).containsKey(reqBO.getCommoditySource().toString())) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 commoditySource\u503c";
        }
        if (reqBO.getCommodityStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_STATUS.toString())).containsKey(reqBO.getCommodityStatus().toString())) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 commodityStatus\u503c";
        }
        if (reqBO.getServenRejectAllow() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_STATUS.toString())).containsKey(reqBO.getServenRejectAllow().toString())) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 servenRejectAllow\u503c";
        }
        for (SalesAttributesBo each : reqBO.getSalesAttrs()) {
            if (each.getSkuSource() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_SOURCE.toString())).containsKey(each.getSkuSource().toString())) {
                return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 skuSource\u503c";
            }
            if (each.getSkuStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_STATUS.toString())).containsKey(each.getSkuStatus().toString())) {
                return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 skuStatus\u503c";
            }
            if (each.getOnShelveWay() == null || (map = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_ON_SHELVE_WAY.toString())).containsKey(each.getOnShelveWay().toString())) continue;
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 onShelveWay\u503c";
        }
        return "";
    }
}

