/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.tydic.commodity.bo.busi.SkuChangePriceBO;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.UccDealUmcMessageReqBO;
import com.tydic.commodity.bo.busi.UccDealUmcMessageRspBO;
import com.tydic.commodity.busi.api.UccDealUmcMessageService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.plugin.starter.mq.manager.MqManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccDealUmcMessageService"})
public class UccDealUmcMessageServiceImpl
implements UccDealUmcMessageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccDealUmcMessageServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private MqManager mqManager;

    @PostMapping(value={"dealUmcMessage"})
    public UccDealUmcMessageRspBO dealUmcMessage(@RequestBody UccDealUmcMessageReqBO reqBO) {
        UccDealUmcMessageRspBO rspBO = new UccDealUmcMessageRspBO();
        LOGGER.info("\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f\u6570\u636e\uff1a" + JSON.toJSONString((Object)reqBO));
        if (reqBO.getCommiditySkuStatus() != null) {
            this.uccSkuMapper.modifySkuByAgreement(reqBO.getAgreementIds(), reqBO.getAgreementSkuIds(), reqBO.getCommiditySkuStatus());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getSkuChangePriceBOs())) {
            List skuChangePriceBOS = reqBO.getSkuChangePriceBOs();
            for (SkuChangePriceBO skuChangePriceBO : skuChangePriceBOS) {
                Long agreementId = null;
                String agreementDetailId = null;
                if (skuChangePriceBO.getAgreementId() != null) {
                    agreementId = skuChangePriceBO.getAgreementId();
                }
                if (skuChangePriceBO.getAgreementSkuId() != null) {
                    agreementDetailId = String.valueOf(skuChangePriceBO.getAgreementSkuId());
                }
                List<UccSkuPo> uccSkuPos = this.uccSkuMapper.selectByAgreementDetailId(agreementId, Long.valueOf(agreementDetailId));
                for (UccSkuPo uccSkuPo : uccSkuPos) {
                    try {
                        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
                        uccSkuPricePo.setSkuId(uccSkuPo.getSkuId());
                        uccSkuPricePo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                        if (skuChangePriceBO.getSalePrice() != null) {
                            uccSkuPricePo.setSalePrice(skuChangePriceBO.getSalePrice().longValue());
                        }
                        if (skuChangePriceBO.getBuyPrice() != null) {
                            uccSkuPricePo.setAgreementPrice(skuChangePriceBO.getBuyPrice().longValue());
                        }
                        this.uccSkuPriceMapper.updateSkuPrice(uccSkuPricePo);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw new BusinessException("8888", "\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
                    }
                    try {
                        UccSkuPo uccSkuPo1 = new UccSkuPo();
                        uccSkuPo1.setSkuId(uccSkuPo.getSkuId());
                        uccSkuPo1.setSupplierShopId(uccSkuPo.getSupplierShopId());
                        if (skuChangePriceBO.getSalePrice() != null) {
                            uccSkuPo1.setSkuPrice(skuChangePriceBO.getSalePrice().longValue());
                        }
                        this.uccSkuMapper.updateSku(uccSkuPo1);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw new BusinessException("8888", "\u4fee\u6539\u4ef7\u683c\u4fe1\u606f\u5931\u8d25");
                    }
                }
            }
        }
        this.dealSkuSyncEs(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d88\u606f\u5904\u7406\u6210\u529f");
        LOGGER.info("\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f\u6210\u529f");
        return rspBO;
    }

    private void dealSkuSyncEs(UccDealUmcMessageReqBO reqBO) {
        List<UccSkuPo> uccSkuPos;
        Map<Object, Object> groupBySupplier = new HashMap();
        if ((CollectionUtils.isNotEmpty((Collection)reqBO.getAgreementIds()) || CollectionUtils.isNotEmpty((Collection)reqBO.getAgreementSkuIds())) && CollectionUtils.isNotEmpty(uccSkuPos = this.uccSkuMapper.selectByAgreementDetailIds(reqBO.getAgreementIds(), reqBO.getAgreementSkuIds()))) {
            groupBySupplier = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getSkuChangePriceBOs())) {
            List<Long> agreementDetailIds = reqBO.getSkuChangePriceBOs().stream().map(SkuChangePriceBO::getAgreementSkuId).collect(Collectors.toList());
            List<Long> agreementIds = reqBO.getSkuChangePriceBOs().stream().map(SkuChangePriceBO::getAgreementId).collect(Collectors.toList());
            List<UccSkuPo> uccSkuPos2 = this.uccSkuMapper.selectByAgreementDetailIds(agreementIds, agreementDetailIds);
            if (CollectionUtils.isNotEmpty(uccSkuPos2)) {
                groupBySupplier = uccSkuPos2.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            }
        }
        for (Map.Entry entry : groupBySupplier.entrySet()) {
            List skuIds = ((List)entry.getValue()).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
            syncSceneCommodityToEsReqBO.setSupplierId((Long)entry.getKey());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            LOGGER.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
            try {
                this.mqManager.getSender(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_PID")).sendMessage(JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
            }
            catch (Exception e) {
                LOGGER.error("\u540c\u6b65\u5546\u54c1\u72b6\u6001\u548c\u4ef7\u683c\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
            }
        }
    }
}

