/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.busi.MqSyncCommdPriceBo;
import com.tydic.commodity.bo.busi.SkuPriceChangeBO;
import com.tydic.commodity.bo.busi.SkuPriceVO;
import com.tydic.commodity.bo.busi.UccPriChangeReqBO;
import com.tydic.commodity.bo.busi.UccPriChangeRspBO;
import com.tydic.commodity.busi.api.QueryDBDateBusiService;
import com.tydic.commodity.busi.api.UccPriChangeBusiService;
import com.tydic.commodity.busi.api.UccSkuAdjustPriceBusiService;
import com.tydic.commodity.dao.ECommercePriceChangeLogMapper;
import com.tydic.commodity.dao.ECommercePriceChangeMapper;
import com.tydic.commodity.dao.UccAddCoefficientMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceLogMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.po.UccAddCoefficientPO;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.enumType.UnitPrice;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.plugin.starter.mq.manager.MqManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccPriChangeBusiService"})
public class UccPriChangeBusiServiceImpl
implements UccPriChangeBusiService {
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuPriceLogMapper uccSkuPriceLogMapper;
    @Autowired
    private UccAddCoefficientMapper uccAddCoefficientMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccPriChangeBusiServiceImpl.class);
    @Autowired
    private UccSkuAdjustPriceBusiService uccSkuAdjustPriceBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ECommercePriceChangeMapper eCommercePriceChangeMapper;
    @Autowired
    private ECommercePriceChangeLogMapper eCommercePriceChangeLogMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    private Sequence coefficientSequence = Sequence.getInstance();
    private static final BigDecimal yuanToMilli = new BigDecimal(10000);
    @Autowired
    private MqManager mqManager;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    @PostMapping(value={"changePrice"})
    public UccPriChangeRspBO changePrice(@RequestBody UccPriChangeReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSkuPriceInfos() == null) {
            throw new BusinessException("8888", "\u4ef7\u683c\u53d8\u66f4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierShopId() == null) {
            throw new BusinessException("8888", "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<SkuPriceVO> skuPriceVOList = new ArrayList<SkuPriceVO>();
        ArrayList<MqSyncCommdPriceBo> mqSyncCommdPriceBoList = new ArrayList<MqSyncCommdPriceBo>();
        for (SkuPriceChangeBO skuPriceChangeBO : reqBO.getSkuPriceInfos()) {
            UccCommodityTypePo uccCommodityTypePo;
            if (skuPriceChangeBO.getSkuId() == null || skuPriceChangeBO.getPrice() == null || skuPriceChangeBO.getMarketPrice() == null) continue;
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setExtSkuId(skuPriceChangeBO.getSkuId());
            uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
            List<UccSkuPo> uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
            if (uccSkuPoList == null || uccSkuPoList.size() != 1) continue;
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            uccSkuPricePo.setSkuId(uccSkuPoList.get(0).getSkuId());
            uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPricePo.setCurrencyType(null);
            if ((uccSkuPricePo = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo)) == null || (uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(uccSkuPoList.get(0).getCommodityTypeId())) == null) continue;
            Long catalogId = uccCommodityTypePo.getCatalogId();
            UccAddCoefficientPO uccAddCoefficientPO = this.uccAddCoefficientMapper.qryCoefficientByCatalogIdAndSupplierShopId(catalogId, reqBO.getSupplierShopId());
            BigDecimal addCoefficient = new BigDecimal(0);
            Integer allowMarketPrice = 0;
            if (uccAddCoefficientPO != null) {
                if (uccAddCoefficientPO.getAddCoefficient() != null) {
                    addCoefficient = uccAddCoefficientPO.getAddCoefficient();
                    addCoefficient = addCoefficient.divide(new BigDecimal(100), 4, 5);
                }
                if (uccAddCoefficientPO.getAllowMarketPrice() != null) {
                    allowMarketPrice = uccAddCoefficientPO.getAllowMarketPrice();
                }
            }
            BigDecimal salePrice = skuPriceChangeBO.getPrice().multiply(addCoefficient.add(new BigDecimal(1)));
            if (allowMarketPrice == 0 && salePrice.compareTo(skuPriceChangeBO.getMarketPrice()) > 0) {
                salePrice = skuPriceChangeBO.getMarketPrice();
            }
            salePrice = salePrice.setScale(2, 0);
            int result1 = salePrice.multiply(UnitPrice.ten_thousand.getCode()).compareTo(new BigDecimal(uccSkuPricePo.getSalePrice()));
            SkuPriceVO skuPriceVO = new SkuPriceVO();
            skuPriceVO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)skuPriceChangeBO.getPrice())));
            skuPriceVO.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)skuPriceChangeBO.getMarketPrice())));
            skuPriceVO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)salePrice)));
            skuPriceVO.setSkuId(uccSkuPoList.get(0).getSkuId());
            skuPriceVO.setExtSkuId(uccSkuPoList.get(0).getExtSkuId());
            skuPriceVO.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
            skuPriceVOList.add(skuPriceVO);
            int result = skuPriceChangeBO.getPrice().multiply(UnitPrice.ten_thousand.getCode()).compareTo(new BigDecimal(uccSkuPricePo.getAgreementPrice()));
            if (result == 0 && result1 == 0) continue;
            MqSyncCommdPriceBo mqSyncCommdPriceBo = new MqSyncCommdPriceBo();
            mqSyncCommdPriceBo.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)skuPriceChangeBO.getPrice())));
            mqSyncCommdPriceBo.setOrgSalePrice(salePrice);
            mqSyncCommdPriceBo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)salePrice)));
            mqSyncCommdPriceBo.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)skuPriceChangeBO.getMarketPrice())));
            mqSyncCommdPriceBo.setExtSkuId(uccSkuPo.getExtSkuId());
            mqSyncCommdPriceBo.setOnShelveTime(uccSkuPoList.get(0).getOnShelveTime());
            mqSyncCommdPriceBo.setSkuId(uccSkuPoList.get(0).getSkuId());
            mqSyncCommdPriceBo.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
            mqSyncCommdPriceBoList.add(mqSyncCommdPriceBo);
        }
        if (!CollectionUtils.isEmpty(mqSyncCommdPriceBoList)) {
            try {
                this.mqManager.getSender(PropertiesUtil.getProperty((String)"PRICE_UCC_SYNC_PID")).sendMessage(JSON.toJSONString(mqSyncCommdPriceBoList));
            }
            catch (Exception e) {
                LOGGER.error("\u4ef7\u683c\u53d8\u52a8\u540c\u6b65\u6570\u636e\u5e93 mq \u751f\u4ea7\u8005\u53d1\u9001\u5f02\u5e38\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString(mqSyncCommdPriceBoList));
            }
        }
        UccPriChangeRspBO rspBO = new UccPriChangeRspBO();
        rspBO.setSkuPriceVOList(skuPriceVOList);
        rspBO.setRespDesc("\u8c03\u4ef7\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

