/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.CommdPropDefBO;
import com.tydic.commodity.bo.busi.UccQueryPropReqBO;
import com.tydic.commodity.bo.busi.UccQueryPropRspBO;
import com.tydic.commodity.busi.api.UccQryPropByGrpCodeBusiService;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccRelPropGrpPropMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccCommdPropDefPo;
import com.tydic.commodity.dao.po.UccCommodityPropGrpPo;
import com.tydic.commodity.dao.po.UccRelPropGrpPropPo;
import com.tydic.commodity.enumType.CommodityPropDefEnum;
import com.tydic.commodity.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccQryPropByGrpCodeBusiService"})
public class UccQryPropByGrpCodeBusiServiceImpl
implements UccQryPropByGrpCodeBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQryPropByGrpCodeBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccRelPropGrpPropMapper uccRelPropGrpPropMapper;
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"queryProp"})
    public UccQueryPropRspBO queryProp(@RequestBody UccQueryPropReqBO reqBO) {
        UccQueryPropRspBO rspBO = new UccQueryPropRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        Page grpPage = new Page();
        UccCommodityPropGrpPo uccCommodityPropGrpPo = new UccCommodityPropGrpPo();
        uccCommodityPropGrpPo.setCommodityPropGrpCode(reqBO.getCommodityPropGrpCode());
        List<UccCommodityPropGrpPo> listPo = this.uccCommodityPropGrpMapper.queryGroup((Page<UccCommodityPropGrpPo>)grpPage, uccCommodityPropGrpPo);
        if (listPo == null || listPo.size() == 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u7f16\u7801:" + reqBO.getCommodityPropGrpCode() + "\u4e0d\u5b58\u5728");
            return rspBO;
        }
        Long groupId = listPo.get(0).getCommodityPropGrpId();
        Page relPage = new Page(-1, 10);
        UccRelPropGrpPropPo uccRelPropGrpPropPo = new UccRelPropGrpPropPo();
        uccRelPropGrpPropPo.setCommodityPropGrpId(groupId);
        List<UccRelPropGrpPropPo> listRel = this.uccRelPropGrpPropMapper.queryRelToPage((Page<UccRelPropGrpPropPo>)relPage, uccRelPropGrpPropPo);
        if (listRel == null || listRel.size() == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u7f16\u7801:" + reqBO.getCommodityPropGrpCode() + "\u65e0\u5173\u8054\u5c5e\u6027");
            return rspBO;
        }
        ArrayList<Long> commodityPropDefIds = new ArrayList<Long>();
        for (UccRelPropGrpPropPo each : listRel) {
            commodityPropDefIds.add(each.getCommodityPropDefId());
        }
        Page propPage = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<UccCommdPropDefPo> propList = this.uccCommodityPropDefMapper.querRecordByCommdPropDefIds((Page<UccCommdPropDefPo>)propPage, commodityPropDefIds);
        if (propList == null || propList.size() == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u7f16\u7801:" + reqBO.getCommodityPropGrpCode() + "\u65e0\u5173\u8054\u5c5e\u6027");
            return rspBO;
        }
        rspBO.setCommodityPropGrpId(groupId);
        ArrayList<CommdPropDefBO> boList = new ArrayList<CommdPropDefBO>();
        CommdPropDefBO bo = null;
        DicDictionaryPo dicDictionaryPo = null;
        for (UccCommdPropDefPo each : propList) {
            bo = new CommdPropDefBO();
            BeanUtils.copyProperties((Object)each, (Object)bo);
            if (each.getCreateTime() != null) {
                bo.setCreateTime(DateUtils.dateToStr((Date)each.getCreateTime()));
            }
            if (each.getUpdateTime() != null) {
                bo.setUpdateTime(DateUtils.dateToStr((Date)each.getUpdateTime()));
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getPropTag().toString(), CommodityPropDefEnum.COMMODITY_PROP_DEF_PROP_TAG.toString())) != null) {
                bo.setPropTagTranslation(dicDictionaryPo.getTitle());
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getPropType()), CommodityPropDefEnum.COMMODITY_PROP_DEF_PROP_TYPE.toString())) != null) {
                bo.setPropTypeTranslation(dicDictionaryPo.getTitle());
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getInputType()), CommodityPropDefEnum.COMMODITY_PROP_DEF_INPUT_TYPE.toString())) != null) {
                bo.setInputTypeTranslation(dicDictionaryPo.getTitle());
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getFilterFlag().toString(), CommodityPropDefEnum.COMMODITY_PROP_DEF_FILTER_FLAG.toString())) != null) {
                bo.setFilterFlagTranslation(dicDictionaryPo.getTitle());
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getRequiredFlag()), CommodityPropDefEnum.COMMODITY_PROP_DEF_REQUIRED_FLAG.toString())) != null) {
                bo.setRequiredFlagTranslation(dicDictionaryPo.getTitle());
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getMultiFlag()), CommodityPropDefEnum.COMMODITY_PROP_DEF_MULTI_FLAG.toString())) != null) {
                bo.setMultiFlagTranslation(dicDictionaryPo.getTitle());
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getPropertyLink()), CommodityPropDefEnum.COMMODITY_PROP_DEF_PROPERTY_LINK.toString())) != null) {
                bo.setPropertyLinkTranslation(dicDictionaryPo.getTitle());
            }
            boList.add(bo);
        }
        rspBO.setRows(boList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPageNo(propPage.getPageNo());
        rspBO.setRecordsTotal(propPage.getTotalCount());
        rspBO.setTotal(propPage.getTotalPages());
        return rspBO;
    }

    private String verify(UccQueryPropReqBO reqBO) {
        String errMsg = "";
        if (StringUtils.isEmpty((CharSequence)reqBO.getCommodityPropGrpCode())) {
            errMsg = "\u5c5e\u6027\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return errMsg;
    }
}

