/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.ability.api.UccSalesVolumeAbilityService;
import com.tydic.commodity.bo.ability.QrySalesVolumeBO;
import com.tydic.commodity.bo.ability.QrySalesVolumeReqBO;
import com.tydic.commodity.bo.ability.QrySalesVolumeRspBO;
import com.tydic.commodity.bo.ability.QrySalesVolumeRspDetailBO;
import com.tydic.commodity.bo.ability.UccUpdateSalesVolumeReqBO;
import com.tydic.commodity.bo.ability.UccUpdateSalesVolumeRspBO;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.dao.po.UccBatchSaleNumPo;
import com.tydic.commodity.dao.po.UccSaleNumPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccSalesVolumeAbilityService.class)
public class UccSalesVolumeAbilityServiceImpl
implements UccSalesVolumeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSalesVolumeAbilityServiceImpl.class);
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(UccSalesVolumeAbilityServiceImpl.class);
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSkuStockMapper uccSkuStockMapper;
    @Autowired
    private UccSkuMapper skuMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    public QrySalesVolumeRspBO querySalesVolume(QrySalesVolumeReqBO salesVolumeReqBO) {
        this.validator(salesVolumeReqBO);
        QrySalesVolumeRspBO qrySalesVolumeRspBO = new QrySalesVolumeRspBO();
        ArrayList<QrySalesVolumeRspDetailBO> qrySalesVolumeRspDetailBOS = new ArrayList<QrySalesVolumeRspDetailBO>(salesVolumeReqBO.getQrySalesVolumeBOS().size());
        List<UccSaleNumPo> saleNumPo = null;
        try {
            for (QrySalesVolumeBO qrySalesVolumeBO : salesVolumeReqBO.getQrySalesVolumeBOS()) {
                UccBatchSaleNumPo batchSaleNumPo = new UccBatchSaleNumPo();
                batchSaleNumPo.setSkuIds(qrySalesVolumeBO.getSkuIds());
                try {
                    saleNumPo = this.uccSaleNumMapper.queryBatchSaleNum(batchSaleNumPo);
                }
                catch (Exception e) {
                    LOGGER.error("\u67e5\u8be2\u5355\u54c1\u9500\u91cf\u5931\u8d25\uff0c\u539f\u56e0:" + e);
                    throw new BusinessException("8888", "\u67e5\u8be2\u9500\u91cf\u5931\u8d25");
                }
                if (CollectionUtils.isEmpty(saleNumPo)) continue;
                QrySalesVolumeRspDetailBO qrySalesVolumeRspDetailBO = new QrySalesVolumeRspDetailBO();
                HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
                for (UccSaleNumPo uccSaleNumPo : saleNumPo) {
                    map.put(uccSaleNumPo.getSkuId(), uccSaleNumPo.getSoldNumber());
                }
                qrySalesVolumeRspDetailBO.setSkuSale(map);
                qrySalesVolumeRspDetailBO.setSupplierShopId(qrySalesVolumeBO.getSupplierShopId());
                qrySalesVolumeRspDetailBOS.add(qrySalesVolumeRspDetailBO);
            }
        }
        catch (BusinessException e) {
            qrySalesVolumeRspBO.setRespCode("8888");
            qrySalesVolumeRspBO.setRespDesc("\u5931\u8d25");
            qrySalesVolumeRspBO.setRspDetailBOS((List)Lists.newArrayList());
            return qrySalesVolumeRspBO;
        }
        if (CollectionUtils.isEmpty(qrySalesVolumeRspDetailBOS)) {
            qrySalesVolumeRspBO.setRespCode("0000");
            qrySalesVolumeRspBO.setRespDesc("\u6210\u529f");
            qrySalesVolumeRspBO.setRspDetailBOS((List)Lists.newArrayList());
            return qrySalesVolumeRspBO;
        }
        qrySalesVolumeRspBO.setRspDetailBOS(qrySalesVolumeRspDetailBOS);
        return qrySalesVolumeRspBO;
    }

    private void validator(QrySalesVolumeReqBO salesVolumeReqBO) {
        if (CollectionUtils.isEmpty((Collection)salesVolumeReqBO.getQrySalesVolumeBOS())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5408\u6cd5\u6027");
        }
        try {
            for (QrySalesVolumeBO qrySalesVolumeBO : salesVolumeReqBO.getQrySalesVolumeBOS()) {
                ValidatorUtil.validator((Object)qrySalesVolumeBO);
                if (!CollectionUtils.isEmpty((Collection)qrySalesVolumeBO.getSkuIds())) continue;
                throw new BusinessException("8888", "\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5408\u6cd5\u6027");
            }
        }
        catch (BusinessException e) {
            throw new BusinessException(e.getMsgCode(), e.getMsgCode());
        }
    }

    /*
     * Exception decompiling
     */
    public UccUpdateSalesVolumeRspBO updateSalesVolume(UccUpdateSalesVolumeReqBO reqBO) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

