/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.atom.UccSkuAdjustPriceLogAtomService;
import com.tydic.commodity.atom.UccSkuInfoUpdateAtomService;
import com.tydic.commodity.atom.UccSkuPicLogAtomService;
import com.tydic.commodity.atom.UccSkuPutCirAtomService;
import com.tydic.commodity.atom.UccSkuStockLogAtomService;
import com.tydic.commodity.atom.bo.UccSkuAdjustPriceLogReqBO;
import com.tydic.commodity.atom.bo.UccSkuInfoUpdateReqBO;
import com.tydic.commodity.atom.bo.UccSkuInfoUpdateRspBO;
import com.tydic.commodity.atom.bo.UccSkuPicLogReqBO;
import com.tydic.commodity.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.atom.bo.UccSkuPutCirRspBO;
import com.tydic.commodity.atom.bo.UccSkuStockLogReqBO;
import com.tydic.commodity.bo.busi.SkuBo;
import com.tydic.commodity.bo.busi.SkuImageBo;
import com.tydic.commodity.bo.busi.SkuPriceBo;
import com.tydic.commodity.bo.busi.SkuPutCirBo;
import com.tydic.commodity.bo.busi.SkuStockBo;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.dao.po.UccSkuLogPo;
import com.tydic.commodity.dao.po.UccSkuPicPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuStockPo;
import com.tydic.commodity.enumType.SkuPriceEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="uccSkuInfoUpdateAtomService")
public class UccSkuInfoUpdateAtomServiceImpl
implements UccSkuInfoUpdateAtomService {
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuStockMapper uccSkuStockMapper;
    @Autowired
    private UccSkuLogMapper uccSkuLogMapper;
    @Autowired
    private UccSkuAdjustPriceLogAtomService uccSkuAdjustPriceLogAtomService;
    @Autowired
    private UccSkuStockLogAtomService uccSkuStockLogAtomService;
    @Autowired
    private UccSkuPicLogAtomService uccSkuPicLogAtomService;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccSkuInfoUpdateAtomServiceImpl.class);

    @Override
    public UccSkuInfoUpdateRspBO dealSkuInfoUpdate(UccSkuInfoUpdateReqBO reqBO) {
        List<UccSkuPo> uccSkuPoList;
        UccSkuInfoUpdateRspBO rspBO = new UccSkuInfoUpdateRspBO();
        long nextId = 0L;
        if (null == reqBO.getBatchId()) {
            nextId = this.uccBatchSequence.nextId();
            reqBO.setBatchId(String.valueOf(nextId));
        }
        try {
            this.addSkuLog(reqBO);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        UccSkuPo skuPo = new UccSkuPo();
        SkuBo skuBo = reqBO.getUpdateSkuInfo();
        skuPo.setSupplierShopId(reqBO.getSupplierShopId());
        skuPo.setCommodityId(reqBO.getCommodityId());
        skuPo.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
        try {
            uccSkuPoList = this.uccSkuMapper.qerySku(skuPo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        if (uccSkuPoList.size() != 0) {
            skuPo = new UccSkuPo();
            BeanUtils.copyProperties((Object)skuBo, (Object)skuPo);
            skuPo.setSupplierShopId(reqBO.getSupplierShopId());
            skuPo.setCommodityId(reqBO.getCommodityId());
            skuPo.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
            int i = 0;
            try {
                i = this.uccSkuMapper.modifySku(skuPo);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
            if (i == 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u4fe1\u606f\u5931\u8d25,\u8bf7\u68c0\u67e5\u4fe1\u606f\u8f93\u5165\u662f\u5426\u6b63\u786e");
                return rspBO;
            }
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u4fe1\u606f\u5931\u8d25,\u6b64\u5355\u54c1ID\u4e0d\u5b58\u5728");
            return rspBO;
        }
        if (reqBO.getUpdateSkuInfo().getSkuPriceInfo() != null) {
            try {
                rspBO = this.dealSkuPrice(reqBO);
                if ("8888".equals(rspBO.getRespCode())) {
                    return rspBO;
                }
                rspBO = new UccSkuInfoUpdateRspBO();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
        }
        if (reqBO.getUpdateSkuInfo().getSkuPicInfoList() != null && reqBO.getUpdateSkuInfo().getSkuPicInfoList().size() != 0) {
            try {
                rspBO = this.dealSkuPic(reqBO);
                if ("8888".equals(rspBO.getRespCode())) {
                    return rspBO;
                }
                rspBO = new UccSkuInfoUpdateRspBO();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
        }
        if (reqBO.getUpdateSkuInfo().getSkuStockInfo() != null) {
            try {
                this.dealSkuStock(reqBO);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
        }
        if (reqBO.getUpdateSkuInfo().getSkuPutCirInfo() != null && reqBO.getUpdateSkuInfo().getSkuPutCirInfo().size() != 0) {
            List skuPutCirBoList = reqBO.getUpdateSkuInfo().getSkuPutCirInfo();
            for (SkuPutCirBo skuPutCirBo : skuPutCirBoList) {
                UccSkuPutCirRspBO uccSkuPutCirRspBO;
                UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                BeanUtils.copyProperties((Object)skuPutCirBo, (Object)uccSkuPutCirReqBO);
                uccSkuPutCirReqBO.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPutCirReqBO.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
                uccSkuPutCirReqBO.setBatchId(nextId);
                try {
                    uccSkuPutCirRspBO = this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new ZTBusinessException(e.getMessage());
                }
                if (!"8888".equals(uccSkuPutCirRspBO.getRespCode())) continue;
                BeanUtils.copyProperties((Object)((Object)uccSkuPutCirRspBO), (Object)((Object)rspBO));
                return rspBO;
            }
        }
        rspBO.setBatchId(nextId);
        rspBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u4fe1\u606f\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public UccSkuInfoUpdateRspBO dealSkuPic(UccSkuInfoUpdateReqBO reqBO) {
        UccSkuInfoUpdateRspBO rspBO = new UccSkuInfoUpdateRspBO();
        List imageList = reqBO.getUpdateSkuInfo().getSkuPicInfoList();
        if (imageList != null && imageList.size() != 0) {
            List<UccSkuPicPo> uccSkuPicPoList;
            ArrayList<UccSkuPicPo> modifyImageList = new ArrayList<UccSkuPicPo>();
            ArrayList<UccSkuPicPo> deleteImageList = new ArrayList<UccSkuPicPo>();
            ArrayList<UccSkuPicPo> addImageList = new ArrayList<UccSkuPicPo>();
            ArrayList<Long> addPicIdLogList = new ArrayList<Long>();
            UccSkuPicPo uccSkuPicPo = new UccSkuPicPo();
            uccSkuPicPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPicPo.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
            try {
                uccSkuPicPoList = this.uccSkuPicMapper.qeurySkuPic(uccSkuPicPo);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
            int picNum = 0;
            if (uccSkuPicPoList != null && uccSkuPicPoList.size() != 0) {
                picNum = uccSkuPicPoList.size();
            }
            for (SkuImageBo imageBo : imageList) {
                if (imageBo.getOperType() == null || imageBo.getOperType().equals("")) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u56fe\u7247\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBO;
                }
                if (imageBo.getCommodityPicType() == null && (imageBo.getOperType() == null || imageBo.getOperType().equals(""))) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5546\u54c1\u56fe\u7247\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBO;
                }
                uccSkuPicPo = new UccSkuPicPo();
                uccSkuPicPo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPicPo.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
                if ("0".equals(imageBo.getOperType())) {
                    BeanUtils.copyProperties((Object)imageBo, (Object)uccSkuPicPo);
                    uccSkuPicPo.setSkuPicId(this.uccBatchSequence.nextId());
                    addImageList.add(uccSkuPicPo);
                    ++picNum;
                }
                if (!"1".equals(imageBo.getOperType()) && !"2".equals(imageBo.getOperType())) continue;
                if (imageBo.getSkuPicId() == null) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u4fee\u6539\u6216\u5220\u9664\u56fe\u7247\u65f6\uff0c\u8bf7\u4f20\u5165\u56fe\u7247ID");
                    return rspBO;
                }
                if ("1".equals(imageBo.getOperType())) {
                    BeanUtils.copyProperties((Object)imageBo, (Object)uccSkuPicPo);
                    modifyImageList.add(uccSkuPicPo);
                    addPicIdLogList.add(imageBo.getSkuPicId());
                    continue;
                }
                --picNum;
                BeanUtils.copyProperties((Object)imageBo, (Object)uccSkuPicPo);
                deleteImageList.add(uccSkuPicPo);
                addPicIdLogList.add(imageBo.getSkuPicId());
            }
            if (picNum < 5) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5546\u54c1\u56fe\u7247\u6570\u91cf\u4e0d\u80fd\u5c11\u4e8e5\u5f20");
                return rspBO;
            }
            if (addPicIdLogList.size() != 0) {
                try {
                    this.addSkuPicLog(addPicIdLogList, reqBO);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new ZTBusinessException(e.getMessage());
                }
            }
            if (addImageList.size() != 0) {
                ArrayList<Long> skuPicIdList = new ArrayList<Long>();
                try {
                    this.uccSkuPicMapper.addskuPicList(addImageList);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new ZTBusinessException(e.getMessage());
                }
                skuPicIdList.add(uccSkuPicPo.getSkuPicId());
                rspBO.setSkuPicIdList(skuPicIdList);
            }
            if (modifyImageList.size() != 0) {
                int j = 0;
                try {
                    j = this.uccSkuPicMapper.modifySkuPicList(modifyImageList);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new ZTBusinessException(e.getMessage());
                }
                if (j == 0) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u56fe\u7247\u4fe1\u606f\u5931\u8d25");
                    return rspBO;
                }
            }
            if (deleteImageList.size() != 0) {
                int j = 0;
                try {
                    j = this.uccSkuPicMapper.modifySkuPicList(deleteImageList);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new ZTBusinessException(e.getMessage());
                }
                if (j == 0) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5220\u9664\u5355\u54c1\u56fe\u7247\u4fe1\u606f\u5931\u8d25");
                    return rspBO;
                }
            }
        }
        return rspBO;
    }

    public UccSkuInfoUpdateRspBO dealSkuPrice(UccSkuInfoUpdateReqBO reqBO) {
        UccSkuInfoUpdateRspBO rspBO = new UccSkuInfoUpdateRspBO();
        if (reqBO.getUpdateSkuInfo().getSkuPriceInfo() != null) {
            SkuPriceBo skuPriceBo = reqBO.getUpdateSkuInfo().getSkuPriceInfo();
            Map<String, String> map = null;
            if (skuPriceBo.getCurrencyType() != null) {
                try {
                    map = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuPriceEnum.CURRENCY_TYPE.toString());
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new ZTBusinessException(e.getMessage());
                }
                if (!map.containsKey(String.valueOf(skuPriceBo.getCurrencyType()))) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5e01\u79cd\u8f93\u5165\u9519\u8bef");
                    return rspBO;
                }
            }
            if (skuPriceBo.getSalePrice() != null && skuPriceBo.getSalePrice() < 0L) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u552e\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                return rspBO;
            }
            if (skuPriceBo.getAgreementPrice() != null && skuPriceBo.getAgreementPrice() < 0L) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("AgreementPrice\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                return rspBO;
            }
            if (skuPriceBo.getMarketPrice() != null && skuPriceBo.getMarketPrice() < 0L) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("MarketPrice\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                return rspBO;
            }
            if (skuPriceBo.getMemberPrice1() != null && skuPriceBo.getMemberPrice1() < 0L) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("MemberPrice1\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                return rspBO;
            }
            if (skuPriceBo.getMemberPrice2() != null && skuPriceBo.getMemberPrice2() < 0L) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("MemberPrice2\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                return rspBO;
            }
            if (skuPriceBo.getMemberPrice3() != null && skuPriceBo.getMemberPrice3() < 0L) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("MemberPrice3\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                return rspBO;
            }
            if (skuPriceBo.getMemberPrice4() != null && skuPriceBo.getMemberPrice4() < 0L) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("MemberPrice4\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                return rspBO;
            }
            if (skuPriceBo.getMemberPrice5() != null && skuPriceBo.getMemberPrice5() < 0L) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("MemberPrice5\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                return rspBO;
            }
            try {
                this.addSkuPriceLog(reqBO);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            BeanUtils.copyProperties((Object)skuPriceBo, (Object)uccSkuPricePo);
            uccSkuPricePo.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
            uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
            try {
                this.uccSkuPriceMapper.updateSkuPrice(uccSkuPricePo);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
        }
        return rspBO;
    }

    public UccSkuInfoUpdateRspBO dealSkuStock(UccSkuInfoUpdateReqBO reqBO) {
        UccSkuInfoUpdateRspBO rspBO = new UccSkuInfoUpdateRspBO();
        if (reqBO.getUpdateSkuInfo().getSkuStockInfo() != null) {
            try {
                this.addSkuStockLog(reqBO);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
            SkuStockBo skuStockBo = reqBO.getUpdateSkuInfo().getSkuStockInfo();
            if (skuStockBo.getStockNum() != null && skuStockBo.getStockNum().longValue() < 0L) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5e93\u5b58\u91cf\u5165\u53c2\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                return rspBO;
            }
            UccSkuStockPo uccSkuStockPo = new UccSkuStockPo();
            BeanUtils.copyProperties((Object)skuStockBo, (Object)uccSkuStockPo);
            uccSkuStockPo.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
            uccSkuStockPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuStockPo.setStockId(reqBO.getUpdateSkuInfo().getSkuStockInfo().getStockId());
            try {
                this.uccSkuStockMapper.updateSkuStockBySkuId(uccSkuStockPo);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
        }
        return rspBO;
    }

    public void addSkuLog(UccSkuInfoUpdateReqBO reqBO) {
        ArrayList<UccSkuLogPo> poList = new ArrayList<UccSkuLogPo>();
        UccSkuLogPo po = new UccSkuLogPo();
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
        uccSkuPo.setCommodityId(reqBO.getCommodityId());
        uccSkuPo.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
        List<Object> skuPoList = new ArrayList();
        try {
            skuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        if (skuPoList.size() != 0) {
            for (UccSkuPo uccSkuPo2 : skuPoList) {
                po = new UccSkuLogPo();
                BeanUtils.copyProperties((Object)uccSkuPo2, (Object)po);
                po.setBatchId(Long.parseLong(reqBO.getBatchId()));
                poList.add(po);
            }
        }
        if (poList.size() != 0) {
            try {
                this.uccSkuLogMapper.addSkuLog(poList);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
        }
    }

    public void addSkuPicLog(List<Long> uccSkuPicIdList, UccSkuInfoUpdateReqBO reqBO) {
        UccSkuPicLogReqBO uccSkuPicLogReqBO = new UccSkuPicLogReqBO();
        uccSkuPicLogReqBO.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
        uccSkuPicLogReqBO.setSupplierShopId(reqBO.getSupplierShopId());
        uccSkuPicLogReqBO.setSkuPicIdList(uccSkuPicIdList);
        try {
            this.uccSkuPicLogAtomService.addSkuPicLog(uccSkuPicLogReqBO);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public void addSkuPriceLog(UccSkuInfoUpdateReqBO reqBO) {
        UccSkuAdjustPriceLogReqBO uccSkuAdjustPriceLogReqBO = new UccSkuAdjustPriceLogReqBO();
        uccSkuAdjustPriceLogReqBO.setBatchId(Long.parseLong(reqBO.getBatchId()));
        uccSkuAdjustPriceLogReqBO.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
        uccSkuAdjustPriceLogReqBO.setSupplierShopId(reqBO.getSupplierShopId());
        uccSkuAdjustPriceLogReqBO.setSkuPriceId(reqBO.getUpdateSkuInfo().getSkuPriceInfo().getSkuPriceId());
        try {
            uccSkuAdjustPriceLogReqBO.setId(this.uccBatchSequence.nextId());
            this.uccSkuAdjustPriceLogAtomService.addSkuAdjustPriceLog(uccSkuAdjustPriceLogReqBO);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public void addSkuStockLog(UccSkuInfoUpdateReqBO reqBO) {
        UccSkuStockLogReqBO uccSkuStockLogReqBO = new UccSkuStockLogReqBO();
        uccSkuStockLogReqBO.setBatchId(Long.parseLong(reqBO.getBatchId()));
        uccSkuStockLogReqBO.setSupplierShopId(reqBO.getSupplierShopId());
        uccSkuStockLogReqBO.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
        uccSkuStockLogReqBO.setStockId(reqBO.getUpdateSkuInfo().getSkuStockInfo().getStockId());
        try {
            this.uccSkuStockLogAtomService.addSkuStockLog(uccSkuStockLogReqBO);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
    }
}

