/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.busi.RelPropDefIdBo;
import com.tydic.commodity.bo.busi.UccAddRelPropReqBO;
import com.tydic.commodity.bo.busi.UccAddRelPropRspBO;
import com.tydic.commodity.busi.api.UccAddRelPropertyBusiService;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccRelPropGrpPropMapper;
import com.tydic.commodity.dao.po.UccCommdPropDefPo;
import com.tydic.commodity.dao.po.UccCommodityPropGrpPo;
import com.tydic.commodity.dao.po.UccRelPropGrpPropPo;
import java.util.ArrayList;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccAddRelPropertyBusiService.class)
public class UccAddRelPropertyBusiServiceImpl
implements UccAddRelPropertyBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAddRelPropertyBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccRelPropGrpPropMapper uccRelPropGrpPropMapper;
    private Sequence uccAttributesSequence = Sequence.getInstance();

    public UccAddRelPropRspBO addRelProp(UccAddRelPropReqBO reqBO) {
        UccAddRelPropRspBO rspBO = new UccAddRelPropRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        int count = this.uccRelPropGrpPropMapper.queryMaxShowOrder(reqBO.getCommodityPropGrpId());
        UccRelPropGrpPropPo po = null;
        ArrayList<Long> relId = new ArrayList<Long>();
        for (RelPropDefIdBo each : reqBO.getCommodityPropDefIds()) {
            po = new UccRelPropGrpPropPo();
            BeanUtils.copyProperties((Object)reqBO, (Object)po);
            po.setCommodityPropDefId(each.getCommodityPropDefId());
            po.setShowOrder(++count);
            try {
                po.setRelId(this.uccAttributesSequence.nextId());
                this.uccRelPropGrpPropMapper.addRelPropGrpProp(po);
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u589e\u5c5e\u6027\u7ec4\u5173\u8054\u5931\u8d25\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u65b0\u589e\u5c5e\u6027\u7ec4\u5173\u8054\u5931\u8d25\uff01");
            }
            relId.add(po.getRelId());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5c5e\u6027\u5173\u8054\u6210\u529f");
        rspBO.setRelId(relId);
        return rspBO;
    }

    private String verify(UccAddRelPropReqBO reqBO) {
        String errMsg = "";
        if (reqBO.getCommodityPropDefIds() == null || reqBO.getCommodityPropDefIds().size() == 0) {
            errMsg = "\u5c5e\u6027ID \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getCommodityPropGrpId() == null || reqBO.getCommodityPropGrpId() == 0L) {
            errMsg = "\u5c5e\u6027\u7ec4 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if ("".equals(errMsg)) {
            errMsg = this.dataBaseVerify(reqBO);
        }
        return errMsg;
    }

    private String dataBaseVerify(UccAddRelPropReqBO reqBO) {
        String errMsg = "";
        UccCommodityPropGrpPo uccCommodityPropGrpPo = this.uccCommodityPropGrpMapper.queryGroupByGrpId(reqBO.getCommodityPropGrpId());
        if (uccCommodityPropGrpPo == null) {
            return "\u5c5e\u6027\u7ec4ID\uff1a " + reqBO.getCommodityPropGrpId() + "\u4e0d\u5b58\u5728";
        }
        UccCommdPropDefPo uccCommdPropDefPo = null;
        for (RelPropDefIdBo each : reqBO.getCommodityPropDefIds()) {
            uccCommdPropDefPo = new UccCommdPropDefPo();
            uccCommdPropDefPo.setCommodityPropDefId(each.getCommodityPropDefId());
            if ((uccCommdPropDefPo = this.uccCommodityPropDefMapper.queryBycommodityPropDefId(uccCommdPropDefPo)) != null) continue;
            return "\u5c5e\u6027ID\uff1a " + each + "\u4e0d\u5b58\u5728";
        }
        UccRelPropGrpPropPo uccRelPropGrpPropPo = null;
        for (RelPropDefIdBo each : reqBO.getCommodityPropDefIds()) {
            uccRelPropGrpPropPo = this.uccRelPropGrpPropMapper.queryByDefIdAndGrpId(each.getCommodityPropDefId(), reqBO.getCommodityPropGrpId());
            if (uccRelPropGrpPropPo == null) continue;
            return "\u5c5e\u6027\u7ec4\uff1a" + reqBO.getCommodityPropGrpId() + "\u4e0e\u5c5e\u6027ID" + each + "\u5df2\u7ecf\u5173\u8054\uff1b\u8bf7\u52ff\u91cd\u590d\u5173\u8054";
        }
        return errMsg;
    }
}

