/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.bo.busi.CatCommodityBO;
import com.tydic.commodity.bo.busi.UccCatalogQryCommdReqBO;
import com.tydic.commodity.bo.busi.UccCatalogQryCommdRspBO;
import com.tydic.commodity.bo.busi.UccPriceVo;
import com.tydic.commodity.bo.busi.UccSaleNumVo;
import com.tydic.commodity.busi.api.UccCatalogQryCommdBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccCatalogQryCommdBusiService.class)
public class UccCatalogQryCommdBusiServiceImpl
implements UccCatalogQryCommdBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCatalogQryCommdBusiServiceImpl.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;

    public UccCatalogQryCommdRspBO queryCatalogCommd(UccCatalogQryCommdReqBO reqBO) {
        UccCatalogQryCommdRspBO rspBO = new UccCatalogQryCommdRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getCatalogId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u7c7b\u76eeID");
            return rspBO;
        }
        if (reqBO.getOrgIdIn() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u673a\u6784ID");
            return rspBO;
        }
        List<UccCommodityTypePo> uccCommodityTypePos = this.uccCommodityTypeMapper.selectByCatId(reqBO.getCatalogId());
        if (CollectionUtils.isEmpty(uccCommodityTypePos)) {
            return rspBO;
        }
        Long commodityTypeId = uccCommodityTypePos.get(0).getCommodityTypeId();
        List<Long> supplierShopIds = new ArrayList<Long>();
        if (reqBO.getSupplierShopId() == null) {
            List<SupplierShopPo> supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getOrgIdIn());
            if (CollectionUtils.isEmpty(supplierShopPos)) {
                rspBO.setRespDesc("\u5546\u6237\u4e0b\u65e0\u5e97\u94fa\u4fe1\u606f");
                return rspBO;
            }
            supplierShopIds = supplierShopPos.stream().map(SupplierShopPo::getSupplierShopId).collect(Collectors.toList());
        } else {
            supplierShopIds.add(reqBO.getSupplierShopId());
        }
        List<UccCommodityPo> uccCommodityPos = this.uccCommodityMapper.qrybatchByType(commodityTypeId, supplierShopIds);
        if (CollectionUtils.isEmpty(uccCommodityPos)) {
            return rspBO;
        }
        ArrayList<CatCommodityBO> catCommodityBOS = new ArrayList<CatCommodityBO>();
        for (UccCommodityPo uccCommodityPo : uccCommodityPos) {
            CatCommodityBO catCommodityBO = new CatCommodityBO();
            catCommodityBO.setCommodityName(uccCommodityPo.getCommodityName());
            catCommodityBO.setCommodityTypeId(uccCommodityPo.getCommodityTypeId());
            catCommodityBO.setCreateTime(uccCommodityPo.getCreateTime());
            catCommodityBO.setUpdateTime(uccCommodityPo.getUpdateTime());
            catCommodityBO.setSupplierShopId(uccCommodityPo.getSupplierShopId());
            catCommodityBO.setShopName(uccCommodityPo.getShopName());
            catCommodityBO.setCommodityId(uccCommodityPo.getCommodityId());
            catCommodityBO.setExtSkuId(uccCommodityPo.getExtSkuId());
            catCommodityBOS.add(catCommodityBO);
        }
        List<Long> commodityIds = uccCommodityPos.stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
        List<UccCommodityPicPo> uccCommodityPicPos = this.uccCommodityPicMapper.queryBatchByCommdId(commodityIds, supplierShopIds);
        List<UccPriceVo> uccPriceVos = this.uccSkuPriceMapper.batchQryBySkuIds(commodityIds, supplierShopIds);
        ArrayList<UccPriceVo> priceInfo = new ArrayList<UccPriceVo>();
        if (CollectionUtils.isNotEmpty(uccPriceVos)) {
            Map<Long, List<UccPriceVo>> map = uccPriceVos.stream().collect(Collectors.groupingBy(UccPriceVo::getCommodityId));
            BigDecimal currentPrice = new BigDecimal(0);
            BigDecimal originalPrice = new BigDecimal(0);
            for (Map.Entry<Long, List<UccSaleNumVo>> entry : map.entrySet()) {
                List<UccSaleNumVo> priceVos = entry.getValue();
                if (CollectionUtils.isNotEmpty(priceVos)) {
                    currentPrice = new BigDecimal(((UccPriceVo)priceVos.get(0)).getSalePrice());
                    for (int j = 0; j < priceVos.size(); ++j) {
                        if (currentPrice.compareTo(new BigDecimal(((UccPriceVo)priceVos.get(j)).getSalePrice())) != 1) continue;
                        currentPrice = new BigDecimal(((UccPriceVo)priceVos.get(j)).getSalePrice());
                    }
                    originalPrice = new BigDecimal(((UccPriceVo)priceVos.get(0)).getMarketPrice());
                }
                UccPriceVo uccPriceVo = new UccPriceVo();
                uccPriceVo.setCommodityId(entry.getKey());
                uccPriceVo.setCurrentPrice(MoneyUtils.haoToYuan((BigDecimal)currentPrice).setScale(2, 4));
                uccPriceVo.setOriginalPrice(MoneyUtils.haoToYuan((BigDecimal)originalPrice).setScale(2, 4));
                priceInfo.add(uccPriceVo);
            }
        }
        List<UccSaleNumVo> uccSaleNumVos = this.uccSaleNumMapper.qryVoBySkuIds(commodityIds);
        Map<Long, List<UccSaleNumVo>> groupByCommodityId = uccSaleNumVos.stream().collect(Collectors.groupingBy(UccSaleNumVo::getCommodityId));
        ArrayList<UccSaleNumVo> saleInfo = new ArrayList<UccSaleNumVo>();
        for (Map.Entry<Long, List<UccSaleNumVo>> entry : groupByCommodityId.entrySet()) {
            List<UccSaleNumVo> uccSaleNumVoList = entry.getValue();
            BigDecimal num = new BigDecimal(0);
            for (int i = 0; i < uccSaleNumVoList.size(); ++i) {
                num = num.add(uccSaleNumVoList.get(i).getEcommerceSale());
            }
            UccSaleNumVo uccSaleNumVo = new UccSaleNumVo();
            uccSaleNumVo.setCommodityId(entry.getKey());
            uccSaleNumVo.setTotalSaleNum(num);
            saleInfo.add(uccSaleNumVo);
        }
        List sale = saleInfo.stream().map(UccSaleNumVo::getCommodityId).collect(Collectors.toList());
        for (CatCommodityBO catCommodityBO : catCommodityBOS) {
            String primaryPicUrl = "";
            if (CollectionUtils.isNotEmpty(uccCommodityPicPos)) {
                for (UccCommodityPicPo uccCommodityPicPo1 : uccCommodityPicPos) {
                    if (!catCommodityBO.getCommodityId().equals(uccCommodityPicPo1.getCommodityId())) continue;
                    if (1 == uccCommodityPicPo1.getCommodityPicType()) {
                        primaryPicUrl = uccCommodityPicPo1.getCommodityPicUrl();
                    }
                    if (!"".equals(primaryPicUrl)) continue;
                    primaryPicUrl = uccCommodityPicPos.get(0).getCommodityPicUrl();
                }
            }
            catCommodityBO.setCommodityPicUrl(primaryPicUrl);
            for (UccPriceVo uccPriceVo : priceInfo) {
                if (!catCommodityBO.getCommodityId().equals(uccPriceVo.getCommodityId())) continue;
                catCommodityBO.setCurrentPrice(uccPriceVo.getCurrentPrice());
                catCommodityBO.setOriginalPrice(uccPriceVo.getOriginalPrice());
            }
            for (UccSaleNumVo uccSaleNumVo : saleInfo) {
                if (!catCommodityBO.getCommodityId().equals(uccSaleNumVo.getCommodityId())) continue;
                catCommodityBO.setTotalSoldQuantity(Long.valueOf(uccSaleNumVo.getTotalSaleNum().longValue()));
            }
        }
        rspBO.setResult(catCommodityBOS);
        return rspBO;
    }
}

