/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.UccCatalogRelCommdTypeBusiDeleteReqBO;
import com.tydic.commodity.bo.busi.UccCatalogRelCommdTypeBusiDeleteRspBO;
import com.tydic.commodity.busi.api.UccCatalogConnectCommdTypeDeleteBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.po.UccCatalogConnectCommdTypeDealPO;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.apache.ibatis.session.SqlSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccCatalogConnectCommdTypeDeleteBusiService.class)
public class UccCatalogRelCommdTypeDeleteBusiServiceImpl
implements UccCatalogConnectCommdTypeDeleteBusiService {
    @Autowired
    UccCatRCommdTypeMapper mapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCatalogRelCommdTypeDeleteBusiServiceImpl.class);
    UccCatalogRelCommdTypeBusiDeleteRspBO rspBO = new UccCatalogRelCommdTypeBusiDeleteRspBO();
    UccCatalogConnectCommdTypeDealPO PO = new UccCatalogConnectCommdTypeDealPO();

    public UccCatalogRelCommdTypeBusiDeleteRspBO deleteCatalogConnectCommdType(UccCatalogRelCommdTypeBusiDeleteReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        List<UccCatalogConnectCommdTypeDealPO> uccCatalogConnectCommdTypeDealPOList = this.mapper.batchQryByRelId(reqBO.getRelIds());
        if (CollectionUtils.isEmpty(uccCatalogConnectCommdTypeDealPOList)) {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u5173\u7cfbID");
            return this.rspBO;
        }
        List<Long> commodityTypeIds = uccCatalogConnectCommdTypeDealPOList.stream().map(UccCatalogConnectCommdTypeDealPO::getCommodityTypeId).collect(Collectors.toList());
        ArrayList<UccCatalogConnectCommdTypeDealPO> uccCatalogConnectCommdTypeDealPOS = new ArrayList<UccCatalogConnectCommdTypeDealPO>();
        for (Long relId : reqBO.getRelIds()) {
            UccCatalogConnectCommdTypeDealPO uccCatalogConnectCommdTypeDealPO = new UccCatalogConnectCommdTypeDealPO();
            uccCatalogConnectCommdTypeDealPO.setRelId(relId);
            uccCatalogConnectCommdTypeDealPOS.add(uccCatalogConnectCommdTypeDealPO);
        }
        try {
            this.mapper.batchDeleteCatalogConnectCommdTypeData(uccCatalogConnectCommdTypeDealPOS);
        }
        catch (Exception e) {
            throw new SqlSessionException("\u6570\u636e\u63d2\u5165\u5f02\u5e38");
        }
        try {
            List<UccCommodityTypePo> uccCommodityTypePos = this.uccCommodityTypeMapper.batchQryInType(commodityTypeIds);
            if (CollectionUtils.isEmpty(uccCommodityTypePos)) {
                this.rspBO.setRespCode("8888");
                this.rspBO.setRespDesc("\u5546\u54c1\u7c7b\u578b\u4e0d\u5b58\u5728");
                return this.rspBO;
            }
            List catalogList = uccCommodityTypePos.stream().map(UccCommodityTypePo::getCatalogId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID);
            syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            syncSceneCommodityToEsReqBo.setCategoryIds(catalogList);
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u7c7b\u76ee\u540c\u6b65ES\u5931\u8d25");
        }
        this.rspBO.setRespCode("0000");
        this.rspBO.setRespDesc("\u5220\u9664\u5173\u7cfb\u6210\u529f");
        return this.rspBO;
    }

    public boolean judge(UccCatalogRelCommdTypeBusiDeleteReqBO reqBO) {
        if (reqBO.getRelIds() == null || reqBO.getRelIds().size() == 0) {
            this.rspBO.setRespDesc("\u5173\u8054ID\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)this.PO);
        if (this.mapper.selectDataByRelId(this.PO) == null || this.mapper.selectDataByRelId(this.PO).size() == 0) {
            this.rspBO.setRespDesc("\u5173\u8054ID\u4e0d\u5b58\u5728");
            return false;
        }
        return true;
    }
}

