/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccCommdMeasureInfoReqBo;
import com.tydic.commodity.bo.busi.UccCommdMeasureInfoRspBo;
import com.tydic.commodity.bo.busi.UccCommdMeasureReqBo;
import com.tydic.commodity.bo.busi.UccCommdMeasureRspBo;
import com.tydic.commodity.busi.api.UccCommdMeasureInfoBusiService;
import com.tydic.commodity.busi.api.UccCommodityMeasureBo;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.po.UccCommodityMeasurePo;
import com.tydic.commodity.enumType.CommodityMeasureEnum;
import com.tydic.commodity.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccCommdMeasureInfoBusiService.class)
public class UccCommdMeasureInfoBusiServiceImpl
implements UccCommdMeasureInfoBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommdMeasureInfoBusiServiceImpl.class);
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    public UccCommdMeasureInfoRspBo queryInfo(UccCommdMeasureInfoReqBo uccCommdMeasureInfoReqBo) {
        UccCommdMeasureInfoRspBo rspBo = new UccCommdMeasureInfoRspBo();
        UccCommodityMeasurePo po = new UccCommodityMeasurePo();
        BeanUtils.copyProperties((Object)uccCommdMeasureInfoReqBo, (Object)po);
        if (!StringUtils.isEmpty((Object)uccCommdMeasureInfoReqBo.getCreateTime())) {
            po.setCreateTime(DateUtils.strToDate((String)uccCommdMeasureInfoReqBo.getCreateTime()));
        }
        if (!StringUtils.isEmpty((Object)uccCommdMeasureInfoReqBo.getUpdateTime())) {
            po.setUpdateTime(DateUtils.strToDate((String)uccCommdMeasureInfoReqBo.getUpdateTime()));
        }
        Page page = new Page(uccCommdMeasureInfoReqBo.getPageNo(), uccCommdMeasureInfoReqBo.getPageSize());
        List<UccCommodityMeasurePo> listPo = this.uccCommodityMeasureMapper.queryToPage((Page<UccCommodityMeasurePo>)page, po);
        ArrayList<UccCommodityMeasureBo> uccCommodityMeasureBos = new ArrayList<UccCommodityMeasureBo>();
        if (!CollectionUtils.isEmpty(listPo)) {
            for (UccCommodityMeasurePo uccCommodityMeasurePo : listPo) {
                UccCommodityMeasureBo uccCommodityMeasureBO = new UccCommodityMeasureBo();
                BeanUtils.copyProperties((Object)uccCommodityMeasurePo, (Object)uccCommodityMeasureBO);
                if (uccCommodityMeasurePo.getCreateTime() != null) {
                    uccCommodityMeasureBO.setCreateTime(DateUtils.dateToStr((Date)uccCommodityMeasurePo.getCreateTime()));
                }
                if (uccCommodityMeasurePo.getUpdateTime() != null) {
                    uccCommodityMeasureBO.setUpdateTime(DateUtils.dateToStr((Date)uccCommodityMeasurePo.getUpdateTime()));
                }
                uccCommodityMeasureBos.add(uccCommodityMeasureBO);
            }
        }
        rspBo.setRows(uccCommodityMeasureBos);
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspBo;
    }

    public UccCommdMeasureRspBo addMeasure(UccCommdMeasureReqBo reqBo) {
        UccCommdMeasureRspBo rspBo = new UccCommdMeasureRspBo();
        String errMsg = this.verify(reqBo);
        if (!StringUtils.isEmpty((Object)errMsg)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(errMsg);
            return rspBo;
        }
        UccCommodityMeasurePo po = new UccCommodityMeasurePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)po);
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTime())) {
            po.setCreateTime(DateUtils.strToDate((String)reqBo.getCreateTime()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUpdateTime())) {
            po.setUpdateTime(DateUtils.strToDate((String)reqBo.getUpdateTime()));
        }
        po.setIsDelete(ModelRuleConstant.MEASURE_IS_DELETE_FALSE);
        try {
            this.uccCommodityMeasureMapper.addMeasure(po);
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u8ba1\u91cf\u5355\u4f4d\u5931\u8d25\uff1a" + e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u65b0\u589e\u8ba1\u91cf\u5355\u4f4d\u5931\u8d25\uff1a" + e.getMessage());
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u65b0\u589e\u6210\u529f");
        return rspBo;
    }

    public UccCommdMeasureRspBo modifyMeasure(UccCommdMeasureReqBo reqBo) {
        UccCommdMeasureRspBo rspBo = new UccCommdMeasureRspBo();
        if (reqBo.getMeasureId() == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u8ba1\u91cf\u5355\u4f4dID");
            return rspBo;
        }
        String errMsg = this.verify(reqBo);
        if (!StringUtils.isEmpty((Object)errMsg)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(errMsg);
            return rspBo;
        }
        UccCommodityMeasurePo measurePo = this.uccCommodityMeasureMapper.queryMeasureById(reqBo.getMeasureId());
        if (measurePo == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5b58\u5728!");
        }
        UccCommodityMeasurePo po = new UccCommodityMeasurePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)po);
        try {
            this.uccCommodityMeasureMapper.updateInfo(po);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u8ba1\u91cf\u5355\u4f4d\u5931\u8d25\uff1a" + e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u66f4\u65b0\u8ba1\u91cf\u5355\u4f4d\u5931\u8d25\uff1a" + e.getMessage());
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u66f4\u65b0\u6210\u529f");
        return rspBo;
    }

    public UccCommdMeasureRspBo deleteMeasure(UccCommdMeasureReqBo reqBo) {
        UccCommdMeasureRspBo rspBo = new UccCommdMeasureRspBo();
        if (reqBo.getMeasureId() == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u8ba1\u91cf\u5355\u4f4dID");
            return rspBo;
        }
        UccCommodityMeasurePo measurePo = this.uccCommodityMeasureMapper.queryMeasureById(reqBo.getMeasureId());
        if (measurePo == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5b58\u5728!");
            return rspBo;
        }
        UccCommodityMeasurePo po = new UccCommodityMeasurePo();
        if (measurePo != null) {
            po.setMeasureId(measurePo.getMeasureId());
        }
        po.setIsDelete(ModelRuleConstant.MEASURE_IS_DELETE_TRUE);
        try {
            this.uccCommodityMeasureMapper.updateInfo(po);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5355\u4f4d\u5931\u8d25\uff1a" + e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5220\u9664\u8ba1\u91cf\u5355\u4f4d\u5931\u8d25\uff1a" + e.getMessage());
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u5220\u9664\u6210\u529f");
        return rspBo;
    }

    private String verify(UccCommdMeasureReqBo reqBo) {
        Map<String, String> dictionary;
        if (reqBo.getMeasureType() != null && !(dictionary = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityMeasureEnum.MEASURE_TYPE.toString())).containsKey(reqBo.getMeasureType().toString())) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 \u8ba1\u91cf\u5355\u4f4d\u7c7b\u578b";
        }
        if (reqBo.getIsDelete() != null && !(dictionary = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityMeasureEnum.MEASURE_IS_DELETE.toString())).containsKey(reqBo.getIsDelete().toString())) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 \u8ba1\u91cf\u5355\u4f4d\u72b6\u6001";
        }
        return "";
    }
}

