/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.busi.UccLabelAddReqBO;
import com.tydic.commodity.bo.busi.UccLabelAddRspBO;
import com.tydic.commodity.busi.api.UccLabelAddBusiService;
import com.tydic.commodity.dao.UccLabelDealMapper;
import com.tydic.commodity.dao.po.UccLabelPO;
import com.tydic.commodity.exception.BusinessException;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccLabelAddBusiService.class)
public class UccLabelAddBusiServiceImpl
implements UccLabelAddBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccLabelAddBusiServiceImpl.class);
    private Sequence uccBrandSequence = Sequence.getInstance();
    @Autowired
    private UccLabelDealMapper mapper;
    UccLabelAddRspBO rspBO = new UccLabelAddRspBO();

    public UccLabelAddRspBO addLabel(UccLabelAddReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        UccLabelPO po = new UccLabelPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        int result = 0;
        try {
            po.setLabelId(this.uccBrandSequence.nextId());
            result = this.mapper.addLabel(po);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6570\u636e\u6dfb\u52a0\u5f02\u5e38");
        }
        if (result > 0) {
            this.rspBO.setRespDesc("\u6dfb\u52a0\u6807\u7b7e\u6210\u529f");
            this.rspBO.setLabelId(po.getLabelId());
            this.rspBO.setRespCode("0000");
        } else {
            this.rspBO.setRespDesc("\u6dfb\u52a0\u6807\u7b7e\u5931\u8d25");
            this.rspBO.setRespCode("8888");
        }
        return this.rspBO;
    }

    public boolean judge(UccLabelAddReqBO reqBO) {
        if (reqBO.getCommodityId() == null) {
            this.rspBO.setRespDesc("\u63d2\u5165\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getSupplierShopId() == null) {
            this.rspBO.setRespDesc("\u63d2\u5165\u5546\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getLabelCode() == null || reqBO.getLabelCode().equals("")) {
            this.rspBO.setRespDesc("\u63d2\u5165\u6807\u7b7e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        return true;
    }
}

