/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccModifyPropGrpReqBO;
import com.tydic.commodity.bo.busi.UccModifyPropGrpRspBO;
import com.tydic.commodity.busi.api.UccModifyPropGroupBusiService;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.po.UccCommodityPropGrpPo;
import com.tydic.commodity.enumType.CommodityPropGrpEnum;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccModifyPropGroupBusiService.class)
public class UccModifyPropGroupBusiServiceImpl
implements UccModifyPropGroupBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccModifyPropGroupBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    public UccModifyPropGrpRspBO modifyGroup(UccModifyPropGrpReqBO reqBO) {
        UccModifyPropGrpRspBO rspBO = new UccModifyPropGrpRspBO();
        if (reqBO.getCommodityPropGrpId() == null || reqBO.getCommodityPropGrpId() == 0L) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4ID \u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        UccCommodityPropGrpPo po = this.uccCommodityPropGrpMapper.queryGroupByGrpId(reqBO.getCommodityPropGrpId());
        if (po == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5c5e\u6027\u7ec4ID");
            return rspBO;
        }
        if (!this.isChange(po, reqBO)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6570\u636e\u65e0\u66f4\u6539\uff0c\u65e0\u9700\u66f4\u65b0");
            return rspBO;
        }
        String errMsg = this.enumVerify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        po = new UccCommodityPropGrpPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        try {
            this.uccCommodityPropGrpMapper.modifyGroup(po);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u5c5e\u6027\u7ec4\u5931\u8d25" + e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u66f4\u65b0\u5c5e\u6027\u7ec4\u5931\u8d25" + e.getMessage());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u66f4\u65b0\u6210\u529f");
        return rspBO;
    }

    private boolean isChange(UccCommodityPropGrpPo po, UccModifyPropGrpReqBO reqBO) {
        if (!StringUtils.isEmpty((CharSequence)reqBO.getCommodityPropGrpCode()) && !reqBO.getCommodityPropGrpCode().equals(po.getCommodityPropGrpCode())) {
            return true;
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getCommodityPropGrpName()) && !reqBO.getCommodityPropGrpName().equals(po.getCommodityPropGrpName())) {
            return true;
        }
        if (reqBO.getPropGrpStatus() != null && reqBO.getPropGrpStatus().compareTo(po.getPropGrpStatus()) != 0) {
            return true;
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getRemark()) && !reqBO.getRemark().equals(po.getRemark())) {
            return true;
        }
        return !StringUtils.isEmpty((CharSequence)reqBO.getUpdateOperId()) && !reqBO.getUpdateOperId().equals(po.getUpdateOperId());
    }

    private String enumVerify(UccModifyPropGrpReqBO reqBO) {
        String errMsg = "";
        Map<String, String> map = null;
        if (reqBO.getPropGrpStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropGrpEnum.COMMODITY_PROP_GRP_STATUS.toString())).containsKey(reqBO.getPropGrpStatus().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 propTag\u503c";
        }
        return errMsg;
    }
}

