/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.bo.busi.UccModifyRelShowOrderReqBO;
import com.tydic.commodity.bo.busi.UccModifyRelShowOrderRspBO;
import com.tydic.commodity.busi.api.UccModifyRelShowOrderBusiService;
import com.tydic.commodity.dao.UccRelPropGrpPropMapper;
import com.tydic.commodity.dao.po.UccRelPropGrpPropPo;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccModifyRelShowOrderBusiService.class)
public class UccModifyRelShowOrderBusiServiceImpl
implements UccModifyRelShowOrderBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccModifyRelShowOrderBusiServiceImpl.class);
    @Autowired
    private UccRelPropGrpPropMapper uccRelPropGrpPropMapper;

    public UccModifyRelShowOrderRspBO modifyRelOrder(UccModifyRelShowOrderReqBO reqBo) {
        UccModifyRelShowOrderRspBO rspBO = new UccModifyRelShowOrderRspBO();
        String errMsg = this.verify(reqBo);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        UccRelPropGrpPropPo po = new UccRelPropGrpPropPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)po);
        try {
            this.uccRelPropGrpPropMapper.modifyRelProp(po);
        }
        catch (Exception e) {
            LOGGER.error("\u5c5e\u6027\u7ec4\u4fee\u6539\u663e\u793a\u987a\u5e8f\u5931\u8d25:" + e.getMessage());
            throw new ZTBusinessException("\u5c5e\u6027\u7ec4\u4fee\u6539\u663e\u793a\u987a\u5e8f\u5931\u8d25:" + e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fee\u6539\u6210\u529f");
        return rspBO;
    }

    private String verify(UccModifyRelShowOrderReqBO reqBO) {
        String errMsg = "";
        if (reqBO.getRelId() == null || reqBO.getRelId() == 0L) {
            return "\u5173\u8054\u5173\u7cfbID \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getShowOrder() == null) {
            return "\u987a\u5e8f \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getShowOrder().compareTo(0) < 0) {
            return "\u8f93\u5165\u6b63\u786e\u7684\u663e\u793a\u987a\u5e8f";
        }
        if ("".equals(errMsg)) {
            errMsg = this.dataBaseVerify(reqBO);
        }
        return errMsg;
    }

    private String dataBaseVerify(UccModifyRelShowOrderReqBO reqBO) {
        UccRelPropGrpPropPo po = this.uccRelPropGrpPropMapper.queryByRelId(reqBO.getRelId());
        if (po == null) {
            return "relId: " + reqBO.getRelId() + "\u4e0d\u5b58\u5728";
        }
        return "";
    }
}

