/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccChannelputBo;
import com.tydic.commodity.bo.busi.UccQrySendChannelReqBo;
import com.tydic.commodity.bo.busi.UccQrySendChannelRspBo;
import com.tydic.commodity.busi.api.UccQrySendChannelBusiService;
import com.tydic.commodity.dao.UccChannelPutMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccChannelPutPo;
import com.tydic.commodity.enumType.ChannelPutEnum;
import com.tydic.commodity.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccQrySendChannelBusiService.class)
public class UccQrySendChannelBusiServiceImpl
implements UccQrySendChannelBusiService {
    @Autowired
    private UccChannelPutMapper uccChannelPutMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    public UccQrySendChannelRspBo qryChannel(UccQrySendChannelReqBo reqBo) {
        UccQrySendChannelRspBo rspBo = new UccQrySendChannelRspBo();
        String errMsg = this.verify(reqBo);
        if (!"".equals(errMsg)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(errMsg);
            return rspBo;
        }
        UccChannelPutPo po = new UccChannelPutPo();
        po.setSupplierShopId(reqBo.getSupplierShopId());
        if (reqBo.getSkuId() != null) {
            po.setPutObjId(reqBo.getSkuId());
            po.setPutObjType(2);
        } else {
            po.setPutObjId(reqBo.getCommodityId());
            po.setPutObjType(1);
        }
        List<UccChannelPutPo> listPo = this.uccChannelPutMapper.qryChannels(po);
        if (listPo == null || listPo.size() == 0) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u65e0\u5546\u54c1\u53d1\u5e03\u9891\u9053\u4fe1\u606f");
            return rspBo;
        }
        UccChannelputBo bo = null;
        DicDictionaryPo dicDictionaryPo = null;
        ArrayList<UccChannelputBo> channels = new ArrayList<UccChannelputBo>();
        for (UccChannelPutPo each : listPo) {
            bo = new UccChannelputBo();
            BeanUtils.copyProperties((Object)each, (Object)bo);
            if (each.getCreateTime() != null) {
                bo.setCreateTime(DateUtils.dateToStr((Date)each.getCreateTime()));
            }
            if (each.getUpdateTime() != null) {
                bo.setUpdateTime(DateUtils.dateToStr((Date)each.getUpdateTime()));
            }
            if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getPutObjType().toString(), ChannelPutEnum.PUT_OBJ_TYPE.toString())) != null) {
                bo.setPutObjTypeDesc(dicDictionaryPo.getTitle());
            }
            channels.add(bo);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        rspBo.setChannels(channels);
        return rspBo;
    }

    private String verify(UccQrySendChannelReqBo reqBo) {
        if (reqBo.getSupplierShopId() == null) {
            return "\u5e97\u94faID \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getCommodityId() == null && reqBo.getSkuId() == null) {
            return "\u8bf7\u4f20\u5165\u67e5\u8be2\u5bf9\u8c61\u4fe1\u606f";
        }
        return "";
    }
}

