/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.google.common.collect.Maps;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.AllSupplierShopBO;
import com.tydic.commodity.bo.busi.SupplierShopBO;
import com.tydic.commodity.bo.busi.UccAllSupplierShopReqBO;
import com.tydic.commodity.bo.busi.UccAllSupplierShopRspBO;
import com.tydic.commodity.bo.busi.UccSupplierShopReqBO;
import com.tydic.commodity.bo.busi.UccSupplierShopRspBO;
import com.tydic.commodity.busi.api.UccQuerySupplierShopService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.enumType.SupplierShopEnum;
import com.tydic.commodity.util.ListCloneUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccQuerySupplierShopService.class)
public class UccQuerySupplierShopServiceImpl
implements UccQuerySupplierShopService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQuerySupplierShopServiceImpl.class);
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    public UccSupplierShopRspBO querySupplierShopPage(UccSupplierShopReqBO supplierShopReqBO) {
        UccSupplierShopRspBO uccSupplierShopRspBO = new UccSupplierShopRspBO();
        SupplierShopPo supplierShopPo = new SupplierShopPo();
        supplierShopPo.setShopName(supplierShopReqBO.getShopName());
        supplierShopPo.setSupplierName(supplierShopReqBO.getSupplierName());
        supplierShopPo.setShopStatus(supplierShopReqBO.getShopStatus());
        HashMap sort = Maps.newHashMap();
        sort.put("CREATE_TIME", true);
        supplierShopPo.setSort(sort);
        Page page = new Page(supplierShopReqBO.getPageNo(), supplierShopReqBO.getPageSize());
        List<SupplierShopPo> supplierShopPos = this.supplierShopMapper.querySupplierShopDetails(supplierShopPo, (Page<SupplierShopPo>)page);
        List supplierShopBOS = new ArrayList();
        try {
            supplierShopBOS = ListCloneUtils.clonePOListToBOList(supplierShopPos, SupplierShopBO.class);
        }
        catch (Exception e) {
            LOGGER.error("\u5e97\u94fa\u67e5\u8be2-->\u6570\u636e\u8f6c\u6362\u9519\u8bef{}", (Throwable)e);
            uccSupplierShopRspBO.setRespCode("8888");
            uccSupplierShopRspBO.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u4e1a\u52a1\u5f02\u5e38");
            return uccSupplierShopRspBO;
        }
        for (SupplierShopBO supplierShopBO : supplierShopBOS) {
            DicDictionaryPo dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(supplierShopBO.getShopStatus().toString(), SupplierShopEnum.SUPPLIER_SHOP_STATUS.toString());
            if (dicDictionaryPo == null) continue;
            supplierShopBO.setShopStatusTranslation(dicDictionaryPo.getTitle());
        }
        uccSupplierShopRspBO.setRespCode("0000");
        uccSupplierShopRspBO.setRespDesc("\u6210\u529f");
        uccSupplierShopRspBO.setPageNo(page.getPageNo());
        uccSupplierShopRspBO.setRows(supplierShopBOS);
        uccSupplierShopRspBO.setRecordsTotal(page.getTotalCount());
        uccSupplierShopRspBO.setTotal(page.getTotalPages());
        return uccSupplierShopRspBO;
    }

    public UccAllSupplierShopRspBO queryAllSupplierShopPage(UccAllSupplierShopReqBO supplierShopReqBO) {
        UccAllSupplierShopRspBO uccAllSupplierShopRspBO = new UccAllSupplierShopRspBO();
        List<SupplierShopPo> supplierShopPos = this.supplierShopMapper.queryAllSupplierShopDetails(supplierShopReqBO);
        List supplierShopBOS = new ArrayList();
        try {
            supplierShopBOS = ListCloneUtils.clonePOListToBOList(supplierShopPos, AllSupplierShopBO.class);
        }
        catch (Exception e) {
            LOGGER.error("\u5e97\u94fa\u67e5\u8be2-->\u6570\u636e\u8f6c\u6362\u9519\u8bef{}", (Throwable)e);
            uccAllSupplierShopRspBO.setRespCode("8888");
            uccAllSupplierShopRspBO.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u4e1a\u52a1\u5f02\u5e38");
            return uccAllSupplierShopRspBO;
        }
        uccAllSupplierShopRspBO.setRespCode("0000");
        uccAllSupplierShopRspBO.setRespDesc("\u6210\u529f");
        uccAllSupplierShopRspBO.setAllSupplierShopBOList(supplierShopBOS);
        return uccAllSupplierShopRspBO;
    }
}

