/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.busi.UccShopRelBrandReqBO;
import com.tydic.commodity.bo.busi.UccShopRelBrandRspBO;
import com.tydic.commodity.busi.api.UccShopRelBrandBusiService;
import com.tydic.commodity.dao.UccShopRelBrandMapper;
import com.tydic.commodity.dao.po.UccShopRelBrandPO;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccShopRelBrandBusiService.class)
public class UccShopRelBrandBusiServiceImpl
implements UccShopRelBrandBusiService {
    @Autowired
    private UccShopRelBrandMapper uccShopRelBrandMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccShopRelBrandBusiServiceImpl.class);
    private Sequence uccBrandSequence = Sequence.getInstance();

    public UccShopRelBrandRspBO shopRelBrand(UccShopRelBrandReqBO reqBO) {
        UccShopRelBrandRspBO rspBO = new UccShopRelBrandRspBO();
        String s = this.judge(reqBO);
        if (!"".equals(s)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(s);
            return rspBO;
        }
        try {
            UccShopRelBrandPO uccShopRelBrandPO = new UccShopRelBrandPO();
            uccShopRelBrandPO.setBrandId(reqBO.getBrandId());
            uccShopRelBrandPO.setSupplierShopId(reqBO.getSupplierShopId());
            Page page = new Page();
            List<UccShopRelBrandPO> uccShopRelBrandPOList = this.uccShopRelBrandMapper.queryShopRelBrand(uccShopRelBrandPO, (Page<UccShopRelBrandPO>)page);
            if (uccShopRelBrandPOList != null && uccShopRelBrandPOList.size() != 0) {
                rspBO.setRespDesc("\u5e97\u94fa\u548c\u54c1\u724c\u5df2\u7ecf\u5173\u8054\uff01\u8bf7\u52ff\u91cd\u590d");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            BeanUtils.copyProperties((Object)reqBO, (Object)uccShopRelBrandPO);
            uccShopRelBrandPO.setRelId(this.uccBrandSequence.nextId());
            int i = this.uccShopRelBrandMapper.shopRelBrand(uccShopRelBrandPO);
            if (i == 0) {
                rspBO.setRespDesc("\u6dfb\u52a0\u5931\u8d25");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            rspBO.setRelId(uccShopRelBrandPO.getRelId());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException("\u6dfb\u52a0\u6570\u636e\u5f02\u5e38");
        }
        return rspBO;
    }

    public String judge(UccShopRelBrandReqBO reqBO) {
        String s = "";
        if (reqBO.getSupplierShopId() == null) {
            s = "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a";
            return s;
        }
        if (reqBO.getBrandId() == null) {
            s = "\u54c1\u724cID\u4e0d\u80fd\u4e3a\u7a7a";
            return s;
        }
        return s;
    }
}

