/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.bo.busi.QuerySkuImageBO;
import com.tydic.commodity.bo.busi.SkuPicEntityBO;
import com.tydic.commodity.bo.busi.UccQuerySkuImageReqBO;
import com.tydic.commodity.bo.busi.UccQuerySkuImageRspBO;
import com.tydic.commodity.busi.api.UccShufflingPicQryMockService;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_PROD", interfaceClass=UccShufflingPicQryMockService.class)
public class UccShufflingPicQryMockServiceImpl
implements UccShufflingPicQryMockService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccShufflingPicQryMockServiceImpl.class);
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccSkuMapper skuMapper;

    public UccQuerySkuImageRspBO skuImage(UccQuerySkuImageReqBO reqBO) {
        List<String> skuId;
        UccQuerySkuImageRspBO uccQuerySkuImageRspBO = new UccQuerySkuImageRspBO();
        String[] sku = reqBO.getSku();
        try {
            skuId = Arrays.asList(sku);
        }
        catch (BusinessException e) {
            LOGGER.error(e.getMsgInfo() + ":" + (Object)((Object)e));
            uccQuerySkuImageRspBO.setRespCode(e.getMsgCode());
            uccQuerySkuImageRspBO.setRespDesc(e.getMsgInfo());
            return uccQuerySkuImageRspBO;
        }
        ArrayList<QuerySkuImageBO> querySkuImageBOS = new ArrayList<QuerySkuImageBO>();
        ArrayList skuIds = Lists.newArrayList();
        try {
            List<UccSkuPo> skuPos = this.skuMapper.qerySkusByExtSkuIds(skuId);
            for (UccSkuPo skuPo : skuPos) {
                skuIds.add(skuPo.getSkuId());
                QuerySkuImageBO querySkuImageBO = new QuerySkuImageBO();
                ArrayList<SkuPicEntityBO> skuPicEntityBOS = new ArrayList<SkuPicEntityBO>();
                querySkuImageBO.setSku(skuPo.getExtSkuId());
                querySkuImageBO.setSkuPic(skuPicEntityBOS);
                UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
                uccCommodityPicPo.setCommodityId(skuPo.getCommodityId());
                uccCommodityPicPo.setSupplierShopId(skuPo.getSupplierShopId());
                List<UccCommodityPicPo> uccCommodityPicPos = this.uccCommodityPicMapper.queryCommdPic(uccCommodityPicPo);
                int i = 0;
                for (UccCommodityPicPo uccCommodityPicPo1 : uccCommodityPicPos) {
                    SkuPicEntityBO skuPicEntityBO = new SkuPicEntityBO();
                    if ("1".equals(uccCommodityPicPo1.getCommodityPicType())) {
                        skuPicEntityBO.setIsPrimary(Integer.valueOf(1));
                    } else {
                        skuPicEntityBO.setIsPrimary(Integer.valueOf(0));
                    }
                    skuPicEntityBO.setOrderSort(Integer.valueOf(i++));
                    skuPicEntityBO.setPath(uccCommodityPicPo1.getCommodityPicUrl());
                    skuPicEntityBOS.add(skuPicEntityBO);
                }
                querySkuImageBOS.add(querySkuImageBO);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5355\u54c1\u56fe\u7247mock,\u6570\u636e\u8f6c\u6362\u5f02\u5e38,\u5165\u53c2sku\uff1a" + reqBO.getSku());
            uccQuerySkuImageRspBO.setRespCode("8888");
            uccQuerySkuImageRspBO.setRespDesc("\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
            return uccQuerySkuImageRspBO;
        }
        uccQuerySkuImageRspBO.setResult(querySkuImageBOS);
        uccQuerySkuImageRspBO.setRespDesc("\u6210\u529f");
        uccQuerySkuImageRspBO.setRespCode("0000");
        return uccQuerySkuImageRspBO;
    }
}

