/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.ability.api.ActivityCenterSearchEsService;
import com.tydic.commodity.atom.UccSupplierCacheAtomService;
import com.tydic.commodity.atom.bo.UccSupplierCacheReqBo;
import com.tydic.commodity.atom.bo.UccSupplierCacheRspBo;
import com.tydic.commodity.bo.ability.ActivityCenterSearchEsReqBO;
import com.tydic.commodity.bo.ability.ActivityCenterSearchEsRspBO;
import com.tydic.commodity.bo.ability.SearchBarEsRspInfo;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.search.SearchCommodityService;
import com.tydic.commodity.search.bo.CommodityRspBo;
import com.tydic.commodity.search.bo.SearchEsReqBO;
import com.tydic.commodity.search.bo.SearchEsRspBo;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=ActivityCenterSearchEsService.class)
public class ActivityCenterSearchEsServiceImpl
implements ActivityCenterSearchEsService {
    private static final Logger log = LoggerFactory.getLogger(ActivityCenterSearchEsServiceImpl.class);
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(ActivityCenterSearchEsServiceImpl.class);
    @Autowired
    private SearchCommodityService searchCommodityService;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccSupplierCacheAtomService uccSupplierCacheAtomService;
    private static Integer esSeaarchSize = 10000;

    public ActivityCenterSearchEsRspBO qryBySearchBar(ActivityCenterSearchEsReqBO reqBo) {
        SearchEsRspBo searchEsRspBo;
        ActivityCenterSearchEsRspBO rspBO = new ActivityCenterSearchEsRspBO();
        if (reqBo.getSkuList() != null && reqBo.getIgnoreList() != null && reqBo.getSkuList().size() > 0 && reqBo.getIgnoreList().size() > 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4e0d\u80fd\u540c\u65f6\u8fc7\u6ee4\u67e5\u8be2");
            return rspBO;
        }
        SearchEsReqBO searchEsReqBO = new SearchEsReqBO();
        if (reqBo.getSupplierId() != null) {
            searchEsReqBO.setMerchantId(reqBo.getSupplierId());
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)searchEsReqBO);
        if (reqBo.getSceneId() == null && reqBo.getSupplierId() != null) {
            UccSupplierCacheReqBo uccSupplierCacheReqBo = new UccSupplierCacheReqBo();
            uccSupplierCacheReqBo.setSupplierId(reqBo.getSupplierId());
            UccSupplierCacheRspBo uccSupplierCacheRspBo = this.uccSupplierCacheAtomService.qryInfomation(uccSupplierCacheReqBo);
            if (uccSupplierCacheRspBo == null || !"0000".equals(uccSupplierCacheRspBo.getRespCode())) {
                LOGGER.error("\u6d3b\u52a8\u6570\u636e\u67e5\u8be2\uff1a\u5546\u6237\u5f02\u5e38!!");
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5546\u6237\u5f02\u5e38!");
                rspBO.setPageNo(1);
                rspBO.setTotal(0);
                rspBO.setRecordsTotal(0);
                return rspBO;
            }
            if (uccSupplierCacheRspBo.getSceneId() != null) {
                searchEsReqBO.setSceneId(uccSupplierCacheRspBo.getSceneId());
            }
            if (reqBo.getRootOrgIdIn() != null) {
                searchEsReqBO.setSupplierId(reqBo.getRootOrgIdIn());
            } else {
                searchEsReqBO.setSupplierId(Long.valueOf(10025L));
            }
        }
        if ((searchEsRspBo = this.searchCommodityService.queryByMatch(searchEsReqBO)) == null) {
            LOGGER.error("\u67e5\u8be2ES\u6570\u636e\u670d\u52a1\u5f02\u5e38!!");
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e!");
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            return rspBO;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)rspBO);
        List commodityRspBos = searchEsRspBo.getCommodityRspBos();
        List<SearchBarEsRspInfo> result = this.convertRspBo(commodityRspBos);
        rspBO.setResult(result);
        int size = reqBo.getPageSize();
        int no = reqBo.getPageNo();
        int totalPage = 0;
        int add = 0;
        Integer total = 0;
        if (esSeaarchSize.compareTo(searchEsRspBo.getTotal()) > 0) {
            totalPage = searchEsRspBo.getTotal() / size;
            add = searchEsRspBo.getTotal() % size == 0 ? 0 : 1;
            total = searchEsRspBo.getTotal();
        } else {
            totalPage = esSeaarchSize / size;
            total = size * (totalPage + (add = esSeaarchSize % size == 0 ? 0 : 1));
            if (total.compareTo(searchEsRspBo.getTotal()) > 0) {
                total = searchEsRspBo.getTotal();
            }
        }
        rspBO.setTotal(totalPage + add);
        rspBO.setPageNo(no);
        if (searchEsRspBo.getQueryParams() != null && searchEsRspBo.getPropParams() != null) {
            searchEsRspBo.getQueryParams().addAll(searchEsRspBo.getPropParams());
        }
        rspBO.setRecordsTotal(total.intValue());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u6d3b\u52a8\u67e5\u8be2\u670d\u52a1\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)rspBO));
        }
        return rspBO;
    }

    private List<SearchBarEsRspInfo> convertRspBo(List<CommodityRspBo> commodityRspBos) {
        ArrayList<SearchBarEsRspInfo> searchBarEsRspInfos = new ArrayList<SearchBarEsRspInfo>();
        if (commodityRspBos != null && commodityRspBos.size() > 0) {
            for (CommodityRspBo commodityRspBo : commodityRspBos) {
                SearchBarEsRspInfo searchBarEsRspInfo = new SearchBarEsRspInfo();
                searchBarEsRspInfo.setCommodityId(Long.valueOf(commodityRspBo.getCommodity_id()));
                searchBarEsRspInfo.setSkuId(Long.valueOf(commodityRspBo.getSku_id()));
                searchBarEsRspInfo.setExtSkuId(commodityRspBo.getExt_sku_id());
                searchBarEsRspInfo.setPriPicUrl(commodityRspBo.getPicture_url());
                searchBarEsRspInfo.setAgreementPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getAgreement_price())));
                searchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMarket_price())));
                searchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getSale_price())));
                searchBarEsRspInfo.setMemberPrice1(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price1())));
                searchBarEsRspInfo.setMemberPrice2(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price2())));
                searchBarEsRspInfo.setMemberPrice3(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price3())));
                searchBarEsRspInfo.setMemberPrice4(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price4())));
                searchBarEsRspInfo.setMemberPrice5(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price5())));
                searchBarEsRspInfo.setSkuName(commodityRspBo.getSku_name());
                searchBarEsRspInfo.setSupplierShopId(commodityRspBo.getSupplier_shop_id());
                searchBarEsRspInfo.setSupplierShopName(commodityRspBo.getShop_name());
                searchBarEsRspInfo.setSupplierId(String.valueOf(commodityRspBo.getSupplier_id()));
                searchBarEsRspInfo.setSupplierName(commodityRspBo.getSupplier_name());
                searchBarEsRspInfo.setSkuSource(Integer.valueOf(commodityRspBo.getSku_source()));
                searchBarEsRspInfo.setL1CategoryId(commodityRspBo.getL1_category_id());
                searchBarEsRspInfo.setL2CategoryId(commodityRspBo.getL2_category_id());
                searchBarEsRspInfo.setL3CategoryId(commodityRspBo.getL3_category_id());
                searchBarEsRspInfo.setL1CategoryName(commodityRspBo.getL1_category_name());
                searchBarEsRspInfo.setL2CategoryName(commodityRspBo.getL2_category_name());
                searchBarEsRspInfo.setL3CategoryName(commodityRspBo.getL3_category_name());
                searchBarEsRspInfo.setCommodityName(commodityRspBo.getCommodity_name());
                searchBarEsRspInfo.setCommdPicUrl(commodityRspBo.getCommd_pic_url());
                if (commodityRspBo.getEcommerce_sale() != null) {
                    searchBarEsRspInfo.setEcommerceSale(Long.valueOf(commodityRspBo.getEcommerce_sale().longValue()));
                }
                searchBarEsRspInfo.setExtendProperties(commodityRspBo.getExtendProperties());
                searchBarEsRspInfo.setViewOrder(Integer.valueOf(commodityRspBo.getView_order()));
                searchBarEsRspInfos.add(searchBarEsRspInfo);
            }
        }
        return searchBarEsRspInfos;
    }

    private void sasDeal(ActivityCenterSearchEsReqBO reqBO, List<SearchBarEsRspInfo> result) {
        if (reqBO.getRootOrgIdIn() == null) {
            return;
        }
        UccSupplierCacheReqBo uccSupplierCacheReqBo = new UccSupplierCacheReqBo();
        uccSupplierCacheReqBo.setSupplierId(reqBO.getSupplierId());
        UccSupplierCacheRspBo uccSupplierCacheRspBo = this.uccSupplierCacheAtomService.qryInfomation(uccSupplierCacheReqBo);
        if (uccSupplierCacheRspBo == null) {
            LOGGER.error("\u6d3b\u52a8\u670d\u52a1\u5546\u54c1\u641c\u7d22sas\u5904\u7406\uff0c\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
            for (SearchBarEsRspInfo each : result) {
                each.setSupplierId(reqBO.getOrgIdIn().toString());
                each.setSupplierShopId(reqBO.getOrgIdIn());
            }
        } else {
            for (SearchBarEsRspInfo each : result) {
                each.setSupplierId(uccSupplierCacheRspBo.getSupplierId().toString());
                each.setSupplierName(uccSupplierCacheRspBo.getSupplierName());
                each.setSupplierShopId(uccSupplierCacheRspBo.getShopPos().get(0).getSupplierShopId());
                each.setSupplierShopName(uccSupplierCacheRspBo.getShopPos().get(0).getShopName());
            }
        }
    }
}

