/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.ability.api.SearchBarEsAbilityService;
import com.tydic.commodity.atom.UccSupplierCacheAtomService;
import com.tydic.commodity.atom.bo.UccSupplierCacheReqBo;
import com.tydic.commodity.atom.bo.UccSupplierCacheRspBo;
import com.tydic.commodity.bo.ability.SearchBarEsReqBO;
import com.tydic.commodity.bo.ability.SearchBarEsRspBO;
import com.tydic.commodity.bo.ability.SearchBarEsRspInfo;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.dao.po.UccSpuSpecPo;
import com.tydic.commodity.search.SearchCommodityService;
import com.tydic.commodity.search.bo.CommodityRspBo;
import com.tydic.commodity.search.bo.SearchEsReqBO;
import com.tydic.commodity.search.bo.SearchEsRspBo;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=SearchBarEsAbilityService.class)
public class SearchBarEsAbilityServiceImpl
implements SearchBarEsAbilityService {
    private static final Logger LOGGER = LogManager.getLogger(SearchBarEsAbilityServiceImpl.class);
    @Autowired
    private SearchCommodityService searchCommodityService;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccSupplierCacheAtomService uccSupplierCacheAtomService;
    private static Integer esSeaarchSize = 10000;

    public SearchBarEsRspBO qryBySearchBar(SearchBarEsReqBO reqBO) {
        SearchEsRspBo searchEsRspBo;
        SearchBarEsRspBO searchBarEsRspBO = new SearchBarEsRspBO();
        if (reqBO.getOrgIdIn() != null) {
            reqBO.setSupplierId(reqBO.getOrgIdIn());
        }
        if (reqBO.getRootOrgIdIn() != null) {
            reqBO.setSupplierId(reqBO.getRootOrgIdIn());
        }
        UccSupplierCacheReqBo uccSupplierCacheReqBo = new UccSupplierCacheReqBo();
        uccSupplierCacheReqBo.setSupplierId(reqBO.getOrgIdIn());
        UccSupplierCacheRspBo uccSupplierCacheRspBo = this.uccSupplierCacheAtomService.qryInfomation(uccSupplierCacheReqBo);
        if (!"0000".equals(uccSupplierCacheRspBo.getRespCode())) {
            LOGGER.error("\u672a\u67e5\u8be2\u5230\u5546\u6237ID" + reqBO.getOrgIdIn());
            searchBarEsRspBO.setRespCode("0000");
            searchBarEsRspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u6237ID" + reqBO.getOrgIdIn());
            searchBarEsRspBO.setRecordsTotal(0);
            searchBarEsRspBO.setTotal(0);
            return searchBarEsRspBO;
        }
        SearchEsReqBO searchEsReqBO = new SearchEsReqBO();
        if (reqBO.getOrgIdIn() != null) {
            searchEsReqBO.setMerchantId(reqBO.getOrgIdIn());
        }
        if (uccSupplierCacheRspBo.getSceneId() != null) {
            searchEsReqBO.setSceneId(uccSupplierCacheRspBo.getSceneId());
        }
        if (reqBO.getSkuStatus() == null || reqBO.getSkuStatus().size() == 0) {
            ArrayList<Integer> skuStatus = new ArrayList<Integer>();
            skuStatus.add(ModelRuleConstant.SKU_STATUS_ON_SHELF);
            reqBO.setSkuStatus(skuStatus);
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)searchEsReqBO);
        if (reqBO.getSupplierShopId() != null) {
            ArrayList<Long> supplierShopIds = new ArrayList<Long>();
            supplierShopIds.add(reqBO.getSupplierShopId());
            searchEsReqBO.setSupplierShopIds(supplierShopIds);
        }
        if (reqBO.getCategoryId() != null) {
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            categoryIds.add(reqBO.getCategoryId());
            searchEsReqBO.setCategoryIds(categoryIds);
        }
        if (reqBO.getBrandId() != null) {
            ArrayList<Long> brandIds = new ArrayList<Long>();
            brandIds.add(reqBO.getBrandId());
            searchEsReqBO.setBrandIds(brandIds);
        }
        if ((searchEsRspBo = this.searchCommodityService.queryByMatch(searchEsReqBO)) == null) {
            LOGGER.info("\u67e5\u8be2ES\u6570\u636e\u670d\u52a1\u5f02\u5e38!!");
            searchBarEsRspBO.setRespCode("0000");
            searchBarEsRspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e!");
            searchBarEsRspBO.setPageNo(1);
            searchBarEsRspBO.setTotal(0);
            searchBarEsRspBO.setRecordsTotal(0);
            return searchBarEsRspBO;
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)searchBarEsRspBO);
        List commodityRspBos = searchEsRspBo.getCommodityRspBos();
        List<SearchBarEsRspInfo> result = this.convertRspBo(commodityRspBos);
        if (reqBO.getRootOrgIdIn() != null) {
            this.sasDeal(reqBO, result);
        }
        searchBarEsRspBO.setResult(result);
        int size = reqBO.getPageSize();
        int no = reqBO.getPageNo();
        int totalPage = 0;
        int add = 0;
        Integer total = 0;
        if (esSeaarchSize.compareTo(searchEsRspBo.getTotal()) > 0) {
            totalPage = searchEsRspBo.getTotal() / size;
            add = searchEsRspBo.getTotal() % size == 0 ? 0 : 1;
            total = searchEsRspBo.getTotal();
        } else {
            totalPage = esSeaarchSize / size;
            total = size * (totalPage + (add = esSeaarchSize % size == 0 ? 0 : 1));
            if (total.compareTo(searchEsRspBo.getTotal()) > 0) {
                total = searchEsRspBo.getTotal();
            }
        }
        searchBarEsRspBO.setTotal(totalPage + add);
        searchBarEsRspBO.setPageNo(no);
        if (searchEsRspBo.getQueryParams() != null && searchEsRspBo.getPropParams() != null) {
            searchEsRspBo.getQueryParams().addAll(searchEsRspBo.getPropParams());
        }
        searchBarEsRspBO.setQueryParams(searchEsRspBo.getQueryParams());
        searchBarEsRspBO.setRecordsTotal(total.intValue());
        searchBarEsRspBO.setRespCode("0000");
        searchBarEsRspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return searchBarEsRspBO;
    }

    private List<SearchBarEsRspInfo> convertRspBo(List<CommodityRspBo> commodityRspBos) {
        ArrayList<SearchBarEsRspInfo> searchBarEsRspInfos = new ArrayList<SearchBarEsRspInfo>();
        if (commodityRspBos != null && commodityRspBos.size() > 0) {
            for (CommodityRspBo commodityRspBo : commodityRspBos) {
                SearchBarEsRspInfo searchBarEsRspInfo = new SearchBarEsRspInfo();
                searchBarEsRspInfo.setCommodityId(Long.valueOf(commodityRspBo.getCommodity_id()));
                searchBarEsRspInfo.setSkuId(Long.valueOf(commodityRspBo.getSku_id()));
                searchBarEsRspInfo.setExtSkuId(commodityRspBo.getExt_sku_id());
                searchBarEsRspInfo.setPriPicUrl(commodityRspBo.getPicture_url());
                searchBarEsRspInfo.setAgreementPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getAgreement_price())));
                searchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMarket_price())));
                searchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getSale_price())));
                searchBarEsRspInfo.setMemberPrice1(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price1())));
                searchBarEsRspInfo.setMemberPrice2(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price2())));
                searchBarEsRspInfo.setMemberPrice3(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price3())));
                searchBarEsRspInfo.setMemberPrice4(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price4())));
                searchBarEsRspInfo.setMemberPrice5(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price5())));
                searchBarEsRspInfo.setCommentNumber(commodityRspBo.getComment_number());
                searchBarEsRspInfo.setSkuName(commodityRspBo.getSku_name());
                searchBarEsRspInfo.setSupplierShopId(commodityRspBo.getSupplier_shop_id());
                searchBarEsRspInfo.setSupplierShopName(commodityRspBo.getShop_name());
                searchBarEsRspInfo.setSupplierId(String.valueOf(commodityRspBo.getSupplier_id()));
                searchBarEsRspInfo.setSupplierName(commodityRspBo.getSupplier_name());
                searchBarEsRspInfo.setSkuSource(Integer.valueOf(commodityRspBo.getSku_source()));
                searchBarEsRspInfo.setCommodityName(commodityRspBo.getCommodity_name());
                searchBarEsRspInfo.setCommdPicUrl(commodityRspBo.getCommd_pic_url());
                if (commodityRspBo.getEcommerce_sale() != null) {
                    searchBarEsRspInfo.setEcommerceSale(Long.valueOf(commodityRspBo.getEcommerce_sale().longValue()));
                }
                searchBarEsRspInfo.setExtendProperties(commodityRspBo.getShow_prop_json());
                searchBarEsRspInfos.add(searchBarEsRspInfo);
            }
        }
        commodityRspBos = null;
        return searchBarEsRspInfos;
    }

    private void queryOtherProp(List<SearchBarEsRspInfo> rspInfos) {
        if (rspInfos == null || rspInfos.size() == 0) {
            return;
        }
        HashedMap shopCommd = new HashedMap();
        for (SearchBarEsRspInfo each : rspInfos) {
            if (shopCommd.containsKey(each.getSupplierShopId())) {
                ((List)shopCommd.get(each.getSupplierShopId())).add(each.getCommodityId());
                continue;
            }
            ArrayList<Long> commoditys = new ArrayList<Long>();
            commoditys.add(each.getCommodityId());
            shopCommd.put(each.getSupplierShopId(), commoditys);
        }
        Iterator iterator = shopCommd.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            System.out.println(++i);
            Map.Entry data = iterator.next();
            List<UccSpuSpecPo> uccSpuSpecPoList = this.uccSpuSpecMapper.batchQueryLessSpecs((List)data.getValue(), ModelRuleConstant.PROP_GRP_TYPE_OTHER, (Long)data.getKey());
            if (uccSpuSpecPoList == null || uccSpuSpecPoList.size() == 0) continue;
            HashedMap specMap = new HashedMap();
            for (UccSpuSpecPo uccSpuSpecPo : uccSpuSpecPoList) {
                if (specMap.containsKey(uccSpuSpecPo.getCommodityId())) {
                    ((JSONObject)specMap.get(uccSpuSpecPo.getCommodityId())).put(uccSpuSpecPo.getPropShowName(), (Object)uccSpuSpecPo.getPropValue());
                    continue;
                }
                JSONObject specData = new JSONObject();
                specData.put(uccSpuSpecPo.getPropShowName(), (Object)uccSpuSpecPo.getPropValue());
                specMap.put(uccSpuSpecPo.getCommodityId(), specData);
            }
            for (SearchBarEsRspInfo searchBarEsRspInfo : rspInfos) {
                searchBarEsRspInfo.setExtendProperties(JSONObject.toJSONString(specMap.get(searchBarEsRspInfo.getCommodityId())));
            }
        }
        shopCommd = null;
    }

    private void sasDeal(SearchBarEsReqBO reqBO, List<SearchBarEsRspInfo> result) {
        if (reqBO.getRootOrgIdIn() == null) {
            return;
        }
        UccSupplierCacheReqBo uccSupplierCacheReqBo = new UccSupplierCacheReqBo();
        uccSupplierCacheReqBo.setSupplierId(reqBO.getOrgIdIn());
        UccSupplierCacheRspBo uccSupplierCacheRspBo = this.uccSupplierCacheAtomService.qryInfomation(uccSupplierCacheReqBo);
        if (uccSupplierCacheRspBo == null || !"0000".equals(uccSupplierCacheRspBo.getRespCode())) {
            LOGGER.error("\u5546\u54c1\u641c\u7d22sas\u5904\u7406\uff0c\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
            for (SearchBarEsRspInfo each : result) {
                each.setSupplierId(reqBO.getOrgIdIn().toString());
                each.setSupplierShopId(reqBO.getOrgIdIn());
            }
        } else {
            for (SearchBarEsRspInfo each : result) {
                each.setSupplierId(uccSupplierCacheRspBo.getSupplierId().toString());
                each.setSupplierShopId(uccSupplierCacheRspBo.getShopPos().get(0).getSupplierShopId());
                each.setSupplierShopName(uccSupplierCacheRspBo.getShopPos().get(0).getShopName());
                each.setSupplierName(uccSupplierCacheRspBo.getSupplierName());
            }
        }
    }
}

