/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.ability.api.UccBatchQryCatlogAbilityService;
import com.tydic.commodity.bo.ability.UccBatchQryCatlogReqBO;
import com.tydic.commodity.bo.ability.UccBatchQryCatlogRspBO;
import com.tydic.commodity.bo.ability.UccCatalogListBO;
import com.tydic.commodity.bo.ability.UccCommdRCatsBO;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.po.CommdRCatPO;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccBatchQryCatlogAbilityService.class)
public class UccBatchQryCatlogAbilityServiceImpl
implements UccBatchQryCatlogAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchQryCatlogAbilityServiceImpl.class);
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;

    public UccBatchQryCatlogRspBO batchQryCatalog(UccBatchQryCatlogReqBO reqBO) {
        UccBatchQryCatlogRspBO rspBO = new UccBatchQryCatlogRspBO();
        ArrayList<UccCommdRCatsBO> uccCommdRCatsBOS = new ArrayList<UccCommdRCatsBO>();
        rspBO.setResult(uccCommdRCatsBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u5546\u54c1ID\u96c6\u5408");
        }
        if (reqBO.getSupplierShopId() == null) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u5e97\u94faID");
        }
        try {
            List<CommdRCatPO> commdRCatPOS = this.uccCatalogDealMapper.batchQryCommdRCat(reqBO.getCommodityIds(), reqBO.getSupplierShopId());
            if (CollectionUtils.isEmpty(commdRCatPOS)) {
                return rspBO;
            }
            Map<Long, List<CommdRCatPO>> groupByCommd = commdRCatPOS.stream().collect(Collectors.groupingBy(CommdRCatPO::getCommodityId));
            for (Map.Entry<Long, List<CommdRCatPO>> each : groupByCommd.entrySet()) {
                UccCommdRCatsBO uccCommdRCatsBO = new UccCommdRCatsBO();
                uccCommdRCatsBO.setCommodityId(each.getKey());
                List<CommdRCatPO> commdRCatPOS1 = each.getValue();
                ArrayList<UccCatalogListBO> uccCatalogListBOS = new ArrayList<UccCatalogListBO>();
                for (CommdRCatPO commdRCatPO : commdRCatPOS1) {
                    UccCatalogListBO uccCatalogListBO = new UccCatalogListBO();
                    uccCatalogListBO.setCatalogId(commdRCatPO.getCatalogId());
                    uccCatalogListBO.setCatalogLevel(commdRCatPO.getCatalogLevel());
                    uccCatalogListBO.setCatalogName(commdRCatPO.getCatalogName());
                    uccCatalogListBO.setIconUrl(commdRCatPO.getIconUrl());
                    uccCatalogListBOS.add(uccCatalogListBO);
                }
                uccCommdRCatsBO.setCatalogInfos(uccCatalogListBOS);
                uccCommdRCatsBOS.add(uccCommdRCatsBO);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5931\u8d25");
        }
        return rspBO;
    }
}

