/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.ability.api.UccBatchShopingQryAbilityService;
import com.tydic.commodity.atom.UccAreaAvailableQryAtomService;
import com.tydic.commodity.atom.UccAvailableCommdQryAtomService;
import com.tydic.commodity.atom.UccCommdDetailsQryAtomService;
import com.tydic.commodity.atom.UccCurrentStockQryAtomService;
import com.tydic.commodity.atom.UccSupplierCacheAtomService;
import com.tydic.commodity.atom.UccSupplierShopCacheAtomService;
import com.tydic.commodity.atom.bo.SkuNumBO_Atom;
import com.tydic.commodity.atom.bo.UccAreaAvailableQryReqBO;
import com.tydic.commodity.atom.bo.UccAreaAvailableQryRspBO;
import com.tydic.commodity.atom.bo.UccAvailableCommdQryReqBO;
import com.tydic.commodity.atom.bo.UccAvailableCommdQryRspBO;
import com.tydic.commodity.atom.bo.UccCommdDetailsQryReqBO;
import com.tydic.commodity.atom.bo.UccCommdDetailsQryRspBO;
import com.tydic.commodity.atom.bo.UccCurrentStockQryReqBO;
import com.tydic.commodity.atom.bo.UccCurrentStockQryRspBO;
import com.tydic.commodity.atom.bo.UccSupplierCacheReqBo;
import com.tydic.commodity.atom.bo.UccSupplierCacheRspBo;
import com.tydic.commodity.atom.bo.UccSupplierShopCacheReqBo;
import com.tydic.commodity.atom.bo.UccSupplierShopCacheRspBo;
import com.tydic.commodity.bo.ReqUccBO;
import com.tydic.commodity.bo.ability.SaleSkuPropEntityBo;
import com.tydic.commodity.bo.ability.UccBatchShopQryBo;
import com.tydic.commodity.bo.ability.UccBatchShopQryMsgBo;
import com.tydic.commodity.bo.ability.UccBatchShopQryReqBo;
import com.tydic.commodity.bo.ability.UccBatchShopQryRspBo;
import com.tydic.commodity.bo.busi.AreaAvailableCommdBO_busi;
import com.tydic.commodity.bo.busi.AvailableCommdBO_busi;
import com.tydic.commodity.bo.busi.CommdStockBO_busi;
import com.tydic.commodity.bo.busi.JdPriceBO_busi;
import com.tydic.commodity.bo.busi.NotJdPriceBO_busi;
import com.tydic.commodity.bo.busi.UccCurrentPriceQryReqBO;
import com.tydic.commodity.bo.busi.UccCurrentPriceQryRspBO;
import com.tydic.commodity.busi.api.UccCurrentPriceQryBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccLabelDealMapper;
import com.tydic.commodity.dao.UccSceneSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccLabelPO;
import com.tydic.commodity.dao.po.UccSceneSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuPicPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuSpecPo;
import com.tydic.commodity.dao.po.UccSkuStockPo;
import com.tydic.commodity.dao.po.UccVendorPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.CommdStockBO;
import com.tydic.commodity.external.bo.SkuStateRspBo;
import com.tydic.commodity.external.bo.UccSkuStateReqBO;
import com.tydic.commodity.external.bo.UccSkuStateRsp;
import com.tydic.commodity.external.bo.UccTmCommdStockQryReqBO;
import com.tydic.commodity.external.bo.UccTmCommdStockQryRspBO;
import com.tydic.commodity.external.bo.UccTmStockBO;
import com.tydic.commodity.external.service.UccQrySkuStateService;
import com.tydic.commodity.external.service.UccTmCommdStockQryService;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccBatchShopingQryAbilityService.class)
public class UccBatchShopingQryAbilityServiceImpl
implements UccBatchShopingQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchShopingQryAbilityServiceImpl.class);
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(UccBatchShopingQryAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommdDetailsQryAtomService uccCommdDetailsQryAtomService;
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV")
    private UccCurrentPriceQryBusiService uccCurrentPriceQryBusiService;
    @Autowired
    private UccAreaAvailableQryAtomService uccAreaAvailableQryAtomService;
    @Autowired
    private UccAvailableCommdQryAtomService uccAvailableCommdQryAtomService;
    @Autowired
    private UccQrySkuStateService UccQrySkuStateService;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccCurrentStockQryAtomService uccCurrentStockQryAtomService;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuStockMapper uccSkuStockMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccTmCommdStockQryService uccTmCommdStockQryService;
    @Autowired
    private UccSupplierCacheAtomService uccSupplierCacheAtomService;
    @Autowired
    private UccSupplierShopCacheAtomService uccSupplierShopCacheAtomService;
    @Autowired
    private UccSceneSkuPriceMapper uccSceneSkuPriceMapper;
    @Autowired
    private UccLabelDealMapper uccLabelDealMapper;

    /*
     * WARNING - void declaration
     */
    public UccBatchShopQryRspBo qryInfo(UccBatchShopQryReqBo reqBo) {
        UccBatchShopQryRspBo rspBo = new UccBatchShopQryRspBo();
        if (reqBo.getShopQry() == null || reqBo.getShopQry().size() == 0) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5355\u54c1ID \u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBo;
        }
        if (((UccBatchShopQryBo)reqBo.getShopQry().get(0)).getRootOrgIdIn() != null) {
            for (UccBatchShopQryBo each : reqBo.getShopQry()) {
                each.setSupplierShopId(each.getRootOrgIdIn());
            }
        }
        ArrayList<Object> shopQryMsgBos = new ArrayList<Object>();
        Map<Integer, Map<Long, ArrayList<UccBatchShopQryBo>>> sortmap = this.groupBySourceAndSupplierShopId(reqBo);
        Map<Object, Object> map = new HashMap();
        if (sortmap.containsKey(ModelRuleConstant.SKU_SOURCE_SELF_SUPPORT)) {
            map = sortmap.get(ModelRuleConstant.SKU_SOURCE_SELF_SUPPORT);
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                try {
                    shopQryMsgBos.addAll(this.queryLocalDetail((List)entry.getValue()));
                }
                catch (BusinessException e) {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc(e.getMsgInfo());
                    return rspBo;
                }
            }
        }
        if (sortmap.containsKey(ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT)) {
            map = sortmap.get(ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT);
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                try {
                    shopQryMsgBos.addAll(this.queryElcCommdDetail((List)entry.getValue()));
                }
                catch (BusinessException e) {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc(e.getMsgInfo());
                    return rspBo;
                }
            }
        }
        if (sortmap.containsKey(ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION)) {
            // empty if block
        }
        ArrayList<UccBatchShopQryMsgBo> invalid = new ArrayList<UccBatchShopQryMsgBo>();
        for (UccBatchShopQryBo old : reqBo.getShopQry()) {
            if (shopQryMsgBos.size() > 0) {
                void var9_12;
                boolean bl = false;
                while (var9_12 < shopQryMsgBos.size() && !old.getSkuId().equals(((UccBatchShopQryMsgBo)shopQryMsgBos.get((int)var9_12)).getSkuId())) {
                    if (var9_12 == shopQryMsgBos.size() - 1 && !old.getSkuId().equals(((UccBatchShopQryMsgBo)shopQryMsgBos.get((int)var9_12)).getSkuId())) {
                        UccBatchShopQryMsgBo shopQryMsgBo = new UccBatchShopQryMsgBo();
                        BeanUtils.copyProperties((Object)old, (Object)shopQryMsgBo);
                        shopQryMsgBo.setStatus(Integer.valueOf(2));
                        shopQryMsgBo.setStock(Integer.valueOf(0));
                        shopQryMsgBo.setSaleNum(old.getSaleNum());
                        invalid.add(shopQryMsgBo);
                    }
                    ++var9_12;
                }
                continue;
            }
            UccBatchShopQryMsgBo uccBatchShopQryMsgBo = new UccBatchShopQryMsgBo();
            BeanUtils.copyProperties((Object)old, (Object)uccBatchShopQryMsgBo);
            uccBatchShopQryMsgBo.setStatus(Integer.valueOf(2));
            uccBatchShopQryMsgBo.setStock(Integer.valueOf(0));
            uccBatchShopQryMsgBo.setSaleNum("1");
            invalid.add(uccBatchShopQryMsgBo);
        }
        shopQryMsgBos.addAll(invalid);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setShopQryMsg(shopQryMsgBos);
        if (((UccBatchShopQryBo)reqBo.getShopQry().get(0)).getRootOrgIdIn() != null) {
            Map<Long, Long> reqBoShop = reqBo.getShopQry().stream().collect(Collectors.toMap(UccBatchShopQryBo::getSkuId, ReqUccBO::getOrgIdIn));
            for (UccBatchShopQryMsgBo uccBatchShopQryMsgBo : shopQryMsgBos) {
                uccBatchShopQryMsgBo.setSupplierShopId(reqBoShop.get(uccBatchShopQryMsgBo.getSkuId()));
                uccBatchShopQryMsgBo.setSupplierId(reqBoShop.get(uccBatchShopQryMsgBo.getSkuId()));
            }
        }
        return rspBo;
    }

    public List<UccBatchShopQryMsgBo> queryElcCommdDetail(List<UccBatchShopQryBo> bos) throws BusinessException {
        ArrayList result = new ArrayList();
        UccSupplierShopCacheReqBo uccSupplierShopCacheReqBo = new UccSupplierShopCacheReqBo();
        uccSupplierShopCacheReqBo.setSupplierShopId(bos.get(0).getSupplierShopId());
        UccSupplierShopCacheRspBo uccSupplierShopCacheRspBo = this.uccSupplierShopCacheAtomService.qryInfomation(uccSupplierShopCacheReqBo);
        if (uccSupplierShopCacheRspBo == null || !"0000".equals(uccSupplierShopCacheRspBo.getRespCode())) {
            LOGGER.error("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
            throw new BusinessException("supplierShopId_is_null", "\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
        }
        UccSupplierCacheReqBo uccSupplierCacheReqBo = new UccSupplierCacheReqBo();
        uccSupplierCacheReqBo.setSupplierId(uccSupplierShopCacheRspBo.getSupplierId());
        UccSupplierCacheRspBo uccSupplierCacheRspBo = this.uccSupplierCacheAtomService.qryInfomation(uccSupplierCacheReqBo);
        if (uccSupplierCacheRspBo == null || !"0000".equals(uccSupplierCacheRspBo.getRespCode())) {
            LOGGER.error("\u4f9b\u5e94\u5546\u67e5\u8be2\u51fa\u9519");
            throw new BusinessException("supplierShopId_is_null", "\u4f9b\u5e94\u5546\u67e5\u8be2\u51fa\u9519");
        }
        ArrayList<Long> skus = new ArrayList<Long>();
        for (UccBatchShopQryBo each : bos) {
            skus.add(each.getSkuId());
        }
        Object uccSkuPo = null;
        List<UccSkuPo> skuPoList = this.uccSkuMapper.queryBatchSkusLessCloum(skus, bos.get(0).getSupplierShopId());
        ArrayList<Long> invalid = new ArrayList<Long>();
        ArrayList<String> extSkus = new ArrayList<String>();
        ArrayList<UccBatchShopQryMsgBo> invalidBatchShopQryMsgBo = new ArrayList<UccBatchShopQryMsgBo>();
        ArrayList<UccBatchShopQryMsgBo> onShlefBatchShopQryMsgBo = new ArrayList<UccBatchShopQryMsgBo>();
        UccBatchShopQryMsgBo batchShopQryMsgBo = null;
        for (UccSkuPo po : skuPoList) {
            batchShopQryMsgBo = new UccBatchShopQryMsgBo();
            batchShopQryMsgBo.setSkuId(po.getSkuId());
            batchShopQryMsgBo.setSupplierShopId(uccSupplierShopCacheRspBo.getSupplierShopId());
            batchShopQryMsgBo.setSupplierId(uccSupplierCacheRspBo.getSupplierId());
            batchShopQryMsgBo.setSupplierName(uccSupplierCacheRspBo.getSupplierName());
            batchShopQryMsgBo.setSupplierCode(uccSupplierCacheRspBo.getSupplierCode());
            batchShopQryMsgBo.setSkuSource(po.getSkuSource());
            batchShopQryMsgBo.setExtralSkuId(po.getExtSkuId());
            batchShopQryMsgBo.setCommodityId(po.getCommodityId());
            for (UccBatchShopQryBo uccBatchShopQryBo : bos) {
                if (!po.getSkuId().equals(uccBatchShopQryBo.getSkuId())) continue;
                batchShopQryMsgBo.setSaleNum(uccBatchShopQryBo.getSaleNum());
                batchShopQryMsgBo.setIsChoice(uccBatchShopQryBo.getIsChoice());
                batchShopQryMsgBo.setJoinTime(uccBatchShopQryBo.getJoinTime());
            }
            if (po.getSkuStatus() != ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                batchShopQryMsgBo.setStatus(Integer.valueOf(0));
                batchShopQryMsgBo.setSkuName(po.getSkuName());
                invalid.add(po.getCommodityId());
                invalidBatchShopQryMsgBo.add(batchShopQryMsgBo);
                skus.remove(po.getSkuId());
                continue;
            }
            onShlefBatchShopQryMsgBo.add(batchShopQryMsgBo);
            extSkus.add(po.getExtSkuId());
        }
        if (invalid.size() > 0) {
            List<UccCommodityPicPo> picPos = this.uccCommodityPicMapper.queryBatchLesCloum(invalid, bos.get(0).getSupplierShopId(), ModelRuleConstant.COMMD_IMG_MAIN);
            Map<Long, String> img = picPos.stream().collect(Collectors.toMap(UccCommodityPicPo::getCommodityId, UccCommodityPicPo::getCommodityPicUrl));
            for (UccBatchShopQryMsgBo uccBatchShopQryMsgBo : invalidBatchShopQryMsgBo) {
                uccBatchShopQryMsgBo.setImage(img.get(uccBatchShopQryMsgBo.getCommodityId()));
                uccBatchShopQryMsgBo.setStock(Integer.valueOf(0));
            }
        }
        if (onShlefBatchShopQryMsgBo.size() == 0) {
            return invalidBatchShopQryMsgBo;
        }
        UccSkuStateReqBO uccSkuStateReqBO = new UccSkuStateReqBO();
        uccSkuStateReqBO.setExtSkuIds(extSkus);
        uccSkuStateReqBO.setSupplierCode(uccSupplierCacheRspBo.getSupplierCode());
        uccSkuStateReqBO.setSupplierId(uccSupplierCacheRspBo.getSupplierId());
        UccSkuStateRsp uccSkuStateRsp = this.UccQrySkuStateService.qrySkuStatus(uccSkuStateReqBO);
        if (!"0000".equals(uccSkuStateRsp.getRespCode())) {
            LOGGER.error("\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)uccSkuStateRsp));
            for (UccBatchShopQryMsgBo uccBatchShopQryMsgBo : onShlefBatchShopQryMsgBo) {
                uccBatchShopQryMsgBo.setStatus(Integer.valueOf(0));
            }
        }
        if (uccSkuStateRsp.getSkuStates() != null) {
            Map<String, Integer> extSkustatus = uccSkuStateRsp.getSkuStates().stream().collect(Collectors.toMap(SkuStateRspBo::getSku, SkuStateRspBo::getState));
            for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
                each.setStatus((Integer)extSkustatus.get(each.getExtralSkuId()));
            }
        }
        for (UccBatchShopQryMsgBo uccBatchShopQryMsgBo : onShlefBatchShopQryMsgBo) {
            UccCommdDetailsQryReqBO uccCommdDetailsQryReqBO = new UccCommdDetailsQryReqBO();
            uccCommdDetailsQryReqBO.setSkuId(uccBatchShopQryMsgBo.getExtralSkuId());
            uccCommdDetailsQryReqBO.setSupplierCode(uccSupplierCacheRspBo.getSupplierCode());
            UccCommdDetailsQryRspBO rspBO = this.uccCommdDetailsQryAtomService.qryCommdDetails(uccCommdDetailsQryReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                LOGGER.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + rspBO);
                continue;
            }
            if (rspBO.getCommdInfo().getJdBookInfo() != null) {
                uccBatchShopQryMsgBo.setImage(rspBO.getCommdInfo().getJdBookInfo().getImage());
                uccBatchShopQryMsgBo.setSaleUnit("\u672c");
                uccBatchShopQryMsgBo.setSkuName(rspBO.getCommdInfo().getJdBookInfo().getName());
            }
            if (rspBO.getCommdInfo().getJdCommdInfo() != null) {
                uccBatchShopQryMsgBo.setImage(rspBO.getCommdInfo().getJdCommdInfo().getImagePath());
                uccBatchShopQryMsgBo.setSaleUnit(rspBO.getCommdInfo().getNotJdCommdDetails().getSaleUnit());
                uccBatchShopQryMsgBo.setSkuName(rspBO.getCommdInfo().getNotJdCommdDetails().getName());
            }
            if (rspBO.getCommdInfo().getJdVedioInfo() != null) {
                uccBatchShopQryMsgBo.setImage(rspBO.getCommdInfo().getJdVedioInfo().getImage());
                uccBatchShopQryMsgBo.setSaleUnit(rspBO.getCommdInfo().getJdVedioInfo().getSaleUnit());
                uccBatchShopQryMsgBo.setSkuName(rspBO.getCommdInfo().getJdVedioInfo().getName());
            }
            if (rspBO.getCommdInfo().getNotJdCommdDetails() == null) continue;
            uccBatchShopQryMsgBo.setImage(rspBO.getCommdInfo().getNotJdCommdDetails().getImagePath());
            uccBatchShopQryMsgBo.setSaleUnit(rspBO.getCommdInfo().getNotJdCommdDetails().getSaleUnit());
            uccBatchShopQryMsgBo.setSkuName(rspBO.getCommdInfo().getNotJdCommdDetails().getName());
        }
        UccCurrentPriceQryReqBO uccCurrentPriceQryReqBO = new UccCurrentPriceQryReqBO();
        uccCurrentPriceQryReqBO.setSkuIds(skus);
        uccCurrentPriceQryReqBO.setSupplierShopId(bos.get(0).getSupplierShopId());
        UccCurrentPriceQryRspBO uccCurrentPriceQryRspBO = this.uccCurrentPriceQryBusiService.changeCommdCurrentPrice(uccCurrentPriceQryReqBO);
        Map<String, BigDecimal> extSkuPrice = null;
        if ("0000".equals(uccCurrentPriceQryRspBO.getRespCode())) {
            if (uccCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos() != null && uccCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos().size() > 0) {
                extSkuPrice = uccCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos().stream().collect(Collectors.toMap(JdPriceBO_busi::getSkuId, JdPriceBO_busi::getNewSalePrice));
            }
            if (uccCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo() != null && uccCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo().size() > 0) {
                extSkuPrice = uccCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo().stream().collect(Collectors.toMap(NotJdPriceBO_busi::getSkuId, NotJdPriceBO_busi::getNewSalePrice));
            }
            for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
                each.setPrice(extSkuPrice.get(each.getSkuId().toString()));
            }
        } else {
            LOGGER.error("\u67e5\u8be2\u91d1\u989d\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)uccCurrentPriceQryRspBO));
        }
        UccAvailableCommdQryReqBO uccAvailableCommdQryReqBO = new UccAvailableCommdQryReqBO();
        uccAvailableCommdQryReqBO.setSkuIds(extSkus);
        uccAvailableCommdQryReqBO.setSupplierCode(uccSupplierCacheRspBo.getSupplierCode());
        UccAvailableCommdQryRspBO uccAvailableCommdQryRspBO = this.uccAvailableCommdQryAtomService.qryAvailableCommd(uccAvailableCommdQryReqBO);
        if ("0000".equals(uccAvailableCommdQryRspBO.getResultCode())) {
            Map<String, Integer> extSkuArea = uccAvailableCommdQryRspBO.getAvailableCommdInfos().stream().collect(Collectors.toMap(AvailableCommdBO_busi::getSkuId, AvailableCommdBO_busi::getSaleState));
            for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
                each.setAvailableSale(extSkuArea.get(each.getExtralSkuId()));
            }
        } else {
            LOGGER.error("\u67e5\u8be2\u53ef\u552e\u9a8c\u8bc1\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)((Object)uccAvailableCommdQryRspBO)));
        }
        if (bos.get(0).getCity() != null && bos.get(0).getProvince() != null && bos.get(0).getCounty() != null) {
            UccAreaAvailableQryReqBO uccAreaAvailableQryReqBO = new UccAreaAvailableQryReqBO();
            uccAreaAvailableQryReqBO.setSkuIds(extSkus);
            if (bos.get(0).getCity() != null) {
                uccAreaAvailableQryReqBO.setCity(bos.get(0).getCity().longValue());
            }
            if (bos.get(0).getCounty() != null) {
                uccAreaAvailableQryReqBO.setCounty(bos.get(0).getCounty().longValue());
            }
            if (bos.get(0).getProvince() != null) {
                uccAreaAvailableQryReqBO.setProvince(bos.get(0).getProvince().longValue());
            }
            if (bos.get(0).getTown() != null) {
                uccAreaAvailableQryReqBO.setTown(bos.get(0).getTown().longValue());
            } else {
                uccAreaAvailableQryReqBO.setTown(0L);
            }
            uccAreaAvailableQryReqBO.setSupplierCode(uccSupplierCacheRspBo.getSupplierCode());
            uccAreaAvailableQryReqBO.setSupplierId(uccSupplierCacheRspBo.getSupplierId());
            UccAreaAvailableQryRspBO uccAreaAvailableQryRspBO = this.uccAreaAvailableQryAtomService.qryAreaAvailableCommd(uccAreaAvailableQryReqBO);
            if ("0000".equals(uccAreaAvailableQryRspBO.getRespCode())) {
                Map<String, Boolean> areaLimit = uccAreaAvailableQryRspBO.getAreaAvailableCommdInfos().stream().collect(Collectors.toMap(AreaAvailableCommdBO_busi::getSkuId, AreaAvailableCommdBO_busi::isAreaRestrict));
                for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
                    if (areaLimit.containsKey(each.getExtralSkuId())) {
                        if (!((Boolean)areaLimit.get(each.getExtralSkuId())).booleanValue()) {
                            each.setAreaLimit(Integer.valueOf(1));
                            continue;
                        }
                        each.setAreaLimit(Integer.valueOf(2));
                        continue;
                    }
                    each.setAreaLimit(Integer.valueOf(2));
                }
            } else {
                LOGGER.error("\u67e5\u8be2\u533a\u57df\u9650\u5236\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)((Object)uccAreaAvailableQryRspBO)));
                throw new BusinessException("BATCHSHOPINGQRY_ESB_AREAVAILABLE", uccAreaAvailableQryRspBO.getResultMessage());
            }
        }
        if (bos.get(0).getCity() != null && bos.get(0).getProvince() != null && bos.get(0).getCounty() != null) {
            UccCurrentStockQryReqBO uccCurrentStockQryReqBO = new UccCurrentStockQryReqBO();
            uccCurrentStockQryReqBO.setSupplierCode(uccSupplierCacheRspBo.getSupplierCode());
            uccCurrentStockQryReqBO.setSupplierId(uccSupplierCacheRspBo.getSupplierId());
            if (bos.get(0).getCity() != null) {
                uccCurrentStockQryReqBO.setCity(bos.get(0).getCity().longValue());
            }
            if (bos.get(0).getCounty() != null) {
                uccCurrentStockQryReqBO.setCounty(bos.get(0).getCounty().longValue());
            }
            if (bos.get(0).getProvince() != null) {
                uccCurrentStockQryReqBO.setProvince(bos.get(0).getProvince().longValue());
            }
            if (bos.get(0).getTown() != null) {
                uccCurrentStockQryReqBO.setTown(bos.get(0).getTown().longValue());
            } else {
                uccCurrentStockQryReqBO.setTown(0L);
            }
            ArrayList<SkuNumBO_Atom> stock = new ArrayList<SkuNumBO_Atom>();
            for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
                SkuNumBO_Atom skuNumBO_atom = new SkuNumBO_Atom();
                skuNumBO_atom.setSkuId(each.getExtralSkuId());
                skuNumBO_atom.setNum(Long.valueOf(each.getSaleNum() == null ? "1" : each.getSaleNum()));
                stock.add(skuNumBO_atom);
            }
            uccCurrentStockQryReqBO.setSkuNum(stock);
            UccCurrentStockQryRspBO uccCurrentStockQryRspBO = this.uccCurrentStockQryAtomService.qryCommdCurrentStock(uccCurrentStockQryReqBO);
            if ("0000".equals(uccCurrentStockQryRspBO.getRespCode())) {
                for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
                    for (CommdStockBO_busi stockBO_busi : uccCurrentStockQryRspBO.getCommdStockInfo()) {
                        if (!stockBO_busi.getSkuId().equals(each.getExtralSkuId())) continue;
                        each.setStock(stockBO_busi.getRemainNum());
                        each.setStockStateDesc(stockBO_busi.getStockStateDesc());
                        each.setStockStateId(stockBO_busi.getStockStateId());
                    }
                }
            }
        }
        onShlefBatchShopQryMsgBo.addAll(invalidBatchShopQryMsgBo);
        return onShlefBatchShopQryMsgBo;
    }

    public List<UccBatchShopQryMsgBo> queryLocalDetail(List<UccBatchShopQryBo> bos) throws BusinessException {
        List<UccLabelPO> uccLabelPOS;
        List<UccSceneSkuPricePo> sceneSkuPricePos;
        Map<Long, Object> commdImg;
        ArrayList result = new ArrayList();
        UccSupplierShopCacheReqBo uccSupplierShopCacheReqBo = new UccSupplierShopCacheReqBo();
        if (bos.get(0).getRootOrgIdIn() != null) {
            uccSupplierShopCacheReqBo.setSupplierShopId(bos.get(0).getOrgIdIn());
        } else {
            uccSupplierShopCacheReqBo.setSupplierShopId(bos.get(0).getSupplierShopId());
        }
        UccSupplierShopCacheRspBo uccSupplierShopCacheRspBo = this.uccSupplierShopCacheAtomService.qryInfomation(uccSupplierShopCacheReqBo);
        if (uccSupplierShopCacheRspBo == null || !"0000".equals(uccSupplierShopCacheRspBo.getRespCode())) {
            LOGGER.error("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
            throw new BusinessException("supplierShopId_is_null", "\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
        }
        UccSupplierCacheReqBo uccSupplierCacheReqBo = new UccSupplierCacheReqBo();
        uccSupplierCacheReqBo.setSupplierId(uccSupplierShopCacheRspBo.getSupplierId());
        UccSupplierCacheRspBo uccSupplierCacheRspBo = this.uccSupplierCacheAtomService.qryInfomation(uccSupplierCacheReqBo);
        if (uccSupplierCacheRspBo == null || !"0000".equals(uccSupplierCacheRspBo.getRespCode())) {
            LOGGER.error("\u4f9b\u5e94\u5546\u67e5\u8be2\u51fa\u9519");
            throw new BusinessException("supplierShopId_is_null", "\u4f9b\u5e94\u5546\u67e5\u8be2\u51fa\u9519");
        }
        ArrayList<Long> skus = new ArrayList<Long>();
        for (UccBatchShopQryBo each : bos) {
            skus.add(each.getSkuId());
        }
        Object uccSkuPo = null;
        List<UccSkuPo> skuPoList = this.uccSkuMapper.queryBatchSkusLessCloum(skus, bos.get(0).getSupplierShopId());
        ArrayList<Long> invalid = new ArrayList<Long>();
        ArrayList<String> extSkus = new ArrayList<String>();
        ArrayList<Long> commdIds = new ArrayList<Long>();
        ArrayList<UccBatchShopQryMsgBo> invalidBatchShopQryMsgBo = new ArrayList<UccBatchShopQryMsgBo>();
        ArrayList<UccBatchShopQryMsgBo> onShlefBatchShopQryMsgBo = new ArrayList<UccBatchShopQryMsgBo>();
        UccBatchShopQryMsgBo batchShopQryMsgBo = null;
        for (UccSkuPo po : skuPoList) {
            batchShopQryMsgBo = new UccBatchShopQryMsgBo();
            batchShopQryMsgBo.setSkuId(po.getSkuId());
            batchShopQryMsgBo.setSupplierShopId(uccSupplierShopCacheRspBo.getSupplierShopId());
            batchShopQryMsgBo.setSupplierId(uccSupplierCacheRspBo.getSupplierId());
            batchShopQryMsgBo.setSupplierName(uccSupplierCacheRspBo.getSupplierName());
            batchShopQryMsgBo.setSupplierCode(uccSupplierCacheRspBo.getSupplierCode());
            batchShopQryMsgBo.setSkuSource(po.getSkuSource());
            batchShopQryMsgBo.setExtralSkuId(po.getExtSkuId());
            batchShopQryMsgBo.setCommodityId(po.getCommodityId());
            batchShopQryMsgBo.setSkuName(po.getSkuName());
            batchShopQryMsgBo.setSaleUnit(po.getMeasureName());
            batchShopQryMsgBo.setCommodityId(po.getCommodityId());
            if (!StringUtils.isEmpty((Object)po.getPreDeliverDay())) {
                batchShopQryMsgBo.setPreDeliverDay(Integer.valueOf(po.getPreDeliverDay()));
            }
            commdIds.add(po.getCommodityId());
            for (UccBatchShopQryBo each : bos) {
                if (!po.getSkuId().equals(each.getSkuId())) continue;
                batchShopQryMsgBo.setSaleNum(each.getSaleNum());
                batchShopQryMsgBo.setIsChoice(each.getIsChoice());
                batchShopQryMsgBo.setJoinTime(each.getJoinTime());
            }
            if (po.getSkuStatus() != ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                batchShopQryMsgBo.setStatus(Integer.valueOf(0));
                batchShopQryMsgBo.setSkuName(po.getSkuName());
                batchShopQryMsgBo.setStock(Integer.valueOf(0));
                invalid.add(po.getSkuId());
                invalidBatchShopQryMsgBo.add(batchShopQryMsgBo);
                continue;
            }
            batchShopQryMsgBo.setStatus(Integer.valueOf(1));
            onShlefBatchShopQryMsgBo.add(batchShopQryMsgBo);
            extSkus.add(po.getExtSkuId());
        }
        ArrayList<UccBatchShopQryMsgBo> allQryMsgBo = new ArrayList<UccBatchShopQryMsgBo>();
        allQryMsgBo.addAll(invalidBatchShopQryMsgBo);
        allQryMsgBo.addAll(onShlefBatchShopQryMsgBo);
        ArrayList<Long> noSkuPic = new ArrayList<Long>();
        List<UccSkuPicPo> picPos = this.uccSkuPicMapper.queryBatchLesCloum(skus, bos.get(0).getSupplierShopId(), ModelRuleConstant.COMMD_IMG_MAIN);
        Map<Long, String> SkuImg = picPos.stream().collect(Collectors.toMap(UccSkuPicPo::getSkuId, UccSkuPicPo::getSkuPicUrl));
        for (UccBatchShopQryMsgBo each : allQryMsgBo) {
            if (!SkuImg.containsKey(each.getSkuId()) || SkuImg.get(each.getSkuId()) == null) {
                noSkuPic.add(each.getCommodityId());
                continue;
            }
            each.setImage(SkuImg.get(each.getSkuId()));
        }
        SkuImg = null;
        picPos = null;
        if (noSkuPic.size() > 0) {
            List<UccCommodityPicPo> commdPicPos = this.uccCommodityPicMapper.queryBatchLesCloum(noSkuPic, bos.get(0).getSupplierShopId(), ModelRuleConstant.COMMD_IMG_MAIN);
            commdImg = commdPicPos.stream().collect(Collectors.toMap(UccCommodityPicPo::getCommodityId, UccCommodityPicPo::getCommodityPicUrl));
            for (UccBatchShopQryMsgBo each : allQryMsgBo) {
                if (!commdImg.containsKey(each.getCommodityId())) continue;
                each.setImage((String)commdImg.get(each.getCommodityId()));
            }
            commdPicPos = null;
            commdImg = null;
        }
        List<UccSkuPricePo> pricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(skus, bos.get(0).getSupplierShopId());
        commdImg = pricePos.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, UccSkuPricePo::getSalePrice));
        for (UccBatchShopQryMsgBo each : allQryMsgBo) {
            each.setPrice(MoneyUtils.haoToYuan((Long)((Long)commdImg.get(each.getSkuId()))));
        }
        if (uccSupplierCacheRspBo.getSceneId() != null && !CollectionUtils.isEmpty(sceneSkuPricePos = this.uccSceneSkuPriceMapper.qrySKuBySceneandsku(skus, uccSupplierCacheRspBo.getSceneId(), 1))) {
            Map<Long, UccSceneSkuPricePo> sceneSkuPricePoMap = sceneSkuPricePos.stream().collect(Collectors.toMap(UccSceneSkuPricePo::getSkuId, UccSceneSkuPricePo2 -> UccSceneSkuPricePo2));
            for (UccBatchShopQryMsgBo uccBatchShopQryMsgBo : allQryMsgBo) {
                if (!sceneSkuPricePoMap.containsKey(uccBatchShopQryMsgBo.getSkuId())) continue;
                uccBatchShopQryMsgBo.setPrice(MoneyUtils.haoToYuan((Long)sceneSkuPricePoMap.get(uccBatchShopQryMsgBo.getSkuId()).getSalePrice()));
            }
        }
        if (!CollectionUtils.isEmpty(uccLabelPOS = this.uccLabelDealMapper.selectPoByCommdsAndShopId(commdIds, Arrays.asList(bos.get(0).getSupplierShopId())))) {
            Map<Long, List<UccLabelPO>> labelGroupByCommdsMap = uccLabelPOS.stream().collect(Collectors.groupingBy(UccLabelPO::getCommodityId));
            for (UccBatchShopQryMsgBo uccBatchShopQryMsgBo : allQryMsgBo) {
                if (labelGroupByCommdsMap.containsKey(uccBatchShopQryMsgBo.getCommodityId())) {
                    uccBatchShopQryMsgBo.setLabelType(((List)labelGroupByCommdsMap.get(uccBatchShopQryMsgBo.getCommodityId())).stream().map(UccLabelPO::getLabelType).collect(Collectors.toList()));
                    continue;
                }
                uccBatchShopQryMsgBo.setLabelType(new ArrayList());
            }
        } else {
            for (UccBatchShopQryMsgBo each : allQryMsgBo) {
                each.setLabelType(new ArrayList());
            }
        }
        pricePos = null;
        commdImg = null;
        List<UccCommodityPo> commodityPoList = this.uccCommodityMapper.qeryBatchCommdity(commdIds);
        Map<Long, String> commdNameMap = commodityPoList.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, UccCommodityPo::getCommodityName));
        for (UccBatchShopQryMsgBo each : allQryMsgBo) {
            each.setCommodityName(commdNameMap.get(each.getCommodityId()));
        }
        commdNameMap = null;
        if (onShlefBatchShopQryMsgBo.size() == 0) {
            return invalidBatchShopQryMsgBo;
        }
        List<UccSkuStockPo> list = this.uccSkuStockMapper.batchQryById(skus, bos.get(0).getSupplierShopId());
        Map<Long, BigDecimal> stockMap = list.stream().collect(Collectors.toMap(UccSkuStockPo::getSkuId, UccSkuStockPo::getStockNum));
        for (UccBatchShopQryMsgBo each : allQryMsgBo) {
            if (stockMap.containsKey(each.getSkuId())) {
                each.setStock(Integer.valueOf(stockMap.get(each.getSkuId()).intValue()));
            }
            each.setAreaLimit(Integer.valueOf(1));
            each.setAvailableSale(Integer.valueOf(1));
        }
        Object var25_30 = null;
        stockMap = null;
        Map<Long, Long> commdMap = commodityPoList.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, UccCommodityPo::getVendorId));
        UccVendorPo uccVendorPo = new UccVendorPo();
        uccVendorPo.setVendorCode("tianmao");
        List<UccVendorPo> vendorPoList = this.uccVendorMapper.queryVerdor(uccVendorPo);
        Long tianmao = 0L;
        if (vendorPoList.size() > 0) {
            tianmao = vendorPoList.get(0).getVendorId();
        }
        ArrayList<UccBatchShopQryMsgBo> qryTanmaoStockList = new ArrayList<UccBatchShopQryMsgBo>();
        for (UccBatchShopQryMsgBo each : onShlefBatchShopQryMsgBo) {
            if (tianmao == 0L || !tianmao.equals(commdMap.get(each.getCommodityId()))) continue;
            qryTanmaoStockList.add(each);
        }
        if (qryTanmaoStockList.size() > 0) {
            this.queryTaomaoStock(qryTanmaoStockList, String.valueOf(bos.get(0).getCounty()));
        }
        commdMap = null;
        for (UccBatchShopQryMsgBo each : allQryMsgBo) {
            this.querySkuProperties(each, bos.get(0).getSupplierShopId());
        }
        return allQryMsgBo;
    }

    private Map<Integer, Map<Long, ArrayList<UccBatchShopQryBo>>> groupBySourceAndSupplierShopId(UccBatchShopQryReqBo reqBo) {
        HashMap<Integer, Map<Long, ArrayList<UccBatchShopQryBo>>> sort = new HashMap<Integer, Map<Long, ArrayList<UccBatchShopQryBo>>>();
        ArrayList<Long> skus = new ArrayList<Long>();
        for (UccBatchShopQryBo each : reqBo.getShopQry()) {
            skus.add(each.getSkuId());
        }
        List<UccSkuPo> skuPoList = this.uccSkuMapper.qeryBatchSkus(skus);
        Map<Long, Integer> source = skuPoList.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, UccSkuPo::getSkuSource));
        ArrayList<UccBatchShopQryBo> eccomer = new ArrayList<UccBatchShopQryBo>();
        ArrayList<UccBatchShopQryBo> self = new ArrayList<UccBatchShopQryBo>();
        ArrayList<UccBatchShopQryBo> zone = new ArrayList<UccBatchShopQryBo>();
        for (UccBatchShopQryBo each : reqBo.getShopQry()) {
            if (ModelRuleConstant.SKU_SOURCE_SELF_SUPPORT == source.get(each.getSkuId())) {
                self.add(each);
            }
            if (ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT == source.get(each.getSkuId())) {
                eccomer.add(each);
            }
            if (ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION != source.get(each.getSkuId())) continue;
            zone.add(each);
        }
        if (self.size() > 0) {
            sort.put(ModelRuleConstant.SKU_SOURCE_SELF_SUPPORT, this.groupBySupplierShopId(self));
        }
        if (eccomer.size() > 0) {
            sort.put(ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT, this.groupBySupplierShopId(eccomer));
        }
        if (zone.size() > 0) {
            sort.put(ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION, this.groupBySupplierShopId(zone));
        }
        return sort;
    }

    public Map<Long, ArrayList<UccBatchShopQryBo>> groupBySupplierShopId(List<UccBatchShopQryBo> bos) {
        HashMap<Long, ArrayList<UccBatchShopQryBo>> result = new HashMap<Long, ArrayList<UccBatchShopQryBo>>();
        for (UccBatchShopQryBo each : bos) {
            if (result.containsKey(each.getSupplierShopId())) {
                ((ArrayList)result.get(each.getSupplierShopId())).add(each);
                continue;
            }
            ArrayList<UccBatchShopQryBo> data = new ArrayList<UccBatchShopQryBo>();
            data.add(each);
            result.put(each.getSupplierShopId(), data);
        }
        return result;
    }

    private void querySkuProperties(UccBatchShopQryMsgBo sku, Long merchantId) {
        UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
        uccSkuSpecPo.setSkuId(sku.getSkuId());
        uccSkuSpecPo.setSupplierShopId(merchantId);
        List<UccSkuSpecPo> skuSpecPoList = this.uccSkuSpecMapper.querySpec(uccSkuSpecPo);
        if (skuSpecPoList == null || skuSpecPoList.size() == 0) {
            return;
        }
        sku.setSkuProperteis(new ArrayList());
        SaleSkuPropEntityBo bo = null;
        JSONArray properties = new JSONArray();
        JSONObject object = null;
        SaleSkuPropEntityBo entityBo = null;
        for (UccSkuSpecPo each : skuSpecPoList) {
            bo = new SaleSkuPropEntityBo();
            entityBo = new SaleSkuPropEntityBo();
            BeanUtils.copyProperties((Object)each, (Object)bo);
            bo.setShowName(each.getPropShowName());
            sku.getSkuProperteis().add(bo);
            object = new JSONObject();
            object.put(each.getPropShowName(), (Object)each.getPropValue());
            properties.add((Object)object);
        }
        sku.setShowProperties(JSONObject.toJSONString((Object)properties));
    }

    private void queryTaomaoStock(List<UccBatchShopQryMsgBo> list, String area) {
        HashSet<Long> set = new HashSet<Long>();
        Long[] commds = new Long[list.size()];
        for (UccBatchShopQryMsgBo each : list) {
            set.add(each.getCommodityId());
        }
        set.toArray(commds);
        List<UccCommodityPo> poList = this.uccCommodityMapper.qeryBatchCommdity(Arrays.stream(commds).collect(Collectors.toList()));
        Map<Long, String> commditys = poList.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, UccCommodityPo::getExtSkuId));
        UccTmCommdStockQryReqBO reqBO = new UccTmCommdStockQryReqBO();
        ArrayList<UccTmStockBO> itemList = new ArrayList<UccTmStockBO>();
        reqBO.setDivisionCode(area);
        reqBO.setItemList(itemList);
        HashedMap pointer = new HashedMap();
        UccTmStockBO bo = null;
        for (UccBatchShopQryMsgBo each : list) {
            if (pointer.containsKey(each.getCommodityId())) {
                ((UccTmStockBO)itemList.get((Integer)pointer.get(each.getCommodityId()) - 1)).getSkuIdLists().add(Long.parseLong(each.getExtralSkuId()));
                each.setExtSkuId(commditys.get(each.getCommodityId()));
                continue;
            }
            bo = new UccTmStockBO();
            ArrayList<Long> skuList = new ArrayList<Long>();
            bo.setItemId(Long.valueOf(Long.parseLong(commditys.get(each.getCommodityId()))));
            bo.setSkuIdLists(skuList);
            itemList.add(bo);
            if (each.getExtralSkuId().equals(commditys.get(each.getCommodityId()))) {
                skuList.add(-1L);
                each.setExtSkuId(commditys.get(each.getCommodityId()));
                each.setExtralSkuId("-1");
            } else {
                skuList.add(Long.parseLong(each.getExtralSkuId()));
                each.setExtSkuId(commditys.get(each.getCommodityId()));
            }
            pointer.put(each.getCommodityId(), itemList.size());
        }
        UccTmCommdStockQryRspBO uccTmCommdStockQryRspBO = this.uccTmCommdStockQryService.qryStock(reqBO);
        if (uccTmCommdStockQryRspBO.getItemList() == null || uccTmCommdStockQryRspBO.getItemList().size() == 0) {
            LOGGER.error("\u5546\u54c1\u5e93\u5b58\u67e5\u8be2\u8fd4\u56de\u7a7a:" + JSONObject.toJSONString((Object)reqBO));
            for (UccBatchShopQryMsgBo each : list) {
                each.setStock(Integer.valueOf(0));
                each.setStockStateDesc("\u6b64\u5546\u54c1\u533a\u57df\u65e0\u8d27");
                each.setStockStateId(Integer.valueOf(34));
            }
            return;
        }
        if ("0000".equals(uccTmCommdStockQryRspBO.getRespCode())) {
            block5: for (UccBatchShopQryMsgBo each : list) {
                for (CommdStockBO stock : uccTmCommdStockQryRspBO.getItemList()) {
                    try {
                        if (!each.getExtSkuId().equals(stock.getCommdExtSkuId()) || !each.getExtralSkuId().equals(stock.getSkuId())) continue;
                        each.setStock(stock.getRemainNum());
                        continue block5;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                    }
                }
            }
        } else {
            LOGGER.error("\u67e5\u8be2\u5e93\u5b58\u5f02\u5e38\uff1a" + uccTmCommdStockQryRspBO.getRespDesc());
        }
    }
}

