/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.ability.api.UccCommodityListsAbilityService;
import com.tydic.commodity.bo.ability.UccCommodityAndSkusDetailRspBO;
import com.tydic.commodity.bo.ability.UccCommodityInDetailBO;
import com.tydic.commodity.bo.ability.UccCommodityInfoListsReqBO;
import com.tydic.commodity.bo.ability.UccCommodityInfoListsRspBO;
import com.tydic.commodity.bo.ability.UccSkuDetailListInfoBO;
import com.tydic.commodity.bo.ability.UccSkuInfoDetailBO;
import com.tydic.commodity.bo.ability.UccSkusDetailBO;
import com.tydic.commodity.bo.busi.JdPriceBO_busi;
import com.tydic.commodity.bo.busi.NotJdPriceBO_busi;
import com.tydic.commodity.bo.busi.QryCommodityDetailListReqBO;
import com.tydic.commodity.bo.busi.QrySkusDetailListReqBO;
import com.tydic.commodity.bo.busi.SkuNumBO_busi;
import com.tydic.commodity.bo.busi.UccCurrentPriceQryReqBO;
import com.tydic.commodity.bo.busi.UccCurrentPriceQryRspBO;
import com.tydic.commodity.bo.busi.UccCurrentStockQryReqBO;
import com.tydic.commodity.bo.busi.UccCurrentStockQryRspBO;
import com.tydic.commodity.busi.api.UccCommdStockQryBusiService;
import com.tydic.commodity.busi.api.UccCurrentPriceQryBusiService;
import com.tydic.commodity.busi.api.UccQryCommodityDetailListBusiService;
import com.tydic.commodity.busi.api.UccQrySkuDetailListBusiService;
import com.tydic.commodity.dao.UccLabelDealMapper;
import com.tydic.commodity.dao.po.UccLabelPO;
import com.tydic.commodity.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccCommodityListsAbilityService.class)
public class UccCommodityListsAbilityServiceImpl
implements UccCommodityListsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCommodityListsAbilityServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityListsAbilityServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV")
    private UccQryCommodityDetailListBusiService queryCommodityInfoList;
    @Autowired
    private UccQrySkuDetailListBusiService qrySkuDetailListBusiService;
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV")
    private UccCurrentPriceQryBusiService currentPriceQryBusiService;
    @Autowired
    private UccCommdStockQryBusiService uccCommdStockQryBusiService;
    @Autowired
    private UccLabelDealMapper uccLabelDealMapper;
    @Autowired
    private CacheClient cacheClient;

    public UccCommodityInfoListsRspBO queryCommodityListsInfo(UccCommodityInfoListsReqBO reqBO) {
        List<Long> supplierShopIds;
        UccCurrentStockQryRspBO currentStockQryRspBO;
        UccCommodityInfoListsRspBO uccCommodityInfoListsRspBO = new UccCommodityInfoListsRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityDetailListReqBOS()) && CollectionUtils.isEmpty((Collection)reqBO.getSkusDetailListReqBOS())) {
            throw new BusinessException("8888", "\u5546\u54c1\u6216\u5355\u54c1\u5165\u53c2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List qryCommodityDetailListReqBOS = reqBO.getCommodityDetailListReqBOS();
        List qrySkusDetailListReqBOS = reqBO.getSkusDetailListReqBOS();
        if (reqBO.getRootOrgIdIn() != null) {
            if (qryCommodityDetailListReqBOS.size() > 0) {
                for (QryCommodityDetailListReqBO each : qryCommodityDetailListReqBOS) {
                    each.setSupplierShopId(reqBO.getRootOrgIdIn());
                }
            }
            if (qrySkusDetailListReqBOS.size() > 0) {
                for (QryCommodityDetailListReqBO each : qrySkusDetailListReqBOS) {
                    each.setSupplierShopId(reqBO.getRootOrgIdIn());
                }
            }
        }
        ArrayList uccCommodityInDetailBOS = Lists.newArrayList();
        ArrayList uccCommodityAndSkusDetailRspBOS = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)qryCommodityDetailListReqBOS)) {
            StringBuilder sb = null;
            for (QryCommodityDetailListReqBO detailListReqBO : qryCommodityDetailListReqBOS) {
                sb = new StringBuilder();
                sb.append("REDIS_UCC_COMMODITYLISTSABILITY").append(detailListReqBO.getCommodityId());
                Object object = this.cacheClient.get(sb.toString());
                List uccCommodityInDetailBO = new ArrayList();
                if (object != null) {
                    uccCommodityInDetailBO = JSONObject.parseArray((String)JSONObject.toJSONString((Object)object), UccCommodityInDetailBO.class);
                    if (CollectionUtils.isEmpty(uccCommodityInDetailBO)) {
                        uccCommodityInDetailBO = this.queryCommodityInfoList.qryCommodityDetailList(detailListReqBO);
                        this.cacheClient.set(sb.toString(), uccCommodityInDetailBO);
                    }
                } else {
                    uccCommodityInDetailBO = this.queryCommodityInfoList.qryCommodityDetailList(detailListReqBO);
                    this.cacheClient.set(sb.toString(), uccCommodityInDetailBO);
                }
                uccCommodityInDetailBOS.addAll(uccCommodityInDetailBO);
                LOGGER.info("\u5546\u54c1\u6570\u636e" + JSON.toJSONString(uccCommodityInDetailBO));
            }
        }
        ArrayList uccSkuInfoDetailBOS = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)qrySkusDetailListReqBOS)) {
            for (QrySkusDetailListReqBO skusDetailListReqBO : qrySkusDetailListReqBOS) {
                if (reqBO.getOrgIdIn() != null) {
                    skusDetailListReqBO.setOrgIdIn(reqBO.getOrgIdIn());
                }
                List skuInfoDetailBOS = this.qrySkuDetailListBusiService.querySkuDetailList(skusDetailListReqBO);
                uccSkuInfoDetailBOS.addAll(skuInfoDetailBOS);
                LOGGER.info("\u5355\u54c1\u6570\u636e" + JSON.toJSONString((Object)skuInfoDetailBOS));
            }
        }
        UccCurrentPriceQryReqBO currentPriceQryReqBO = new UccCurrentPriceQryReqBO();
        UccCurrentStockQryReqBO uccCurrentStockQryReqBO = new UccCurrentStockQryReqBO();
        ArrayList skuNumBO_busis = Lists.newArrayList();
        ArrayList skuIds = Lists.newArrayList();
        for (Object uccSkuInfoDetailBO : uccSkuInfoDetailBOS) {
            if (!uccSkuInfoDetailBO.getSkuSource().equals(2)) continue;
            SkuNumBO_busi skuNumBO_busi = new SkuNumBO_busi();
            skuIds.add(uccSkuInfoDetailBO.getSkuId());
            skuNumBO_busi.setSkuId(uccSkuInfoDetailBO.getSkuId());
            skuNumBO_busis.add(skuNumBO_busi);
            uccCurrentStockQryReqBO.setSupplierShopId(uccSkuInfoDetailBO.getSupplierShopId());
            currentPriceQryReqBO.setSupplierShopId(uccSkuInfoDetailBO.getSupplierShopId());
        }
        uccCurrentStockQryReqBO.setSkuNum((List)skuNumBO_busis);
        currentPriceQryReqBO.setSkuIds((List)skuIds);
        if (CollectionUtils.isNotEmpty((Collection)skuIds)) {
            UccCurrentPriceQryRspBO uccCurrentPriceQryRspBO = this.currentPriceQryBusiService.changeCommdCurrentPrice(currentPriceQryReqBO);
            if (CollectionUtils.isNotEmpty((Collection)uccCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos())) {
                block5: for (JdPriceBO_busi jdPriceBO_busi : uccCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos()) {
                    for (Object uccSkuInfoDetailB : uccSkuInfoDetailBOS) {
                        if (Long.valueOf(jdPriceBO_busi.getSkuId()).longValue() != uccSkuInfoDetailB.getSkuId().longValue()) continue;
                        if (jdPriceBO_busi.getPrice() == null) {
                            uccSkuInfoDetailB.getSkuInfoPrice().setAgreementPrice(Long.valueOf(0L));
                        } else {
                            uccSkuInfoDetailB.getSkuInfoPrice().setAgreementPrice(Long.valueOf(jdPriceBO_busi.getPrice().multiply(new BigDecimal(10000)).longValue()));
                        }
                        if (jdPriceBO_busi.getMarketprice() == null) {
                            uccSkuInfoDetailB.getSkuInfoPrice().setMarketPrice(Long.valueOf(0L));
                        } else {
                            uccSkuInfoDetailB.getSkuInfoPrice().setMarketPrice(Long.valueOf(jdPriceBO_busi.getMarketprice().multiply(new BigDecimal(10000)).longValue()));
                        }
                        if (jdPriceBO_busi.getNewSalePrice() == null) {
                            uccSkuInfoDetailB.getSkuInfoPrice().setSalePrice(Long.valueOf(0L));
                            continue block5;
                        }
                        uccSkuInfoDetailB.getSkuInfoPrice().setSalePrice(Long.valueOf(jdPriceBO_busi.getNewSalePrice().multiply(new BigDecimal(10000)).longValue()));
                        continue block5;
                    }
                }
            } else if (CollectionUtils.isNotEmpty((Collection)uccCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo())) {
                block7: for (NotJdPriceBO_busi notJdPriceBO_busi : uccCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo()) {
                    for (Object uccSkuInfoDetailB : uccSkuInfoDetailBOS) {
                        if (Long.valueOf(notJdPriceBO_busi.getSkuId()).longValue() != uccSkuInfoDetailB.getSkuId().longValue()) continue;
                        if (notJdPriceBO_busi.getPrice() == null) {
                            uccSkuInfoDetailB.getSkuInfoPrice().setAgreementPrice(Long.valueOf(0L));
                        } else {
                            uccSkuInfoDetailB.getSkuInfoPrice().setAgreementPrice(Long.valueOf(notJdPriceBO_busi.getPrice().multiply(new BigDecimal(10000)).longValue()));
                        }
                        if (notJdPriceBO_busi.getEcPrice() == null) {
                            uccSkuInfoDetailB.getSkuInfoPrice().setMarketPrice(Long.valueOf(0L));
                        } else {
                            uccSkuInfoDetailB.getSkuInfoPrice().setMarketPrice(Long.valueOf(notJdPriceBO_busi.getEcPrice().multiply(new BigDecimal(10000)).longValue()));
                        }
                        if (notJdPriceBO_busi.getNewSalePrice() == null) {
                            uccSkuInfoDetailB.getSkuInfoPrice().setSalePrice(Long.valueOf(0L));
                            continue block7;
                        }
                        uccSkuInfoDetailB.getSkuInfoPrice().setSalePrice(Long.valueOf(notJdPriceBO_busi.getNewSalePrice().multiply(new BigDecimal(10000)).longValue()));
                        continue block7;
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)skuNumBO_busis) && CollectionUtils.isNotEmpty((Collection)(currentStockQryRspBO = this.uccCommdStockQryBusiService.qryStock(uccCurrentStockQryReqBO)).getCommdStockInfo())) {
            block9: for (Object commdStockBO_busi : currentStockQryRspBO.getCommdStockInfo()) {
                for (Object uccSkuInfoDetailB : uccSkuInfoDetailBOS) {
                    if (Long.valueOf(commdStockBO_busi.getSkuId()).longValue() != uccSkuInfoDetailB.getSkuId().longValue()) continue;
                    uccSkuInfoDetailB.getSkuStock().setStockNum(BigDecimal.valueOf(commdStockBO_busi.getRemainNum().intValue()));
                    uccSkuInfoDetailB.getSkuStock().setStockStatusDesc(commdStockBO_busi.getStockStateDesc());
                    uccSkuInfoDetailB.getSkuStock().setStockStatus(commdStockBO_busi.getStockStateId());
                    continue block9;
                }
            }
        }
        for (UccCommodityInDetailBO uccCommodityInDetailBO : uccCommodityInDetailBOS) {
            UccCommodityAndSkusDetailRspBO uccCommodityAndSkusDetailRspBO = new UccCommodityAndSkusDetailRspBO();
            ArrayList uccSkuDetailListInfoBOS = Lists.newArrayList();
            BeanUtils.copyProperties((Object)uccCommodityInDetailBO, (Object)uccCommodityAndSkusDetailRspBO);
            for (UccSkuInfoDetailBO uccSkuInfoDetailBO : uccSkuInfoDetailBOS) {
                if (uccCommodityInDetailBO.getCommodityId().longValue() != uccSkuInfoDetailBO.getCommodityId().longValue()) continue;
                UccSkuDetailListInfoBO uccSkuDetailListInfoBO = new UccSkuDetailListInfoBO();
                BeanUtils.copyProperties((Object)uccSkuInfoDetailBO, (Object)uccSkuDetailListInfoBO);
                uccSkuDetailListInfoBOS.add(uccSkuDetailListInfoBO);
            }
            uccCommodityAndSkusDetailRspBO.setUccSkusDetailBO(new UccSkusDetailBO());
            uccCommodityAndSkusDetailRspBO.getUccSkusDetailBO().setUccSkuDetailListInfoBOList((List)uccSkuDetailListInfoBOS);
            uccCommodityAndSkusDetailRspBOS.add(uccCommodityAndSkusDetailRspBO);
        }
        List<Long> commdIds = uccCommodityAndSkusDetailRspBOS.stream().map(UccCommodityAndSkusDetailRspBO::getCommodityId).collect(Collectors.toList());
        List<UccLabelPO> uccLabelPOS = this.uccLabelDealMapper.selectPoByCommdsAndShopId(commdIds, supplierShopIds = uccCommodityAndSkusDetailRspBOS.stream().map(UccCommodityAndSkusDetailRspBO::getSupplierShopId).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(uccLabelPOS)) {
            Map<Long, List<UccLabelPO>> labelGroupByCommdsMap = uccLabelPOS.stream().collect(Collectors.groupingBy(UccLabelPO::getCommodityId));
            for (UccCommodityAndSkusDetailRspBO each : uccCommodityAndSkusDetailRspBOS) {
                if (!labelGroupByCommdsMap.containsKey(each.getCommodityId())) continue;
                each.setLabelType(labelGroupByCommdsMap.get(each.getCommodityId()).stream().map(UccLabelPO::getLabelType).collect(Collectors.toList()));
            }
        }
        if (reqBO.getRootOrgIdIn() != null && uccCommodityAndSkusDetailRspBOS.size() > 0) {
            for (UccCommodityAndSkusDetailRspBO each : uccCommodityAndSkusDetailRspBOS) {
                each.setSupplierShopId(reqBO.getOrgIdIn());
                if (each.getUccSkusDetailBO().getUccSkuDetailListInfoBOList() == null || each.getUccSkusDetailBO().getUccSkuDetailListInfoBOList().size() <= 0) continue;
                for (UccSkuDetailListInfoBO sku : each.getUccSkusDetailBO().getUccSkuDetailListInfoBOList()) {
                    sku.setSupplierShopId(reqBO.getOrgIdIn());
                }
            }
        }
        uccCommodityInfoListsRspBO.setUccCommodityAndSkusDetailRspBOS((List)uccCommodityAndSkusDetailRspBOS);
        return uccCommodityInfoListsRspBO;
    }

    public BigDecimal dealCurrentPrice(UccCurrentPriceQryReqBO currentPriceQryReqBO) {
        BigDecimal salePrice;
        block5: {
            UccCurrentPriceQryRspBO uccCurrentPriceQryRspBO;
            block4: {
                salePrice = null;
                uccCurrentPriceQryRspBO = this.currentPriceQryBusiService.changeCommdCurrentPrice(currentPriceQryReqBO);
                if (!CollectionUtils.isNotEmpty((Collection)uccCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos())) break block4;
                for (JdPriceBO_busi jdPriceBO_busi : uccCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos()) {
                    if (jdPriceBO_busi.getNewSalePrice() == null) {
                        salePrice = BigDecimal.ZERO;
                        continue;
                    }
                    salePrice = jdPriceBO_busi.getNewSalePrice();
                }
                break block5;
            }
            if (!CollectionUtils.isNotEmpty((Collection)uccCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo())) break block5;
            for (NotJdPriceBO_busi notJdPriceBO_busi : uccCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo()) {
                if (notJdPriceBO_busi.getNewSalePrice() == null) {
                    salePrice = BigDecimal.ZERO;
                    continue;
                }
                salePrice = notJdPriceBO_busi.getNewSalePrice();
            }
        }
        return salePrice;
    }
}

