/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.ability.api.UccCommodityOverviewAbilityService;
import com.tydic.commodity.bo.ability.CommodityOverviewBO;
import com.tydic.commodity.bo.ability.UccCommodityOverviewReqBO;
import com.tydic.commodity.bo.ability.UccCommodityOverviewRspBO;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.dao.po.CommodityOverviewPO;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.util.ListCloneUtils;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccCommodityOverviewAbilityService.class)
public class UccCommodityOverviewAbilityServiceImpl
implements UccCommodityOverviewAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCommodityOverviewAbilityServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityOverviewAbilityServiceImpl.class);
    @Autowired
    private UccCommodityMapper commodityMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    private static final int STATUS_LOSE_EFFICACY = 4;

    public UccCommodityOverviewRspBO qryCommodityList(UccCommodityOverviewReqBO reqBO) {
        UccCommodityOverviewRspBO rspBO;
        block14: {
            List<SupplierShopPo> supplierShopPos;
            Integer[] commodityStatus;
            rspBO = new UccCommodityOverviewRspBO();
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            if (reqBO.getStatus() == 1) {
                commodityStatus = new Integer[]{3};
                reqBO.setCommodityStatus(commodityStatus);
            } else {
                commodityStatus = new Integer[]{0, 2, 4, 5, 7, 8};
                reqBO.setCommodityStatus(commodityStatus);
            }
            if (reqBO.getMaxCurrentPrice() != null) {
                reqBO.setMaxCurrentPrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getMaxCurrentPrice()));
            }
            if (reqBO.getMinCurrentPrice() != null) {
                reqBO.setMinCurrentPrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getMinCurrentPrice()));
            }
            if (null != reqBO.getBaseType() && reqBO.getBaseType() == 1 && StringUtils.isNumeric((String)reqBO.getBaseConditions())) {
                LOGGER.info("\u8fdb\u5165baseType\u67e5\u8be2\u6761\u4ef6\u5224\u65ad");
                reqBO.setBaseType(Integer.valueOf(3));
            }
            LOGGER.info("baseType\u67e5\u8be2\u6761\u4ef6\u662f->:" + reqBO.getBaseType());
            if (reqBO.getOrgIdIn() != null) {
                reqBO.setSupplierId(reqBO.getOrgIdIn());
            }
            if (reqBO.getRootOrgIdIn() != null) {
                reqBO.setSupplierId(reqBO.getRootOrgIdIn());
            }
            if (reqBO.getSupplierId() != null && CollectionUtils.isNotEmpty(supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId()))) {
                reqBO.setQuerySupplierShopId(supplierShopPos.stream().map(supplierShopPo -> String.valueOf(supplierShopPo.getSupplierShopId())).collect(Collectors.joining(",")));
            }
            List<CommodityOverviewPO> commodityOverviewPOList = this.commodityMapper.queryCommodityListPage((Page<CommodityOverviewPO>)page, reqBO);
            try {
                List commodityOverviewBOS = ListCloneUtils.clonePOListToBOListNotDate(commodityOverviewPOList, CommodityOverviewBO.class);
                rspBO.setRows(commodityOverviewBOS);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setPageNo(page.getPageNo());
                rspBO.setRecordsTotal(page.getTotalCount());
                rspBO.setTotal(page.getTotalPages());
            }
            catch (Exception e) {
                LOGGER.error("\u67e5\u8be2\u5546\u54c1\u603b\u89c8\u5931\u8d25\uff0c\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5931\u8d25");
                return rspBO;
            }
            if (reqBO.getRootOrgIdIn() == null || reqBO.getOrgIdIn() == null) break block14;
            List<SupplierShopPo> supplierShopPos2 = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getOrgIdIn());
            if (supplierShopPos2 != null && supplierShopPos2.size() > 0) {
                for (Object each : rspBO.getRows()) {
                    CommodityOverviewBO a = (CommodityOverviewBO)each;
                    a.setSupplierShopId(supplierShopPos2.get(0).getSupplierShopId());
                    a.setShopName(supplierShopPos2.get(0).getShopName());
                }
            } else {
                LOGGER.error("\u5546\u54c1\u603b\u89c8\u670d\u52a1sas\u5316\uff1borginId:" + reqBO.getOrgIdIn() + "\u4e0d\u5b58\u5728");
                for (Object each : rspBO.getRows()) {
                    CommodityOverviewBO a = (CommodityOverviewBO)each;
                    a.setSupplierShopId(reqBO.getOrgIdIn());
                }
            }
        }
        return rspBO;
    }
}

