/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.ability.api.UccCommodityOverviewDownLoadAbilityService;
import com.tydic.commodity.bo.ability.CommodityOverviewDownLoadBO;
import com.tydic.commodity.bo.ability.UccCommodityOverviewDownLoadReqBO;
import com.tydic.commodity.bo.ability.UccCommodityOverviewDownLoadRspBO;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.CommodityOverviewDownLoadDetailPO;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.util.ListCloneUtils;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccCommodityOverviewDownLoadAbilityService.class)
public class UccCommodityOverviewDownLoadAbilityServiceImpl
implements UccCommodityOverviewDownLoadAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(UccCommodityOverviewDownLoadAbilityServiceImpl.class);
    private final Boolean IS_DEBUGENABLED = LOG.isDebugEnabled();
    @Autowired
    private UccCommodityMapper commodityMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;

    public UccCommodityOverviewDownLoadRspBO dealCommodityOverviewDownLoad(UccCommodityOverviewDownLoadReqBO uccCommodityOverviewDownLoadReqBo) {
        List<SupplierShopPo> supplierShopPos;
        Integer[] commodityStatus;
        UccCommodityOverviewDownLoadRspBO uccCommodityOverviewDownLoadRspBo = new UccCommodityOverviewDownLoadRspBO();
        Page page = new Page(uccCommodityOverviewDownLoadReqBo.getPageNo(), uccCommodityOverviewDownLoadReqBo.getPageSize());
        if (uccCommodityOverviewDownLoadReqBo.getStatus() == 1) {
            commodityStatus = new Integer[]{3};
            uccCommodityOverviewDownLoadReqBo.setCommodityStatus(commodityStatus);
        } else {
            commodityStatus = new Integer[]{0, 2, 4, 5, 7, 8};
            uccCommodityOverviewDownLoadReqBo.setCommodityStatus(commodityStatus);
        }
        if (uccCommodityOverviewDownLoadReqBo.getMaxCurrentPrice() != null) {
            uccCommodityOverviewDownLoadReqBo.setMaxCurrentPrice(MoneyUtils.yuanToHao((BigDecimal)uccCommodityOverviewDownLoadReqBo.getMaxCurrentPrice()));
        }
        if (uccCommodityOverviewDownLoadReqBo.getMinCurrentPrice() != null) {
            uccCommodityOverviewDownLoadReqBo.setMinCurrentPrice(MoneyUtils.yuanToHao((BigDecimal)uccCommodityOverviewDownLoadReqBo.getMinCurrentPrice()));
        }
        if (null != uccCommodityOverviewDownLoadReqBo.getBaseType() && uccCommodityOverviewDownLoadReqBo.getBaseType() == 1 && StringUtils.isNumeric((String)uccCommodityOverviewDownLoadReqBo.getBaseConditions())) {
            LOG.info("\u8fdb\u5165baseType\u67e5\u8be2\u6761\u4ef6\u5224\u65ad");
            uccCommodityOverviewDownLoadReqBo.setBaseType(Integer.valueOf(3));
        }
        LOG.info("baseType\u67e5\u8be2\u6761\u4ef6\u662f->:" + uccCommodityOverviewDownLoadReqBo.getBaseType());
        if (uccCommodityOverviewDownLoadReqBo.getOrgIdIn() != null) {
            uccCommodityOverviewDownLoadReqBo.setSupplierId(uccCommodityOverviewDownLoadReqBo.getOrgIdIn());
        }
        if (uccCommodityOverviewDownLoadReqBo.getRootOrgIdIn() != null) {
            uccCommodityOverviewDownLoadReqBo.setSupplierId(uccCommodityOverviewDownLoadReqBo.getRootOrgIdIn());
        }
        if (uccCommodityOverviewDownLoadReqBo.getSupplierId() != null && CollectionUtils.isNotEmpty(supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(uccCommodityOverviewDownLoadReqBo.getSupplierId()))) {
            uccCommodityOverviewDownLoadReqBo.setQuerySupplierShopId(supplierShopPos.stream().map(supplierShopPo -> String.valueOf(supplierShopPo.getSupplierShopId())).collect(Collectors.joining(",")));
        }
        List<CommodityOverviewDownLoadDetailPO> commodityOverviewPoList = this.commodityMapper.queryCommodityDownLoadListPage((Page<CommodityOverviewDownLoadDetailPO>)page, uccCommodityOverviewDownLoadReqBo);
        try {
            List commodityOverviewDownLoadBos = ListCloneUtils.clonePOListToBOListNotDate(commodityOverviewPoList, CommodityOverviewDownLoadBO.class);
            uccCommodityOverviewDownLoadRspBo.setRows(commodityOverviewDownLoadBos);
            uccCommodityOverviewDownLoadRspBo.setRespCode("0000");
            uccCommodityOverviewDownLoadRspBo.setRespDesc("\u6210\u529f");
            uccCommodityOverviewDownLoadRspBo.setPageNo(page.getPageNo());
            uccCommodityOverviewDownLoadRspBo.setRecordsTotal(page.getTotalCount());
            uccCommodityOverviewDownLoadRspBo.setTotal(page.getTotalPages());
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u5546\u54c1\u603b\u89c8\u4e0b\u8f7d\u6570\u636e\u5931\u8d25\uff0c\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
            uccCommodityOverviewDownLoadRspBo.setRespCode("8888");
            uccCommodityOverviewDownLoadRspBo.setRespDesc("\u5931\u8d25");
            return uccCommodityOverviewDownLoadRspBo;
        }
        return uccCommodityOverviewDownLoadRspBo;
    }
}

