/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.google.common.collect.Lists;
import com.tydic.commodity.ability.api.UccCommodityListsAbilityService;
import com.tydic.commodity.ability.api.UccSynchronizeCMSInfoService;
import com.tydic.commodity.bo.ability.AddCmsArticelSkuBO;
import com.tydic.commodity.bo.ability.UccSyncCmsInfoReqBo;
import com.tydic.commodity.bo.ability.UccSyncCmsInfoRspBO;
import com.tydic.commodity.bo.busi.CMSSkuInfoBO;
import com.tydic.commodity.bo.busi.QrySkuCMSInfoReqBO;
import com.tydic.commodity.bo.busi.QrySkuCMSInfoRspBO;
import com.tydic.commodity.bo.busi.UccCurrentPriceQryReqBO;
import com.tydic.commodity.busi.api.UccQrySkuCMSInfoService;
import com.tydic.commodity.config.vo.CommdProPertiesVo;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.enumType.CmsSkuColumnNameEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.AddCmsArticelSkuInfoBO;
import com.tydic.commodity.external.bo.UccAddCmsArticelSkuInfoReqBO;
import com.tydic.commodity.external.bo.UccAddCmsArticelSkuInfoRspBO;
import com.tydic.commodity.external.bo.UccRemoveSkuInfoReqBO;
import com.tydic.commodity.external.bo.UccRemoveSkuInfoRspBO;
import com.tydic.commodity.external.service.UccAddMultiArticleService;
import com.tydic.commodity.external.service.UccRemoveCmsSkuInfoService;
import com.tydic.commodity.util.ListCloneUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccSynchronizeCMSInfoService.class)
public class UccSynchronizeCMSInfoServiceImpl
implements UccSynchronizeCMSInfoService {
    private static final Logger log = LoggerFactory.getLogger(UccSynchronizeCMSInfoServiceImpl.class);
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(UccSynchronizeCMSInfoServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV")
    private UccQrySkuCMSInfoService qrySkuCMSInfoService;
    @Autowired
    private UccRemoveCmsSkuInfoService uccRemoveCmsSkuInfoService;
    @Autowired
    private CommdProPertiesVo commdProPertiesVo;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV")
    private UccCommodityListsAbilityService commodityListsAbilityService;
    @Autowired
    private UccAddMultiArticleService uccAddMultiArticleService;

    public UccSyncCmsInfoRspBO sync(UccSyncCmsInfoReqBo syncCmsInfoReqBo) {
        UccSyncCmsInfoRspBO uccSyncCmsInfoRspBO = new UccSyncCmsInfoRspBO();
        QrySkuCMSInfoReqBO qrySkuCMSInfoReqBO = new QrySkuCMSInfoReqBO();
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(CmsSkuColumnNameEnum.bgsb.code());
        arrayList.add(CmsSkuColumnNameEnum.bgyp.code());
        arrayList.add(CmsSkuColumnNameEnum.dnzj.code());
        arrayList.add(CmsSkuColumnNameEnum.ghyp.code());
        arrayList.add(CmsSkuColumnNameEnum.rzyp.code());
        UccRemoveSkuInfoReqBO uccRemoveSkuInfoReqBO = new UccRemoveSkuInfoReqBO();
        uccRemoveSkuInfoReqBO.setColumnCode((List)arrayList);
        uccRemoveSkuInfoReqBO.setUrl(this.commdProPertiesVo.getDelArticleByColumnCodeUrl());
        UccRemoveSkuInfoRspBO uccRemoveSkuInfoRspBO = this.uccRemoveCmsSkuInfoService.removeCmsSkuInfo(uccRemoveSkuInfoReqBO);
        if (!uccRemoveSkuInfoRspBO.isSuccess()) {
            LOGGER.error("\u5220\u9664cms\u680f\u76ee\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a", (Object)uccRemoveSkuInfoRspBO.getRespDesc());
            uccSyncCmsInfoRspBO.setRespCode("8888");
            uccSyncCmsInfoRspBO.setRespDesc(uccRemoveSkuInfoRspBO.getRespDesc());
            return uccSyncCmsInfoRspBO;
        }
        qrySkuCMSInfoReqBO.setArrayList((List)arrayList);
        QrySkuCMSInfoRspBO qrySkuCMSInfoRspBO = null;
        try {
            qrySkuCMSInfoRspBO = this.qrySkuCMSInfoService.qrySkuCMSInfo(qrySkuCMSInfoReqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636ecms \u914d\u7f6e\u67e5\u8be2sku\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            uccSyncCmsInfoRspBO.setRespCode("8888");
            uccSyncCmsInfoRspBO.setRespDesc("\u6839\u636ecms \u914d\u7f6e\u67e5\u8be2sku\u4fe1\u606f\u5931\u8d25");
            return uccSyncCmsInfoRspBO;
        }
        try {
            this.sendAddMultiArticleAction(qrySkuCMSInfoRspBO);
        }
        catch (BusinessException e) {
            uccSyncCmsInfoRspBO.setRespCode(e.getMsgCode());
            uccSyncCmsInfoRspBO.setRespDesc(e.getMsgInfo());
            return uccSyncCmsInfoRspBO;
        }
        uccRemoveSkuInfoReqBO = new UccRemoveSkuInfoReqBO();
        ArrayList stringArrayList = Lists.newArrayList();
        stringArrayList.add(CmsSkuColumnNameEnum.shop.code());
        uccRemoveSkuInfoReqBO.setColumnCode((List)stringArrayList);
        uccRemoveSkuInfoReqBO.setUrl(this.commdProPertiesVo.getDelArticleByColumnCodeUrl());
        UccRemoveSkuInfoRspBO removeSkuInfoRspBO = this.uccRemoveCmsSkuInfoService.removeCmsSkuInfo(uccRemoveSkuInfoReqBO);
        if (!removeSkuInfoRspBO.isSuccess()) {
            LOGGER.error("\u5220\u9664cms\u7535\u5b50\u8d85\u5e02\u7236\u7ea7\u680f\u76ee\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a", (Object)uccRemoveSkuInfoRspBO.getRespDesc());
            uccSyncCmsInfoRspBO.setRespCode("8888");
            uccSyncCmsInfoRspBO.setRespDesc(uccRemoveSkuInfoRspBO.getRespDesc());
            return uccSyncCmsInfoRspBO;
        }
        uccSyncCmsInfoRspBO.setRespCode("0000");
        uccSyncCmsInfoRspBO.setRespDesc("\u6210\u529f");
        return uccSyncCmsInfoRspBO;
    }

    private void sendAddMultiArticleAction(QrySkuCMSInfoRspBO qrySkuCMSInfoRspBO) {
        if (CollectionUtils.isEmpty((Collection)qrySkuCMSInfoRspBO.getCmsSkuInfoBOS())) {
            LOGGER.error("CMS\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728");
            throw new BusinessException("8888", "CMS\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Map<String, List<CMSSkuInfoBO>> groupBy = qrySkuCMSInfoRspBO.getCmsSkuInfoBOS().stream().collect(Collectors.groupingBy(CMSSkuInfoBO::getColumnCode));
        try {
            for (Map.Entry<String, List<CMSSkuInfoBO>> stringListEntry : groupBy.entrySet()) {
                List<CMSSkuInfoBO> cmsSkuInfoBOS = stringListEntry.getValue();
                this.doSendAddMultiArticleAction(cmsSkuInfoBOS);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589ecms\u5546\u54c1\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new BusinessException("8888", "\u65b0\u589ecms\u5546\u54c1\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private void doSendAddMultiArticleAction(List<CMSSkuInfoBO> cmsSkuInfoBOS) {
        List addCmsArticelSkuInfoBOS;
        List<AddCmsArticelSkuBO> addCmsArticelSkuBOS = this.getSkuInfo(cmsSkuInfoBOS);
        UccAddCmsArticelSkuInfoReqBO uccAddCmsArticelSkuInfoReqBO = new UccAddCmsArticelSkuInfoReqBO();
        uccAddCmsArticelSkuInfoReqBO.setUrl(this.commdProPertiesVo.getAddMultiArticleActionUrl());
        try {
            addCmsArticelSkuInfoBOS = ListCloneUtils.clonePOListToBOList(addCmsArticelSkuBOS, AddCmsArticelSkuInfoBO.class);
            CMSSkuInfoBO cmsSkuInfoBO = cmsSkuInfoBOS.get(0);
            for (AddCmsArticelSkuInfoBO addCmsArticelSkuInfoBO : addCmsArticelSkuInfoBOS) {
                addCmsArticelSkuInfoBO.setBasicTitle(cmsSkuInfoBO.getColumnName());
                addCmsArticelSkuInfoBO.setColumnCode(cmsSkuInfoBO.getColumnCode());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0cms \u6587\u7ae0\u6570\u636e\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("8888", "\u6dfb\u52a0cms \u6587\u7ae0\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
        }
        uccAddCmsArticelSkuInfoReqBO.setCmsArticelSkuInfoBOS(addCmsArticelSkuInfoBOS);
        UccAddCmsArticelSkuInfoRspBO uccAddCmsArticelSkuInfoRspBO = this.uccAddMultiArticleService.AddSkuMultiArticle(uccAddCmsArticelSkuInfoReqBO);
        if (!uccAddCmsArticelSkuInfoRspBO.isSuccess()) {
            LOGGER.error("\u53d1\u9001http\u65b0\u589ecms\u5546\u54c1\u4fe1\u606f\u5931\u8d25,\u539f\u56e0:", (Object)uccAddCmsArticelSkuInfoRspBO.getRespDesc());
            throw new BusinessException(uccAddCmsArticelSkuInfoRspBO.getRespCode(), uccAddCmsArticelSkuInfoRspBO.getRespDesc());
        }
    }

    private List<AddCmsArticelSkuBO> getSkuInfo(List<CMSSkuInfoBO> cmsSkuInfoBOS) {
        ArrayList skuIds = Lists.newArrayList();
        for (CMSSkuInfoBO cmsSkuInfoBO : cmsSkuInfoBOS) {
            skuIds.add(Long.valueOf(cmsSkuInfoBO.getSkuId()));
        }
        UccCurrentPriceQryReqBO uccCurrentPriceQryReqBO = null;
        List<AddCmsArticelSkuBO> commodityPos = this.uccCommodityMapper.batchQueryCommoBySkuId(skuIds);
        if (CollectionUtils.isEmpty(commodityPos)) {
            LOGGER.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5230cms\uff0c\u67e5\u8be2\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728,skuIDS:" + skuIds);
            return commodityPos;
        }
        for (AddCmsArticelSkuBO commodityPo : commodityPos) {
            ArrayList<Long> arrayLists = new ArrayList<Long>();
            uccCurrentPriceQryReqBO = new UccCurrentPriceQryReqBO();
            arrayLists.add(commodityPo.getSkuId());
            if (StringUtils.isNotBlank((CharSequence)commodityPo.getSkuName())) {
                commodityPo.setSkuName(commodityPo.getSkuName().replaceAll("'", ""));
                commodityPo.setSkuName(commodityPo.getSkuName().replaceAll("<", ""));
                commodityPo.setSkuName(commodityPo.getSkuName().replaceAll(">", ""));
                commodityPo.setSkuName(commodityPo.getSkuName().replaceAll("\"", ""));
            }
            uccCurrentPriceQryReqBO.setSkuIds(arrayLists);
            uccCurrentPriceQryReqBO.setSupplierShopId(commodityPo.getSupplierShopId());
            BigDecimal skuInfoPriceBos = this.commodityListsAbilityService.dealCurrentPrice(uccCurrentPriceQryReqBO);
            commodityPo.setSalePrice(skuInfoPriceBos);
        }
        return commodityPos;
    }
}

