/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.atom.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.bo.busi.CommodityCategoryForEsBO;
import com.tydic.commodity.bo.busi.CommodityForEsBO;
import com.tydic.commodity.bo.busi.CommoditySpecForEsBO;
import com.tydic.commodity.bo.busi.DeleteSpuInfoFromEsBO;
import com.tydic.commodity.bo.busi.EsStorageSpuInfoBO;
import com.tydic.commodity.bo.busi.SkuForEsBO;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsRspBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSceneSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.dao.po.UccCatalogDealPO;
import com.tydic.commodity.dao.po.UccSaleNumPo;
import com.tydic.commodity.dao.po.UccSceneSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuPicPo;
import com.tydic.commodity.dao.po.UccSkuStockPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.search.SearchCommodityService;
import com.tydic.commodity.search.bo.CommodityRspBo;
import com.tydic.commodity.search.bo.SearchEsReqBO;
import com.tydic.commodity.search.bo.SearchEsRspBo;
import com.tydic.commodity.search.config.ElasticsearchUtil;
import com.tydic.commodity.search.config.EsConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="syncSceneCommodityToEsAtomService")
public class SyncSceneCommodityToEsAtomServiceImpl
implements SyncSceneCommodityToEsAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncSceneCommodityToEsAtomServiceImpl.class);
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    private UccCommodityMapper uccCommodityMapper;
    private UccSkuMapper uccSkuMapper;
    private UccSkuStockMapper uccSkuStockMapper;
    private UccSaleNumMapper uccSaleNumMapper;
    private UccSkuPicMapper uccSkuPicMapper;
    private UccSpuSpecMapper uccSpuSpecMapper;
    private UccCatalogDealMapper uccCatalogDealMapper;
    private ElasticsearchUtil elasticsearchUtil;
    private EsConfig esConfig;
    private SearchCommodityService searchCommodityService;
    @Autowired
    private UccSceneSkuPriceMapper uccSceneSkuPriceMapper;

    @Autowired
    public SyncSceneCommodityToEsAtomServiceImpl(UccCommodityTypeMapper uccCommodityTypeMapper, UccCommodityMapper uccCommodityMapper, UccSkuMapper uccSkuMapper, UccSkuStockMapper uccSkuStockMapper, UccSaleNumMapper uccSaleNumMapper, UccSkuPicMapper uccSkuPicMapper, UccSpuSpecMapper uccSpuSpecMapper, UccCatalogDealMapper uccCatalogDealMapper, ElasticsearchUtil elasticsearchUtil, EsConfig esConfig, SearchCommodityService searchCommodityService) {
        this.uccCommodityTypeMapper = uccCommodityTypeMapper;
        this.uccCommodityMapper = uccCommodityMapper;
        this.uccSkuMapper = uccSkuMapper;
        this.uccSkuStockMapper = uccSkuStockMapper;
        this.uccSaleNumMapper = uccSaleNumMapper;
        this.uccSkuPicMapper = uccSkuPicMapper;
        this.uccSpuSpecMapper = uccSpuSpecMapper;
        this.uccCatalogDealMapper = uccCatalogDealMapper;
        this.elasticsearchUtil = elasticsearchUtil;
        this.esConfig = esConfig;
        this.searchCommodityService = searchCommodityService;
    }

    @Override
    public SyncSceneCommodityToEsRspBO syncSceneCommodityToEs(SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO) {
        SyncSceneCommodityToEsRspBO rspBO = new SyncSceneCommodityToEsRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u573a\u666fES\u540c\u6b65\u6210\u529f!");
        this.validateReqParams(syncSceneCommodityToEsReqBO);
        if (ModelRuleConstant.OPER_ES_ADD_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.syncCommodityToEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.OPER_ES_DELETE_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.deleteCommodityInfoFromEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.OPER_ES_UPDATE_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.updateCommodityToEs(syncSceneCommodityToEsReqBO);
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u573a\u666fES\u540c\u6b65\u5931\u8d25\uff1aES\u64cd\u4f5c\u7c7b\u578b[" + syncSceneCommodityToEsReqBO.getOperType() + "]\u6682\u4e0d\u652f\u6301!");
        }
        return rspBO;
    }

    private void syncCommodityToEs(SyncSceneCommodityToEsReqBO reqBO) {
        List<CommodityForEsBO> commodityForEsBOS = this.qryCommodityList(reqBO);
        if (commodityForEsBOS == null || commodityForEsBOS.isEmpty()) {
            LOGGER.error("\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u573a\u666f[" + reqBO.getSceneId() + "]\u4e0b\u5173\u8054\u7684\u5173\u8054\u5546\u54c1\u6570\u636e!");
            return;
        }
        List<Long> commodityIds = commodityForEsBOS.stream().map(CommodityForEsBO::getCommodityId).collect(Collectors.toList());
        ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
        this.assemblyEsSkuInfo(reqBO, commodityIds, esStorageSpuInfoBOS);
        this.assemblyEsCommodityAndCategoryInfo(reqBO, commodityIds, esStorageSpuInfoBOS, commodityForEsBOS);
        this.syncCommodityInfoToEs(esStorageSpuInfoBOS);
    }

    private void deleteCommodityInfoFromEs(SyncSceneCommodityToEsReqBO reqBO) {
        List<CommodityForEsBO> commodityForEsBOS = this.qryCommodityList(reqBO);
        if (commodityForEsBOS == null || commodityForEsBOS.isEmpty()) {
            LOGGER.error("\u4eceES\u5220\u9664\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u573a\u666f[" + reqBO.getSceneId() + "]\u4e0b\u5173\u8054\u7684\u5546\u54c1\u6570\u636e!");
            return;
        }
        List commodityIds = commodityForEsBOS.stream().map(CommodityForEsBO::getCommodityId).collect(Collectors.toList());
        ArrayList<DeleteSpuInfoFromEsBO> deleteSpuInfoFromEsBOS = new ArrayList<DeleteSpuInfoFromEsBO>();
        Long sceneId = reqBO.getSceneId();
        for (Long commodityId : commodityIds) {
            DeleteSpuInfoFromEsBO deleteSpuInfoFromEsBO = new DeleteSpuInfoFromEsBO();
            deleteSpuInfoFromEsBO.setSceneId(sceneId);
            deleteSpuInfoFromEsBO.setCommodityId(commodityId);
            deleteSpuInfoFromEsBOS.add(deleteSpuInfoFromEsBO);
        }
        this.deleteSpuInfoFromEs(deleteSpuInfoFromEsBOS);
    }

    private void updateCommodityToEs(SyncSceneCommodityToEsReqBO reqBO) {
        List<CommodityForEsBO> commodityForEsBOS = this.qryCommodityList(reqBO);
        if (commodityForEsBOS == null || commodityForEsBOS.isEmpty()) {
            LOGGER.error("\u66f4\u65b0ES\u4e0b\u7684\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u573a\u666f[" + reqBO.getSceneId() + "]\u4e0b\u5173\u8054\u7684\u5546\u54c1\u6570\u636e!");
            return;
        }
        List commodityIds = commodityForEsBOS.stream().map(CommodityForEsBO::getCommodityId).collect(Collectors.toList());
        SearchEsReqBO searchEsReqBO = new SearchEsReqBO();
        searchEsReqBO.setCommdIds(commodityIds);
        searchEsReqBO.setSceneId(reqBO.getSceneId());
        SearchEsRspBo searchEsRspBo = this.searchCommodityService.queryByMatch(searchEsReqBO);
        List<Long> esExistCommodityIds = null;
        if (searchEsRspBo != null && searchEsRspBo.getCommodityRspBos() != null && !searchEsRspBo.getCommodityRspBos().isEmpty()) {
            List commodityRspBos = searchEsRspBo.getCommodityRspBos();
            esExistCommodityIds = commodityRspBos.stream().map(CommodityRspBo::getCommodity_id).collect(Collectors.toList());
        }
        if (esExistCommodityIds == null || esExistCommodityIds.isEmpty()) {
            return;
        }
        ArrayList<CommodityForEsBO> newCommodityForEsBOS = new ArrayList<CommodityForEsBO>();
        for (CommodityForEsBO commodityForEsBO : commodityForEsBOS) {
            if (!esExistCommodityIds.contains(commodityForEsBO.getCommodityId())) continue;
            newCommodityForEsBOS.add(commodityForEsBO);
        }
        ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
        this.assemblyEsSkuInfo(reqBO, esExistCommodityIds, esStorageSpuInfoBOS);
        this.assemblyEsCommodityAndCategoryInfo(reqBO, esExistCommodityIds, esStorageSpuInfoBOS, newCommodityForEsBOS);
        this.syncCommodityInfoToEs(esStorageSpuInfoBOS);
    }

    private List<CommodityForEsBO> qryCommodityList(SyncSceneCommodityToEsReqBO reqBO) {
        List<CommodityForEsBO> commodityForEsBOS = null;
        if (ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID.equals(reqBO.getSyncType())) {
            List<Long> commodityTypeIds = this.uccCommodityTypeMapper.qryCommodityTypeIdsByCategorys(reqBO.getCategoryIds());
            if (commodityTypeIds == null || commodityTypeIds.isEmpty()) {
                throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u7c7b\u76ee\u5173\u8054\u7684\u5546\u54c1\u7c7b\u578b\u6570\u636e!");
            }
            commodityForEsBOS = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(commodityTypeIds, null, reqBO.getRootOrgIdIn(), reqBO.getSceneId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType())) {
            commodityForEsBOS = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(null, reqBO.getCommodityIds(), reqBO.getRootOrgIdIn(), reqBO.getSceneId());
        }
        return commodityForEsBOS;
    }

    private void assemblyEsSkuInfo(SyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        List<SkuForEsBO> skuForEsBOS = this.uccSkuMapper.qrySkuAndLowPriceList(reqBO.getRootOrgIdIn(), commodityIds);
        if (skuForEsBOS == null || skuForEsBOS.isEmpty()) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4e0b\u5173\u8054\u7684\u5355\u54c1\u6570\u636e!");
        }
        List<Long> skuIds = skuForEsBOS.stream().map(SkuForEsBO::getSkuId).collect(Collectors.toList());
        List<UccSceneSkuPricePo> uccSceneSkuPricePos = this.uccSceneSkuPriceMapper.qrySKuBySceneandsku(skuIds, reqBO.getSceneId(), 1);
        if (!CollectionUtils.isEmpty(uccSceneSkuPricePos)) {
            Map<Long, UccSceneSkuPricePo> sceneSkuPriceMap = uccSceneSkuPricePos.stream().collect(Collectors.toMap(UccSceneSkuPricePo::getSkuId, UccSceneSkuPricePo2 -> UccSceneSkuPricePo2));
            for (SkuForEsBO each : skuForEsBOS) {
                if (!sceneSkuPriceMap.containsKey(each.getSkuId())) continue;
                each.setSalePrice(sceneSkuPriceMap.get(each.getSkuId()).getSalePrice());
                each.setMarketPrice(sceneSkuPriceMap.get(each.getSkuId()).getMarketPrice());
            }
            sceneSkuPriceMap = null;
        }
        List<UccSkuStockPo> skuStockPos = this.uccSkuStockMapper.batchQryById(skuIds, reqBO.getRootOrgIdIn());
        Map<Long, UccSkuStockPo> skuStockPoMap = skuStockPos.stream().collect(Collectors.toMap(UccSkuStockPo::getSkuId, uccSkuStockPo -> uccSkuStockPo));
        List<UccSaleNumPo> saleNumPos = this.uccSaleNumMapper.qryBySkuIds(skuIds);
        Map<Long, UccSaleNumPo> saleNumPoMap = saleNumPos.stream().collect(Collectors.toMap(UccSaleNumPo::getSkuId, uccSaleNumPo -> uccSaleNumPo));
        List<UccSkuPicPo> skuPicPos = this.uccSkuPicMapper.qeurySkuPicBySkuId(skuIds);
        Map<Long, UccSkuPicPo> skuPicPoMap = skuPicPos.stream().collect(Collectors.toMap(UccSkuPicPo::getSkuId, uccSkuPicPo -> uccSkuPicPo));
        this.buildEsSku(esStorageSpuInfoBOS, skuForEsBOS, skuStockPoMap, saleNumPoMap, skuPicPoMap);
    }

    private void buildEsSku(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS, List<SkuForEsBO> skuForEsBOS, Map<Long, UccSkuStockPo> skuStockPoMap, Map<Long, UccSaleNumPo> saleNumPoMap, Map<Long, UccSkuPicPo> skuPicPoMap) {
        for (SkuForEsBO skuForEsBO : skuForEsBOS) {
            UccSkuPicPo uccSkuPicPo;
            UccSaleNumPo uccSaleNumPo;
            UccSkuStockPo uccSkuStockPo;
            EsStorageSpuInfoBO esStorageSpuInfoBO = new EsStorageSpuInfoBO();
            esStorageSpuInfoBO.setCommodity_id(skuForEsBO.getCommodityId());
            esStorageSpuInfoBO.setSku_id(skuForEsBO.getSkuId());
            esStorageSpuInfoBO.setSku_name(skuForEsBO.getSkuName());
            esStorageSpuInfoBO.setExt_sku_id(skuForEsBO.getExtSkuId());
            esStorageSpuInfoBO.setBrand_id(skuForEsBO.getBrandId());
            esStorageSpuInfoBO.setBrand_name(skuForEsBO.getBrandName());
            esStorageSpuInfoBO.setSku_status(skuForEsBO.getSkuStatus());
            esStorageSpuInfoBO.setSku_source(skuForEsBO.getSkuSource());
            esStorageSpuInfoBO.setMfgsku(skuForEsBO.getMfgsku());
            esStorageSpuInfoBO.setUpc(skuForEsBO.getUpcCode());
            esStorageSpuInfoBO.setOn_shelve_time(Long.valueOf(DateUtils.strToDateLong((String)skuForEsBO.getOnShelveTime()).getTime()));
            esStorageSpuInfoBO.setAgreement_id(skuForEsBO.getAgreementId());
            esStorageSpuInfoBO.setSale_price(Double.valueOf(skuForEsBO.getSalePrice().longValue()));
            esStorageSpuInfoBO.setAgreement_price(Double.valueOf(skuForEsBO.getAgreementPrice().longValue()));
            esStorageSpuInfoBO.setMarket_price(Double.valueOf(skuForEsBO.getMarketPrice().longValue()));
            esStorageSpuInfoBO.setMember_price1(Double.valueOf(skuForEsBO.getMemberPrice1().longValue()));
            esStorageSpuInfoBO.setMember_price2(Double.valueOf(skuForEsBO.getMemberPrice2().longValue()));
            esStorageSpuInfoBO.setMember_price3(Double.valueOf(skuForEsBO.getMemberPrice3().longValue()));
            esStorageSpuInfoBO.setMember_price4(Double.valueOf(skuForEsBO.getMemberPrice4().longValue()));
            esStorageSpuInfoBO.setMember_price5(Double.valueOf(skuForEsBO.getMemberPrice5().longValue()));
            esStorageSpuInfoBO.setSupplier_id(skuForEsBO.getSupplierId());
            String discount = "0";
            if (skuForEsBO.getSalePrice() != null && skuForEsBO.getMarketPrice() != null && skuForEsBO.getMarketPrice() != 0L) {
                discount = String.format("%.2f", (double)skuForEsBO.getSalePrice().longValue() / (double)skuForEsBO.getMarketPrice().longValue());
            }
            esStorageSpuInfoBO.setDiscounts(Double.valueOf(discount));
            esStorageSpuInfoBO.setComment_number(null);
            if (skuStockPoMap.size() > 0 && (uccSkuStockPo = skuStockPoMap.get(skuForEsBO.getSkuId())) != null) {
                esStorageSpuInfoBO.setComment_number(Long.valueOf(uccSkuStockPo.getStockNum().longValue()));
            }
            esStorageSpuInfoBO.setSold_number(null);
            esStorageSpuInfoBO.setEcommerce_sale(null);
            if (saleNumPoMap.size() > 0 && (uccSaleNumPo = saleNumPoMap.get(skuForEsBO.getSkuId())) != null) {
                esStorageSpuInfoBO.setSold_number(Long.valueOf(uccSaleNumPo.getSoldNumber().longValue()));
                esStorageSpuInfoBO.setEcommerce_sale(Long.valueOf(uccSaleNumPo.getEcommerceSale().longValue()));
            }
            if (skuPicPoMap.size() > 0 && (uccSkuPicPo = skuPicPoMap.get(skuForEsBO.getSkuId())) != null) {
                esStorageSpuInfoBO.setPicture_url(uccSkuPicPo.getSkuPicUrl());
            }
            esStorageSpuInfoBO.setBrand_id_name(null);
            esStorageSpuInfoBO.setType_id(null);
            esStorageSpuInfoBO.setType_name(null);
            esStorageSpuInfoBO.setDescription(null);
            esStorageSpuInfoBO.setSupplier_id_name(null);
            esStorageSpuInfoBO.setProperties(null);
            esStorageSpuInfoBOS.add(esStorageSpuInfoBO);
        }
    }

    private void assemblyEsCommodityAndCategoryInfo(SyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS, List<CommodityForEsBO> commodityForEsBOS) {
        Map<Long, CommodityForEsBO> commodityEsBOMap = commodityForEsBOS.stream().collect(Collectors.toMap(CommodityForEsBO::getCommodityId, commodityForEsBO -> commodityForEsBO));
        List<UccCatalogDealPO> uccCatalogDealPOS = this.uccCatalogDealMapper.qryCatalogListBySceneId(reqBO.getSceneId());
        Map<Long, UccCatalogDealPO> catalogDealPOMap = uccCatalogDealPOS.stream().collect(Collectors.toMap(UccCatalogDealPO::getGuideCatalogId, uccCatalogDealPO -> uccCatalogDealPO));
        HashMap<Long, UccCatalogDealPO> upperCatalogDealPOMap = new HashMap<Long, UccCatalogDealPO>();
        for (UccCatalogDealPO uccCatalogDealPO2 : uccCatalogDealPOS) {
            Long upperCatalogId = uccCatalogDealPO2.getUpperCatalogId();
            if (upperCatalogDealPOMap.get(upperCatalogId) != null) continue;
            if (upperCatalogId == 0L) {
                Long catalogId = uccCatalogDealPO2.getGuideCatalogId();
                if (upperCatalogDealPOMap.get(catalogId) != null) continue;
                upperCatalogDealPOMap.put(catalogId, catalogDealPOMap.get(catalogId));
                continue;
            }
            upperCatalogDealPOMap.put(upperCatalogId, catalogDealPOMap.get(upperCatalogId));
        }
        List<CommoditySpecForEsBO> commoditySpecForEsBOS = this.uccSpuSpecMapper.qrySpuSpecList(commodityIds, reqBO.getRootOrgIdIn());
        Map<Long, CommoditySpecForEsBO> commoditySpecForEsBOMap = commoditySpecForEsBOS.stream().collect(Collectors.toMap(CommoditySpecForEsBO::getCommodityId, commoditySpecForEsBO -> commoditySpecForEsBO));
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            UccCatalogDealPO uccCatalogDealPO3;
            CommoditySpecForEsBO commoditySpecForEsBO2;
            CommodityForEsBO commodityForEsBO2 = commodityEsBOMap.get(esStorageSpuInfoBO.getCommodity_id());
            esStorageSpuInfoBO.setScene_id(reqBO.getSceneId());
            esStorageSpuInfoBO.setCommodity_name(commodityForEsBO2.getCommodityName());
            esStorageSpuInfoBO.setCommd_pic_url(commodityForEsBO2.getCommodityPicUrl());
            esStorageSpuInfoBO.setChannel_id(Long.valueOf(commodityForEsBO2.getChannelId().intValue()));
            if (StringUtils.isEmpty((CharSequence)esStorageSpuInfoBO.getPicture_url())) {
                esStorageSpuInfoBO.setPicture_url(commodityForEsBO2.getCommodityPicUrl());
            }
            esStorageSpuInfoBO.setView_order(commodityForEsBO2.getViewOrder());
            esStorageSpuInfoBO.setShow_prop_json(null);
            if (commoditySpecForEsBOMap.size() > 0 && (commoditySpecForEsBO2 = commoditySpecForEsBOMap.get(esStorageSpuInfoBO.getCommodity_id())) != null) {
                esStorageSpuInfoBO.setShow_prop_json(commoditySpecForEsBO2.getPropJson());
            }
            if (catalogDealPOMap.size() > 0 && (uccCatalogDealPO3 = catalogDealPOMap.get(commodityForEsBO2.getGuideCataLogId())) != null) {
                CommodityCategoryForEsBO categoryForEsBO = new CommodityCategoryForEsBO();
                categoryForEsBO.setGuideCatalogId(commodityForEsBO2.getGuideCataLogId());
                categoryForEsBO.setUpperGatalogId(uccCatalogDealPO3.getUpperCatalogId());
                categoryForEsBO.setCatalogName(uccCatalogDealPO3.getCatalogName());
                categoryForEsBO.setChildCatalog(null);
                CommodityCategoryForEsBO finalCategoryForEsBO = this.assemblyCategoryInfo(categoryForEsBO, upperCatalogDealPOMap);
                this.analysisCategory(esStorageSpuInfoBO, finalCategoryForEsBO);
            }
            esStorageSpuInfoBO.setUnuse_suppliershop_list(null);
        }
    }

    private CommodityCategoryForEsBO assemblyCategoryInfo(CommodityCategoryForEsBO categoryForEsBO, Map<Long, UccCatalogDealPO> upperCatalogDealPOMap) {
        CommodityCategoryForEsBO finalSpuCategoryForEsBO = new CommodityCategoryForEsBO();
        for (int i = 0; i < upperCatalogDealPOMap.size(); ++i) {
            UccCatalogDealPO uccCatalogDealPO;
            if (i == 0 && categoryForEsBO.getUpperGatalogId() == 0L) {
                return categoryForEsBO;
            }
            if (i == 0 && categoryForEsBO.getUpperGatalogId() != 0L) {
                uccCatalogDealPO = upperCatalogDealPOMap.get(categoryForEsBO.getUpperGatalogId());
                finalSpuCategoryForEsBO = this.mergeChildAndParentCategory(categoryForEsBO, uccCatalogDealPO);
                continue;
            }
            if (finalSpuCategoryForEsBO.getUpperGatalogId() == 0L) {
                return finalSpuCategoryForEsBO;
            }
            uccCatalogDealPO = upperCatalogDealPOMap.get(finalSpuCategoryForEsBO.getUpperGatalogId());
            finalSpuCategoryForEsBO = this.mergeChildAndParentCategory(finalSpuCategoryForEsBO, uccCatalogDealPO);
        }
        return finalSpuCategoryForEsBO;
    }

    private CommodityCategoryForEsBO mergeChildAndParentCategory(CommodityCategoryForEsBO childCategory, UccCatalogDealPO parentCategory) {
        CommodityCategoryForEsBO finalCategory = new CommodityCategoryForEsBO();
        finalCategory.setGuideCatalogId(parentCategory.getGuideCatalogId());
        finalCategory.setUpperGatalogId(parentCategory.getUpperCatalogId());
        finalCategory.setCatalogName(parentCategory.getCatalogName());
        finalCategory.setChildCatalog((Object)childCategory);
        return finalCategory;
    }

    private void analysisCategory(EsStorageSpuInfoBO esStorageSpuInfoBO, CommodityCategoryForEsBO categoryForEsBO) {
        String defaultlName = "\u65e0";
        String l1Id = esStorageSpuInfoBO.getL1_category_id();
        String l1Nm = esStorageSpuInfoBO.getL1_category_name();
        String l2Id = esStorageSpuInfoBO.getL2_category_id();
        String l2Nm = esStorageSpuInfoBO.getL2_category_name();
        if (categoryForEsBO.getChildCatalog() != null) {
            if (StringUtils.isBlank((CharSequence)l1Id) && StringUtils.isBlank((CharSequence)l1Nm)) {
                esStorageSpuInfoBO.setL1_category_id(String.valueOf(categoryForEsBO.getGuideCatalogId()));
                if (StringUtils.isBlank((CharSequence)categoryForEsBO.getCatalogName())) {
                    esStorageSpuInfoBO.setL1_category_name(defaultlName);
                } else {
                    esStorageSpuInfoBO.setL1_category_name(categoryForEsBO.getCatalogName());
                }
                CommodityCategoryForEsBO childCategoryBO = (CommodityCategoryForEsBO)categoryForEsBO.getChildCatalog();
                this.analysisCategory(esStorageSpuInfoBO, childCategoryBO);
                return;
            }
            if (StringUtils.isBlank((CharSequence)l2Id) && StringUtils.isBlank((CharSequence)l2Nm)) {
                esStorageSpuInfoBO.setL2_category_id(String.valueOf(categoryForEsBO.getGuideCatalogId()));
                if (StringUtils.isBlank((CharSequence)categoryForEsBO.getCatalogName())) {
                    esStorageSpuInfoBO.setL2_category_name(defaultlName);
                } else {
                    esStorageSpuInfoBO.setL2_category_name(categoryForEsBO.getCatalogName());
                }
                CommodityCategoryForEsBO childCategoryBO = (CommodityCategoryForEsBO)categoryForEsBO.getChildCatalog();
                this.analysisCategory(esStorageSpuInfoBO, childCategoryBO);
            }
        } else {
            if (categoryForEsBO.getGuideCatalogId() != null) {
                esStorageSpuInfoBO.setL3_category_id(String.valueOf(categoryForEsBO.getGuideCatalogId()));
            } else {
                esStorageSpuInfoBO.setL3_category_id(null);
            }
            if (StringUtils.isBlank((CharSequence)categoryForEsBO.getCatalogName())) {
                esStorageSpuInfoBO.setL3_category_name(defaultlName);
            } else {
                esStorageSpuInfoBO.setL3_category_name(categoryForEsBO.getCatalogName());
            }
        }
    }

    private void syncCommodityInfoToEs(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            String jsonStr = JSONObject.toJSONString((Object)esStorageSpuInfoBO);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String esId = esStorageSpuInfoBO.getScene_id() + String.valueOf(esStorageSpuInfoBO.getSku_id());
            String id = this.elasticsearchUtil.addData(this.esConfig.getIndexName(), this.esConfig.getEsType(), esId, jsonObject);
            if (!StringUtils.isBlank((CharSequence)id)) continue;
            LOGGER.error("\u573a\u666f\u4e0b\u7684\u5546\u54c1\u4fe1\u606f[" + esStorageSpuInfoBO.getScene_id() + "|" + esStorageSpuInfoBO.getCommodity_id() + "]\u540c\u6b65\u5931\u8d25!");
        }
    }

    private void deleteSpuInfoFromEs(List<DeleteSpuInfoFromEsBO> deleteSpuInfoFromEsBOS) {
        for (DeleteSpuInfoFromEsBO deleteSpuInfoFromEsBO : deleteSpuInfoFromEsBOS) {
            JSONObject delConditionOrderJson = new JSONObject();
            delConditionOrderJson.put("commodity_id", (Object)String.valueOf(deleteSpuInfoFromEsBO.getCommodityId()));
            JSONObject termOrderJson = new JSONObject();
            termOrderJson.put("term", (Object)delConditionOrderJson);
            JSONObject delConditionAfsJson = new JSONObject();
            delConditionAfsJson.put("scene_id", (Object)String.valueOf(deleteSpuInfoFromEsBO.getSceneId()));
            JSONObject termAfsJson = new JSONObject();
            termAfsJson.put("term", (Object)delConditionAfsJson);
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)termOrderJson);
            jsonArray.add((Object)termAfsJson);
            JSONObject mustJson = new JSONObject();
            mustJson.put("must", (Object)jsonArray);
            JSONObject boolJson = new JSONObject();
            boolJson.put("bool", (Object)mustJson);
            JSONObject qryJson = new JSONObject();
            qryJson.put("query", (Object)boolJson);
            String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_delete_by_query";
            Boolean deleteResult = this.elasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
            if (deleteResult.booleanValue()) continue;
            LOGGER.error("\u573a\u666f\u4e0b\u7684\u5546\u54c1\u4fe1\u606f[" + deleteSpuInfoFromEsBO.getSceneId() + "|" + deleteSpuInfoFromEsBO.getCommodityId() + "]\u5220\u9664\u5931\u8d25!");
        }
    }

    private void validateReqParams(SyncSceneCommodityToEsReqBO reqBO) {
        if (reqBO.getOperType() == null) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1aES\u64cd\u4f5c\u7c7b\u578b\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getSyncType() == null) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u540c\u6b65\u7c7b\u578b\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getSceneId() == null || reqBO.getSceneId() == 0L) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u573a\u666fID\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID.equals(reqBO.getSyncType()) && (reqBO.getCategoryIds() == null || reqBO.getCategoryIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5173\u8054\u7c7b\u76ee\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType()) && (reqBO.getCommodityIds() == null || reqBO.getCommodityIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5546\u54c1ID\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_ACTIVITY_CONTENT.equals(reqBO.getSyncType()) && (reqBO.getSpuEsForActivityBOS() == null || reqBO.getSpuEsForActivityBOS().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u6d3b\u52a8\u4fe1\u606f\u5230ES\u5931\u8d25\uff1a\u6d3b\u52a8\u76f8\u5173\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

