/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.commodity.atom.UccCommodityAtomService;
import com.tydic.commodity.atom.bo.BatchUpdateCommodityStatusReqBo;
import com.tydic.commodity.atom.bo.BatchUpdateCommodityStatusRspBO;
import com.tydic.commodity.atom.bo.BatchUpdateSkuBO;
import com.tydic.commodity.atom.bo.BatchUpdateSkuStatusReqBO;
import com.tydic.commodity.atom.bo.BatchUpdateSkuStatusRspBO;
import com.tydic.commodity.businessenums.BusinessRsponseEnums;
import com.tydic.commodity.dao.UccCommdQueryDealMapper;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuQueryDealMapper;
import com.tydic.commodity.dao.po.UccSkuLogPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuQueryPO;
import com.tydic.commodity.exception.BusinessException;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uccCommodityAtomService")
public class UccCommodityAtomServiceImpl
implements UccCommodityAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityAtomServiceImpl.class);
    @Autowired
    private UccCommdQueryDealMapper uccCommdQueryDealMapper;
    @Autowired
    private UccSkuQueryDealMapper skuMapper;
    @Autowired
    private UccSkuLogMapper uccSkuLogMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private OrderSequence uccBatchSequence;

    @Override
    public BatchUpdateCommodityStatusRspBO batchUpdateCommodityByCommodityId(BatchUpdateCommodityStatusReqBo reqBo) {
        BatchUpdateCommodityStatusRspBO batchUpdateCommodityStatusRspBO = new BatchUpdateCommodityStatusRspBO();
        try {
            this.uccCommdQueryDealMapper.batchUpdateCommodityByCommodityId(reqBo.getBoList(), reqBo.getSupplierShopId());
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("BATCH_UPDATE_COMMODITY_ERROR", "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5f02\u5e38");
        }
        batchUpdateCommodityStatusRspBO.setRespCode("0000");
        batchUpdateCommodityStatusRspBO.setRespDesc("\u6210\u529f");
        return batchUpdateCommodityStatusRspBO;
    }

    @Override
    public BatchUpdateSkuStatusRspBO batchUpdateSkuInStatusByCommodityId(BatchUpdateSkuStatusReqBO reqBO) {
        BatchUpdateSkuStatusRspBO batchUpdateSkuStatusRspBO = new BatchUpdateSkuStatusRspBO();
        try {
            List<BatchUpdateSkuBO> batchUpdateSkuBOList = reqBO.getBoList();
            for (BatchUpdateSkuBO batchUpdateSkuBO : batchUpdateSkuBOList) {
                List<UccSkuQueryPO> skuQueryPO = this.skuMapper.selectSkuInfoByCommodityId(batchUpdateSkuBO.getCommodityId());
                UccSkuPo queryUccSkuPo = new UccSkuPo();
                for (UccSkuQueryPO SkuPo : skuQueryPO) {
                    Long batchId;
                    try {
                        batchId = this.uccBatchSequence.nextId();
                    }
                    catch (SQLException e) {
                        throw new BusinessException(BusinessRsponseEnums.SEQUENCE_ID_ERROR.code(), BusinessRsponseEnums.SEQUENCE_ID_ERROR.message());
                    }
                    queryUccSkuPo.setSkuId(SkuPo.getSkuId());
                    List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qerySku(queryUccSkuPo);
                    UccSkuPo uccSkuPo = uccSkuPos.get(0);
                    UccSkuLogPo po = new UccSkuLogPo();
                    BeanUtils.copyProperties((Object)uccSkuPo, (Object)po);
                    po.setBatchId(batchId);
                    po.setSkuSource(uccSkuPo.getSkuSource());
                    try {
                        this.uccSkuLogMapper.insert(po);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u63d2\u5165\u5355\u54c1\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
                    }
                }
                this.skuMapper.batchUpdateSkuStatusBySkuId(skuQueryPO, reqBO.getStatus(), batchUpdateSkuBO.getSupplierShopId());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("BATCH_UPDATE_SKU_ERROR", "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u5931\u8d25");
        }
        batchUpdateSkuStatusRspBO.setRespCode("0000");
        batchUpdateSkuStatusRspBO.setRespDesc("\u6210\u529f");
        return batchUpdateSkuStatusRspBO;
    }

    @Override
    public BatchUpdateSkuStatusRspBO batchSkuInStatus(BatchUpdateSkuStatusReqBO reqBO) {
        BatchUpdateSkuStatusRspBO batchUpdateSkuStatusRspBO = new BatchUpdateSkuStatusRspBO();
        try {
            List<BatchUpdateSkuBO> batchUpdateSkuBOList = reqBO.getBoList();
            for (BatchUpdateSkuBO batchUpdateSkuBO : batchUpdateSkuBOList) {
                List<UccSkuQueryPO> skuQueryPO = this.skuMapper.selectSkuInfoByCommodityId(batchUpdateSkuBO.getCommodityId());
                this.skuMapper.batchUpdateSkuStatusBySkuId(skuQueryPO, reqBO.getStatus(), batchUpdateSkuBO.getSupplierShopId());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("BATCH_UPDATE_SKU_ERROR", "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u5931\u8d25");
        }
        batchUpdateSkuStatusRspBO.setRespCode("0000");
        batchUpdateSkuStatusRspBO.setRespDesc("\u6210\u529f");
        return batchUpdateSkuStatusRspBO;
    }
}

