/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.commodity.atom.UccSkuLogRecordAtomService;
import com.tydic.commodity.atom.bo.UccSkuLogRecordReqBO;
import com.tydic.commodity.atom.bo.UccSkuLogRecordRspBO;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccSkuLogPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="uccSkuLogRecordAtomService")
public class UccSkuLogRecordAtomServiceImpl
implements UccSkuLogRecordAtomService {
    @Autowired
    private OrderSequence uccBatchSequence;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuLogMapper uccSkuLogMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccSkuLogRecordAtomServiceImpl.class);

    @Override
    public UccSkuLogRecordRspBO dealSkuLogRecord(UccSkuLogRecordReqBO reqBO) {
        ArrayList<UccSkuLogPo> poList = new ArrayList<UccSkuLogPo>();
        UccSkuLogPo po = new UccSkuLogPo();
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
        uccSkuPo.setCommodityId(reqBO.getCommodityId());
        uccSkuPo.setSkuId(reqBO.getSkuId());
        List<Object> skuPoList = new ArrayList();
        try {
            skuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        long nextId = 0L;
        if (skuPoList.size() != 0) {
            for (UccSkuPo uccSkuPo2 : skuPoList) {
                try {
                    nextId = this.uccBatchSequence.nextId();
                    reqBO.setBatchId(nextId);
                }
                catch (SQLException e) {
                    throw new ZTBusinessException("\u5546\u54c1\u4e2d\u5fc3\u5355\u54c1\u4fe1\u606f\u7ef4\u62a4\u539f\u5b50\u670d\u52a1\u751f\u6210\u4fee\u6539\u6279\u6b21\u53f7\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
                }
                po = new UccSkuLogPo();
                BeanUtils.copyProperties((Object)uccSkuPo2, (Object)po);
                po.setBatchId(nextId);
                poList.add(po);
            }
        }
        if (poList.size() == 1) {
            try {
                this.uccSkuLogMapper.addSkuLog(poList);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException("\u65b0\u589e\u5355\u54c1\u65e5\u5fd7\u4fe1\u606f\u5f02\u5e38");
            }
        }
        UccSkuLogRecordRspBO rspBO = new UccSkuLogRecordRspBO();
        rspBO.setBatchId(nextId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6dfb\u52a0\u5355\u54c1\u65e5\u5fd7\u6210\u529f");
        return rspBO;
    }
}

