/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.commodity.atom.UccSkuSpecLogAtomService;
import com.tydic.commodity.atom.bo.UccSkuSpecLogReqBO;
import com.tydic.commodity.atom.bo.UccSkuSpecLogRspBO;
import com.tydic.commodity.dao.UccSkuSpecLogMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.po.UccSkuSpecLogPo;
import com.tydic.commodity.dao.po.UccSkuSpecPo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="uccSkuSpecLogAtomService")
public class UccSkuSpecLogAtomServiceImpl
implements UccSkuSpecLogAtomService {
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccSkuSpecLogMapper uccSkuSpecLogMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccSkuSpecLogAtomServiceImpl.class);
    @Autowired
    private OrderSequence uccBatchSequence;

    @Override
    public UccSkuSpecLogRspBO addSkuSpecLog(UccSkuSpecLogReqBO reqBO) {
        UccSkuSpecLogRspBO rspBO = this.judge(reqBO);
        if ("8888".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        rspBO = new UccSkuSpecLogRspBO();
        List<Long> skuSpecIdList = reqBO.getSkuSpecIdList();
        List<Object> uccSkuSpecPoList = new ArrayList();
        ArrayList<UccSkuSpecLogPo> uccSkuSpecLogPoList = new ArrayList<UccSkuSpecLogPo>();
        UccSkuSpecLogPo uccSkuSpecLogPo = null;
        Long nextId = reqBO.getBatchId();
        if (skuSpecIdList != null && skuSpecIdList.size() != 0) {
            for (Long skuSpecId : skuSpecIdList) {
                UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
                uccSkuSpecPo.setSkuSpecId(skuSpecId);
                uccSkuSpecPo.setCommodityId(reqBO.getCommodityId());
                uccSkuSpecPo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuSpecPo.setSkuId(reqBO.getSkuId());
                try {
                    uccSkuSpecPoList = this.uccSkuSpecMapper.querySpec(uccSkuSpecPo);
                }
                catch (Exception e) {
                    throw new ZTBusinessException(e.getMessage());
                }
                if (uccSkuSpecPoList == null || uccSkuSpecPoList.size() != 1) continue;
                uccSkuSpecLogPo = new UccSkuSpecLogPo();
                if (null == reqBO.getBatchId()) {
                    try {
                        nextId = this.uccBatchSequence.nextId();
                    }
                    catch (SQLException e) {
                        throw new ZTBusinessException("\u5546\u54c1\u4e2d\u5fc3\u5355\u54c1\u4fe1\u606f\u7ef4\u62a4\u539f\u5b50\u670d\u52a1\u751f\u6210\u4fee\u6539\u6279\u6b21\u53f7\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
                    }
                }
                BeanUtils.copyProperties((Object)uccSkuSpecPoList.get(0), (Object)uccSkuSpecLogPo);
                uccSkuSpecLogPo.setBatchId(nextId);
                uccSkuSpecLogPoList.add(uccSkuSpecLogPo);
            }
        }
        if (uccSkuSpecLogPoList.size() != 0) {
            try {
                this.uccSkuSpecLogMapper.addSkuSpecLogs(uccSkuSpecLogPoList);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException("\u6dfb\u52a0\u5355\u54c1\u89c4\u683c\u65e5\u5fd7\u5f02\u5e38");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6dfb\u52a0\u5355\u54c1\u5c5e\u6027\u65e5\u5fd7\u6210\u529f");
        return rspBO;
    }

    public UccSkuSpecLogRspBO judge(UccSkuSpecLogReqBO reqBO) {
        UccSkuSpecLogRspBO rspBO = new UccSkuSpecLogRspBO();
        if (reqBO.getCommodityId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1Id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getSupplierShopId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5e97\u94faId\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getSkuId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5355\u54c1Id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getSkuSpecIdList() == null || reqBO.getSkuSpecIdList().size() == 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027Id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5165\u53c2\u6b63\u5e38");
        return rspBO;
    }
}

