/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.atom.UccSupplierCacheAtomService;
import com.tydic.commodity.atom.bo.UccSupplierCacheReqBo;
import com.tydic.commodity.atom.bo.UccSupplierCacheRspBo;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccSceneSupplierSubscribeMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccSceneSupplierSubscribePo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UccSupplierCacheAtomServiceImpl
implements UccSupplierCacheAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccSupplierCacheAtomServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccSceneSupplierSubscribeMapper uccSceneSupplierSubscribeMapper;

    @Override
    public UccSupplierCacheRspBo qryInfomation(UccSupplierCacheReqBo reqBo) {
        List<SupplierShopPo> shopPos;
        UccSupplierCacheRspBo rspBo = new UccSupplierCacheRspBo();
        StringBuilder sb = new StringBuilder();
        sb.append("REDIS_SUPPLIER_ID").append(reqBo.getSupplierId());
        Object object = this.cacheClient.get(sb.toString());
        if (object != null && !"".equals(object)) {
            rspBo = (UccSupplierCacheRspBo)((Object)object);
            rspBo.setRespCode("0000");
            return rspBo;
        }
        SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(reqBo.getSupplierId());
        if (supplierBusiPo == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u67e5\u8be2\u5931\u8d25\uff1a" + reqBo.getSupplierId() + "\u65e0\u5546\u6237\u6570\u636e");
            return rspBo;
        }
        BeanUtils.copyProperties((Object)supplierBusiPo, (Object)((Object)rspBo));
        if (supplierBusiPo.getSupplierType() != null && supplierBusiPo.getSupplierType() == 1) {
            UccSceneSupplierSubscribePo po = this.uccSceneSupplierSubscribeMapper.qrySceneBySupplierId(reqBo.getSupplierId());
            if (po != null) {
                rspBo.setSceneId(po.getSceneId());
                rspBo.setSceneStatus(po.getStatus());
            } else if (log.isDebugEnabled()) {
                log.debug("\u5546\u6237ID:" + reqBo.getSupplierId() + "  \u83b7\u53d6\u573a\u666fID\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty(shopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBo.getSupplierId()))) {
            rspBo.setShopPos(shopPos);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        this.cacheClient.set(sb.toString(), (Object)rspBo);
        return rspBo;
    }

    @Override
    public UccSupplierCacheRspBo onLoadCache(UccSupplierCacheReqBo reqBo) {
        UccSupplierCacheRspBo rspBo = null;
        StringBuilder sb = new StringBuilder();
        sb.append("REDIS_SUPPLIER_ID").append(reqBo.getSupplierId());
        try {
            this.cacheClient.delete(sb.toString());
        }
        catch (Exception e) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5220\u9664\u5931\u8d25redisKey\uff1a" + sb.toString());
            return rspBo;
        }
        SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(reqBo.getSupplierId());
        if (supplierBusiPo == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u67e5\u8be2\u5931\u8d25\uff1a" + reqBo.getSupplierId() + "\u65e0\u5546\u6237\u6570\u636e");
            return rspBo;
        }
        List<SupplierShopPo> shopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBo.getSupplierId());
        if (!CollectionUtils.isEmpty(shopPos)) {
            rspBo.setShopPos(shopPos);
        }
        this.cacheClient.set(sb.toString(), (Object)rspBo);
        return rspBo;
    }
}

