/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.google.common.collect.Lists;
import com.tydic.commodity.bo.UmcStationWebBO;
import com.tydic.commodity.bo.busi.ApprovalAuthorCheckReqBO;
import com.tydic.commodity.bo.busi.ApprovalAuthorCheckRspBO;
import com.tydic.commodity.bo.busi.ApprovalCommoAuthor;
import com.tydic.commodity.busi.api.ApprovalCommoAuthorService;
import com.tydic.commodity.busi.api.UccApprovalAuthorCheckService;
import com.tydic.commodity.enumType.ApprovalCommoAuthDetailEnum;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccApprovalAuthorCheckService.class)
public class UccApprovalAuthorCheckServiceImpl
implements UccApprovalAuthorCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccApprovalAuthorCheckServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV")
    private ApprovalCommoAuthorService approvalCommoAuthorService;

    public ApprovalAuthorCheckRspBO approvalAuthorCheck(ApprovalAuthorCheckReqBO reqBO) {
        ApprovalAuthorCheckRspBO approvalAuthorCheckRspBO = new ApprovalAuthorCheckRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
            approvalAuthorCheckRspBO.setRespCode("0000");
            approvalAuthorCheckRspBO.setCheckFlag(Boolean.valueOf(false));
            approvalAuthorCheckRspBO.setRespDesc("\u8be5\u64cd\u4f5c\u5458\u65e0\u4efb\u4f55\u6743\u9650\uff0c\u4e0d\u80fd\u64cd\u4f5c");
            return approvalAuthorCheckRspBO;
        }
        List authString = null;
        ArrayList code = Lists.newArrayList();
        try {
            Map authMap;
            for (UmcStationWebBO umcStationWebBO : reqBO.getUmcStationsListWebExt()) {
                code.add(umcStationWebBO.getStationCode());
            }
            ApprovalCommoAuthor approvalCommoAuthor = this.approvalCommoAuthorService.getApprovalRoleAuth((List)code);
            if (approvalCommoAuthor != null && null != (authMap = approvalCommoAuthor.getMap()).get(ApprovalCommoAuthDetailEnum.APPROVAL_LEVEL.code())) {
                authString = (List)authMap.get(ApprovalCommoAuthDetailEnum.APPROVAL_LEVEL.code());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5f02\u5e38:" + e);
            throw new BusinessException("8888", "\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5f02\u5e38");
        }
        if (CollectionUtils.isNotEmpty(authString)) {
            for (String approvalStatus : authString) {
                if (!approvalStatus.equals(ApprovalTypeEnum.APPROVAL_PASS_ZRO.getStep())) continue;
                approvalAuthorCheckRspBO.setRespCode("0000");
                approvalAuthorCheckRspBO.setRespDesc("\u6210\u529f");
                return approvalAuthorCheckRspBO;
            }
        }
        approvalAuthorCheckRspBO.setRespCode("0000");
        approvalAuthorCheckRspBO.setCheckFlag(Boolean.valueOf(false));
        approvalAuthorCheckRspBO.setRespDesc("\u8be5\u7ea7\u5ba1\u6838\u5458\u4e0d\u80fd\u64cd\u4f5c");
        return approvalAuthorCheckRspBO;
    }
}

