/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.atom.UccSupplierCacheAtomService;
import com.tydic.commodity.atom.bo.UccSupplierCacheReqBo;
import com.tydic.commodity.atom.bo.UccSupplierCacheRspBo;
import com.tydic.commodity.bo.busi.SkuOriginalPriceBo;
import com.tydic.commodity.bo.busi.SkuPriceBo;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.UccBatchSkuAdjustPriceBO;
import com.tydic.commodity.bo.busi.UccBatchSkuAdjustPriceReqBO;
import com.tydic.commodity.bo.busi.UccBatchSkuAdjustPriceRspBO;
import com.tydic.commodity.bo.busi.UccSkuAdjustPriceReqBO;
import com.tydic.commodity.bo.busi.UccSkuAdjustPriceRspBO;
import com.tydic.commodity.busi.api.UccBatchSkuAdjustPriceBusiService;
import com.tydic.commodity.busi.api.UccSkuAdjustPriceBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccSceneSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccSceneSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccBatchSkuAdjustPriceBusiService.class)
public class UccBatchSkuAdjustPriceBusiServiceImpl
implements UccBatchSkuAdjustPriceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchSkuAdjustPriceBusiServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV")
    private UccSkuAdjustPriceBusiService uccSkuAdjustPriceBusiService;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccSupplierCacheAtomService uccSupplierCacheAtomService;
    @Autowired
    private UccSceneSkuPriceMapper uccSceneSkuPriceMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Value(value="${default_regist_scene}")
    private String defaultRegistScene;
    @Autowired
    private OrderSequence uccBatchSequence;

    public UccBatchSkuAdjustPriceRspBO dealSkuAdjustPrice(UccBatchSkuAdjustPriceReqBO reqBO) {
        UccBatchSkuAdjustPriceRspBO rspBO = new UccBatchSkuAdjustPriceRspBO();
        if (reqBO.getSkuPrices() == null || reqBO.getSkuPrices().size() == 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u9009\u62e9\u4ef7\u683c\u6570\u636e");
            return rspBO;
        }
        Long secenId = reqBO.getSceneId();
        UccSupplierCacheReqBo uccSupplierCacheReqBo = new UccSupplierCacheReqBo();
        if (reqBO.getOrgIdIn() != null) {
            uccSupplierCacheReqBo.setSupplierId(reqBO.getOrgIdIn());
        } else {
            uccSupplierCacheReqBo.setSupplierId(((UccBatchSkuAdjustPriceBO)reqBO.getSkuPrices().get(0)).getSupplierShopId());
        }
        UccSupplierCacheRspBo uccSupplierCacheRspBo = this.uccSupplierCacheAtomService.qryInfomation(uccSupplierCacheReqBo);
        if ("0000".equals(uccSupplierCacheRspBo.getRespCode()) && uccSupplierCacheRspBo.getSceneId() != null) {
            secenId = uccSupplierCacheRspBo.getSceneId();
        }
        if (secenId != null) {
            this.senceAdjustPrice(reqBO, rspBO, secenId);
        } else {
            this.mangerAdjustPirce(reqBO, rspBO);
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(((UccBatchSkuAdjustPriceBO)reqBO.getSkuPrices().get(0)).getSkuId());
        List<UccSkuPo> skuPos = this.uccSkuMapper.qerySku(uccSkuPo);
        if (!CollectionUtils.isEmpty(skuPos)) {
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSceneId(reqBO.getSceneId());
            if (reqBO.getSceneId() == null && !StringUtils.isEmpty((Object)this.defaultRegistScene)) {
                syncSceneCommodityToEsReqBO.setSceneId(Long.valueOf(Long.parseLong(this.defaultRegistScene)));
            }
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setRootOrgIdIn(reqBO.getRootOrgIdIn());
            ArrayList<Long> commdIds = new ArrayList<Long>();
            commdIds.add(skuPos.get(0).getCommodityId());
            syncSceneCommodityToEsReqBO.setCommodityIds(commdIds);
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8c03\u4ef7\u6210\u529f");
        return rspBO;
    }

    public void mangerAdjustPirce(UccBatchSkuAdjustPriceReqBO reqBO, UccBatchSkuAdjustPriceRspBO rspBO) {
        UccSkuAdjustPriceRspBO uccSkuAdjustPriceRspBO = new UccSkuAdjustPriceRspBO();
        Long supplierShopId = ((UccBatchSkuAdjustPriceBO)reqBO.getSkuPrices().get(0)).getSupplierShopId();
        if (null != reqBO.getOrgIdIn() || reqBO.getRootOrgIdIn() != null) {
            List<SupplierShopPo> supplierShopPos;
            Object supperliId = 0L;
            supperliId = reqBO.getOrgIdIn();
            if (reqBO.getRootOrgIdIn() != null) {
                supperliId = reqBO.getRootOrgIdIn();
            }
            if (CollectionUtils.isNotEmpty(supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId((Long)supperliId))) {
                supplierShopId = supplierShopPos.get(0).getSupplierShopId();
            }
        }
        for (UccBatchSkuAdjustPriceBO each : reqBO.getSkuPrices()) {
            UccSkuAdjustPriceReqBO bo = new UccSkuAdjustPriceReqBO();
            SkuPriceBo skuPriceBo = new SkuPriceBo();
            BeanUtils.copyProperties((Object)each, (Object)bo);
            BeanUtils.copyProperties((Object)each.getUpdateSkuPriceInfo(), (Object)skuPriceBo);
            bo.setUpdateSkuPriceInfo(skuPriceBo);
            bo.setSupplierShopId(supplierShopId);
            if (!StringUtils.isEmpty((Object)each.getUpdateSkuPriceInfo().getSalePrice())) {
                bo.getUpdateSkuPriceInfo().setSalePrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)new BigDecimal(each.getUpdateSkuPriceInfo().getSalePrice())).longValue()));
            }
            if (!StringUtils.isEmpty((Object)each.getUpdateSkuPriceInfo().getAgreementPrice())) {
                bo.getUpdateSkuPriceInfo().setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getAgreementPrice()).longValue()));
            }
            if (!StringUtils.isEmpty((Object)each.getUpdateSkuPriceInfo().getMarketPrice())) {
                bo.getUpdateSkuPriceInfo().setMarketPrice(Long.valueOf(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getMarketPrice()).longValue()));
            }
            if (!StringUtils.isEmpty((Object)each.getUpdateSkuPriceInfo().getMemberPrice1())) {
                bo.getUpdateSkuPriceInfo().setMemberPrice1(Long.valueOf(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getMemberPrice1()).longValue()));
            }
            if (!StringUtils.isEmpty((Object)each.getUpdateSkuPriceInfo().getMemberPrice2())) {
                bo.getUpdateSkuPriceInfo().setMemberPrice2(Long.valueOf(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getMemberPrice2()).longValue()));
            }
            if (!StringUtils.isEmpty((Object)each.getUpdateSkuPriceInfo().getMemberPrice3())) {
                bo.getUpdateSkuPriceInfo().setMemberPrice3(Long.valueOf(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getMemberPrice3()).longValue()));
            }
            if (!StringUtils.isEmpty((Object)each.getUpdateSkuPriceInfo().getMemberPrice4())) {
                bo.getUpdateSkuPriceInfo().setMemberPrice4(Long.valueOf(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getMemberPrice4()).longValue()));
            }
            if (!StringUtils.isEmpty((Object)each.getUpdateSkuPriceInfo().getMemberPrice5())) {
                bo.getUpdateSkuPriceInfo().setMemberPrice5(Long.valueOf(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getMemberPrice5()).longValue()));
            }
            if (each.getUpdateSkuPriceInfo().getWholesalePrice() != null) {
                bo.getUpdateSkuPriceInfo().setWholesalePrice(Long.valueOf(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getWholesalePrice()).longValue()));
            }
            if (each.getUpdateSkuPriceInfo().getSupplyPrice1() != null) {
                bo.getUpdateSkuPriceInfo().setSupplyPrice1(Long.valueOf(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getSupplyPrice1()).longValue()));
            }
            if (each.getUpdateSkuPriceInfo().getDistributionPrice() != null) {
                bo.getUpdateSkuPriceInfo().setDistributionPrice(Long.valueOf(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getDistributionPrice()).longValue()));
            }
            if ("0000".equals((uccSkuAdjustPriceRspBO = this.uccSkuAdjustPriceBusiService.dealSkuAdjustPrice(bo)).getRespCode())) continue;
            BeanUtils.copyProperties((Object)uccSkuAdjustPriceRspBO, (Object)rspBO);
            return;
        }
        List<Long> sku = reqBO.getSkuPrices().stream().map(UccBatchSkuAdjustPriceBO::getSkuId).collect(Collectors.toList());
        List<UccSceneSkuPricePo> sceneSkuPricePos = this.uccSceneSkuPriceMapper.qrySKuBySceneandsku(sku, null, null);
        if (!CollectionUtils.isEmpty(sceneSkuPricePos)) {
            this.exchangeDate(reqBO.getSkuPrices(), sceneSkuPricePos);
            for (UccSceneSkuPricePo pricePo : sceneSkuPricePos) {
                this.uccSceneSkuPriceMapper.update(pricePo);
            }
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
    }

    public void senceAdjustPrice(UccBatchSkuAdjustPriceReqBO reqBO, UccBatchSkuAdjustPriceRspBO rspBO, Long senceId) {
        List<Long> sku = reqBO.getSkuPrices().stream().map(UccBatchSkuAdjustPriceBO::getSkuId).collect(Collectors.toList());
        List<UccSceneSkuPricePo> sceneSkuPricePos = this.uccSceneSkuPriceMapper.qrySKuBySceneandsku(sku, senceId, null);
        List<Object> insertPrice = new ArrayList();
        if (!CollectionUtils.isEmpty(sceneSkuPricePos)) {
            if (sceneSkuPricePos.size() == reqBO.getSkuPrices().size()) {
                this.exchangeDate(reqBO.getSkuPrices(), sceneSkuPricePos);
                for (UccSceneSkuPricePo pricePo : sceneSkuPricePos) {
                    this.uccSceneSkuPriceMapper.update(pricePo);
                }
                return;
            }
            insertPrice = this.filterData(reqBO.getSkuPrices(), sceneSkuPricePos, senceId);
        } else {
            insertPrice = this.dealInsertData(reqBO.getSkuPrices(), senceId);
        }
        this.uccSceneSkuPriceMapper.batchInsert(insertPrice);
    }

    private void exchangeDate(List<UccBatchSkuAdjustPriceBO> skuPrices, List<UccSceneSkuPricePo> pos) {
        Map<Long, SkuOriginalPriceBo> reqPriceMap = skuPrices.stream().collect(Collectors.toMap(UccBatchSkuAdjustPriceBO::getSkuId, UccBatchSkuAdjustPriceBO::getUpdateSkuPriceInfo));
        for (UccSceneSkuPricePo each : pos) {
            each.setSalePrice(MoneyUtils.yuanToHao((String)reqPriceMap.get(each.getSkuId()).getSalePrice()).longValue());
            each.setWholesalePrice(MoneyUtils.yuanToHao((String)reqPriceMap.get(each.getSkuId()).getWholesalePrice()).longValue());
            each.setMarketPrice(MoneyUtils.yuanToHao((String)reqPriceMap.get(each.getSkuId()).getMarketPrice()).longValue());
            each.setDistributionPrice(MoneyUtils.yuanToHao((String)reqPriceMap.get(each.getSkuId()).getDistributionPrice()).longValue());
            each.setStatus(1);
        }
    }

    private List<UccSceneSkuPricePo> filterData(List<UccBatchSkuAdjustPriceBO> skuPrices, List<UccSceneSkuPricePo> pos, Long senceId) {
        ArrayList<UccSceneSkuPricePo> pricePos = new ArrayList<UccSceneSkuPricePo>();
        Map<Long, UccSceneSkuPricePo> priceMap = pos.stream().collect(Collectors.toMap(UccSceneSkuPricePo::getSkuId, UccSceneSkuPricePo2 -> UccSceneSkuPricePo2));
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(skuPrices.get(0).getSkuId());
        List<UccSkuPo> skuPos = this.uccSkuMapper.qerySku(uccSkuPo);
        if (CollectionUtils.isEmpty(skuPos)) {
            log.error("\u672a\u67e5\u8be2\u5230\u5546\u54c1ID\uff1a" + skuPrices.get(0).getSkuId());
            return new ArrayList<UccSceneSkuPricePo>();
        }
        UccSceneSkuPricePo po = null;
        for (UccBatchSkuAdjustPriceBO each : skuPrices) {
            po = new UccSceneSkuPricePo();
            if (priceMap.containsKey(each.getSkuId())) continue;
            try {
                po.setId(this.uccBatchSequence.nextId());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            po.setSceneId(senceId);
            po.setSalePrice(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getSalePrice()).longValue());
            po.setWholesalePrice(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getWholesalePrice()).longValue());
            po.setMarketPrice(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getMarketPrice()).longValue());
            po.setDistributionPrice(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getDistributionPrice()).longValue());
            po.setCommodityId(skuPos.get(0).getCommodityId());
            po.setSkuId(each.getSkuId());
            po.setStatus(ModelRuleConstant.UCC_SCENE_SKU_PRICE_ON);
            pricePos.add(po);
        }
        return pricePos;
    }

    private List<UccSceneSkuPricePo> dealInsertData(List<UccBatchSkuAdjustPriceBO> skuPrices, Long senceId) {
        ArrayList<UccSceneSkuPricePo> pricePos = new ArrayList<UccSceneSkuPricePo>();
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(skuPrices.get(0).getSkuId());
        List<UccSkuPo> skuPos = this.uccSkuMapper.qerySku(uccSkuPo);
        if (CollectionUtils.isEmpty(skuPos)) {
            log.error("\u672a\u67e5\u8be2\u5230\u5546\u54c1ID\uff1a" + skuPrices.get(0).getSkuId());
            return new ArrayList<UccSceneSkuPricePo>();
        }
        UccSceneSkuPricePo po = null;
        for (UccBatchSkuAdjustPriceBO each : skuPrices) {
            po = new UccSceneSkuPricePo();
            try {
                po.setId(this.uccBatchSequence.nextId());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            po.setSceneId(senceId);
            po.setSalePrice(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getSalePrice()).longValue());
            po.setMarketPrice(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getMarketPrice()).longValue());
            po.setWholesalePrice(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getWholesalePrice()).longValue());
            po.setDistributionPrice(MoneyUtils.yuanToHao((String)each.getUpdateSkuPriceInfo().getDistributionPrice()).longValue());
            po.setCommodityId(skuPos.get(0).getCommodityId());
            po.setSkuId(each.getSkuId());
            po.setStatus(ModelRuleConstant.UCC_SCENE_SKU_PRICE_ON);
            pricePos.add(po);
        }
        return pricePos;
    }
}

