/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.bo.busi.SkuPriceVOs;
import com.tydic.commodity.bo.busi.UccBatchUpdatePriceReqBO;
import com.tydic.commodity.bo.busi.UccBatchUpdatePriceRspBO;
import com.tydic.commodity.busi.api.UccBatchUpdatePriceBusiService;
import com.tydic.commodity.dao.UccSkuPriceLogMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.po.UccSkuPriceLogPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.util.ListUtils;
import com.tydic.commodity.utils.GenSnowFlakeIdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccBatchUpdatePriceBusiService.class)
public class UccBatchUpdatePriceBusiServiceImpl
implements UccBatchUpdatePriceBusiService {
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuPriceLogMapper uccSkuPriceLogMapper;
    @Autowired
    private GenSnowFlakeIdUtil idUtil;

    public UccBatchUpdatePriceRspBO update(UccBatchUpdatePriceReqBO reqBO) {
        UccBatchUpdatePriceRspBO rspBO = new UccBatchUpdatePriceRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuPriceVOs())) {
            List<UccSkuPricePo> skuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(reqBO.getSkuPriceVOs().stream().map(SkuPriceVOs::getSkuId).collect(Collectors.toList()), ((SkuPriceVOs)reqBO.getSkuPriceVOs().get(0)).getSupplierShopId());
            ArrayList<UccSkuPriceLogPo> skuPriceLogPoList = new ArrayList<UccSkuPriceLogPo>();
            Date date = new Date();
            Long batch = Long.valueOf(DateUtils.dateToStr((Date)date, (String)"yyyyMMddHHmmssSSS"));
            for (UccSkuPricePo uccSkuPricePo : skuPricePos) {
                UccSkuPriceLogPo skuPriceLogPo = new UccSkuPriceLogPo();
                skuPriceLogPo.setId(this.idUtil.nextId());
                skuPriceLogPo.setBatchId(batch);
                skuPriceLogPo.setSkuPriceId(uccSkuPricePo.getSkuPriceId());
                skuPriceLogPo.setSkuId(uccSkuPricePo.getSkuId());
                skuPriceLogPo.setSupplierShopId(uccSkuPricePo.getSupplierShopId());
                skuPriceLogPo.setMarketPrice(uccSkuPricePo.getMarketPrice());
                skuPriceLogPo.setAgreementPrice(uccSkuPricePo.getAgreementPrice());
                skuPriceLogPo.setSalePrice(uccSkuPricePo.getSalePrice());
                skuPriceLogPo.setCurrencyType(uccSkuPricePo.getCurrencyType());
                skuPriceLogPo.setCreateTime(date);
                skuPriceLogPo.setRemark("\u5168\u91cf\u540c\u6b65\u670d\u52a1\u66f4\u65b0\u4ef7\u683c\u8bb0\u5f55\u65e5\u5fd7");
                skuPriceLogPoList.add(skuPriceLogPo);
            }
            this.uccSkuPriceLogMapper.insertBatch(skuPriceLogPoList);
            ArrayList<UccSkuPricePo> skuPricePoList = new ArrayList<UccSkuPricePo>();
            for (SkuPriceVOs skuPriceVOs : reqBO.getSkuPriceVOs()) {
                UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
                uccSkuPricePo.setSupplierShopId(skuPriceVOs.getSupplierShopId());
                uccSkuPricePo.setSkuId(skuPriceVOs.getSkuId());
                if (null != skuPriceVOs.getAgreePrice()) {
                    uccSkuPricePo.setAgreementPrice(skuPriceVOs.getAgreePrice().longValue());
                }
                if (null != skuPriceVOs.getSalePrice()) {
                    uccSkuPricePo.setSalePrice(skuPriceVOs.getSalePrice().longValue());
                }
                if (null != skuPriceVOs.getMarketPrice()) {
                    uccSkuPricePo.setMarketPrice(skuPriceVOs.getMarketPrice().longValue());
                }
                skuPricePoList.add(uccSkuPricePo);
            }
            Map map = ListUtils.batchList(skuPricePoList, (int)200);
            map.forEach((key, value) -> this.uccSkuPriceMapper.batchUpdatePrice((List<UccSkuPricePo>)value));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

