/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccBrandAddReqBO;
import com.tydic.commodity.bo.busi.UccBrandAddRspBO;
import com.tydic.commodity.busi.api.UccBrandAddBusiService;
import com.tydic.commodity.busi.impl.UccCommodityPublishBusiServiceImpl;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.enumType.Brand;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccBrandAddBusiService.class)
public class UccBrandAddBusiServiceImpl
implements UccBrandAddBusiService {
    @Autowired
    private UccBrandDealMapper mapper;
    @Autowired
    private OrderSequence uccBrandSequence;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityPublishBusiServiceImpl.class);
    UccBrandAddRspBO rspBO = new UccBrandAddRspBO();

    public UccBrandAddRspBO addBrand(UccBrandAddReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        UccBrandDealPO brandDealPO = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)brandDealPO);
        UccBrandAddBusiServiceImpl.transStringToDate(reqBO, brandDealPO);
        try {
            Long brandId = this.uccBrandSequence.nextId();
            brandDealPO.setBrandId(brandId);
            int result = this.mapper.addBrand(brandDealPO);
            if (result > 0) {
                this.rspBO.setRespCode("0000");
                this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u6210\u529f");
                this.rspBO.setBrandId(brandId);
            } else {
                this.rspBO.setRespCode("8888");
                this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        return this.rspBO;
    }

    public boolean judge(UccBrandAddReqBO reqBO) {
        Map<String, String> map = null;
        if (reqBO.getBrandCode() == null || reqBO.getBrandCode().equals("")) {
            this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getBrandName() == null || reqBO.getBrandName().equals("")) {
            this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getEffTime() == null || reqBO.getEffTime().equals("")) {
            this.rspBO.setRespDesc("\u63d2\u5165\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getExpTime() == null || reqBO.getExpTime().equals("")) {
            this.rspBO.setRespDesc("\u63d2\u5165\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getBrandStatus() != null) {
            map = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString());
            if (!map.containsKey(reqBO.getBrandStatus().toString())) {
                this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u72b6\u6001");
                return false;
            }
        } else {
            this.rspBO.setRespDesc("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getExpTime() != null && reqBO.getEffTime() != null) {
            SimpleDateFormat str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date expTime = str.parse(reqBO.getExpTime());
                Date effTime = str.parse(reqBO.getEffTime());
                long result = effTime.getTime() - expTime.getTime();
                if (result > 0L) {
                    this.rspBO.setRespDesc("\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4");
                    return false;
                }
            }
            catch (ParseException e) {
                throw new BusinessException("8888", "\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
            }
        }
        return true;
    }

    public static void transStringToDate(UccBrandAddReqBO reqBO, UccBrandDealPO brandDealPO) {
        String effTime = reqBO.getEffTime();
        String expTime = reqBO.getExpTime();
        try {
            Date effTime1 = DateUtils.strToDate((String)effTime);
            Date expTime1 = DateUtils.strToDate((String)expTime);
            brandDealPO.setEffTime(effTime1);
            brandDealPO.setExpTime(expTime1);
        }
        catch (Exception e) {
            LOGGER.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
            throw new ZTBusinessException(e.getMessage());
        }
    }
}

