/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccBrandDateBO;
import com.tydic.commodity.bo.busi.UccBrandSelectReqBO;
import com.tydic.commodity.bo.busi.UccBrandSelectRspBO;
import com.tydic.commodity.busi.api.UccBrandSelectBusiService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.enumType.Brand;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccBrandSelectBusiService.class)
public class UccBrandSelectBusiServiceImpl
implements UccBrandSelectBusiService {
    @Autowired
    private UccBrandDealMapper mapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    UccBrandSelectRspBO rspBO = new UccBrandSelectRspBO();

    public UccBrandSelectRspBO selectBrand(UccBrandSelectReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRows(null);
            return this.rspBO;
        }
        this.rspBO = new UccBrandSelectRspBO();
        UccBrandDealPO brandDealPO = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)brandDealPO);
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getPageNo());
        List<UccBrandDealPO> result = null;
        try {
            result = this.mapper.selectBrand(brandDealPO, (Page<UccBrandDealPO>)page);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6570\u636e\u5e93\u67e5\u8be2\u5f02\u5e38");
        }
        if (result != null && result.size() > 0) {
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u6210\u529f");
            ArrayList<UccBrandDateBO> dataList = new ArrayList<UccBrandDateBO>();
            UccBrandDateBO result1 = null;
            DicDictionaryPo dicDictionaryPo = null;
            for (UccBrandDealPO po : result) {
                result1 = new UccBrandDateBO();
                BeanUtils.copyProperties((Object)po, (Object)result1);
                dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(po.getBrandStatus()), Brand.BRAND_STATUS.toString());
                if (dicDictionaryPo != null) {
                    result1.setBrandStatusTranslation(dicDictionaryPo.getTitle());
                }
                dataList.add(result1);
            }
            this.rspBO.setPageNo(page.getPageNo());
            this.rspBO.setRecordsTotal(page.getTotalCount());
            this.rspBO.setTotal(page.getTotalPages());
            this.rspBO.setRows(dataList);
        } else {
            this.rspBO.setRows(null);
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u6210\u529f");
        }
        return this.rspBO;
    }

    public boolean judge(UccBrandSelectReqBO reqBO) {
        Map<String, String> map = null;
        if (reqBO.getBrandStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString())).containsKey(String.valueOf(reqBO.getBrandStatus()))) {
            this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u54c1\u724c\u72b6\u6001");
            return false;
        }
        return true;
    }
}

